# 指示テンプレート

> このテンプレートをコピーして使用してください。

## 目的

{何を達成すべきか - 1-2文で簡潔に}

## 前提条件

- {前提1: 必要な環境・ツール・権限}
- {前提2: 事前に完了しているべき作業}
- {前提N}

## 手順

### Step 1: {ステップ名}

{具体的なアクション}

```bash
{コマンド例}
```

**成功基準**: {このステップの完了条件}
**検証方法**: {確認手順}

### Step 2: {ステップ名}

{具体的なアクション}

**成功基準**: {このステップの完了条件}
**検証方法**: {確認手順}

## 最終確認

- [ ] {全体の成功基準1}
- [ ] {全体の成功基準2}

## 例外処理

### {問題1}が発生した場合

{対処方法}

### {問題N}が発生した場合

{対処方法}

---

## 使用例

### 良い例

```markdown
## 目的

開発環境のデータベースを初期状態にリセットする

## 前提条件

- Node.js v18以上がインストール済み
- Docker Desktopが起動中
- .envファイルにDATABASE_URLが設定済み

## 手順

### Step 1: データベースコンテナを再起動

docker compose down -v && docker compose up -d db

**成功基準**: `docker ps` でdbコンテナがrunning状態
**検証方法**: `docker ps | grep db`

### Step 2: マイグレーションを実行

pnpm db:migrate

**成功基準**: "Migration complete" が表示される
**検証方法**: 上記メッセージを確認

## 最終確認

- [ ] `pnpm db:studio` でテーブルが表示される
- [ ] seedデータ3件がusersテーブルに存在

## 例外処理

### ポートが使用中の場合

`lsof -i :5432` で使用中のプロセスを確認し、終了させる
```

### 悪い例

```markdown
データベースを適切にリセットしてください。
```
