# Level 1: 指示明瞭化の基礎

## 概要

このドキュメントは、指示明瞭化の基本概念と5C原則の理解を目的としています。
初めて指示の品質改善に取り組む方向けの入門ガイドです。

## 5C原則とは

優れた指示は5つの要素（5C Principle）を満たします。

### 1. Clear（明瞭）

**定義**: 実行者が「何をすべきか」を即座に理解できること

**チェック項目**:

- [ ] 主語と述語が明確か
- [ ] 専門用語に説明があるか
- [ ] 一文一義（一文で一つの意味）になっているか

**良い例**:

```
データベースのusersテーブルから、last_login_at が NULL のレコードを削除してください。
```

**悪い例**:

```
適切にユーザーデータを処理してください。
```

### 2. Concise（簡潔）

**定義**: 不要な情報がなく、必要十分な内容に絞られていること

**チェック項目**:

- [ ] 冗長な修飾語がないか
- [ ] 同じことを繰り返していないか
- [ ] 実行に不要な背景情報を含んでいないか

**良い例**:

```
`npm install` を実行してください。
```

**悪い例**:

```
Node.jsのパッケージマネージャーであるnpmを使用して、package.jsonに記載された依存関係を
インストールするために、ターミナルでnpm installというコマンドを実行してください。
```

### 3. Complete（完全）

**定義**: 実行に必要なすべての情報が含まれていること

**チェック項目**:

- [ ] 前提条件が明記されているか
- [ ] すべてのステップが記載されているか
- [ ] 例外処理の方法が書かれているか

**良い例**:

```
前提条件:
- Node.js v18以上がインストール済み
- .envファイルにAPI_KEYが設定済み

手順:
1. npm install を実行
2. npm run dev を実行
3. http://localhost:3000 にアクセス

エラー時:
- ポートが使用中の場合: PORT環境変数を変更
```

**悪い例**:

```
npm run dev を実行してください。
```

### 4. Concrete（具体的）

**定義**: 抽象的な表現ではなく、具体的な例や数値で示されていること

**チェック項目**:

- [ ] 「適切に」「よろしく」などの曖昧語がないか
- [ ] 数値基準が明確か
- [ ] 具体例が含まれているか

**良い例**:

```
レスポンス時間が200ms以下であることを確認してください。
テストケース: curl -w "%{time_total}" http://localhost:3000/api/users
```

**悪い例**:

```
パフォーマンスが良いことを確認してください。
```

### 5. Correct（正確）

**定義**: 技術的に正しく、誤解を招く表現がないこと

**チェック項目**:

- [ ] コマンド・API名が正確か
- [ ] ファイルパスが正しいか
- [ ] 用語の使い方が正確か

**良い例**:

```
`git commit -m "Add user authentication"` を実行してください。
```

**悪い例**:

```
git save を実行してください。
```

## よくある曖昧な表現

| 曖昧な表現       | 問題点                   | 改善方向                    |
| ---------------- | ------------------------ | --------------------------- |
| 適切に処理する   | 「適切」の基準が不明     | 具体的な条件・基準を明記    |
| よろしく対応する | 対応方法が不明           | 具体的なアクションを列挙    |
| 必要に応じて     | 「必要」の判断基準が不明 | 条件を明示（if/else）       |
| なるべく         | 優先度・必須度が不明     | 必須/推奨/任意を明確に区別  |
| できるだけ早く   | 期限が不明               | 具体的な日時・時間を指定    |
| 大量の           | 量の基準が不明           | 具体的な数値を示す          |
| 高速に           | 速度の基準が不明         | 具体的な時間・レート を示す |

## 指示品質診断の基本手順

### Step 1: 5C原則でチェック

指示文を読み、5つの要素それぞれを評価します。

| 要素     | 評価基準                 |
| -------- | ------------------------ |
| Clear    | 意味が即座に分かるか     |
| Concise  | 不要な情報がないか       |
| Complete | 必要な情報が揃っているか |
| Concrete | 具体的か                 |
| Correct  | 正確か                   |

### Step 2: 曖昧語を検出

以下のパターンを探します:

- 副詞: 適切に、よろしく、なるべく、できるだけ
- 定性語: 速い、多い、大きい、良い
- 不明確な条件: 必要に応じて、場合によっては
- 不明確な範囲: 等、など、その他

### Step 3: 不足要素を特定

- 前提条件は書かれているか
- 成功基準は明記されているか
- 例外処理は書かれているか
- 検証方法は示されているか

## 次のステップ

基本を理解したら、以下のドキュメントに進んでください:

- `Level2_intermediate.md`: Pyramid Principleと実務パターン
- `5c-principle-guide.md`: 5C原則の詳細ガイド
- `common-vague-patterns.md`: 曖昧表現のパターンカタログ
