# Level 2: 指示明瞭化の実務

## 概要

このドキュメントは、Pyramid Principleによる論理構造の設計と、
実務でよく使われる指示パターンを解説します。

## Pyramid Principle（ピラミッド原則）

### 原則の概要

Barbara Mintoが提唱した論理構造の設計手法。
結論を先頭に配置し、その根拠を階層的に示すことで理解速度を向上させます。

### 基本構造

```
結論（What）
├── 理由1（Why）
│   ├── 根拠1-1
│   └── 根拠1-2
├── 理由2（Why）
│   ├── 根拠2-1
│   └── 根拠2-2
└── 理由3（Why）
    ├── 根拠3-1
    └── 根拠3-2
```

### 指示文への適用

**結論先行の指示フォーマット**:

```markdown
## 目的

{何を達成すべきか}

## 前提条件

{実行に必要な前提}

## 手順

{どのように実行するか}

## 成功基準

{何をもって完了とするか}

## 例外処理

{問題が起きた時の対応}
```

## 実務パターン

### パターン1: 単一タスク指示

**用途**: 単一の明確なアクションを指示する場合

**フォーマット**:

```markdown
## 目的

{アクションの目的}

## 実行内容

{具体的なコマンド・操作}

## 成功基準

{期待される結果}

## 検証方法

{確認手順}
```

**例**:

````markdown
## 目的

開発環境のデータベースをリセットする

## 実行内容

```bash
pnpm --filter @repo/shared db:reset
```
````

## 成功基準

- usersテーブルにseedデータが3件存在する
- 既存データがすべてクリアされている

## 検証方法

```bash
pnpm --filter @repo/shared db:studio
# ブラウザでusersテーブルを確認
```

````

### パターン2: 多段階タスク指示

**用途**: 複数のステップを含む作業を指示する場合

**フォーマット**:
```markdown
## 目的
{全体の目的}

## 前提条件
- {前提1}
- {前提N}

## 手順

### Step 1: {ステップ名}
{具体的なアクション}

**成功基準**: {このステップの完了条件}
**検証方法**: {確認手順}

### Step N: {ステップ名}
{具体的なアクション}

**成功基準**: {このステップの完了条件}
**検証方法**: {確認手順}

## 完了確認
{全ステップ完了後の最終確認}
````

### パターン3: 条件分岐指示

**用途**: 状況によって異なるアクションが必要な場合

**フォーマット**:

```markdown
## 目的

{目的}

## 条件分岐

### ケース1: {条件}の場合

{実行内容}

### ケース2: {条件}の場合

{実行内容}

### その他の場合

{デフォルトの実行内容}

## 判断方法

{どの条件に該当するか確認する方法}
```

**例**:

````markdown
## 目的

環境に応じた設定ファイルを選択する

## 条件分岐

### ケース1: 本番環境（RAILWAY_ENVIRONMENT=production）

.env.productionを使用

### ケース2: ステージング環境（RAILWAY_ENVIRONMENT=staging）

.env.stagingを使用

### ケース3: ローカル開発環境（その他）

.env.localを使用

## 判断方法

```bash
echo $RAILWAY_ENVIRONMENT
```
````

````

### パターン4: エラー対応指示

**用途**: 問題発生時の対応を指示する場合

**フォーマット**:
```markdown
## エラーの症状
{どのような問題が起きているか}

## 原因の特定

### 確認項目1
{確認方法}
→ {この場合の原因}

### 確認項目N
{確認方法}
→ {この場合の原因}

## 対処方法

### 原因1の場合
{対処手順}

### 原因Nの場合
{対処手順}

## 検証
{問題が解決したことを確認する方法}
````

## 成功基準の書き方

### 測定可能な基準

**悪い例**:

- 正常に動作すること
- 適切に処理されること
- エラーがないこと

**良い例**:

- HTTPステータスコード200が返ること
- レスポンス時間が200ms以下であること
- テストカバレッジが80%以上であること

### 検証可能な基準

成功基準には、必ず検証方法をセットで記載します。

**フォーマット**:

```markdown
**成功基準**: {測定可能な条件}
**検証方法**: {具体的な確認手順}
```

**例**:

````markdown
**成功基準**: すべてのユニットテストが通過すること
**検証方法**:

```bash
pnpm test
# PASS: 45 tests, 0 failures が表示されること
```
````

```

## 曖昧語の具体化テクニック

### テクニック1: 数値化

| 曖昧な表現 | 具体化例               |
| ---------- | ---------------------- |
| 速く       | 200ms以下              |
| 多く       | 100件以上              |
| 大きく     | 10MB以上               |
| 頻繁に     | 1日3回以上             |

### テクニック2: 例示

| 曖昧な表現     | 具体化例                                       |
| -------------- | ---------------------------------------------- |
| 適切なファイル名 | `user-{id}-{timestamp}.json` 例: user-123-20250101.json |
| 正しいフォーマット | JSON形式、例: `{"name": "太郎", "age": 25}` |

### テクニック3: チェックリスト化

| 曖昧な表現       | 具体化例                       |
| ---------------- | ------------------------------ |
| セキュリティ対策 | - [ ] SQLインジェクション対策<br>- [ ] XSS対策<br>- [ ] CSRF対策 |

## 次のステップ

実務パターンを理解したら、以下のドキュメントに進んでください:

- `Level3_advanced.md`: ドメイン特化指示の設計
- `pyramid-principle-guide.md`: Pyramid Principleの詳細
```
