---
name: interview-records
description: Archive of past customer interviews. Contains full transcripts, summaries, pain points, outcomes, and skills used. Use for referencing previous conversations with the same company or finding similar case patterns.
---

# Interview Records Skill

## Purpose

This skill stores complete interview records from customer calls. Each record captures the full context of a conversation for future reference.

## When to Use

- "Have we talked to this company before?"
- "What did we discuss with FinBot last time?"
- "Find similar fintech customer conversations"
- "What objections came up in past calls about token costs?"

## Record Structure

Each interview record contains:

1. **Metadata**: Company, date, attendee, outcome, duration
2. **Summary**: AI-generated call summary
3. **Pain Points**: Customer challenges identified
4. **Requirements**: What the customer needs
5. **Transcript**: Full conversation record
6. **Skills Used**: Which skills were activated and why
7. **Follow-up Actions**: Next steps recommended

## Usage Pattern

Interview records are automatically created when a session ends. They can be searched and referenced in future prep sessions to:

- Provide continuity with returning customers
- Find patterns across similar customer types
- Track which approaches worked well
- Build institutional knowledge from field conversations
