---
name: interview-techniques
description: Frameworks and techniques for conducting effective interviews and transforming conversations into content. Use when interviewing for insights or converting interview material into articles/posts.
---

# Interview Techniques Skill

Master the art of extracting insights through conversation and transforming them into compelling content.

## The STAR Method for Story Extraction

When someone mentions an experience, dig deeper with STAR:

- **Situation**: What was the context? What were you dealing with?
- **Task**: What was your specific role or challenge?
- **Action**: What exactly did you do? What decisions did you make?
- **Result**: What happened? What did you learn?

## The Funnel Technique

Start broad, then narrow:

```
Broad:    "Tell me about your experience with X"
          ↓
Medium:   "What was the biggest challenge you faced?"
          ↓
Narrow:   "Walk me through exactly what happened on that day"
          ↓
Specific: "What were you thinking in that moment?"
```

## Question Types & When to Use Them

### Opening Questions (Start Here)
- "What got you interested in [topic]?"
- "How did you come to have this expertise?"
- "What's your relationship with [topic]?"

### Deepening Questions (Pull on Threads)
- "Can you say more about that?"
- "What do you mean by [term they used]?"
- "How did you figure that out?"

### Example Questions (Get Concrete)
- "Can you give me a specific example?"
- "When was the last time you encountered this?"
- "What does that look like in practice?"

### Contrarian Questions (Find Unique Angles)
- "What do most people get wrong about this?"
- "Where do you disagree with the mainstream view?"
- "What's the unpopular opinion you hold?"

### Framework Questions (Extract Mental Models)
- "How do you think about [topic]?"
- "What's your process for [activity]?"
- "If you had to teach this in 3 steps, what would they be?"

### Synthesis Questions (Crystallize Insights)
- "What's the one thing you wish everyone understood?"
- "If you could give one piece of advice, what would it be?"
- "What's the headline takeaway?"

## Active Listening Signals

Show you're tracking without interrupting:

- Brief acknowledgments: "Right", "I see", "Interesting"
- Reflect back key phrases: "So you're saying..."
- Build on their words: "That connects to what you said earlier about..."

## Interview Pacing

### Warm-Up Phase (2-3 mins)
- Establish rapport
- Understand their relationship to topic
- Set expectations for the conversation

### Exploration Phase (10-15 mins)
- Broad questions to map the territory
- Note threads worth pursuing
- Let them lead initially

### Deep Dive Phase (10-15 mins)
- Pick 2-3 richest threads
- Go deep with follow-ups
- Extract specific stories and frameworks

### Synthesis Phase (5 mins)
- Help them articulate core message
- Confirm key takeaways
- Identify best content angles

## From Interview to Content

### Identifying Article-Worthy Material

Look for:
- **Unique insights** - Something not commonly known
- **Compelling stories** - Narrative with tension and resolution
- **Practical frameworks** - Actionable mental models
- **Contrarian takes** - Against-the-grain perspectives
- **Quotable moments** - Phrases that stand alone

### Content Angle Selection

Rate potential angles on:
1. **Uniqueness** - Is this said elsewhere?
2. **Relevance** - Does the audience care?
3. **Evidence** - Can we back it up from the interview?
4. **Emotion** - Does it provoke a response?
5. **Action** - Can readers do something with it?

### Structural Patterns for Interview-Based Content

**Story-First Structure**
```
1. Hook with compelling story moment
2. Pull back to explain context
3. Reveal the insight/lesson
4. Expand with framework
5. Call to action
```

**Framework-First Structure**
```
1. State the framework/model
2. Explain each component
3. Illustrate with interview stories
4. Show how to apply it
5. Summary and CTA
```

**Problem-First Structure**
```
1. Name the problem vividly
2. Show why common solutions fail
3. Reveal the better approach (from interview)
4. Provide evidence/examples
5. Implementation steps
```

## Memory Integration

### During Interview

Store incrementally:
```
Key insight discovered: [insight]
Supporting story: [brief summary]
Potential content angle: [angle]
```

### After Interview

Compile:
```
Interview Summary - [Topic] - [Date]

Top 3 Insights:
1. [Insight + evidence]
2. [Insight + evidence]
3. [Insight + evidence]

Best Stories:
- [Story title]: [2-sentence summary]

Frameworks Articulated:
- [Framework name]: [How it works]

Recommended Content:
- Article: [Angle + headline idea]
- LinkedIn: [Hook + angle]
- Twitter: [Thread hook]
```

## Common Interview Pitfalls

1. **Rushing past gold** - They hint at something interesting but you move on
2. **Asking compound questions** - Multiple questions confuse the answer
3. **Projecting your views** - Leading questions embed your answers
4. **Surface-level acceptance** - Not asking "why" or "how" enough
5. **Forgetting to circle back** - Dropping threads that deserved follow-up

## The Art of Silence

After asking a question:
- Wait at least 3 seconds before filling silence
- Silence often prompts deeper, more honest answers
- If they pause, they're often about to say something valuable
- Resist the urge to rephrase or offer multiple choice
