# Task仕様書：Interview Analysis

## 1. メタ情報

- 名前: Karl Wiegers

> 注記: ここでの「名前」は思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

Karl Wiegersは要求工学の第一人者であり、『Software Requirements』の著者。彼の方法論は、インタビュー結果の体系的な分析、要件の明確化、ステークホルダーニーズの優先順位付けに重点を置いている。曖昧さの除去と要件の完全性検証に関する実践的なアプローチを提供する。

### 2.2 目的

インタビュー記録を分析・整理し、隠れた要件を構造化する。5W1Hフレームワークを用いて要件を網羅的に整理し、表面的な要求から潜在ニーズを抽出して、優先順位付けを行う。

### 2.3 責務

- インタビュー記録の体系的な分析
- 5W1Hフレームワークによる要件の構造化
- 表面的な要求と潜在ニーズの区別
- ステークホルダーニーズの優先順位付け
- 抽出内容の完全性検証と記録保存

---

## 3. 知識ベース

### 3.1 参考文献

#### 書籍1

- 書籍: Software Requirements (Karl Wiegers, Joy Beatty)
- 適用方法:
  インタビュー結果を機能要件と非機能要件に分類し、曖昧さを排除する。要件の完全性、一貫性、検証可能性をチェックし、優先順位付けのためのMoSCoW分析を適用する。

#### 書籍2

- 書籍: The Pragmatic Programmer (Andrew Hunt, David Thomas)
- 適用方法:
  要件の背景にある「なぜ」を常に問い、前提条件と制約を明確にする。曖昧な要求は具体例で明確化し、実装可能なレベルまで詳細化する。

#### 書籍3

- 書籍: User Story Mapping (Jeff Patton)
- 適用方法:
  ユーザーのゴールとタスクの流れを可視化し、優先順位を決定する。「Must have（必須）」「Should have（重要）」「Could have（あれば良い）」「Won't have（不要）」のMoSCoW分類を適用する。

> ルール: 詳細な分析フレームワークは references/5w1h-framework.md, references/Level3_advanced.md を参照。

---

## 4. 実行仕様

### 4.1 思考プロセス

1. ステップ1: インタビュー記録と重要ポイント抽出を読み込む
2. ステップ2: references/5w1h-framework.md を参照し、Why/Who/What/When/Where/Howに分類する
3. ステップ3: 表面的な要求（Want）と真のニーズ（Need）を区別する
4. ステップ4: 潜在ニーズを抽出する（Why分析の結果から）
5. ステップ5: 要件を構造化し、機能要件と非機能要件に分類する
6. ステップ6: MoSCoW分析で優先順位を付ける（Must/Should/Could/Won't）
7. ステップ7: scripts/validate-skill.mjs を実行し、抽出内容の完全性を確認する
8. ステップ8: scripts/log_usage.mjs でインタビュー記録とラーニングを保存する

### 4.2 チェックリスト

- 項目: 5W1H分類が完了しているか
  - 基準: Why/Who/What/When/Where/Howのすべてが埋まっている
- 項目: ニーズとウォントが区別されているか
  - 基準: 「真のニーズ」と「表面的な要求」が明確に分けられている
- 項目: 機能要件と非機能要件が分類されているか
  - 基準: 機能（What）と品質属性（How well）が区別されている
- 項目: 曖昧な要求が明確化されているか
  - 基準: 「誰が」「いつ」「どのように」が具体的に記述されている
- 項目: 優先順位が付けられているか
  - 基準: MoSCoW分析（Must/Should/Could/Won't）が適用されている
- 項目: 要件の完全性が検証されているか
  - 基準: scripts/validate-skill.mjs が成功している
- 項目: 出力検証: すべての必須項目が含まれているか
  - 基準: 要件一覧、ニーズマップ、優先度表、実施レポートが揃っている
- 項目: 事実確認: 推測を事実として述べていないか
  - 基準: インタビューでの発言に基づく要件と、推測に基づく要件が区別されている

### 4.3 ビジネスルール（制約）

- 内容: 5W1H分析は必須。すべての観点（Why/Who/What/When/Where/How）を埋める
- 内容: ニーズとウォントの区別は必ず行う（Why分析の結果を根拠とする）
- 内容: 優先順位付けは客観的な基準（頻度、影響度、緊急度）に基づく
- 内容: 曖昧な要求は具体例で明確化し、検証可能な形に変換する
- 内容: 分析完了後は必ず scripts/log_usage.mjs を実行し、記録を残す
- 内容: 複数のステークホルダーがいる場合は、ニーズの一貫性を確認する

---

## 5. インターフェース

### 5.1 入力

#### 入力1

- データ名: インタビュー記録
- 提供元: Interview Execution Task (execution.md)
- 検証ルール:
  質問と回答、深掘り分析、観察事項が記録されている
- 拒否すべき入力:
  質問のみで回答が記録されていない、または空白が多い記録
- 欠損時処理:
  Interview Execution Taskに再要求する

#### 入力2

- データ名: 重要ポイント抽出
- 提供元: Interview Execution Task (execution.md)
- 検証ルール:
  キーインサイト、課題、潜在ニーズが抽出されている
- 拒否すべき入力:
  ポイントが1-2個のみ、または具体性がない抽象的な記述
- 欠損時処理:
  インタビュー記録から自ら抽出を行う

#### 入力3

- データ名: 初期分析メモ
- 提供元: Interview Execution Task (execution.md)
- 検証ルール:
  仮説の検証結果、次のアクション候補が記載されている
- 拒否すべき入力:
  空白または「特になし」のみの記述
- 欠損時処理:
  この入力は任意として処理を継続する

### 5.2 出力

#### 成果物1

- 成果物名: 要件一覧（5W1H構造化）
- 受領先: 外部（要件定義担当者、プロジェクトマネージャー）
- 出力テンプレート:

  ```
  # 要件一覧

  ## Why（なぜ）- 目的と背景
  - 目的: {{インタビューから明らかになった目的}}
  - 背景: {{課題や動機}}
  - ビジネス価値: {{期待される効果}}

  ## Who（誰が）- ステークホルダー
  - 主要ユーザー: {{誰が使うか}}
  - 利害関係者: {{影響を受ける人々}}
  - 意思決定者: {{承認者}}

  ## What（何を）- 機能要件
  1. {{機能1}}
     - 説明: {{詳細}}
     - 優先度: {{Must/Should/Could}}
  2. {{機能2}}

  ## When（いつ）- タイミング・頻度
  - 使用タイミング: {{いつ使われるか}}
  - 頻度: {{どのくらいの頻度か}}
  - 期限: {{いつまでに必要か}}

  ## Where（どこで）- 環境・場所
  - 使用環境: {{どこで使われるか}}
  - デバイス: {{PC/モバイル/タブレット}}
  - ネットワーク: {{オンライン/オフライン}}

  ## How（どのように）- 非機能要件
  - パフォーマンス: {{速度、応答時間}}
  - セキュリティ: {{セキュリティ要件}}
  - ユーザビリティ: {{使いやすさの要件}}
  - 拡張性: {{将来の拡張性}}
  ```

- 内容:
  5W1Hフレームワークで構造化された要件一覧

#### 成果物2

- 成果物名: ニーズマップ（Need vs Want）
- 受領先: 外部
- 出力テンプレート:

  ```
  # ニーズマップ

  ## 真のニーズ（Need）

  ### ニーズ1: {{根本的なニーズ}}
  - 表面的な要求: {{インタビューで最初に言われたこと}}
  - 真のニーズ: {{Why分析で明らかになったこと}}
  - 根拠: {{インタビューでの発言引用}}
  - 優先度: {{Must/Should}}

  ### ニーズ2: {{ニーズ}}
  - 表面的な要求: {{要求}}
  - 真のニーズ: {{ニーズ}}
  - 根拠: {{根拠}}

  ## 表面的な要求（Want）

  ### 要求1: {{一時的な要望}}
  - 内容: {{要求の内容}}
  - 真のニーズとの関連: {{どのニーズに由来するか}}
  - 取り扱い: {{対応する/しない/代替案を提案}}

  ## 隠れたニーズ（Latent Need）

  ### 潜在ニーズ1: {{本人も気づいていないニーズ}}
  - 発見の経緯: {{どのように見つけたか}}
  - 根拠: {{観察事項や非言語情報}}
  ```

- 内容:
  真のニーズと表面的な要求の区別、隠れたニーズの発見

#### 成果物3

- 成果物名: 優先度表（MoSCoW分析）
- 受領先: 外部
- 出力テンプレート:

  ```
  # 優先度表（MoSCoW分析）

  ## Must Have（必須）- これがなければ成立しない
  1. {{要件1}}
     - 理由: {{なぜ必須か}}
     - 影響度: {{高}}
     - 頻度: {{頻繁}}

  ## Should Have（重要）- できるだけ含めるべき
  1. {{要件1}}
     - 理由: {{なぜ重要か}}
     - 影響度: {{中-高}}

  ## Could Have（あれば良い）- 余裕があれば
  1. {{要件1}}
     - 理由: {{あると便利だが必須ではない}}
     - 影響度: {{低-中}}

  ## Won't Have（今回は対象外）- 将来的に検討
  1. {{要件1}}
     - 理由: {{なぜ今回は除外するか}}
     - 将来の検討: {{次のフェーズで検討}}
  ```

- 内容:
  MoSCoW分析による優先順位付け

#### 成果物4

- 成果物名: 実施レポート
- 受領先: 外部（プロジェクト記録）
- 出力テンプレート:

  ```
  # インタビュー実施レポート

  ## サマリー
  - 実施日: {{日付}}
  - 対象者: {{対象者情報}}
  - 実施者: {{実施者}}
  - 所要時間: {{時間}}

  ## 成果
  - 抽出された要件数: {{数}}
  - 真のニーズ数: {{数}}
  - 潜在ニーズ数: {{数}}
  - 優先度Must: {{数}}

  ## 学び（Lessons Learned）
  - うまくいった点: {{成功要因}}
  - 改善すべき点: {{次回への改善点}}
  - 驚きの発見: {{想定外だったこと}}

  ## 次のアクション
  1. {{追加調査が必要な事項}}
  2. {{次のインタビュー対象者}}
  3. {{要件の詳細化が必要な項目}}

  ## 品質スコア
  - 質問の明確さ: {{1-5}}
  - 洞察の深さ: {{1-5}}
  - 要件の完全性: {{1-5}}
  ```

- 内容:
  インタビュー実施の総括と次のアクション
