# 要件ヒアリングガイドテンプレート

## インタビュー情報

| 項目             | 内容                     |
| ---------------- | ------------------------ |
| 日時             | YYYY/MM/DD HH:MM - HH:MM |
| 場所/方法        | [対面/オンライン]        |
| インタビュアー   | [氏名]                   |
| インタビュイー   | [氏名、役職、部門]       |
| 目的             | [このインタビューの目的] |
| 関連プロジェクト | [プロジェクト名]         |

---

## 事前準備

### インタビュイー情報

- 役職: [役職]
- 部門: [部門]
- 専門領域: [専門領域]
- 過去のインタビュー: [あり/なし]

### 事前に確認した資料

- [ ] 既存のドキュメント
- [ ] 現行システムの概要
- [ ] 過去のインタビュー記録

### 準備した質問（優先度順）

1. [最優先の質問]
2. [次に重要な質問]
3. [確認したい質問]

---

## インタビュー構成

### オープニング（5分）

- [ ] 自己紹介
- [ ] インタビューの目的説明
- [ ] 時間の確認
- [ ] 録音の許可確認

**台本**:

```
「本日はお時間いただきありがとうございます。
私は[名前]と申します。[プロジェクト名]の要件定義を担当しています。
本日は[目的]についてお話を伺いたいと思います。
お時間は[X]分を予定しています。よろしいでしょうか？
また、後で確認するために録音させていただいてもよろしいでしょうか？」
```

---

## 5W1H質問セクション

### Who（誰が）- 10分

**目的**: ユーザーと関係者の特定

**質問リスト**:

1. このシステム/機能を使うのは主にどなたですか？
2. 他に関係する部門や人はいますか？
3. ユーザーの技術レベルはどの程度ですか？
4. 意思決定者はどなたですか？

**回答記録**:

```
[ここに回答を記録]
```

**フォローアップ質問**:

- 「それは具体的にどのような方ですか？」
- 「その方の主な関心事は何ですか？」

---

### What（何を）- 15分

**目的**: 機能と要件の明確化

**質問リスト**:

1. 何を実現したいですか？最も重要な機能は何ですか？
2. 現在できていないことは何ですか？
3. 必須の機能と、あれば良い機能を教えてください
4. 成功の基準は何ですか？

**回答記録**:

```
[ここに回答を記録]
```

**フォローアップ質問**:

- 「それがないとどうなりますか？」
- 「具体的な例を教えていただけますか？」

---

### When（いつ）- 5分

**目的**: タイミングと期限の把握

**質問リスト**:

1. いつまでに必要ですか？その期限は絶対ですか？
2. いつ、どのくらいの頻度で使いますか？
3. ピーク時期はいつですか？

**回答記録**:

```
[ここに回答を記録]
```

---

### Where（どこで）- 5分

**目的**: 環境と場所の把握

**質問リスト**:

1. どこで使いますか？（オフィス、外出先、在宅）
2. どのデバイスで使いますか？
3. 連携する他のシステムはありますか？

**回答記録**:

```
[ここに回答を記録]
```

---

### Why（なぜ）- 10分

**目的**: 目的と背景の理解

**質問リスト**:

1. なぜこれが必要ですか？（5回繰り返す）
2. 現在の課題は何ですか？
3. 期待する効果は何ですか？

**Why分析記録**:

```
Why 1: なぜ[要求]が必要ですか？
→ 回答:

Why 2: なぜ[Why1の回答]ですか？
→ 回答:

Why 3: なぜ[Why2の回答]ですか？
→ 回答:

Why 4: なぜ[Why3の回答]ですか？
→ 回答:

Why 5: なぜ[Why4の回答]ですか？
→ 回答:

本質的なニーズ:
```

---

### How（どのように）- 10分

**目的**: 方法と手順の把握

**質問リスト**:

1. 現在の業務手順を教えてください
2. 理想的な手順はどのようなものですか？
3. 特殊なケースや例外はありますか？

**回答記録**:

```
[ここに回答を記録]
```

**業務フロー図**:

```
[現在のフロー]

[理想のフロー]
```

---

## 追加質問セクション

### 制約と懸念

**質問リスト**:

1. 技術的な制約はありますか？
2. 予算の制約はありますか？
3. 最も懸念していることは何ですか？

**回答記録**:

```
[ここに回答を記録]
```

### 優先順位

**質問リスト**:

1. 最も重要な要件を3つ挙げるとしたら？
2. 逆に、なくても困らない機能は？
3. トレードオフが必要な場合、何を優先しますか？

**回答記録**:

```
[ここに回答を記録]
```

---

## クロージング（5分）

- [ ] 理解の確認
- [ ] 追加で話したいことの確認
- [ ] 次のステップの説明
- [ ] お礼

**台本**:

```
「本日お聞きした内容を整理させていただきます。
[主要なポイントを要約]
この理解で合っていますでしょうか？

他にお伝えしたいことはありますか？

次のステップとして、[次のアクション]を予定しています。
追加で確認が必要な場合はご連絡させていただきます。
本日はお時間いただきありがとうございました。」
```

---

## インタビュー後の処理

### 要約

**主要な発見**:

1. [発見1]
2. [発見2]
3. [発見3]

**特定された要件**:
| ID | 要件 | 優先度 | 備考 |
|----|------|--------|-----|
| | | | |

**未解決の質問**:

- [ ] [質問1] - フォローアップ必要
- [ ] [質問2] - 別のステークホルダーに確認

**次のアクション**:

- [ ] [アクション1] - 期限: YYYY/MM/DD
- [ ] [アクション2] - 期限: YYYY/MM/DD

### インタビュー品質チェック

- [ ] 5W1Hすべてカバーした
- [ ] 深堀り質問をした
- [ ] 具体例を引き出した
- [ ] 曖昧な回答を明確化した
- [ ] 次のステップを合意した

---

## 変更履歴

| バージョン | 日付       | 変更者 | 変更内容 |
| ---------- | ---------- | ------ | -------- |
| 1.0        | YYYY/MM/DD | [氏名] | 初版作成 |
