# 5W1Hフレームワーク

## 概要

5W1Hは、要件を網羅的に収集するための基本フレームワークです。
Who, What, When, Where, Why, Howの6つの観点から情報を整理します。

## 6つの観点

### 1. Who（誰が）

**目的**: ステークホルダーとユーザーの特定

**質問例**:

- このシステムを使うのは誰ですか？
- 誰がこの機能を必要としていますか？
- 意思決定者は誰ですか？
- 承認者は誰ですか？
- 影響を受けるのは誰ですか？

**深堀り質問**:

- その人の技術レベルは？
- どのくらいの頻度で使いますか？
- 他にどんなシステムを使っていますか？
- 代理で使う人はいますか？

**出力例**:

```markdown
## ユーザー分析

### プライマリユーザー

- **一般社員**: 約500名、PC基本操作可能
- **部門管理者**: 約50名、中級レベル
- **システム管理者**: 5名、技術者

### 関連ステークホルダー

- **経営層**: 承認・予算決定
- **法務部門**: コンプライアンス確認
- **IT部門**: 技術検証・運用
```

### 2. What（何を）

**目的**: 機能と要件の明確化

**質問例**:

- 何を実現したいですか？
- どんな機能が必要ですか？
- 何が現在できないですか？
- 何を変えたいですか？
- 成果物は何ですか？

**深堀り質問**:

- それは必須ですか、あれば良いですか？
- 類似の機能で参考になるものは？
- 現在はどうやって実現していますか？
- それがないとどうなりますか？

**出力例**:

```markdown
## 機能要件

### 必須機能（Must have）

- 経費申請の作成・提出
- 承認ワークフロー
- 経費精算レポート

### 重要機能（Should have）

- 過去申請のコピー機能
- 一括承認機能

### 希望機能（Could have）

- スマートフォン対応
- AI による経費分類
```

### 3. When（いつ）

**目的**: タイミングと期限の把握

**質問例**:

- いつまでに必要ですか？
- どのタイミングで使いますか？
- 繁忙期はいつですか？
- 定期的な処理はありますか？
- いつまでデータを保持しますか？

**深堀り質問**:

- その期限は絶対ですか？
- 段階的なリリースは可能ですか？
- 緊急時の対応は必要ですか？
- 夜間バッチは許容されますか？

**出力例**:

```markdown
## タイムライン

### プロジェクトスケジュール

- **要件定義完了**: 2025年2月末
- **開発完了**: 2025年5月末
- **本番リリース**: 2025年6月初旬

### 運用タイミング

- **申請ピーク**: 月末3日間
- **締め処理**: 毎月5日
- **年次処理**: 3月末

### SLA要件

- **稼働時間**: 平日8:00-22:00
- **メンテナンス**: 毎週日曜深夜
```

### 4. Where（どこで）

**目的**: 環境と場所の把握

**質問例**:

- どこで使いますか？
- どのデバイスで使いますか？
- ネットワーク環境は？
- データはどこに保存しますか？
- どのシステムと連携しますか？

**深堀り質問**:

- オフライン利用は必要ですか？
- 海外からのアクセスは？
- VPN経由のアクセスは？
- クラウド/オンプレミスの制約は？

**出力例**:

```markdown
## 環境要件

### 利用場所

- **社内**: デスクトップPC（Windows 10）
- **外出先**: ノートPC、スマートフォン
- **在宅**: 個人PC（VPN経由）

### ネットワーク

- **社内**: 有線LAN（1Gbps）
- **外出先**: モバイル回線（4G/5G）

### システム連携

- **人事システム**: ユーザー情報同期
- **会計システム**: 経費データ連携
- **メールサーバー**: 通知送信
```

### 5. Why（なぜ）

**目的**: 目的と背景の理解

**質問例**:

- なぜこれが必要ですか？
- 解決したい問題は何ですか？
- 期待する効果は何ですか？
- 現在の課題は何ですか？
- なぜ今このタイミングですか？

**深堀り質問**:

- それを解決するとどうなりますか？（5回繰り返す）
- 他の解決策は検討しましたか？
- 成功の基準は何ですか？
- 失敗した場合の影響は？

**出力例**:

```markdown
## 目的と背景

### ビジネス課題

- 紙ベースの経費申請で処理に平均5日
- 入力ミスによる差し戻しが30%
- 月末の経理担当の残業時間増加

### 期待効果

- 処理時間を5日→1日に短縮
- 入力ミスを30%→5%に削減
- 経理担当の残業時間50%削減

### 成功指標

- 申請から承認まで平均24時間以内
- ユーザー満足度80%以上
- 年間コスト削減1000万円
```

### 6. How（どのように）

**目的**: 方法と手段の把握

**質問例**:

- どのように操作しますか？
- どのような手順で進めますか？
- 例外処理はどうしますか？
- トレーニングはどうしますか？
- 移行はどうしますか？

**深堀り質問**:

- 現在の手順を教えてください
- 理想的な手順は？
- 自動化できる部分は？
- 特殊なケースはありますか？

**出力例**:

```markdown
## 業務フロー

### 経費申請フロー

1. 申請者が経費情報を入力
2. 領収書を添付
3. 上長に承認依頼
4. 上長が承認/差し戻し
5. 経理部門が最終確認
6. 精算処理を実行

### 例外フロー

- 上長不在時: 代理承認者へエスカレーション
- 高額申請: 部長承認を追加
- 海外経費: 為替レート自動計算

### 移行計画

- Phase 1: パイロット部門で試験運用
- Phase 2: 全社展開
- Phase 3: 旧システム廃止
```

## 5W1Hマトリクス

| 観点  | 質問       | 収集する情報           |
| ----- | ---------- | ---------------------- |
| Who   | 誰が       | ユーザー、権限、ロール |
| What  | 何を       | 機能、データ、成果物   |
| When  | いつ       | 期限、タイミング、頻度 |
| Where | どこで     | 環境、デバイス、場所   |
| Why   | なぜ       | 目的、課題、効果       |
| How   | どのように | 手順、方法、制約       |

## インタビューテンプレート

```markdown
# 要件ヒアリングシート

## 基本情報

- **日時**:
- **参加者**:
- **対象システム**:

## Who（ユーザーと関係者）

1. このシステムを使うのは誰ですか？
2. 意思決定者は誰ですか？
3. 技術レベルはどの程度ですか？

## What（機能と要件）

1. 何を実現したいですか？
2. 必須の機能は何ですか？
3. 現在できないことは何ですか？

## When（タイミングと期限）

1. いつまでに必要ですか？
2. ピーク時期はいつですか？
3. データの保持期間は？

## Where（環境と場所）

1. どこで使いますか？
2. どのデバイスで使いますか？
3. 連携するシステムは？

## Why（目的と背景）

1. なぜこれが必要ですか？
2. 解決したい問題は何ですか？
3. 期待する効果は何ですか？

## How（方法と手順）

1. 現在の業務手順は？
2. 理想的な手順は？
3. 移行の制約はありますか？

## その他

- 懸念事項:
- 追加で確認したいこと:
```

## チェックリスト

### インタビュー前

- [ ] 5W1Hの各観点で質問を準備したか？
- [ ] 優先順位を決めたか？
- [ ] 時間配分を決めたか？

### インタビュー中

- [ ] すべての観点をカバーしたか？
- [ ] 深堀り質問をしたか？
- [ ] 具体例を引き出したか？

### インタビュー後

- [ ] 各観点の情報が揃っているか？
- [ ] 不明点はフォローアップリストに入れたか？
- [ ] 矛盾点はないか？
