# レベル1: 基礎

## 概要

要求抽出のためのヒアリングスキル。オープンエンド質問、要求の深掘り、 前提の明確化を通じて、ユーザーの真のニーズを引き出します。

SKILL.md の内容だけで完結する基本運用を扱います。

## 前提条件

- SKILL.md の概要とワークフローを読了している
- 対象タスクの目的と成果物を把握している

## 詳細ガイド

### 使用タイミング

- ヒアリング技法タスクを処理する際に積極的に使用する

### 必要な知識

- 対象領域: 要求抽出のためのヒアリングスキル。オープンエンド質問、要求の深掘り、 前提の明確化を通じて、ユーザーの真のニーズを引き出します。
- 主要概念: 5W1Hフレームワーク / 6つの観点 / 1. Who（誰が） / 質問タイプガイド / 質問タイプの分類
- 実務指針: ユーザーから要望をヒアリングする時
- 実務指針: 曖昧な要求を明確化する時
- 実務指針: 隠れたニーズを発見する時

### 判断基準

- 避けるべき判断: アンチパターンや注意点を確認せずに進めることを避ける

### 成果物の最小要件

- テンプレートの必須項目を満たしている
- 主要テンプレート: `templates/interview-guide.md`

### 参照書籍

- 『The Pragmatic Programmer』（Andrew Hunt, David Thomas）: 実践的改善

### 主要リソース

- `SKILL.md`: スキルの目的・前提・判断基準の基礎

### 主要テンプレート

- `templates/interview-guide.md`: このレベルでは参照のみ

## 実践手順

1. SKILL.md の概要と目的を確認する
2. 適用タイミングと成果物の期待値を言語化する
3. 作業の冒頭で前提条件が満たされているか確認する

## チェックリスト

- [ ] スキルの適用タイミングを説明できる
- [ ] 必要な知識と判断基準を整理できた
- [ ] テンプレートの必須項目を把握している
