# レベル2: 中級

## 概要

要求抽出のためのヒアリングスキル。オープンエンド質問、要求の深掘り、 前提の明確化を通じて、ユーザーの真のニーズを引き出します。

resources/・scripts/・templates/ の活用を前提とした運用を整理します。

## 前提条件

- Level 1 の内容を理解している
- SKILL.md の適用範囲を説明できる

## 詳細ガイド

### 必要な知識・情報

- 主要トピック: 5W1Hフレームワーク / 6つの観点 / 1. Who（誰が） / 質問タイプガイド / 質問タイプの分類 / 1. オープン質問（Open-ended Questions）
- 実務指針: ユーザーから要望をヒアリングする時 / 曖昧な要求を明確化する時 / 隠れたニーズを発見する時

### 判断基準と検証観点

- 回避事項: アンチパターンや注意点を確認せずに進めることを避ける

### リソース運用

- `resources/5w1h-framework.md`: Why/Who/What/When/Where/Howによる網羅的要件理解手法（把握する知識: 5W1Hフレームワーク / 6つの観点 / 1. Who（誰が））
- `resources/question-types.md`: 7種類の質問タイプ（オープン/クローズド/深堀り/仮説検証/シナリオ/比較/反転）と使い分け（把握する知識: 質問タイプガイド / 質問タイプの分類 / 1. オープン質問（Open-ended Questions））
- `resources/why-analysis.md`: 5回のWhy繰り返しによる根本ニーズ発見手法（把握する知識: Why分析（なぜなぜ分析） / 基本原則 / 5回のWhyルール）
- `resources/legacy-skill.md`: 旧SKILL.mdの全文（把握する知識: Interview Techniques / リソース構造 / リソース読み取り）

### スクリプト運用

- `scripts/log_usage.mjs`: 使用記録・自動評価スクリプト
- `scripts/prepare-interview.mjs`: ヒアリング準備チェックリストと質問セット自動生成
- `scripts/validate-skill.mjs`: スキル構造検証スクリプト

### テンプレート運用

- `templates/interview-guide.md`: インタビュー実施ガイドとフロー制御テンプレート

### 成果物要件

- テンプレートの構成・必須項目を反映する

## 実践手順

1. 利用するリソースを選定し、適用順を決める
2. スクリプトは `--help` で引数を確認し、検証系から実行する
3. テンプレートを使い成果物の形式を統一する
4. `scripts/log_usage.mjs` で実行記録を残す

## チェックリスト

- [ ] リソースから必要な知識を抽出できた
- [ ] スクリプトの役割と実行順を把握している
- [ ] テンプレートで成果物の形式を揃えた
