# 質問タイプガイド

## 概要

効果的な要件ヒアリングには、適切な質問タイプの選択が不可欠です。
このガイドでは、状況に応じた質問タイプの使い分けを解説します。

## 質問タイプの分類

### 1. オープン質問（Open-ended Questions）

**特徴**: 自由に回答できる質問

**使用場面**:

- 情報収集の初期段階
- 相手の考えを広く聞きたい時
- 予想外の情報を得たい時

**例**:

```
✅ 「この業務で困っていることは何ですか？」
✅ 「理想的なシステムはどのようなものですか？」
✅ 「日常業務の流れを教えてください」
✅ 「このプロジェクトに期待することは？」
```

**回答例**:

```
質問: 「現在の業務で困っていることは何ですか？」
回答: 「データ入力に時間がかかること、確認作業が多いこと、
      あと月末に集中する処理が大変ですね」
```

### 2. クローズド質問（Closed Questions）

**特徴**: はい/いいえ、または選択肢から回答

**使用場面**:

- 事実確認
- 具体的な情報の取得
- 選択肢からの決定

**例**:

```
✅ 「この機能は必須ですか？」
✅ 「現在のシステムに満足していますか？」
✅ 「予算は1000万円以内ですか？」
✅ 「リリースは4月でよいですか？」
```

**注意**: クローズド質問だけでは情報が偏る

### 3. 深堀り質問（Probing Questions）

**特徴**: 回答をさらに掘り下げる質問

**使用場面**:

- 曖昧な回答を具体化
- 詳細情報の取得
- 真意の確認

**例**:

```
相手: 「システムが使いにくい」

深堀り質問:
✅ 「具体的にどの部分が使いにくいですか？」
✅ 「使いにくいと感じる場面を教えてください」
✅ 「それはどのくらいの頻度で起きますか？」
✅ 「他のシステムと比べてどうですか？」
```

### 4. 仮説検証質問（Hypothesis-testing Questions）

**特徴**: 仮説を提示して確認する質問

**使用場面**:

- 理解の確認
- 方向性の合意形成
- 選択肢の絞り込み

**例**:

```
✅ 「つまり、処理時間を半分にしたいということですか？」
✅ 「モバイル対応より、まず基本機能の安定化が優先という理解でよいですか？」
✅ 「〜という理解で合っていますか？」
```

### 5. シナリオ質問（Scenario Questions）

**特徴**: 具体的な状況を設定して聞く質問

**使用場面**:

- エッジケースの発見
- 例外処理の確認
- ユーザー行動の理解

**例**:

```
✅ 「もし承認者が休暇中だった場合、どうしますか？」
✅ 「大量のデータを処理する必要がある場合は？」
✅ 「初めて使うユーザーはどのように操作しますか？」
✅ 「ネットワークが切れた場合、どう対応しますか？」
```

### 6. 比較質問（Comparative Questions）

**特徴**: 他との比較で回答を引き出す質問

**使用場面**:

- 要件の優先順位付け
- 期待値の把握
- 競合分析

**例**:

```
✅ 「現在のシステムと比べて、何が改善されれば良いですか？」
✅ 「AとBどちらが重要ですか？」
✅ 「競合のXXXサービスと比較してどうですか？」
✅ 「理想を100点とすると、現状は何点ですか？」
```

### 7. 反転質問（Reversal Questions）

**特徴**: 逆の視点から聞く質問

**使用場面**:

- 要件の境界確認
- 優先度の確認
- リスクの特定

**例**:

```
✅ 「逆に、なくても困らない機能は何ですか？」
✅ 「この機能がなかったら、どうなりますか？」
✅ 「失敗するとしたら、どういうケースですか？」
✅ 「やってはいけないことは何ですか？」
```

## 質問タイプの使い分けフロー

```
インタビュー開始
    │
    ▼
[オープン質問] ← 広く情報収集
    │
    ▼
曖昧な回答あり？ ─Yes─→ [深堀り質問] ← 詳細化
    │ No                      │
    ▼                        ▼
[シナリオ質問] ← エッジケース確認
    │
    ▼
[比較質問] ← 優先順位付け
    │
    ▼
[仮説検証質問] ← 理解の確認
    │
    ▼
[クローズド質問] ← 最終確認
    │
    ▼
インタビュー終了
```

## 質問の組み立てパターン

### パターン1: 漏斗型（Funnel）

広い質問から徐々に絞り込む

```
1. オープン: 「業務の課題は何ですか？」
2. 深堀り: 「その中で最も重要なのは？」
3. シナリオ: 「具体的にはどんな場面で発生しますか？」
4. 仮説検証: 「つまり〜ということですね」
5. クローズド: 「これを最優先で解決しますか？」
```

### パターン2: 逆漏斗型（Inverted Funnel）

具体から抽象へ広げる

```
1. クローズド: 「このレポートは毎日使いますか？」
2. 深堀り: 「具体的にどのように使いますか？」
3. オープン: 「レポートの目的は何ですか？」
4. 比較: 「他のツールと比べてどうですか？」
5. オープン: 「理想的なレポートとは？」
```

### パターン3: TED（Tell, Explain, Describe）

詳細な説明を引き出す

```
Tell me about... 「〜について教えてください」
Explain how... 「どのように〜するか説明してください」
Describe... 「〜を描写してください」
```

## 避けるべき質問パターン

### 1. 誘導質問

```
❌ 「この機能は必要ですよね？」
❌ 「みんな不満を持っていますよね？」
❌ 「当然〜ですよね？」

✅ 「この機能についてどう思いますか？」
✅ 「現状に対する意見を聞かせてください」
```

### 2. 複合質問

```
❌ 「この機能は必要ですか？また、いつまでに必要ですか？予算は？」

✅ 「この機能は必要ですか？」
✅ （回答後）「いつまでに必要ですか？」
✅ （回答後）「予算はどのくらいですか？」
```

### 3. 否定的な質問

```
❌ 「なぜそんなことが必要なのですか？」
❌ 「それは本当に必要ですか？」

✅ 「その機能の目的を教えてください」
✅ 「どのような場面で使いますか？」
```

### 4. 専門用語を多用した質問

```
❌ 「RESTful APIでCRUD操作のエンドポイントは必要ですか？」

✅ 「外部システムからデータを登録・更新・削除する機能は必要ですか？」
```

## 質問タイプ選択マトリクス

| 目的             | 推奨質問タイプ |
| ---------------- | -------------- |
| 情報収集（初期） | オープン       |
| 詳細確認         | 深堀り         |
| 事実確認         | クローズド     |
| 理解確認         | 仮説検証       |
| 例外発見         | シナリオ       |
| 優先順位付け     | 比較           |
| 境界確認         | 反転           |

## チェックリスト

### 質問準備

- [ ] 各質問タイプを準備したか？
- [ ] オープン質問から始められるか？
- [ ] 深堀り質問を用意したか？

### インタビュー中

- [ ] 誘導質問をしていないか？
- [ ] 1つずつ質問しているか？
- [ ] 相手の言葉を使っているか？

### インタビュー後

- [ ] すべての質問タイプを活用したか？
- [ ] 追加質問が必要な箇所はないか？
