# Why分析（なぜなぜ分析）

## 概要

Why分析は、要求の真の目的や根本原因を特定するための手法です。
「なぜ？」を繰り返し問うことで、表面的な要求から本質的なニーズを引き出します。

## 基本原則

### 5回のWhyルール

問題や要求に対して「なぜ？」を5回繰り返すことで、
表面的な症状から根本原因・本質的なニーズに到達します。

**例：機能要求のWhy分析**

```
要求: 「レポート出力機能がほしい」

Why 1: なぜレポートが必要ですか？
→ 「毎週の会議で報告するため」

Why 2: なぜ毎週報告する必要がありますか？
→ 「進捗状況を経営層に共有するため」

Why 3: なぜ経営層に共有する必要がありますか？
→ 「問題を早期に発見して対処するため」

Why 4: なぜ早期発見が重要ですか？
→ 「遅れが大きくなると予算超過するため」

Why 5: なぜ予算超過を防ぎたいですか？
→ 「プロジェクトの成功と会社の収益を守るため」
```

**洞察**: 本質的なニーズは「問題の早期発見」であり、
レポートは手段の一つ。リアルタイムダッシュボードやアラート機能も有効かもしれない。

## Why分析のパターン

### パターン1: 機能要求からビジネス価値へ

```
要求: 「検索機能を高速化してほしい」

Why 1: なぜ高速化が必要ですか？
→ 「検索に10秒かかるから」

Why 2: なぜ10秒では問題ですか？
→ 「お客様が待てずに離脱するから」

Why 3: なぜ離脱が問題ですか？
→ 「売上機会を失うから」

Why 4: なぜ売上機会が重要ですか？
→ 「ECサイトの主要収益源だから」

Why 5: 目標とする検索時間は？
→ 「競合と同等の2秒以内」
```

**成果**: 曖昧な「高速化」が「2秒以内」という具体的な要件に変換。

### パターン2: 課題から解決策の幅出し

```
課題: 「承認が遅くて困っている」

Why 1: なぜ承認が遅いですか？
→ 「承認者が不在のことが多いから」

Why 2: なぜ不在が多いですか？
→ 「外出や会議で席を外しているから」

Why 3: なぜ席にいないと承認できないですか？
→ 「PCでしか承認できないから」

Why 4: なぜPCでしか承認できないですか？
→ 「モバイル対応していないから」

Why 5: モバイル対応すれば解決しますか？
→ 「大部分は解決する。緊急時の代理承認も欲しい」
```

**成果**: 「モバイル対応」と「代理承認機能」という2つの解決策を発見。

### パターン3: 制約の理解

```
制約: 「既存システムは変更できない」

Why 1: なぜ変更できないですか？
→ 「ベンダーとの契約で禁止されているから」

Why 2: なぜそのような契約になっていますか？
→ 「カスタマイズすると保守対象外になるから」

Why 3: 保守対象外になると何が問題ですか？
→ 「障害時にサポートを受けられないから」

Why 4: サポートなしで運用できないですか？
→ 「社内に技術者がいないから」

Why 5: 外部の技術者に依頼は可能ですか？
→ 「コストが許容範囲なら検討可能」
```

**成果**: 制約の本質は「保守体制」であり、代替策の可能性を発見。

## Why分析の質問テクニック

### オープンエンド質問

```
✅ 「なぜそれが必要ですか？」
✅ 「その理由を教えていただけますか？」
✅ 「何が問題になりますか？」

❌ 「〜だからですか？」（誘導質問）
❌ 「はい/いいえ」で答えられる質問
```

### 言い換えテクニック

同じ「なぜ」を繰り返すと相手が詰問されているように感じることがあります。
言い換えパターンを使いましょう。

| 回数  | 質問パターン                           |
| ----- | -------------------------------------- |
| 1回目 | 「なぜそれが必要ですか？」             |
| 2回目 | 「それはどういう理由からですか？」     |
| 3回目 | 「その背景を教えていただけますか？」   |
| 4回目 | 「それによってどうなりますか？」       |
| 5回目 | 「最終的に実現したいことは何ですか？」 |

### 深堀りのサイン

以下の回答が出たら、さらに深堀りが必要です：

- 「当然のことだから」→ なぜ当然なのか
- 「みんなそう言っている」→ 具体的に誰が何と言っているか
- 「前からそうだから」→ その経緯は何か
- 「決まりだから」→ その決まりの目的は何か

## Why分析テンプレート

```markdown
# Why分析シート

## 対象

**要求/課題**: [分析対象を記載]
**日付**:
**分析者**:

## Why分析

### Level 1

**質問**: なぜ[要求/課題]が発生していますか？
**回答**:
**メモ**:

### Level 2

**質問**: なぜ[Level 1の回答]ですか？
**回答**:
**メモ**:

### Level 3

**質問**: なぜ[Level 2の回答]ですか？
**回答**:
**メモ**:

### Level 4

**質問**: なぜ[Level 3の回答]ですか？
**回答**:
**メモ**:

### Level 5

**質問**: なぜ[Level 4の回答]ですか？
**回答**:
**メモ**:

## 分析結果

### 根本原因/本質的ニーズ

[特定された根本原因または本質的なニーズ]

### 発見した解決策の選択肢

1. [選択肢1]
2. [選択肢2]
3. [選択肢3]

### 推奨アプローチ

[推奨する解決策とその理由]

### 追加で確認が必要な点

- [ ] [確認事項1]
- [ ] [確認事項2]
```

## Why分析の注意点

### すべきこと

1. **中立的な態度を保つ**
   - 相手を責めているように聞こえないよう注意
   - 好奇心を持って質問する

2. **記録を取る**
   - 各レベルの回答を正確に記録
   - 後で分析できるように

3. **適切なタイミングで止める**
   - 本質に到達したら無理に5回続けない
   - 堂々巡りになったら別の観点に切り替え

4. **複数の分岐を追う**
   - 1つのWhyに複数の回答がある場合、両方追う

### 避けるべきこと

1. **詰問調にならない**
   - ❌ 「なぜですか？なぜですか？なぜですか？」
   - ✅ 言い換えながら自然に掘り下げる

2. **答えを誘導しない**
   - ❌ 「コスト削減のためですよね？」
   - ✅ 「目的は何ですか？」

3. **表面的な回答で終わらない**
   - 「なんとなく」「昔からそう」は深堀りのサイン

4. **相手を疲弊させない**
   - 時間を区切る
   - 休憩を入れる

## Why分析の応用

### 要求の優先順位付け

各要求に対してWhyを実施し、
ビジネス価値（最終的なWhy）を比較することで優先順位を決定。

```
要求A → Why → 売上10%向上
要求B → Why → 業務効率5%改善
要求C → Why → コンプライアンス対応（必須）

優先順位: C > A > B
```

### 要求の統合

同じ根本ニーズに由来する複数の要求を発見し、統合的な解決策を提案。

```
要求1: レポート機能 → Why → 進捗の可視化
要求2: アラート機能 → Why → 問題の早期発見
要求3: ダッシュボード → Why → リアルタイム状況把握

→ 統合解決策: リアルタイムダッシュボード with アラート
```

## チェックリスト

### 分析前

- [ ] 分析対象の要求/課題は明確か？
- [ ] 適切な回答者を選定したか？
- [ ] 十分な時間を確保したか？

### 分析中

- [ ] オープンエンドの質問をしているか？
- [ ] 言い換えを使っているか？
- [ ] 記録を取っているか？
- [ ] 複数の分岐を追っているか？

### 分析後

- [ ] 根本原因/本質的ニーズは特定できたか？
- [ ] 複数の解決策オプションが出たか？
- [ ] 追加確認事項はリストアップしたか？
