---
name: Investment Analyzer
slug: investment-analyzer
description: Analyze investment opportunities across asset classes with risk assessment, return modeling, and portfolio optimization
category: finance
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "analyze investment"
  - "investment analysis"
  - "ROI calculation"
  - "investment comparison"
  - "due diligence"
  - "portfolio analysis"
tags:
  - investments
  - due-diligence
  - roi-analysis
  - risk-assessment
  - portfolio-management
---

# Investment Analyzer

Expert investment analysis agent that evaluates investment opportunities, calculates risk-adjusted returns, performs due diligence, and optimizes portfolio allocation. Specializes in private company investments, public equities, real estate, and alternative investments.

This skill applies rigorous investment analysis frameworks to help investors make informed decisions, understand risk/return trade-offs, and build diversified portfolios. Perfect for startup investments, stock analysis, real estate evaluation, and portfolio construction.

## Core Workflows

### Workflow 1: Private Company Investment Analysis

**Objective:** Evaluate equity investment opportunity in a private company

**Steps:**
1. **Investment Overview**
   - Investment amount requested
   - Valuation (pre-money and post-money)
   - Ownership percentage offered
   - Investment structure (equity, convertible note, SAFE)
   - Investment round (seed, Series A, B, etc.)
   - Use of funds

2. **Business Analysis**
   - **Market Opportunity:**
     - Total Addressable Market (TAM)
     - Serviceable Addressable Market (SAM)
     - Serviceable Obtainable Market (SOM)
     - Market growth rate
     - Competitive landscape

   - **Business Model:**
     - Revenue model (subscription, transactional, etc.)
     - Unit economics
     - Customer acquisition cost (CAC)
     - Lifetime value (LTV)
     - LTV/CAC ratio (target > 3x)
     - Gross margins

   - **Traction:**
     - Revenue/MRR/ARR
     - Growth rate (MoM, YoY)
     - Customer count and quality
     - Retention/churn rates
     - Key milestones achieved

3. **Team Assessment**
   - Founder backgrounds
   - Domain expertise
   - Previous exits
   - Team completeness
   - Key person risk
   - Board composition

4. **Financial Due Diligence**
   - Historical financials (if available)
   - Burn rate and runway
   - Path to profitability
   - Financial projections analysis
   - Key assumptions validation

5. **Return Modeling**
   - **Exit Scenarios:**
     - Conservative exit (2-3x revenue multiple)
     - Base case exit (5-7x revenue multiple)
     - Optimistic exit (10x+ revenue multiple)

   - **Return Calculations:**
     - Expected exit valuation
     - Ownership at exit (dilution adjusted)
     - Gross return (exit value / investment)
     - IRR calculation (based on timeline)
     - Multiple of Invested Capital (MOIC)

6. **Risk Assessment**
   - Market risk (competition, timing)
   - Execution risk (team, operational)
   - Financial risk (runway, fundraising)
   - Technology risk (scalability, defensibility)
   - Regulatory risk
   - Overall risk rating (High/Medium/Low)

7. **Deal Terms Analysis**
   - Valuation reasonableness
   - Liquidation preferences
   - Anti-dilution provisions
   - Board seats and governance
   - Information rights
   - Pro-rata rights

8. **Investment Decision**
   - Investment thesis summary
   - Expected return vs. risk
   - Key risks and mitigants
   - Recommendation (Invest/Pass)
   - Conditions or modifications

**Deliverable:** Investment memo with analysis and recommendation

### Workflow 2: Public Equity Analysis

**Objective:** Evaluate stock investment opportunity

**Steps:**
1. **Company Overview**
   - Business description
   - Market position
   - Competitive advantages (moat)
   - Key products/services
   - Geographic presence

2. **Financial Analysis**
   - **Income Statement:**
     - Revenue trends (3-5 years)
     - Margin analysis (gross, operating, net)
     - EPS growth
     - Revenue mix and diversification

   - **Balance Sheet:**
     - Asset quality
     - Debt levels
     - Cash position
     - Working capital
     - Book value

   - **Cash Flow:**
     - Operating cash flow trends
     - Free cash flow
     - CapEx requirements
     - Dividend coverage
     - Share buyback capacity

3. **Ratio Analysis**
   - **Profitability:**
     - ROE, ROA, ROIC
     - Profit margins

   - **Valuation:**
     - P/E ratio vs peers and history
     - EV/EBITDA
     - P/B ratio
     - PEG ratio
     - Dividend yield

   - **Financial Health:**
     - Debt/Equity
     - Interest coverage
     - Current ratio

4. **Valuation**
   - **DCF Analysis:**
     - Revenue projections
     - Margin assumptions
     - WACC calculation
     - Terminal value
     - Implied share price

   - **Comparable Analysis:**
     - Peer company multiples
     - Implied valuation range

   - **Fair Value Estimate:**
     - Weighted valuation
     - Margin of safety

5. **Technical Factors**
   - Price trends
   - Support/resistance levels
   - Volume patterns
   - Relative strength
   - Moving averages

6. **Risk Factors**
   - Company-specific risks
   - Industry risks
   - Macro risks
   - ESG considerations

7. **Investment Recommendation**
   - Fair value estimate
   - Current price vs fair value
   - Upside/downside potential
   - Rating (Strong Buy/Buy/Hold/Sell)
   - Price target
   - Investment horizon

**Deliverable:** Equity research report with recommendation

### Workflow 3: Real Estate Investment Analysis

**Objective:** Evaluate real estate investment opportunity

**Steps:**
1. **Property Overview**
   - Property type (residential, commercial, industrial)
   - Location and market
   - Size and specifications
   - Age and condition
   - Purchase price

2. **Income Analysis**
   - **Gross Rental Income:**
     - Current rent roll
     - Market rent comparison
     - Occupancy rate
     - Lease terms

   - **Operating Expenses:**
     - Property taxes
     - Insurance
     - Utilities
     - Maintenance and repairs
     - Property management (8-12%)
     - Vacancy reserve (5-10%)
     - CapEx reserve (5-10%)

   - **Net Operating Income (NOI):**
     - Gross Income - Operating Expenses

3. **Return Metrics**
   - **Cap Rate:**
     - NOI / Purchase Price
     - Compare to market cap rates

   - **Cash-on-Cash Return:**
     - Annual Cash Flow / Total Cash Invested
     - Pre-tax and after-tax

   - **Internal Rate of Return (IRR):**
     - 5-10 year hold period
     - Include exit sale

   - **Equity Multiple:**
     - Total Cash Returned / Total Cash Invested

4. **Financing Analysis**
   - Loan terms (rate, term, amortization)
   - Down payment required
   - Debt service coverage ratio (DSCR)
   - Loan-to-value (LTV)
   - Monthly payment calculation
   - Positive/negative leverage

5. **Market Analysis**
   - Comparable sales
   - Rental comps
   - Market trends
   - Supply/demand dynamics
   - Economic drivers
   - Appreciation potential

6. **Risk Assessment**
   - Vacancy risk
   - Tenant quality
   - Market risk
   - Interest rate risk
   - Deferred maintenance
   - Environmental issues
   - Regulatory changes

7. **Value-Add Opportunities**
   - Rent increases
   - Expense reductions
   - Property improvements
   - Use conversion
   - Development potential

8. **Investment Decision**
   - Return summary
   - Risk-adjusted assessment
   - Recommendation
   - Offer price suggestion

**Deliverable:** Real estate investment analysis with recommendation

### Workflow 4: ROI and Payback Analysis

**Objective:** Calculate return on investment for business projects

**Steps:**
1. **Project Definition**
   - Investment description
   - Total investment required
   - Investment timeline
   - Expected benefits

2. **Cost Analysis**
   - **Initial Investment:**
     - Capital costs
     - Implementation costs
     - Training costs
     - One-time expenses

   - **Ongoing Costs:**
     - Operating costs
     - Maintenance
     - License fees
     - Personnel

3. **Benefit Analysis**
   - **Revenue Benefits:**
     - New revenue generation
     - Revenue acceleration
     - Price improvements

   - **Cost Savings:**
     - Labor savings
     - Material savings
     - Efficiency gains
     - Error reduction

   - **Quantification:**
     - Conservative estimate
     - Expected estimate
     - Optimistic estimate

4. **Financial Metrics**
   - **Simple ROI:**
     - (Total Benefits - Total Costs) / Total Costs

   - **Payback Period:**
     - Time to recover initial investment
     - Simple payback = Investment / Annual Cash Flow

   - **Net Present Value (NPV):**
     - Discount future cash flows
     - NPV > 0 indicates good investment

   - **Internal Rate of Return (IRR):**
     - Discount rate where NPV = 0
     - Compare to hurdle rate

5. **Sensitivity Analysis**
   - Vary key assumptions
   - Break-even analysis
   - Scenario modeling

6. **Recommendation**
   - Investment summary
   - Key assumptions
   - Risk factors
   - Go/No-Go recommendation

**Deliverable:** ROI analysis with payback period and NPV/IRR

### Workflow 5: Portfolio Allocation Analysis

**Objective:** Optimize investment portfolio allocation

**Steps:**
1. **Current Portfolio Assessment**
   - Asset inventory
   - Current allocation by:
     - Asset class
     - Geography
     - Sector
     - Risk level
   - Performance history

2. **Investor Profile**
   - Risk tolerance (conservative/moderate/aggressive)
   - Investment horizon
   - Liquidity needs
   - Tax considerations
   - ESG preferences
   - Return objectives

3. **Target Allocation**
   - **Asset Class Allocation:**
     - Equities (domestic, international)
     - Fixed income (government, corporate)
     - Real estate
     - Alternatives (private equity, hedge funds)
     - Cash

   - **Risk-Based Allocation:**
     - Growth assets
     - Income assets
     - Defensive assets

4. **Rebalancing Analysis**
   - Current vs target allocation
   - Required trades
   - Tax implications
   - Transaction costs
   - Rebalancing triggers

5. **Risk Analysis**
   - Portfolio volatility
   - Correlation analysis
   - Concentration risk
   - Downside risk (VaR, max drawdown)
   - Stress testing

6. **Expected Returns**
   - Asset class return assumptions
   - Portfolio expected return
   - Risk-adjusted return (Sharpe ratio)
   - Probability of meeting goals

7. **Recommendations**
   - Allocation changes
   - Specific investments
   - Implementation plan
   - Monitoring schedule

**Deliverable:** Portfolio analysis with allocation recommendations

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Startup analysis | "Analyze this startup investment" |
| Stock analysis | "Analyze [ticker] stock" |
| Real estate | "Analyze this property investment" |
| ROI calculation | "Calculate ROI for [project]" |
| Portfolio review | "Analyze my portfolio allocation" |
| Due diligence | "Perform due diligence on [company]" |

## Investment Formulas

### Return Metrics

| Metric | Formula | Notes |
|--------|---------|-------|
| ROI | (Gain - Cost) / Cost | Simple return percentage |
| IRR | Rate where NPV = 0 | Time-weighted return |
| MOIC | Exit Value / Investment | Multiple of money |
| CAGR | (End/Start)^(1/years) - 1 | Annualized return |
| Sharpe Ratio | (Return - Risk-free) / Std Dev | Risk-adjusted return |

### Valuation Metrics

| Metric | Formula | Typical Range |
|--------|---------|---------------|
| P/E Ratio | Price / EPS | 10-25x (varies) |
| EV/EBITDA | Enterprise Value / EBITDA | 8-15x |
| EV/Revenue | Enterprise Value / Revenue | 1-5x |
| P/B Ratio | Price / Book Value | 1-3x |
| Cap Rate | NOI / Property Value | 4-10% |

### Startup Metrics

| Metric | Target | Notes |
|--------|--------|-------|
| LTV/CAC | > 3x | Unit economics health |
| CAC Payback | < 12 months | How fast you recover CAC |
| Gross Margin | > 70% (SaaS) | Scalability indicator |
| Net Dollar Retention | > 100% | Revenue expansion |
| Monthly Burn | < Cash/18mo | Runway health |

## Investment Analysis Template

```markdown
# Investment Analysis: [Company/Asset Name]

**Date:** [Date]
**Analyst:** [Name]
**Investment Type:** [Equity/Debt/Real Estate/etc.]

## Executive Summary
- Investment amount: $XXX
- Expected return: XX% IRR
- Risk level: [High/Medium/Low]
- Recommendation: [Invest/Pass]

## Opportunity Overview
[Brief description]

## Key Investment Thesis
1. [Reason 1]
2. [Reason 2]
3. [Reason 3]

## Financial Analysis

### Historical Performance
| Metric | Year 1 | Year 2 | Year 3 |
|--------|--------|--------|--------|
| Revenue | | | |
| Growth | | | |
| Margin | | | |

### Return Analysis
| Scenario | Exit Value | MOIC | IRR |
|----------|------------|------|-----|
| Bear | | | |
| Base | | | |
| Bull | | | |

## Risk Assessment

### Key Risks
1. [Risk 1] - [Mitigation]
2. [Risk 2] - [Mitigation]
3. [Risk 3] - [Mitigation]

### Risk Matrix
| Factor | Rating (1-5) |
|--------|--------------|
| Market Risk | |
| Execution Risk | |
| Financial Risk | |
| Team Risk | |

## Recommendation
[Detailed recommendation with conditions]
```

## Best Practices

### Due Diligence
- Verify all claims independently
- Check references thoroughly
- Review legal documents carefully
- Validate financial statements
- Assess team track record

### Return Analysis
- Use multiple valuation methods
- Model multiple scenarios
- Be conservative in assumptions
- Consider opportunity cost
- Factor in fees and taxes

### Risk Management
- Diversify across investments
- Size positions appropriately
- Set clear exit criteria
- Monitor investments regularly
- Know your walk-away points

## Integration with Other Skills

- **Use with `valuation-analyst`:** Deep-dive company valuation
- **Use with `financial-analyst`:** Financial statement analysis
- **Use with `contract-analyzer`:** Review investment terms
- **Use with `compliance-checker`:** Regulatory considerations
- **Use with `tax-strategist`:** Tax-efficient structuring

## Common Pitfalls to Avoid

- **FOMO investing:** Don't rush due diligence
- **Overconfidence in projections:** Hockey stick forecasts rarely materialize
- **Ignoring downside:** Model the failure case
- **Insufficient diversification:** Don't concentrate too heavily
- **Emotional attachment:** Stay objective
- **Ignoring fees:** Total cost matters
- **Skipping references:** Always check
- **Confirmation bias:** Seek disconfirming evidence
