---
name: iterative-analysis
description: Performs sequential multi-round oracle analysis where each round builds on previous findings. Use when user specifies analysis count (e.g., "analyze 5 times"), asks to think repeatedly, or needs progressive refinement.
---

# Iterative Analysis

Performs multi-round, progressively deeper analysis using the oracle. Each iteration builds upon previous findings to refine understanding.

## When to Use

- User asks for "deep thinking" or "thorough analysis"
- Complex problems requiring multiple perspectives
- When initial analysis needs refinement
- User explicitly requests N rounds of analysis

## Parameters

- **Iterations**: Number of analysis rounds (default: 3, user can specify)
- **Focus**: The topic or problem to analyze
- **Files**: Relevant files to examine

## Workflow

### Step 1: Get User Requirements

Ask user (if not specified):
- What to analyze
- How many iterations (default: 3)
- Any specific focus areas

### Step 2: Execute Iterative Analysis

For each iteration (1 to N):

```
Round 1 - Initial Analysis:
oracle(
  task: "Analyze [topic]. Provide initial findings, identify key areas needing deeper investigation.",
  files: [relevant_files]
)

Round 2 - Deeper Investigation:
oracle(
  task: "Based on previous findings: [summary of round 1]. 
         Dig deeper into identified issues. Challenge initial assumptions. 
         Find edge cases and overlooked aspects.",
  files: [relevant_files],
  context: "[Round 1 findings]"
)

Round 3 - Refinement & Synthesis:
oracle(
  task: "Based on all previous analysis: [summary of rounds 1-2].
         Synthesize findings. Identify patterns. Provide final recommendations.
         Rate confidence level for each conclusion.",
  files: [relevant_files],
  context: "[All previous findings]"
)

... continue for additional rounds as specified
```

### Step 3: Final Report

After all iterations, compile:
- Key discoveries from each round
- Evolution of understanding
- Final conclusions with confidence levels
- Actionable recommendations

## Iteration Prompts Template

| Round | Focus |
|-------|-------|
| 1 | Initial exploration, identify key areas |
| 2 | Challenge assumptions, find edge cases |
| 3 | Cross-validate, identify patterns |
| 4 | Stress-test conclusions, find gaps |
| 5+ | Synthesize, prioritize, finalize |

## Example Usage

User: "帮我分析这个认证系统，进行5轮分析"

```
Round 1: "Analyze the authentication system architecture and flow"
Round 2: "Based on [R1], investigate security vulnerabilities and edge cases"
Round 3: "Based on [R1,R2], analyze error handling and failure modes"
Round 4: "Based on [R1-R3], evaluate scalability and performance implications"
Round 5: "Synthesize all findings, prioritize issues, provide remediation plan"
```

## Best Practices

1. **Carry Context Forward**: Each round must reference previous findings
2. **Progressive Focus**: Narrow focus as iterations progress
3. **Challenge Assumptions**: Later rounds should question earlier conclusions
4. **Track Evolution**: Note how understanding changed across rounds
5. **Confidence Levels**: Final round should rate certainty of each finding
