# Icon Design Skill

Select semantically appropriate icons for websites and applications.

## Auto-Trigger Keywords

This skill activates when discussing:

### Icon Libraries
- lucide, lucide-react, lucide icons
- heroicons, @heroicons/react, heroicons outline, heroicons solid
- phosphor, phosphor icons, @phosphor-icons/react
- icon library, icon package, icon set

### Selection Tasks
- which icon, what icon, select icon, choose icon, pick icon
- icon for, icon representing, icon that means
- feature icons, service icons, benefit icons
- navigation icons, menu icons, UI icons
- contact icons, social icons

### Specific Concepts
- trophy icon, award icon, quality icon
- price icon, value icon, money icon, tag icon
- location icon, map icon, pin icon
- support icon, chat icon, message icon
- security icon, shield icon, lock icon
- speed icon, fast icon, lightning icon, bolt icon
- phone icon, email icon, mail icon

### Templates & Patterns
- icon button, icon card, icon list
- inline icon, feature card icon
- icon with text, icon container
- icon styling, icon sizing

### Migration
- font awesome to lucide, fa to lucide
- material icons to lucide
- feather icons, feather to lucide
- replace emoji with icons
- icon migration

### Problems & Errors
- icons not showing, icon tree shaking
- icons all bundled, icon bundle size
- wrong icon, inappropriate icon
- icon consistency, icon style mismatch
- emoji instead of icon

## Quick Start

```tsx
// Install
npm install lucide-react

// Import specific icons (tree-shakeable)
import { Trophy, MapPin, Shield } from 'lucide-react'

// Use with Tailwind
<Trophy className="w-8 h-8 text-primary" />
```

## Related Skills

- `tailwind-v4-shadcn` - Semantic colour tokens
- `react-patterns` - Tree-shaking prevention
