# vintage

复古基调 - Historical, aged, period authenticity

## Overview

Historical atmosphere with aged paper effects and period-appropriate aesthetics. Creates sense of time, authenticity, and historical distance.

## Mood Characteristics

- Historical authenticity
- Period distance
- Archival quality
- Time and memory
- Classical elegance

## Color Modifiers

When applied to any art style:

| Adjustment | Direction |
|------------|-----------|
| Saturation | Reduced, muted |
| Contrast | Medium, aged |
| Temperature | Sepia shift |
| Brightness | Slightly faded |

## Color Palette

Shift toward aged tones:

| Role | Color | Hex |
|------|-------|-----|
| Primary | Sepia brown | #8B7355 |
| Background | Aged paper | #F5E6D3 |
| Accent 1 | Faded teal | #6B8E8E |
| Accent 2 | Muted burgundy | #7B3F3F |
| Ink | Aged black | #3D3D3D |
| Yellowed | Paper yellow | #F5DEB3 |

## Visual Effects

**Aging effects** (apply subtly):

| Effect | Application |
|--------|-------------|
| Paper aging | Background texture |
| Faded edges | Vignette effect |
| Dust specks | Subtle overlay |
| Yellowing | Color shift |
| Wear marks | Corner/edge details |

## Period Elements

- Historical typography
- Period-accurate details
- Archival presentation
- Classical compositions
- Formal framing

## Lighting

- Natural, period-appropriate
- Oil lamp/candle warmth
- Soft, diffused light
- Indoor historical lighting
- Photographic quality

## Emotional Range

| Emotion | Expression |
|---------|-----------|
| Dignity | Formal, composed |
| Sorrow | Restrained, elegant |
| Pride | Classical posture |
| Wisdom | Aged grace |

## Composition

- Classical framing
- Formal compositions
- Period-appropriate staging
- Documentary style
- Historical accuracy priority

## Best For

- Pre-1950s stories
- Classical science history
- Historical biographies
- Period pieces
- Documentary comics
- Archival narratives

## Combination Notes

Works especially well with:
- realistic: period drama
- ligne-claire: historical adventure
- ink-brush: classical Asian stories

Avoid with:
- manga: style mismatch (too modern)
- chalk: style mismatch (modern educational)
