# Mood Dimension

Color temperature and palette style.

## Options

| Option | Color Temperature | Palette Style | Best For |
|--------|-------------------|---------------|----------|
| `professional` | Cool-neutral | Navy, gold, structured grays | Business, investor, corporate |
| `warm` | Warm | Earth tones, oranges, natural colors | Education, friendly, approachable |
| `cool` | Cool | Blues, grays, cyan, teal | Technical, data, analytical |
| `vibrant` | Varied | High saturation, bold colors | Marketing, creative, attention-grabbing |
| `dark` | Dark | Deep backgrounds with bright accents | Entertainment, gaming, atmospheric |
| `neutral` | Neutral | Minimal color, grayscale focus | Executive, minimal, sophisticated |

## Palette Specifications

### professional

```
Background: #FFFFFF (Pure White)
Primary Text: #1E3A5F (Navy)
Secondary Text: #4A5568 (Dark Gray)
Accent 1: #C9A227 (Gold)
Accent 2: #3D5A80 (Light Navy)
```

### warm

```
Background: #FAF8F0 (Warm Off-White)
Primary Text: #2C3E50 (Deep Charcoal)
Secondary Text: #4A4A4A (Deep Brown)
Accent 1: #F4A261 (Soft Orange)
Accent 2: #E9C46A (Mustard Yellow)
Accent 3: #87A96B (Sage Green)
```

### cool

```
Background: #FAF8F5 (Blueprint Off-White)
Primary Text: #334155 (Deep Slate)
Secondary Text: #64748B (Slate Gray)
Accent 1: #2563EB (Engineering Blue)
Accent 2: #1E3A5F (Navy Blue)
Accent 3: #BFDBFE (Light Blue)
```

### vibrant

```
Background: #FFFFFF or #1A1A2E (Light or Dark)
Primary Text: #1A1A2E or #FFFFFF
Accent 1: #E94560 (Coral Red)
Accent 2: #0F3460 (Deep Blue)
Accent 3: #16C79A (Teal Green)
Accent 4: #F9B208 (Golden Yellow)
```

### dark

```
Background: #0D1117 (Deep Black)
Primary Text: #E6EDF3 (Soft White)
Secondary Text: #8B949E (Muted Gray)
Accent 1: #58A6FF (Bright Blue)
Accent 2: #7EE787 (Bright Green)
Accent 3: #FF7B72 (Coral)
```

### neutral

```
Background: #FFFFFF (Pure White)
Primary Text: #18181B (Near Black)
Secondary Text: #71717A (Medium Gray)
Accent 1: #18181B (Black)
Accent 2: #A1A1AA (Light Gray)
```

## Rendering Guidelines

### professional

- Restrained use of accent colors
- Gold for emphasis only
- Clean, institutional feel
- Balanced contrast

### warm

- Generous use of warm tones
- Natural, approachable colors
- Soft transitions between colors
- Welcoming atmosphere

### cool

- Blue-dominant palette
- Technical precision in color use
- High contrast for clarity
- Analytical, trustworthy feel

### vibrant

- Bold color combinations
- High saturation throughout
- Dynamic color contrasts
- Energetic visual presence

### dark

- Deep backgrounds dominate
- Accent colors pop against dark
- Glowing/luminous effects
- Cinematic atmosphere

### neutral

- Minimal color usage
- Typography carries weight
- Grayscale hierarchy
- Maximum sophistication

## Combination Notes

| Mood | Works Best With | Avoid With |
|------|-----------------|------------|
| professional | clean texture, geometric typography | organic texture, handwritten |
| warm | organic texture, humanist typography | pixel texture, minimal density |
| cool | grid texture, technical typography | paper texture, handwritten |
| vibrant | pixel/organic texture, editorial typography | neutral mood overlaps |
| dark | clean/pixel texture, technical typography | paper texture |
| neutral | clean texture, geometric typography | organic texture, vibrant elements |
