# blueprint

Precise technical blueprint style with professional analytical visual presentation

## Design Aesthetic

Clean, structured visual metaphors using blueprints, diagrams, and schematics. Precise, analytical and aesthetically refined. Information presented in triptych or grid-based layouts with engineering precision.

## Background

- Color: Blueprint Off-White (#FAF8F5)
- Texture: Subtle grid overlay, light engineering paper feel

## Typography

### Primary Font (Headlines)

Neue Haas Grotesk Display Pro or similar clean sans-serif. Bold weight for titles. Precise letterforms with consistent spacing. Technical, authoritative presence.

### Secondary Font (Body)

Tiempos Text or similar elegant serif for body explanations. Clean, readable at smaller sizes. Professional editorial quality.

## Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Background | Blueprint Paper | #FAF8F5 | Primary background |
| Grid | Light Gray | #E5E5E5 | Background grid lines |
| Primary Text | Deep Slate | #334155 | Headlines, body text |
| Primary Accent | Engineering Blue | #2563EB | Key elements, highlights |
| Secondary Accent | Navy Blue | #1E3A5F | Supporting elements |
| Tertiary | Light Blue | #BFDBFE | Backgrounds, fills |
| Warning | Amber | #F59E0B | Warnings, emphasis points |

## Visual Elements

- Precise lines with consistent stroke weights
- Technical schematics and clean vector graphics
- Thin line work in technical drawing style
- Connection lines use straight lines or 90-degree angles only
- Data visualization with clean, minimal charts
- Dimension lines and measurement indicators
- Cross-section style diagrams
- Isometric or orthographic projections

## Style Rules

### Do

- Maintain consistent line weights throughout
- Use grid alignment for all elements
- Keep color palette restrained and unified
- Create clear visual hierarchy through scale
- Use geometric precision for all shapes

### Don't

- Use hand-drawn or organic shapes
- Add decorative flourishes
- Use curved connection lines
- Include photographic elements
- Add slide numbers, footers, or logos

## Best For

Technical architecture, system design, data analysis, professional business presentations, engineering documentation, process flows
