---
name: bold
category: impact
---

# Bold Style

High impact, attention-grabbing aesthetic.

## Element Combination

```yaml
canvas:
  ratio: portrait-3-4
  grid: single | dual

image_effects:
  cutout: clean
  stroke: colored-solid | double
  filter: high-saturation

typography:
  decorated: shadow-3d | stroke-text
  tags: black-white | ribbon
  direction: horizontal | diagonal

decorations:
  emphasis: exclamation | star-burst | red-arrow
  background: solid-saturated | gradient-linear
  doodles: arrows-curvy | squiggles
  frames: none
```

## Color Palette

| Role | Colors | Hex |
|------|--------|-----|
| Primary | Vibrant red, orange, yellow | #E53E3E, #DD6B20, #F6E05E |
| Background | Deep black, dark charcoal | #000000, #1A1A1A |
| Accents | White, neon yellow | #FFFFFF, #F7FF00 |

## Visual Elements

- Exclamation marks, arrows, warning icons
- Strong shapes, high contrast elements
- Dramatic compositions
- Bold geometric forms

## Typography

- Bold, impactful hand lettering with shadows
- High contrast text treatments
- Large, commanding headlines

## Best Layout Pairings

| Layout | Compatibility | Use Case |
|--------|---------------|----------|
| sparse | ✓✓ | Impactful statements |
| balanced | ✓ | Warning content |
| dense | ✓ | Critical information cards |
| list | ✓✓ | Must-know lists, rankings |
| comparison | ✓✓ | Dramatic contrasts |
| flow | ✓ | Critical process steps |

## Best For

- Important tips and warnings
- Must-know content
- Critical announcements
- Rankings and comparisons
- Attention-grabbing hooks
