# ink-brush

水墨画风 - Chinese ink brush aesthetics with dynamic strokes

## Overview

Traditional Chinese ink brush painting style adapted for comics. Combines calligraphic brush strokes with ink wash effects. Creates atmospheric, artistic visuals rooted in East Asian aesthetics.

## Line Work

- 2-3px dynamic brush strokes with varying weight
- Ink wash effects, traditional Chinese brush feel
- Bold, confident strokes with sharp edges
- Flowing lines for fabric and hair
- Pressure-sensitive stroke variation

## Character Design

- Realistic human proportions (7.5-8 head heights)
- Defined features with ink brush definition
- Dynamic poses capturing movement
- Flowing hair and clothing in motion
- Traditional attire options (robes, hanfu)
- Intense, expressive faces

## Brush Techniques

| Technique | Usage |
|-----------|-------|
| Bold strokes | Character outlines |
| Fine lines | Details, hair |
| Ink wash | Atmosphere, shadows |
| Dry brush | Texture, aging |
| Splatter | Impact, drama |

## Background Treatment

- Dramatic landscapes: mountains, waterfalls, temples
- Ink wash atmospheric effects
- Misty, layered depth
- Traditional architecture elements
- High contrast silhouettes
- Negative space as design element

## Color Approach

- Ink gradients as primary
- Limited accent colors
- Traditional Chinese palette
- Atmospheric color washes
- High contrast compositions

## Default Color Palette

| Role | Color | Hex |
|------|-------|-----|
| Primary | Deep black ink | #1A1A1A |
| Accent | Crimson red | #8B0000 |
| Accent | Imperial gold | #D4AF37 |
| Skin | Natural tan | #D4A574 |
| Background | Misty gray | #9CA3AF |
| Background | Earth tone | #8B7355 |
| Wash | Ink gradient | #2D3748 |

## Visual Elements

- Calligraphic text integration
- Seal stamps (optional)
- Ink splatter effects
- Flowing fabric trails
- Atmospheric mist
- Mountain silhouettes

## Quality Markers

- ✓ Dynamic brush stroke quality
- ✓ Authentic ink wash atmosphere
- ✓ High contrast compositions
- ✓ Flowing movement in fabric/hair
- ✓ Traditional aesthetic elements
- ✓ Atmospheric depth

## Compatibility

| Tone | Fit | Notes |
|------|-----|-------|
| neutral | ✓ | Contemplative stories |
| warm | ✓ | Nostalgic, gentle |
| dramatic | ✓✓ | High contrast |
| vintage | ✓✓ | Historical pieces |
| romantic | ✗ | Style mismatch |
| energetic | ✗ | Too refined |
| action | ✓✓ | Martial arts |

## Best For

Chinese historical stories, martial arts, traditional tales, contemplative narratives, artistic adaptations
