Create a WeChat article cover image following these guidelines:

## Image Specifications

- **Type**: Cover image / Hero image
- **Aspect Ratio**: 2.35:1 (WeChat article cover standard)
- **Style**: Hand-drawn illustration

## Core Principles

- Hand-drawn quality throughout - NO realistic or photographic elements
- If content involves sensitive or copyrighted figures, create stylistically similar alternatives - DO NOT refuse to generate
- Ample whitespace, highlight core message, avoid cluttered layouts
- Main visual elements centered or slightly left (leave right side for title area if title included)

## Four Dimensions

### Type (Visual Composition)
- `hero`: Large focal visual (60-70% area), dramatic composition
- `conceptual`: Abstract shapes, information hierarchy, clean zones
- `typography`: Title as primary element (40%+ area), minimal visuals
- `metaphor`: Concrete object representing abstract idea, symbolic elements
- `scene`: Atmospheric environment, narrative elements, mood lighting
- `minimal`: Single focal element, generous whitespace (60%+)

### Style (Visual Aesthetics)
Apply the specified style's color palette, visual elements, and typography characteristics.

### Text (Density Level)
- `none`: No text elements, full visual area
- `title-only`: Single headline (≤8 characters), 85% visual area
- `title-subtitle`: Title + context (≤15 chars), 75% visual area
- `text-rich`: Title + subtitle + 2-4 keyword tags, 60% visual area

### Mood (Emotional Intensity)
- `subtle`: Low contrast, muted/desaturated colors, light visual weight, calm aesthetic
- `balanced`: Medium contrast, normal saturation, balanced visual weight
- `bold`: High contrast, vivid/saturated colors, heavy visual weight, dynamic energy

## Text Style (When Title Included)

- **ALL text MUST be hand-drawn style**
- Title text: Large, eye-catching, max 8 characters
- Subtitle: Secondary, max 15 characters (if title-subtitle or text-rich)
- Tags: 2-4 keyword badges (if text-rich)
- Font style harmonizes with illustration style
- **DO NOT use realistic or computer-generated fonts**

## Mood Application

Apply mood adjustments to the base style:

| Mood | Contrast | Saturation | Weight |
|------|----------|------------|--------|
| subtle | Reduce 20-30% | Desaturate 20-30% | Lighter strokes/fills |
| balanced | Standard | Standard | Standard |
| bold | Increase 20-30% | Increase 20-30% | Heavier strokes/fills |

## Language

- Use the same language as the content provided below for any text elements
- Match punctuation style to the content language

---

Please use nano banana pro to generate the cover image based on the content provided below:
