# Preset → Dimension Mapping

Maps 16 preset styles to their dimension combinations.

## Mapping Table

| Preset | Texture | Mood | Typography | Density |
|--------|---------|------|------------|---------|
| blueprint | grid | cool | technical | balanced |
| chalkboard | organic | warm | handwritten | balanced |
| corporate | clean | professional | geometric | balanced |
| minimal | clean | neutral | geometric | minimal |
| sketch-notes | organic | warm | handwritten | balanced |
| watercolor | organic | warm | humanist | minimal |
| dark-atmospheric | clean | dark | editorial | balanced |
| notion | clean | neutral | geometric | dense |
| bold-editorial | clean | vibrant | editorial | balanced |
| editorial-infographic | clean | cool | editorial | dense |
| fantasy-animation | organic | vibrant | handwritten | minimal |
| intuition-machine | clean | cool | technical | dense |
| pixel-art | pixel | vibrant | technical | balanced |
| scientific | clean | cool | technical | dense |
| vector-illustration | clean | vibrant | humanist | balanced |
| vintage | paper | warm | editorial | balanced |

## Preset Details

### blueprint
- **Dimensions**: grid + cool + technical + balanced
- **Feel**: Engineering precision, analytical clarity
- **Auto-select**: architecture, system, data, analysis, technical

### chalkboard
- **Dimensions**: organic + warm + handwritten + balanced
- **Feel**: Classroom warmth, educational
- **Auto-select**: classroom, teaching, school, chalkboard

### corporate
- **Dimensions**: clean + professional + geometric + balanced
- **Feel**: Business credibility, institutional trust
- **Auto-select**: investor, quarterly, business, corporate

### minimal
- **Dimensions**: clean + neutral + geometric + minimal
- **Feel**: Maximum sophistication, executive focus
- **Auto-select**: executive, minimal, clean, simple

### sketch-notes
- **Dimensions**: organic + warm + handwritten + balanced
- **Feel**: Friendly learning, approachable education
- **Auto-select**: tutorial, learn, education, guide, beginner

### watercolor
- **Dimensions**: organic + warm + humanist + minimal
- **Feel**: Artistic, natural, lifestyle
- **Auto-select**: lifestyle, wellness, travel, artistic

### dark-atmospheric
- **Dimensions**: clean + dark + editorial + balanced
- **Feel**: Cinematic, entertainment
- **Auto-select**: entertainment, music, gaming, atmospheric

### notion
- **Dimensions**: clean + neutral + geometric + dense
- **Feel**: SaaS professional, data-forward
- **Auto-select**: saas, product, dashboard, metrics

### bold-editorial
- **Dimensions**: clean + vibrant + editorial + balanced
- **Feel**: Magazine impact, keynote drama
- **Auto-select**: launch, marketing, keynote, magazine

### editorial-infographic
- **Dimensions**: clean + cool + editorial + dense
- **Feel**: Publication quality, informative
- **Auto-select**: explainer, journalism, science communication

### fantasy-animation
- **Dimensions**: organic + vibrant + handwritten + minimal
- **Feel**: Magical, storytelling
- **Auto-select**: story, fantasy, animation, magical

### intuition-machine
- **Dimensions**: clean + cool + technical + dense
- **Feel**: Technical briefing, bilingual documentation
- **Auto-select**: briefing, academic, research, bilingual

### pixel-art
- **Dimensions**: pixel + vibrant + technical + balanced
- **Feel**: Retro gaming, developer culture
- **Auto-select**: gaming, retro, pixel, developer

### scientific
- **Dimensions**: clean + cool + technical + dense
- **Feel**: Academic precision, research quality
- **Auto-select**: biology, chemistry, medical, scientific

### vector-illustration
- **Dimensions**: clean + vibrant + humanist + balanced
- **Feel**: Flat design, friendly creative
- **Auto-select**: creative, children, kids, cute

### vintage
- **Dimensions**: paper + warm + editorial + balanced
- **Feel**: Historical, heritage storytelling
- **Auto-select**: history, heritage, vintage, expedition

## Building Custom Combinations

When user selects "Custom dimensions", combine any:

- **Texture** (5): clean, grid, organic, pixel, paper
- **Mood** (6): professional, warm, cool, vibrant, dark, neutral
- **Typography** (5): geometric, humanist, handwritten, editorial, technical
- **Density** (3): minimal, balanced, dense

Total possible combinations: 5 × 6 × 5 × 3 = **450 unique styles**

## Recommended Combinations (Beyond Presets)

| Custom Name | Texture | Mood | Typography | Density | Use Case |
|-------------|---------|------|------------|---------|----------|
| tech-minimal | clean | neutral | technical | minimal | Developer keynotes |
| warm-editorial | paper | warm | editorial | balanced | Heritage brands |
| dark-technical | grid | dark | technical | dense | Security, DevOps |
| playful-clean | clean | vibrant | humanist | balanced | Startups, apps |
