# Texture Dimension

Visual texture and background treatment.

## Options

| Option | Background | Visual Elements | Best For |
|--------|------------|-----------------|----------|
| `clean` | Pure solid color, no texture | Clean lines, geometric shapes | Executive, minimal, corporate |
| `grid` | Subtle grid overlay | Grid lines, schematics, technical diagrams | Technical, architecture, engineering |
| `organic` | Soft textures, hand-drawn feel | Brush strokes, watercolor, sketchy lines | Creative, educational, friendly |
| `pixel` | Chunky pixels, 8-bit aesthetic | Pixel art, retro game elements | Gaming, developer, nostalgic |
| `paper` | Aged/textured paper | Vintage elements, stamps, weathering | Historical, heritage, storytelling |

## Rendering Guidelines

### clean

- Solid background colors with no visible texture
- Crisp, sharp edges on all elements
- Digital precision and clarity
- Maximum contrast for readability

### grid

- Light grid overlay (5-10% opacity)
- Engineering paper or blueprint feel
- Alignment guides visible but subtle
- Technical drawing aesthetic

### organic

- Paper grain or canvas texture
- Imperfect edges, natural variations
- Hand-painted color fills
- Casual, approachable feel

### pixel

- Visible pixel grid (chunky, not fine)
- 8-bit color palette aesthetic
- Aliased edges (no smoothing)
- Retro game UI elements

### paper

- Aged paper texture (subtle creases, discoloration)
- Vintage printing artifacts
- Sepia or warm tones
- Historical document feel

## Combination Notes

| Texture | Works Best With | Avoid With |
|---------|-----------------|------------|
| clean | professional, neutral moods | handwritten typography |
| grid | cool, professional moods | handwritten, vibrant moods |
| organic | warm, vibrant moods | technical typography |
| pixel | vibrant, dark moods | editorial typography |
| paper | warm moods | geometric typography, minimal density |
