# editorial-infographic

Modern magazine-style editorial infographic with clear visual storytelling

## Design Aesthetic

High-quality magazine explainer aesthetic. Clear visual storytelling that transforms complex information into digestible narratives. Clean illustrations, structured layouts, and professional typography. Think Wired, The Verge, or high-end science publications.

## Background

- Color: Pure White (#FFFFFF) or Light Gray (#F8F9FA)
- Texture: None or subtle paper grain for print feel

## Typography

### Primary Font (Headlines)

Bold display serif or modern sans-serif. Strong visual presence. Clean letterforms with editorial sophistication. Large scale for impact.

### Secondary Font (Subheads)

Semi-bold sans-serif for section headers. Clear hierarchy distinction from body text. Consistent styling throughout.

### Body Font

Humanist sans-serif optimized for reading. Clean, professional, accessible. Comfortable line height (1.6).

## Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Background | Pure White | #FFFFFF | Primary background |
| Alt Background | Light Gray | #F8F9FA | Section backgrounds |
| Primary Text | Near Black | #1A1A1A | Headlines, body |
| Secondary Text | Dark Gray | #4A5568 | Captions, metadata |
| Accent 1 | Editorial Blue | #2563EB | Primary accent |
| Accent 2 | Coral | #F97316 | Secondary accent |
| Accent 3 | Emerald | #10B981 | Positive elements |
| Accent 4 | Amber | #F59E0B | Warning, attention |
| Dividers | Medium Gray | #D1D5DB | Section dividers |

## Visual Elements

- Clean flat illustrations (not photos)
- Structured multi-section layouts
- Callout boxes for key insights
- Icon-based data visualization
- Visual metaphors for abstract concepts
- Flow diagrams with clear directional hierarchy
- Pull quotes and highlight boxes
- Section dividers and visual breaks

## Style Rules

### Do

- Create clear visual narrative flow
- Use structured multi-section layouts
- Include callout boxes for key insights
- Design visual metaphors for complex ideas
- Maintain magazine-quality polish

### Don't

- Use photographic imagery
- Create cluttered dense layouts
- Mix too many visual styles
- Add decorative elements without purpose
- Add slide numbers, footers, or logos

## Best For

Technology explainers, science communication, research summaries, policy briefings, investigative content, educational deep-dives, thought leadership pieces
