# scientific

Educational scientific illustration style for pathways, processes, and technical diagrams

## Design Aesthetic

Academic scientific illustration aesthetic for biological pathways, chemical processes, and technical systems. Clean, precise diagrams with proper labeling and clear visual flow. Educational clarity with professional polish. Think textbook quality illustrations and academic journal figures.

## Background

- Color: Off-White (#FAFAFA) or Light Blue-Gray (#F0F4F8)
- Texture: None or very subtle paper grain for print feel

## Typography

### Primary Font (Headlines)

Clean serif font (Times New Roman style) for formal academic feel. Bold weight for main titles. Professional, authoritative presence.

### Secondary Font (Labels)

Sans-serif for diagram labels and annotations. Clear, readable at small sizes. Consistent sizing for hierarchy.

### Body Font

Serif for body paragraphs, sans-serif for bullet points and lists. Academic publication styling.

## Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Background | Off-White | #FAFAFA | Primary background |
| Primary Text | Dark Slate | #1E293B | Headlines, body |
| Label Text | Medium Gray | #475569 | Annotations |
| Pathway 1 | Teal | #0D9488 | Primary pathway |
| Pathway 2 | Blue | #3B82F6 | Secondary pathway |
| Pathway 3 | Purple | #8B5CF6 | Tertiary pathway |
| Membrane | Amber | #F59E0B | Biological membranes |
| Alert | Red | #EF4444 | Key molecules, emphasis |
| Positive | Green | #22C55E | Products, outputs |

## Visual Elements

- Horizontal membrane or structure bases
- Labeled modular components with distinct colors
- Flow arrows (electron, proton, molecule movement)
- Chemical formulas and molecular notation
- Cross-section and pathway diagrams
- Numbered step sequences
- Key molecule callouts
- Process summary boxes

## Style Rules

### Do

- Use precise, consistent line weights
- Label all components clearly
- Show directional flow with arrows
- Include chemical/molecular notation where relevant
- Create clear numbered sequences

### Don't

- Use decorative illustrations
- Create imprecise or artistic diagrams
- Omit important labels
- Use inconsistent visual language
- Add slide numbers, footers, or logos

## Best For

Biology lectures, chemistry presentations, medical education, research presentations, academic papers, scientific conferences, textbook illustrations, process documentation
