# vector-illustration

Flat vector illustration style with clear black outlines and retro soft color palette

## Design Aesthetic

Flat vector illustration with no gradients or 3D effects. Clear, uniform-thickness black outlines on all elements. Geometric simplification reducing complex objects to basic shapes. Toy model aesthetic that's cute, playful, and approachable. Panoramic horizontal compositions work well.

## Background

- Color: Cream Off-White (#F5F0E6)
- Texture: Subtle paper texture, warm nostalgic feel reminiscent of vintage prints

## Typography

### Primary Font (Headlines)

Large, bold retro serif for titles conveying authority and elegance. Think classic advertising posters. Clean letterforms with strong presence.

### Secondary Font (Subtitles)

All-caps sans-serif inside colored rectangular blocks. Label-like appearance. High contrast against block color.

### Body Font

Clean geometric sans-serif for readability. Futura, Avenir, or similar. Consistent weight throughout.

## Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Background | Cream Off-White | #F5F0E6 | Primary background |
| Outlines | Deep Charcoal | #2D2D2D | All element outlines |
| Primary Text | Black | #1A1A1A | Headlines, body |
| Accent 1 | Coral Red | #E07A5F | Primary accent, warmth |
| Accent 2 | Mint Green | #81B29A | Secondary accent, nature |
| Accent 3 | Mustard Yellow | #F2CC8F | Highlights, energy |
| Accent 4 | Burnt Orange | #D4764A | Tertiary accent |
| Accent 5 | Rock Blue | #577590 | Cool balance, tech |

## Visual Elements

- All objects have closed black outlines (coloring book style)
- Rounded line endings, avoid sharp corners
- Trees simplified to lollipop or triangle shapes
- Buildings simplified to rectangular blocks with grid windows
- 2.5D perspective (isometric-like but more free-form)
- Depth through layering and overlap, not atmospheric perspective
- Decorative geometric elements: radiating lines (sunbursts), pill-shaped clouds, dots, stars
- People as simple geometric figures with minimal facial detail

## Style Rules

### Do

- Maintain consistent outline thickness throughout
- Use soft, vintage color palette
- Simplify all objects to basic geometric shapes
- Create depth through layering
- Add playful decorative elements

### Don't

- Use gradients or realistic shading
- Create photorealistic elements
- Use thin or varying line weights
- Include complex detailed illustrations
- Add slide numbers, footers, or logos

## Best For

Educational presentations, creative proposals, children's content, brand showcases, warm approachable topics, explainer content
