---
name: job-posting-intelligence
description: Detect when companies are hiring transportation managers as a 90-120 day leading indicator of upcoming RFPs. Use when finding companies about to issue RFPs, analyzing job postings for freight opportunities, or creating outreach campaigns based on hiring signals.
---

# Job Posting Intelligence for RFP Prediction

## Purpose

This skill helps you systematically detect when companies are hiring transportation managers, which serves as a 90-120 day leading indicator of upcoming RFPs. New managers typically evaluate vendors in their first 90 days, and the job posting itself signals that budget has been allocated for logistics transformation.

## When to Use This Skill

- User wants to find companies about to issue RFPs
- Analyzing job postings for freight opportunities
- Creating outreach campaigns based on hiring signals
- Building a pipeline of pre-RFP opportunities

## Key Indicators

Transportation Manager job postings predict RFPs because:
- New manager will evaluate vendors in first 90 days
- Company recognizes need for logistics expertise
- Budget already allocated for logistics transformation
- Fresh perspective often leads to vendor changes

## Target Job Titles

Monitor these exact titles for maximum signal strength:
- Transportation Manager
- Director of Transportation
- Director of Logistics
- VP Supply Chain
- VP Logistics
- Supply Chain Manager
- Logistics Manager
- Operations Manager (with freight responsibilities)

## Critical Keywords in Job Descriptions

These keywords indicate imminent RFP:
- "carrier management"
- "vendor evaluation"
- "RFP management"
- "transportation procurement"
- "rate negotiation"
- "freight optimization"
- "TMS implementation"
- "establish carrier relationships"

## Engagement Timeline

### Day 1-7 After Posting

**Target**: Current VP/CFO
**Angle**: Headcount replacement cost savings

**Message Template**:
```
Subject: Hiring a Transportation Manager? There's a smarter way.

I noticed [Company] posted for a Transportation Manager. Before investing $140K+:

Transportation Manager (all-in): $140,000/year
CabotageTMS + managed brokerage: $25,000/year
Net savings: $115,000 Year 1

Plus: 24/7 team, 10,000+ carriers, no turnover risk.

Free offer: Let us facilitate your next RFP. Zero obligation.

15-minute call?
```

### Day 60-90 After Hire

**Target**: New Transportation Manager
**Angle**: Partnership and support

**Message Template**:
```
Subject: Free RFP facilitation for your first 90 days

Congratulations on your role at [Company]!

We help new logistics managers succeed with:
✓ Custom RFP template (saves 8-10 hours)
✓ Pre-qualified carrier network
✓ Bid analysis platform
✓ Data-driven recommendations

No obligation. 15+ managers achieved 15% savings in first 120 days.

Quick call?
```

## Tools to Use

### Essential Tools
- **LinkedIn Sales Navigator** ($135/month): Job posting alerts, decision maker identification
- **Apollo.io** ($79/month): Email finding, sequencing
- **Indeed/ZipRecruiter**: Daily job alerts

### Setup Instructions
1. Create saved searches for each target job title
2. Set up daily email alerts
3. Create CRM tag: "job_posting_lead"
4. Set up automated follow-up sequences

## Success Metrics

Track these KPIs weekly:
- Job postings discovered weekly: Target 15-20
- Outreach sent per posting: 2-3 touches
- Meeting conversion: 15-20%
- RFP inclusion rate: 60% of meetings
- Win rate: 20-25%

## Workflow Example

### Daily Routine (10 minutes)
1. Check job alerts (3 minutes)
2. Research promising companies (5 minutes per lead)
3. Send company-level outreach Day 7 (2 minutes)
4. Set reminder for Day 60 new hire outreach
5. Track in CRM with "job_posting_lead" tag

### Weekly Analysis (30 minutes)
1. Review response rates
2. Identify best-performing industries
3. Refine messaging based on results
4. Update target company list

## Best Practices

1. **Speed Matters**: Reach out within 7 days of posting
2. **Personalize**: Reference specific job posting details
3. **Dual Track**: Target both hiring executive AND new hire
4. **Track Everything**: CRM discipline is critical
5. **Test Messages**: A/B test subject lines and angles
6. **Follow Up**: 80% of value comes from follow-ups

## Common Objections & Responses

**"We're happy with current broker"**
→ "Great! This is perfect timing to benchmark rates during your RFP process."

**"Not looking to change"**
→ "Even better - no obligation. Let us participate to ensure your current provider stays competitive."

**"Too busy right now"**
→ "Exactly why we offer free RFP facilitation. We do the work, you get market data."

## Integration with Other Skills

- Use **RFP Early Detection** to validate signals
- Feed leads into **Campaign Orchestration** for automated follow-up
- Apply **Competitive Displacement** tactics when current broker is identified
- Coordinate with **Master Intelligence Orchestration** for prioritization
