---
name: journey-mapping
description: 모든 터치포인트에서 고객 경험을 시각화하고 분석하는 포괄적인 고객 여정 맵을 작성합니다.
---

# 고객 여정 맵 작성

## 목적

고객의 여정을 시각화하고 분석하는 User Journey Map을 작성합니다.

## 사용 시점

- 고객경험 단계 정의와 고객 경험 조사가 완료된 후
- 고객의 전체 경험 흐름을 시각화해야 할 때
- Pain point와 기회를 식별해야 할 때
- 사용자가 "여정 맵", "고객 여정", "UX 맵"을 언급할 때

## 필수 입력
- MVP 주제
- 타겟 고객 정의
- 고객경험 단계: `define/고객경험단계.md` (customer-journey-stages 결과)
- 고객 경험 조사 데이터 (customer-experience 결과):
  - `define/관찰결과.md`
  - `define/체험결과.md`
  - `define/고객경험인터뷰결과.md`
  - `define/고객경험인터뷰결과취합.md`

## 여정 맵 구성 요소

### 1. 페르소나
대표 사용자를 정의합니다:
- 이름, 나이, 직업
- 배경 및 상황
- 목표 및 동기
- 기술 숙련도

### 2. 고객경험 단계

**중요**: customer-journey-stages 스킬에서 정의한 고객경험 단계를 X축으로 사용합니다.

예시: `니즈 인식 -> 방법 탐색 -> 수집 -> 분류/정리 -> 활용 -> 최적화/관리`

각 단계를 다음 요소로 분석합니다:

#### {고객경험 단계 1}
- **고객 행동**: 무엇을 하는가?
- **생각**: 무엇을 생각하는가?
- **감정**: 어떻게 느끼는가? (감정 곡선)
- **터치포인트**: 어디에서 서비스와 상호작용하는가?
- **Pain Points**: 어려움과 장애물
- **Gain Points**: 긍정적 경험과 만족 요소

#### {고객경험 단계 2}
[동일한 분석 프레임워크]

(모든 고객경험 단계 반복)

### 3. 핵심 인사이트
발견사항 요약:
- 가장 큰 pain points 상위 3개
- 개선 기회 영역
- 감정의 고점과 저점
- 이탈 위험 지점

### 4. 기회 영역
혁신 영역 식별:
- 높은 우선순위 개선 영역
- 혁신이 필요한 터치포인트
- 차별화 포인트

## 작성 형식

```markdown
# 고객 여정 맵

## 페르소나

### 대표 사용자
- **이름**: {이름} ({나이}, {직업})
- **배경**: {배경 및 상황}
- **목표**: {목표 및 동기}
- **기술 숙련도**: {낮음/중간/높음}

## 고객경험 단계
\```
{단계1} -> {단계2} -> {단계3} -> {단계4} -> {단계5}
\```

## 여정 맵 상세

### {단계1}: {단계명}

**고객 행동**
- {행동 1}
- {행동 2}

**생각**
- "{생각 1}"
- "{생각 2}"

**감정**
- 감정 상태: 😊 / 😐 / 😞
- 감정 레벨: ★★★☆☆ (5점 만점)

**터치포인트**
- {터치포인트 1}
- {터치포인트 2}

**Pain Points** 😞
1. {pain point 1}
2. {pain point 2}

**Gain Points** 😊
1. {gain point 1}
2. {gain point 2}

---

### {단계2}: {단계명}
[동일한 구조 반복]

(모든 고객경험 단계 반복)

---

## 감정 곡선

\```
 높음 ┤     ╭─╮
      │    ╱   ╲    ╭─╮
      │   ╱     ╲  ╱   ╲
 중간 ┤  ╱       ╲╱     ╰─╮
      │ ╱                  ╲
 낮음 ┤╯                    ╰
      └─────────────────────────>
       단계1  단계2  단계3  단계4  단계5
\```

## 핵심 인사이트

### 주요 Pain Points
1. **{Pain Point 1}** (단계: {단계}, 심각도: 높음)
2. **{Pain Point 2}** (단계: {단계}, 심각도: 중간)
3. **{Pain Point 3}** (단계: {단계}, 심각도: 중간)

### 개선 기회 영역
1. **{영역 1}**: {설명}
2. **{영역 2}**: {설명}

### 감정의 고점과 저점
- **감정 고점**: {단계} - {이유}
- **감정 저점**: {단계} - {이유}

### 이탈 위험 지점
- **위험 단계**: {단계}
- **이탈 이유**: {이유}
- **영향**: {영향}

## 기회 영역

### 높은 우선순위 개선 영역
1. **{영역 1}**
   - 현재 문제: {문제}
   - 개선 방향: {방향}
   - 예상 효과: {효과}

2. **{영역 2}**
   - 현재 문제: {문제}
   - 개선 방향: {방향}
   - 예상 효과: {효과}

### 혁신이 필요한 터치포인트
- {터치포인트 1}: {혁신 아이디어}
- {터치포인트 2}: {혁신 아이디어}

### 차별화 포인트
- {차별화 1}
- {차별화 2}
```

## 시각화 가이드라인

- 감정 곡선을 이모지나 텍스트로 표현
  - 😊 긍정
  - 😐 중립
  - 😞 부정
- 명확한 단계 경계 사용
- 중요한 순간 강조
- 시간 경과에 따른 감정 궤적 표시

## 중요 고려사항

- 고객 경험 조사 데이터를 광범위하게 활용
- 인터뷰의 Pain Points와 니즈 사용
- 관찰의 행동 패턴 적용
- 체험의 실제 감정과 만족도 반영
- End-to-end 고객 경험에 집중
- 결정적 순간(moment of truth) 식별
- 개선 기회 우선순위화

## 도구 활용

### Sequential MCP 사용
복잡한 여정 분석과 패턴 식별이 필요할 때 Sequential MCP를 활용하여 체계적으로 인사이트를 도출하세요.

## 결과 파일

- **유저저니맵.md**: `define/유저저니맵.md`
- **유저저니맵.svg**: `define/유저저니맵.svg`

## 주의사항

- 고객경험 단계를 X축으로 사용 (customer-journey-stages 결과)
- 실제 고객 데이터 기반 작성 (추측 X)
- 감정 곡선은 정량적 데이터 기반
- Pain point는 구체적이고 측정 가능하게
- 터치포인트는 실제 접점 위주로
- 개선 기회는 실행 가능하게

## 다음 단계

고객 여정 맵 작성 완료 후:
1. 문제 가설 정의 (Pain point 기반)
2. 킹핀 문제 및 방향성 정의
3. 아이디어 발상
