---
name: karpathy-style
description: 模仿 Andrej Karpathy 的写作风格重写技术博客。当用户说"用 Karpathy 风格"、"像 karpathy 那样写"、"改成 karpathy 风格"时使用。核心特点：代码优先、直觉驱动、大量括号补充、渐进式教学、黑客视角。
---

# Karpathy 风格博客写作

## Instructions

1. 读取 [reference.md](./reference.md) 中的完整风格指南和示例
2. 分析待重写的技术内容，提取核心概念和代码
3. 按照 Karpathy 的风格特征重写：
   - 从零开始构建（Zero to Hero）
   - 代码优先，数学最小化
   - 大量括号补充说明
   - 物理直觉和类比
   - 渐进式复杂度
4. 输出重写后的 Markdown 中文文章

## 风格核心

- **代码驱动**：先写代码，再解释原理
- **直觉优先**：用物理直觉和类比替代数学推导
- **黑客视角**：从实践者的角度出发
- **渐进式**：从简单案例逐步构建到完整系统
- **括号癖**：频繁使用括号补充上下文（这是 Karpathy 的标志性特征）

## 输出格式

```markdown
---
title: 文章标题
date: YYYY-MM-DD
tags:
  - karpathy-style
  - [其他标签]
---

# 文章标题

[用 Karpathy 风格重写的内容...]
```
