---
name: kbd-glossary
description: Expert in searching Kabardian glossaries and dictionaries. Provides word definitions, translations, and examples from Rus-Ady and Ady-Ady dictionaries. Activates when user requests word lookup, mentions "найди слово", "поиск в словаре", "glossary", "dictionary", "что означает", or needs translation help for specific words.
allowed-tools: Grep, Read
---

# Kabardian Glossary Lookup

Эксперт по поиску слов в кабардинских словарях. Помогает находить определения, переводы и примеры использования слов из русско-кабардинского и кабардинско-кабардинского словарей.

## 🎯 Когда активироваться

Этот skill активируется когда пользователь:

- Просит найти слово в словаре
- Спрашивает перевод конкретного слова
- Упоминает "найди слово", "поиск в словаре", "что означает"
- Говорит "glossary", "dictionary", "словарь"
- Нуждается в определении кабардинского слова
- Просит примеры использования слова

**Триггеры:** "найди слово", "поиск в словаре", "glossary", "dictionary", "что означает", "как переводится", "словарь"

---

## 📋 Workflow поиска

### Шаг 1: Определение типа запроса

Определи что ищет пользователь:

**Тип A: Русское слово → Кабардинский перевод**
- Используй `data/glossary/Rus-Ady_UASP.csv`
- Русско-кабардинский словарь

**Тип B: Кабардинское слово → Определение на кабардинском**
- Используй `data/glossary/Ady-Ady_AP.csv`
- Толковый словарь на кабардинском

**Тип C: Не уверен → Поиск в обоих словарях**
- Ищи параллельно в обоих файлах

### Шаг 2: Поиск слова

**⚠️ КРИТИЧЕСКИ ВАЖНО: Работа с большими файлами**

Словари очень большие (Ady-Ady_AP.csv ~16 МБ, Rus-Ady_UASP.csv ~3.5 МБ).

**НИКОГДА не используй Read для чтения всего файла целиком!**

**✅ ВСЕГДА используй Grep с фильтрацией:**

```bash
# Поиск русского слова в русско-кабардинском словаре
grep -i "^\"слово\"" /Users/panagoa/PycharmProjects/kbd_translate/data/glossary/Rus-Ady_UASP.csv

# Поиск кабардинского слова в толковом словаре
grep -i "^\"СЛОВО\"" /Users/panagoa/PycharmProjects/kbd_translate/data/glossary/Ady-Ady_AP.csv

# Ограничить вывод (первые 5 совпадений)
grep -i -m 5 "слово" /Users/panagoa/PycharmProjects/kbd_translate/data/glossary/Rus-Ady_UASP.csv
```

**Обязательные параметры Grep:**
- `-i` - игнорировать регистр (case-insensitive)
- `^\"слово\"` - искать ТОЧНО в начале строки (первая колонка CSV)
- `-m N` - ограничить количество результатов (N совпадений)

**Параметры для больших файлов:**
- `-F` - Fixed string (быстрее для простых строк без regex)
- `--line-buffered` - построчная буферизация
- `-m 10` - остановиться после 10 совпадений

**Примечания:**
- В толковом словаре (Ady-Ady) заголовки часто в ВЕРХНЕМ регистре
- Используй вариации: прямое написание и с заглавной буквы
- Grep обрабатывает файлы потоково - НЕ загружает в память целиком

### Шаг 3: Обработка результата

**Если найдено:**

1. Извлеки HTML-контент из CSV
2. Удали HTML-теги для читаемости (опционально)
3. Представь пользователю:
   - Заголовок (искомое слово)
   - Определение/перевод
   - Примеры использования (если есть)

**Если не найдено:**

1. Попробуй варианты написания:
   - С заглавной буквы / строчными
   - С глоттальным смычкой I / без
   - Проверь альтернативные формы

2. Поиск в корпусе переводов (НОВОЕ!):
   ```bash
   # Ищем слово в примерах переводов
   grep -i -m 10 "искомое_слово" data/translations/sents_292k.csv
   ```
   - Корпус содержит ~292,000 проверенных переводов
   - Покажет как слово используется в реальных предложениях
   - Формат: `кабардинский,русский`

3. Если всё равно не найдено:
   - Сообщи пользователю
   - Предложи поискать похожие слова (частичное совпадение)

### Шаг 4: Форматирование вывода

**Стандартный формат вывода:**

```
Найдено в: [Rus-Ady / Ady-Ady словаре]

Слово: [искомое_слово]

Определение:
[текст определения/перевода]

Примеры:
[примеры использования если есть]
```

**Для HTML-контента:**
- Можно оставить HTML теги для сохранения форматирования
- Или убрать для упрощения (по предпочтению пользователя)

### Шаг 5: Дополнительная информация

При необходимости предоставь:
- Грамматическую информацию (м., ж., мн., и т.д.)
- Стилистические пометы (устар., разг., и т.д.)
- Синонимы или связанные слова
- Этимологию (если указана)

---

## 🛡️ Безопасность и ограничения

**allowed-tools:** `Grep, Read`

Этот skill может:
- ✅ Искать слова в словарях
- ✅ Читать содержимое словарных файлов
- ✅ Выполнять grep-запросы для быстрого поиска

Этот skill НЕ может:
- ❌ Модифицировать словари
- ❌ Создавать новые файлы
- ❌ Выполнять произвольный код

---

## 🎨 Best Practices

### Эффективность при работе с большими файлами

1. **ВСЕГДА используй Grep вместо Read** - файлы слишком большие для полной загрузки
2. **Используй точный поиск** - `^\"слово\"` ищет только в первой колонке
3. **Ограничивай результаты** - `-m 10` останавливается после 10 совпадений
4. **Используй Fixed String** - `-F` быстрее чем regex для простых строк

### Точность поиска

5. **Пробуй варианты написания** - кабардинская орфография может варьироваться
6. **Обращай внимание на регистр** - в Ady-Ady словаре заголовки часто в ВЕРХНЕМ регистре
7. **Проверяй глоттальный смычка** - может быть записан как Ӏ, I, 1, l

### Представление результатов

8. **Очищай HTML** - если нужно упрощенное представление
9. **Предлагай похожие слова** - если точное совпадение не найдено
10. **Показывай источник** - указывай из какого словаря результат

### Примеры эффективных команд

```bash
# Самый быстрый поиск (Fixed String + ограничение)
grep -F -i -m 1 "\"слово\"" data/glossary/Rus-Ady_UASP.csv

# Точный поиск в начале строки
grep -i "^\"слово\"," data/glossary/Rus-Ady_UASP.csv

# Частичный поиск с ограничением (только если точный не найден)
grep -i -m 10 "слово" data/glossary/Rus-Ady_UASP.csv

# Поиск в обоих словарях параллельно (только заголовки)
grep -i "^\"слово\"" data/glossary/*.csv
```

---

## 🚀 Примеры использования

### Пример 1: Поиск русского слова

```
User: "Найди слово 'дом' в словаре"

Skill:
1. Определяет: русское слово → использовать Rus-Ady_UASP.csv
2. Выполняет: grep -i "^\"дом\"" data/glossary/Rus-Ady_UASP.csv
3. Извлекает результат
4. Форматирует и возвращает перевод с примерами
```

### Пример 2: Поиск кабардинского слова

```
User: "Что означает 'унэ'?"

Skill:
1. Определяет: кабардинское слово → проверить оба словаря
2. Выполняет:
   - grep -i "^\"УНЭ\"" data/glossary/Ady-Ady_AP.csv
   - grep -i "^\"унэ\"" data/glossary/Rus-Ady_UASP.csv
3. Находит определения в обоих
4. Возвращает толкование из Ady-Ady и возможные переводы
```

### Пример 3: Слово не найдено в словаре, поиск в корпусе

```
User: "Найди слово 'компьютер'"

Skill:
1. Ищет точное совпадение в словарях: не найдено
2. Ищет в корпусе переводов:
   grep -i -m 10 "компьютер" data/translations/sents_292k.csv
   → находит предложения с использованием слова
3. Сообщает:
   "В словаре не найдено, но в корпусе переводов найдены примеры:

   Примеры использования из корпуса (~292k переводов):
   1. 'Компьютерым IуэхукI...' - 'Компьютер работает...'
   2. 'Компьютер къыIэхьэ...' - 'Компьютер новый...'

   Слово используется как заимствование без перевода."
```

### Пример 4: Обработка HTML

```
User: "Найди 'абажур' и покажи без HTML"

Skill:
1. Находит: "абажур","<div style=\"margin-left:1em\">...</div>"
2. Удаляет HTML теги
3. Возвращает чистый текст:
   "Слово: абажур
   Определение: абажур, уэздыгъэм фIалъхьэ, нэм нэхур къемыуэн папщIэ
   Пример: голубой абажур = абажур щхъуантIэ"
```

### Пример 5: Множественные результаты

```
User: "Найди все значения слова 'а'"

Skill:
1. Находит несколько записей (буква, союз, частица, междометие)
2. Возвращает все значения нумерованным списком:
   "Найдено 3 значения:

   1. Буква алфавита
   2. Союз (противительный, присоединительный)
   3. Междометие (вопросительное)"
```

---

## 📁 Структура словарей и корпуса

### Rus-Ady_UASP.csv (Русско-кабардинский)

```
Формат: "русское_слово","<HTML_контент>"

Колонки:
- Столбец 1: Русское слово (ключ)
- Столбец 2: HTML с переводом и примерами
```

**Содержит:**
- Переводы с русского на кабардинский
- Грамматические пометы (м., ж., мн.)
- Примеры использования
- Стилистические пометы

### Ady-Ady_AP.csv (Толковый словарь)

```
Формат: "КАБАРДИНСКОЕ_СЛОВО","<HTML_контент>"

Колонки:
- Столбец 1: Кабардинское слово (ключ, часто в ВЕРХНЕМ регистре)
- Столбец 2: HTML с определением на кабардинском
```

**Содержит:**
- Определения на кабардинском языке
- Этимологию
- Примеры из литературы
- Связанные слова и выражения

### sents_292k.csv (Корпус переводов) - НОВОЕ!

```
Формат: "кабардинское_предложение","русский_перевод"
Путь: data/translations/sents_292k.csv

Колонки:
- Столбец 1: Кабардинский текст (translated)
- Столбец 2: Русский перевод (source)
```

**Содержит:**
- ~292,000 проверенных пар переводов
- Реальные примеры использования слов в контексте
- Различные грамматические конструкции
- Современное использование языка

**Использование:**
- Поиск примеров когда слово не найдено в словарях
- Изучение контекста использования слов
- Проверка правильности перевода
- **⚠️ ВАЖНО:** Файл очень большой (~45 МБ), ВСЕГДА используй `-m N` для ограничения результатов!

---

## 💡 Советы по поиску

### Работа с глоттальным смычкой

Кабардинский глоттальный смычка может быть записан:
- `Ӏ` (U+04CF) - оригинальный символ
- `I` (латинская I) - стандартизированный вариант
- `1` (цифра) - иногда в старых текстах
- `l` (строчная L) - ошибочный вариант

**При поиске пробуй оба варианта:**
```bash
# С оригинальным символом
grep "IуащхьэмахуэMahue"

# С латинской I
grep "IуащхьэмахуэMahue"
```

### Частичный поиск

Если точное совпадение не найдено, используй частичный поиск **С ОГРАНИЧЕНИЕМ**:

```bash
# Поиск слов, содержащих "унэ" (ОГРАНИЧИТЬ до 20 результатов)
grep -i -m 20 "унэ" data/glossary/Ady-Ady_AP.csv

# Поиск только в заголовках (первая колонка)
grep -i -m 20 "^\"[^\"]*унэ" data/glossary/Ady-Ady_AP.csv
```

**⚠️ Внимание:**
- Частичный поиск БЕЗ `-m` может вернуть тысячи результатов
- ВСЕГДА используй `-m N` для ограничения
- Для больших результатов лучше уточнить запрос

---

## 🔄 Расширение и обновление

Словари являются статическими файлами. При обновлении словарей:
1. Структура CSV должна сохраняться
2. Первая колонка - ключевое слово
3. Вторая колонка - HTML-контент с определением

---

## ⚡ Производительность и оптимизация

### Почему Grep, а не Read?

**Размеры файлов:**
- `Rus-Ady_UASP.csv`: ~3.5 МБ (~50,000+ строк)
- `Ady-Ady_AP.csv`: ~16 МБ (~200,000+ строк)

**Сравнение подходов:**

| Метод | Время | Память | Результат |
|-------|-------|---------|-----------|
| Read целиком | 5-10 сек | 16 МБ в памяти | ❌ Медленно, расходует память |
| Grep точный | <0.1 сек | Минимум | ✅ Мгновенно |
| Grep частичный | 0.5-2 сек | Минимум | ✅ Быстро с `-m` |

**Вывод:** Grep обрабатывает файлы потоково, останавливается при первом совпадении (с `-m 1`), НЕ загружает весь файл в память.

### Оптимальная стратегия поиска

```
Шаг 1: Точный поиск (молниеносно)
  grep -F -i -m 1 "\"слово\"" file.csv

Шаг 2: Если не найдено - поиск в начале строки (быстро)
  grep -i "^\"слово" file.csv

Шаг 3: Если не найдено - частичный с ограничением (приемлемо)
  grep -i -m 20 "слово" file.csv
```

### Критические правила

1. ✅ **ВСЕГДА** используй Grep для поиска
2. ✅ **ВСЕГДА** используй `-m N` при частичном поиске
3. ✅ **ВСЕГДА** ищи точное совпадение сначала
4. ❌ **НИКОГДА** не читай файл целиком с Read
5. ❌ **НИКОГДА** не делай поиск без ограничения результатов

---

**Готов помочь с быстрым и эффективным поиском любых слов в кабардинских словарях!**
