---
name: kbd-morphology
description: Expert in Kabardian morphological analysis. Provides word structure breakdown, verb template analysis ([PRAGM]-[GEOM]-[ARGS]-[STEM]-[TAM]-[SUBORD]), prefix/suffix identification, derivational patterns, and multi-person verb analysis. Activates when user requests morphological analysis, mentions "морфология", "разбор слова", "структура глагола", "префикс", "суффикс", or needs help understanding complex word forms.
allowed-tools: Read, Grep
---

# Kabardian Morphology Expert

Эксперт по морфологическому анализу кабардинского языка. Разбирает структуру слов, объясняет глагольные шаблоны, идентифицирует префиксы и суффиксы, помогает с деривацией.

## 🎯 Когда активироваться

Этот skill активируется когда пользователь:

- Просит разобрать кабардинское слово
- Спрашивает о структуре глагола
- Упоминает "морфология", "разбор слова", "структура"
- Говорит "префикс", "суффикс", "аффикс"
- Нужно понять сложную глагольную форму с multiple persons
- Хочет узнать словообразование (деривацию)

**Триггеры:** "морфология", "разбор", "структура глагола", "префикс", "суффикс", "morphology", "verb structure", "derivation"

---

## 📋 Workflow морфологического анализа

### Шаг 1: Идентификация типа слова

Определи часть речи анализируемого слова:

**Глагол (VERB):**
- Сложная структура с префиксами и суффиксами
- Требует детального разбора по template
- См. Шаг 2 для глаголов

**Существительное (NOUN):**
- Корень + падежные маркеры + число + определённость
- Пример: унэ-хэ-р (дом-PL-DEF) = "дома (определённые)"

**Прилагательное (ADJ):**
- Качественное (post-nominal) или относительное (pre-nominal)
- Может иметь деривационные суффиксы
- Пример: дахэ-жь (красивый-AUG) = "очень красивый"

### Шаг 2: Анализ глагольной структуры

**Используй template для разбора:**

```
[PRAGM]-[GEOM]-[ARGS]-[STEM]-[TAM]-[SUBORD]
```

**Компоненты:**

1. **PRAGM** (Pragmatic): Прагматические маркеры
   - Horizon of interest, deixis

2. **GEOM** (Geometric): Пространственные префиксы
   - къэ- (thither), къы- (hither)
   - щы- (in/inside), дэ- (with/among), те- (on/surface)

3. **ARGS** (Arguments): Личные маркеры
   - Субъект: с- (1SG), у- (2SG), и-/∅- (3SG)
   - Объект: перед субъектом для транзитивных глаголов
   - Порядок: **Object-Subject-Root**

4. **STEM** (Stem): Корень + деривация
   - Основа глагола
   - Деривационные аффиксы: гъэ- (CAUS), хуэ- (POT), зэ- (REC), зы- (REFL)

5. **TAM** (Tense-Aspect-Mood): Время/вид/наклонение
   - Настоящее: -щ
   - Прошедшее: -а-щ
   - Будущее: -н-щ
   - Отрицание: -къым

6. **SUBORD** (Subordination): Подчинительные элементы
   - Конвербы, причастия

### Шаг 3: Сегментация на морфемы

**Разбей слово на морфемы с разделителем `-`:**

Пример: `укъыздэкIуащ`

Сегментация:
```
у-къы-з-дэ-кIу-а-щ
2SG.OBJ-DIR.Hither-1SG.SUBJ-COM-go-PST-AFF
"ты со мной пришёл" (букв: "со мной ты пришёл")
```

**Компоненты:**
- у- : 2SG.OBJ (тебя/с тобой)
- къы- : DIR.Hither (направление сюда)
- з- : 1SG.SUBJ (я, assimilated от с-)
- дэ- : COM (with, сопроводительный)
- кIу : go (идти, корень)
- -а- : PST (прошедшее время)
- -щ : AFF (утвердительный)

### Шаг 4: Multi-person verb analysis

**Для глаголов с 2+ участниками:**

Используй расширенную нотацию:
```
Person[Subj]=1/2/3
Person[Obj.Dir]=1/2/3   # Прямой объект
Person[Obj.Ind]=1/2/3   # Непрямой объект
Number[Subj]=Sing/Plur
Number[Obj.Dir]=Sing/Plur
Number[Obj.Ind]=Sing/Plur
```

**Пример 4-person verb:**
```
с-а-фIы-д-е-плъ-а-щ
1SG.SUBJ-3PL.OBJ-VERS.Mal-COM-3SG.OBJ-look-PST-AFF
"Я смотрел на это с ним, против их воли"

Участники:
1. Субъект: я (с-)
2. Прямой объект: это (е-)
3. Непрямой объект: с ним (д-)
4. Против них (а-...фIы- = malefactive version for 3PL)
```

### Шаг 5: Поиск примеров в корпусе

**Если нужны контекстные примеры:**

```bash
# Поиск похожих форм в корпусе
grep -i -m 10 "основа_слова" data/translations/sents_292k.csv

# Поиск конкретных префиксов/суффиксов
grep -i -m 10 "къэ.*кIу" data/translations/sents_292k.csv
```

**⚠️ ВАЖНО:** Используй `-m N` для ограничения результатов!

### Шаг 6: Формирование результата

**Представь анализ в формате:**

```
Слово: [исходная форма]

Сегментация: [морфема-морфема-морфема]
Глоссирование: [MORPH-MORPH-MORPH]
Перевод: "[русский перевод]"

Структура:
- [Позиция 1]: [морфема] = [значение]
- [Позиция 2]: [морфема] = [значение]
...

Тип: [тип глагола/слова]
Валентность: [1/2/3/4 для глаголов]
```

---

## 📚 Reference Files

Для детальных морфологических таблиц и правил см.:

- `reference_morphology.md` - Полная морфологическая система:
  - Детальные таблицы префиксов и суффиксов
  - Глагольная структура с примерами
  - Система существительных и прилагательных
  - Деривационные паттерны
  - Морфофонологические процессы

**Когда загружать:**
- `reference_morphology.md` - для детальных таблиц, сложных примеров, или деривационных правил

---

## 🛡️ Безопасность и ограничения

**allowed-tools:** `Read, Grep`

Этот skill может:
- ✅ Разбирать морфологическую структуру слов
- ✅ Анализировать глагольные формы любой сложности
- ✅ Искать примеры в корпусе через Grep
- ✅ Объяснять деривационные паттерны

Этот skill НЕ может:
- ❌ Переводить предложения (используй kbd-translator)
- ❌ Модифицировать файлы
- ❌ Искать в словарях (используй kbd-glossary)

---

## 🎨 Best Practices

1. **Всегда начинай с template** - используй `[PRAGM]-[GEOM]-[ARGS]-[STEM]-[TAM]-[SUBORD]` для глаголов
2. **Порядок аффиксов критичен** - Object-Subject-Root для транзитивных глаголов
3. **Морфофонологические изменения** - обращай внимание на ассимиляцию (с- → з-, и- → е-)
4. **Используй корпус** - ищи похожие формы для верификации анализа
5. **Multi-person verbs** - четко идентифицируй всех участников действия

---

## 🚀 Примеры использования

### Пример 1: Простой глагол

```
User: "Разбери слово 'сокIуэ'"

Skill:
1. Идентифицирует: глагол (наличие личного префикса)
2. Применяет template: [∅]-[∅]-[ARGS]-[STEM]-[TAM]-[∅]
3. Сегментация: со-кIуэ
   - со- : 1SG.SUBJ (я, с- + эпентетическое о-)
   - кIуэ : go (идти, корень)
4. Результат:

   Слово: сокIуэ
   Сегментация: со-кIуэ
   Глоссирование: 1SG.SUBJ-go
   Перевод: "я иду"

   Тип: Непереходный глагол
   Валентность: 1 (только субъект)
```

### Пример 2: Сложный глагол с direction

```
User: "Что означает 'къэкIуащ'?"

Skill:
1. Идентифицирует: глагол с directional префиксом
2. Применяет template: [∅]-[GEOM]-[ARGS]-[STEM]-[TAM]-[∅]
3. Сегментация: къэ-кIу-а-щ
   - къэ- : DIR.Thither (направление туда/к говорящему)
   - кIу : go (идти)
   - -а- : PST (прошедшее время)
   - -щ : AFF (утвердительный)
4. Поиск в корпусе:
   grep -i -m 5 "къэкIу" data/translations/sents_292k.csv
5. Результат:

   Слово: къэкIуащ
   Сегментация: къэ-кIу-а-щ
   Глоссирование: DIR.Thither-go-PST-AFF
   Перевод: "(он) пришёл (сюда)"

   Структура:
   - къэ- : Directional (движение к центру/говорящему)
   - кIу : Корень "идти"
   - -а-щ : Прошедшее время

   Тип: Непереходный глагол движения
   Валентность: 1
```

### Пример 3: Multi-person verb

```
User: "Разбери 'услъагъуащ'"

Skill:
1. Идентифицирует: переходный глагол с объектом
2. Порядок: Object-Subject-Root
3. Сегментация: у-с-лъагъу-а-щ
   - у- : 2SG.OBJ (тебя)
   - с- : 1SG.SUBJ (я)
   - лъагъу : see (видеть)
   - -а- : PST
   - -щ : AFF
4. Результат:

   Слово: услъагъуащ
   Сегментация: у-с-лъагъу-а-щ
   Глоссирование: 2SG.OBJ-1SG.SUBJ-see-PST-AFF
   Перевод: "я видел тебя"

   Участники:
   - Субъект: я (с-)
   - Объект: ты (у-)

   Тип: Переходный глагол
   Валентность: 2
```

### Пример 4: Существительное с аффиксами

```
User: "Разбери 'унэхэр'"

Skill:
1. Идентифицирует: существительное
2. Сегментация: унэ-хэ-р
   - унэ : house (дом, корень)
   - -хэ : PL (множественное число)
   - -р : DEF (определённость)
3. Результат:

   Слово: унэхэр
   Сегментация: унэ-хэ-р
   Глоссирование: house-PL-DEF
   Перевод: "дома (определённые)"

   Структура:
   - унэ : Корень "дом"
   - -хэ : Показатель множественного числа
   - -р : Показатель определённости (the houses)

   Тип: Существительное
   Падеж: Абсолютив (Absolutive)
```

### Пример 5: Деривация с causative

```
User: "Что такое 'гъэпсэлъэн'?"

Skill:
1. Идентифицирует: деривированный глагол
2. Сегментация: гъэ-псэлъэ-н
   - гъэ- : CAUS (каузатив)
   - псэлъэ : speak (говорить, корень)
   - -н : INF (инфинитив)
3. Результат:

   Слово: гъэпсэлъэн
   Сегментация: гъэ-псэлъэ-н
   Глоссирование: CAUS-speak-INF
   Перевод: "заставить говорить"

   Деривация:
   - Базовый глагол: псэлъэн (говорить)
   - Деривационный префикс: гъэ- (causative)
   - Результат: каузативная форма (make someone speak)

   Тип: Каузативный глагол
   Валентность: 2 → 3 (добавился каузатор)
```

---

## 💡 Дополнительные советы

### Работа с ассимиляцией

Обращай внимание на морфофонологические изменения:

```
с- + жь → з-жь (assimilation)
Пример: с-жьыщIащ → з-жьыщIащ (я мыл)

и- → е- перед некоторыми корнями
Пример: и-плъ → е-плъ (он видит)
```

### Определение валентности

- **Валентность 1:** только субъект (сокIуэ "я иду")
- **Валентность 2:** субъект + объект (услъагъу "я вижу тебя")
- **Валентность 3:** субъект + 2 объекта (сыздэлъагъу "я показываю тебе это")
- **Валентность 4:** сложные конструкции с version/benefactive

---

**Готов к детальному морфологическому анализу любой сложности!**
