# Kabardian Morphology Reference

> Детальная справка по морфологической системе кабардинского языка

---

## 1. Глагольная структура

### Template глагола

```
[PRAGM]-[GEOM]-[ARGS]-[STEM]-[TAM]-[SUBORD]
```

**Полное описание позиций:**

| Позиция | Название | Функция | Примеры |
|---------|----------|---------|---------|
| 1 | PRAGM | Прагматические маркеры | Horizon of interest, deixis |
| 2 | GEOM | Геометрические пре-глаголы | къэ-, къы-, щы-, дэ-, те-, хэ- |
| 3 | ARGS | Личные маркеры (аргументы) | с-, у-, и-, д-, ф-, я- |
| 4 | STEM | Корень + деривация | кIу, лъагъу + гъэ-, хуэ-, зэ-, зы- |
| 5 | TAM | Время/вид/наклонение | -щ, -а-щ, -н-щ, -къым |
| 6 | SUBORD | Подчинение | Конвербы, причастия |

---

## 2. Личные маркеры (ARGS)

### 2.1 Субъектные префиксы

| Лицо/Число | Префикс | Пример | Глоссирование |
|------------|---------|--------|---------------|
| 1 SG | с(ы)- | **с**окIуэ | 1SG.SUBJ-go "я иду" |
| 2 SG | у(э)- | **у**кIуэ | 2SG.SUBJ-go "ты идёшь" |
| 3 SG | и-, е-, ∅- | **и**кIуэ / кIуэ | 3SG.SUBJ-go "он идёт" |
| 1 PL | д(ы)- | **д**окIуэ | 1PL.SUBJ-go "мы идём" |
| 2 PL | ф(ы)- | **ф**окIуэ | 2PL.SUBJ-go "вы идёте" |
| 3 PL | (∅)- | мэкIуэх | 3PL.SUBJ-go "они идут" |

**Примечания:**
- Эпентетические гласные (ы, о, э) для предотвращения consonant clusters
- с- → з- перед звонкими согласными (ассимиляция)
- и- → е- в некоторых контекстах

### 2.2 Объектные префиксы

| Лицо/Число | Префикс | Позиция |
|------------|---------|---------|
| 1 SG | с(ы)- | Перед субъектом |
| 2 SG | у(э)- | Перед субъектом |
| 3 SG | и-, е- | Перед субъектом |
| 1 PL | д(ы)- | Перед субъектом |
| 2 PL | ф(ы)- | Перед субъектом |
| 3 PL | я- | Перед субъектом |

**Порядок для транзитивных глаголов:**
```
Object - Subject - Root
```

**Примеры:**
```
у-с-лъагъу-а-щ
2SG.OBJ-1SG.SUBJ-see-PST-AFF
"я видел тебя"

с-у-лъагъу-а-щ
1SG.OBJ-2SG.SUBJ-see-PST-AFF
"ты видел меня"
```

---

## 3. Геометрические префиксы (GEOM)

### 3.1 Directional префиксы

| Префикс | Значение | Примеры |
|---------|----------|---------|
| къэ- | Thither (к говорящему) | къэ-кIу-а-щ "пришёл (сюда)" |
| къы- | Hither (от говорящего) | къы-кIу-а-щ "ушёл (отсюда)" |

### 3.2 Locative префиксы

| Префикс | Значение | Примеры |
|---------|----------|---------|
| щы- | In/inside (внутри) | щы-тхэ-н "писать в" |
| дэ- | Among/with (среди, с) | дэ-кIу-а-щ "пошёл с кем-то" |
| хэ- | Mass/through (через массу) | хэ-кIу-а-щ "прошёл через" |
| те- | On/surface (на поверхности) | те-щ-а-щ "положил на" |

---

## 4. Деривационные префиксы (в STEM)

### 4.1 Valency-changing операции

| Префикс | Тип | Функция | Пример |
|---------|-----|---------|--------|
| гъэ- | Causative | Заставить делать | гъэ-псэлъэ-н "заставить говорить" |
| хуэ- | Potential | Мочь/уметь | хуэ-кIу-н "мочь пойти" |
| зэ- | Reciprocal | Взаимное действие | зэ-лъагъу-н "видеть друг друга" |
| зы-/з- | Reflexive | Возвратное действие | зы-тхьэ-н "мыться" |

**Примеры:**

```
Базовый: псэлъэн (говорить) - валентность 1
→ Causative: гъэ-псэлъэн (заставить говорить) - валентность 2

Базовый: кIуэн (идти) - валентность 1
→ Potential: хуэ-кIу-н (мочь идти) - валентность 1
```

### 4.2 Version префиксы

| Префикс | Тип | Функция |
|---------|-----|---------|
| фIэ- | Malefactive | Против интересов участника |
| а-...фIы- | Malefactive (3PL) | Против их интересов |

**Пример 4-person verb:**
```
с-а-фIы-д-е-плъ-а-щ
1SG.SUBJ-3PL.OBJ-VERS.Mal-COM-3SG.OBJ-look-PST-AFF
"Я смотрел на это с ним, против их воли"
```

---

## 5. TAM суффиксы

### 5.1 Tense (Время)

| Суффикс | Время | Примеры |
|---------|-------|---------|
| -щ | Present | со-кIуэ-**щ** "я иду" |
| -а-щ | Past | со-кIу-**а-щ** "я пошёл" |
| -н-щ | Future | со-кIуэ-**н-щ** "я пойду" |
| -рт | Imperfective past | со-кIуэ-**рт** "я (часто) ходил" |

### 5.2 Negation (Отрицание)

| Суффикс | Функция | Примеры |
|---------|---------|---------|
| -къым | Negative | со-кIуэ-**къым** "я не иду" |

**Позиция:** После TAM, заменяет финальный -щ

```
Утвердительное: со-кIу-а-щ "я пошёл"
Отрицательное: со-кIу-а-къым "я не пошёл"
```

### 5.3 Mood (Наклонение)

| Форма | Маркер | Примеры |
|-------|--------|---------|
| Indicative | -щ | со-кIуэ-щ "я иду" |
| Imperative | ∅ или -т | кIу! "иди!" |
| Jussive | -т | кIу-т "пусть идёт" |
| Optative | -ну...фае | кIуэ-ну си-фае "хотел бы я пойти" |

---

## 6. Именная морфология

### 6.1 Падежная система

| Падеж | Маркер | Функция | Пример |
|-------|--------|---------|--------|
| Absolutive | -р | Субъект intr, объект tr | унэ-**р** "дом (субъект)" |
| Ergative | -м | Субъект transitive | унэ-**м** "дом (агенс)" |
| Postpositional | -кIэ | Instrumental, comitative | унэ-**кIэ** "с домом" |
| Adverbial | -у/-уэ | Предикативный | дахэ-**уэ** "красиво" |

**Примеры:**
```
Абсолютив: унэр мэхъу "дом высокий"
Эргатив: унэм щIэщ "дом строится" (агенс)
Постпозиционный: унэкIэ "с домом"
```

### 6.2 Число

| Маркер | Число | Примеры |
|--------|-------|---------|
| ∅ | Singular | унэ "дом" |
| -хэ | Plural | унэ-**хэ** "дома" |
| -хэ (rep) | Representative plural | Анзор-**хэ** "Анзор и его семья" |

**Определённость:**
```
Неопределённый: унэ "дом"
Определённый: унэ-р "дом (определённый)"
Множественное + определённое: унэ-хэ-р "дома (определённые)"
```

### 6.3 Possessive префиксы

| Лицо/Число | Префикс | Пример |
|------------|---------|--------|
| 1 SG | си- | **си** унэ "мой дом" |
| 2 SG | уи- | **уи** унэ "твой дом" |
| 3 SG | и- | **и** унэ "его/её дом" |
| 1 PL | ди- | **ди** унэ "наш дом" |
| 2 PL | фи- | **фи** унэ "ваш дом" |
| 3 PL | я- | **я** унэ "их дом" |
| Relative | зи- | **зи** унэ "чей дом" |

**Possessive chains:**
```
си къуэшым и унэ
1SG.POSS brother.ERG 3SG.POSS house
"дом моего брата"
```

---

## 7. Прилагательные

### 7.1 Типы прилагательных

**Qualitative (качественные):**
- Позиция: POST-nominal (после существительного)
- Принимают падежные маркеры
- Примеры: дахэ "красивый", ин "большой", цIыкIу "маленький"

```
унэ дахэр
house beautiful.DEF
"красивый дом"
```

**Relative (относительные):**
- Позиция: PRE-nominal (перед существительным)
- Не принимают падежные маркеры
- Примеры: пщIэ "деревянный", жыг "старый"

```
пщIэ унэ
wooden house
"деревянный дом"
```

### 7.2 Деривационные суффиксы

**Продуктивные:**

| Суффикс | Функция | Примеры |
|---------|---------|---------|
| -ншэ | Absence (без X) | гу-**ншэ** "без ума" |
| -фIэ | Abundance (с много X) | жьы-**фIэ** "кровавый" |
| -лъэ | Property (имеющий X) | губзыгъэ-**лъэ** "мудрый" |
| -гъуафIэ | Ease (легко X-able) | кIуэ-**гъуафIэ** "лёгкий в ходьбе" |
| -гъуей | Difficulty (трудно X) | кIуэ-**гъуей** "трудно идти" |
| -рей | Tendency (склонен к X) | жаIэ-**рей** "драчливый" |

**Менее продуктивные:**

| Суффикс | Функция | Примеры |
|---------|---------|---------|
| -жь | Base colors | плъы-**жь** "красный" |
| -фэ | Similarity (X-like) | хужь-**фэ** "белёсый" |
| -цэ | Possession (имеющий X) | гу-**цэ** "умный" |
| -шэ | Deficiency (недостаток X) | гу-**шэ** "глупый" |

### 7.3 Степени сравнения

**Comparative:**
```
Basic: нэхъ + ADJ
нэхъ дахэ "более красивый"

Emphatic: нэхъ + ADJ + -ж
нэхъ дахэж "намного красивее"

Double: нэхърэ + нэхъ + ADJ
нэхърэ нэхъ дахэ "ещё более красивый"
```

**Superlative:**

Простые суффиксы:
- -щэ: extreme degree (дахэ-**щэ** "очень красивый")
- -Iуэ: moderate degree (дахэ-**Iуэ** "довольно красивый")
- -бзэ: complete quality (дахэ-**бзэ** "полностью красивый")
- -кIей: superlative (дахэ-**кIей** "самый красивый")

Сложные формы:
```
нэхъ + ADJ + дыдэ
нэхъ дахэ дыдэ "самый красивый"
```

**Evaluative (оценочные):**

Augmentative (увеличительные):
- -жь: дахэ-**жь** "очень красивый"
- -шхуэ: ин-**шхуэ** "огромный"

Diminutive (уменьшительные):
- -Iуэ: дахэ-**Iуэ** "красивенький"
- цIыкIу (postposed): унэ **цIыкIу** "домик"

---

## 8. Числительные

### 8.1 Типы числительных

| Тип | Суффикс | Примеры |
|-----|---------|---------|
| Cardinal | ∅ | зы "один", тIу "два", щы "три" |
| Ordinal | -анэ | зы-**анэ** "первый", тIу-**анэ** "второй" |
| Distributive | -ры- | тIу-**ры**-тIу "по двое" |
| Multiplicative | -у | тIу-**у** "дважды" |
| Fractional | -бжъэ | тIу-**бжъэ** "половина" |

### 8.2 Формы числительных

**Simple (1-10, 100):**
```
зы, тIу, щы, плI, тху, хы, блы, и, бгъу, пщI
1, 2, 3, 4, 5, 6, 7, 8, 9, 10

щэ "100"
```

**Compound (11-19):**
```
пщIы-кIу-зы "11" (10-on-1)
пщIы-кIу-тIу "12" (10-on-2)
```

**Complex (с -рэ):**
```
щи-щ-рэ тху-щI-рэ зы-рэ "351"
3-100-and 5-10-and 1-and
```

---

## 9. Морфофонологические процессы

### 9.1 Vowel Gradation (чередование гласных)

| Grade | Гласный | Примеры |
|-------|---------|---------|
| Normal | э/е | тхэн "писать" |
| Extended | а/э | тхан "writing" |
| Zero | ∅ | тхы-н "write (trans)" |

### 9.2 Assimilation (ассимиляция)

**Person prefix assimilation:**
```
с- + звонкий → з-
Пример: с-жьы-щI-а-щ → з-жьы-щI-а-щ "я мыл"

и- → е- (в некоторых контекстах)
Пример: и-плъ → е-плъ "он видит"
```

### 9.3 Vowel Harmony (гармония гласных)

```
Эпентетические гласные подстраиваются под окружение:
с- + кIу → со-кIуэ (о вставлен)
у- + кIу → уо-кIуэ (о вставлен)
```

---

## 10. Сложные конструкции

### 10.1 Serial Verb Constructions

```
кIуэ-ри къэ-кIуэ-жа-щ
go-CONV DIR.Thither-go-back-PST.AFF
"пошёл и вернулся"
```

### 10.2 Light Verb Constructions

```
гу лъы-тэ-н
attention give-BEN-INF
"обращать внимание" (букв: "давать внимание")

псалъэ жеI-эн
word say-INF
"говорить" (букв: "говорить слово")
```

### 10.3 Compound Verbs

```
Noun + Verb:
IуэхуитI + щI-эн
work + do-INF
"работать" (букв: "делать работу")
```

---

## 11. Примеры сложных глагольных форм

### Пример 1: Простой переходный

```
у-с-лъагъу-а-щ
2SG.OBJ-1SG.SUBJ-see-PST-AFF

Template: [∅]-[∅]-[у-с]-[лъагъу]-[а-щ]-[∅]
PRAGM: ∅
GEOM: ∅
ARGS: у- (2SG.OBJ) + с- (1SG.SUBJ)
STEM: лъагъу "see"
TAM: -а-щ (PST.AFF)
SUBORD: ∅

Перевод: "я видел тебя"
Валентность: 2
```

### Пример 2: С directional

```
у-къэ-з-гъэ-кIуэ-нщ
2SG.OBJ-DIR.Thither-1SG.SUBJ-CAUS-go-FUT.AFF

Template: [∅]-[къэ]-[у-з]-[гъэ-кIуэ]-[нщ]-[∅]
PRAGM: ∅
GEOM: къэ- (DIR.Thither)
ARGS: у- (2SG.OBJ) + з- (1SG.SUBJ, assimilated)
STEM: гъэ-кIуэ "CAUS-go" (заставить идти)
TAM: -н-щ (FUT.AFF)
SUBORD: ∅

Перевод: "я заставлю тебя прийти сюда"
Валентность: 3 (каузатор + каузируемый + движение)
```

### Пример 3: Multi-person (4 участника)

```
с-а-фIы-д-е-плъ-а-щ
1SG.SUBJ-3PL.OBJ-VERS.Mal-COM-3SG.OBJ-look-PST-AFF

Template: [∅]-[∅]-[с-а-...фIы-д-е]-[плъ]-[а-щ]-[∅]
PRAGM: ∅
GEOM: ∅
ARGS: с- (1SG.SUBJ) + а-...фIы- (3PL malefactive) + д- (COM) + е- (3SG.OBJ)
STEM: плъ "look"
TAM: -а-щ (PST.AFF)
SUBORD: ∅

Участники:
1. Субъект: я (с-)
2. Против них: 3PL (а-...фIы-)
3. С кем-то: COM (д-)
4. Объект: это (е-)

Перевод: "я смотрел на это с кем-то, против их воли"
Валентность: 4
```

### Пример 4: С potential и negation

```
с-хуэ-хь-а-къым
1SG.SUBJ-POT-carry-PST-NEG

Template: [∅]-[∅]-[с]-[хуэ-хь]-[а-къым]-[∅]
PRAGM: ∅
GEOM: ∅
ARGS: с- (1SG.SUBJ)
STEM: хуэ-хь "POT-carry" (мочь нести)
TAM: -а-къым (PST.NEG)
SUBORD: ∅

Перевод: "я не мог нести это"
Валентность: 2 (субъект + объект)
```

---

## 12. Цветовая система

### Базовые цвета

| Цвет | Кабардинский | Деривация |
|------|--------------|-----------|
| Красный | плъыжь | плъы + -жь |
| Белый | хужь | ху + -жь |
| Жёлтый | гъуэжь | гъуэ + -жь |
| Зелёный | щхъуантIэ | щхъуа + -нтIэ |
| Чёрный | фIыцIэ | фIы + -цIэ |

### Сложные цвета

**Compound colors:**
```
морэ-фIыцIэ
brown-black
"тёмно-коричневый"

гъуэ-плъ
reddish-red
"оранжевый"
```

**Derived colors:**
```
Base + -фэ (similarity):
хужь-фэ "белёсый"

Base + -шхуэ (intensity):
плъыжь-шхуэ "ярко-красный"

Base + -бзэ (purity):
хужь-бзэ "чисто-белый"
```

---

## 13. Конвербы и причастия

### 13.1 Converbs (деепричастия)

| Тип | Форма | Примеры |
|-----|-------|---------|
| Simultaneous | -ри | кIуэ-**ри** "идя" |
| Sequential | -мэ | кIу-а-**мэ** "после того как пошёл" |

**Пример в предложении:**
```
кIуэ-ри къэ-кIуэ-жа-щ
go-CONV DIR-go-back-PST.AFF
"идя, вернулся" = "пошёл и вернулся"
```

### 13.2 Participles (причастия)

| Время | Форма | Примеры |
|-------|-------|---------|
| Present | Stem | кIуэ "идущий" |
| Past | -а | кIу-а "ушедший" |
| Future | -ну | кIуэ-ну "который пойдёт" |

---

## 14. Словообразовательные паттерны

### 14.1 Verb → Noun

```
V + -гъуэ (действие):
кIуэ-н → кIуэ-гъуэ "ходьба"

V + -Iэ (инструмент):
лъагъу-н → лъагъу-Iэ "зрение"

V + -щI (место):
псэ-н → псэ-щI "место жизни"
```

### 14.2 Noun → Adjective

```
N + -нщIэ (material):
пщIэ → пщIэ-нщIэ "деревянный"

N + -фIэ (full of):
жьы → жьы-фIэ "кровавый"
```

### 14.3 Adjective → Adverb

```
ADJ + -у/-уэ:
дахэ → дахэ-уэ "красиво"
къабзэ → къабзэ-уэ "близко"
```

---

**Этот reference содержит полную морфологическую систему для детального анализа!**
