---
name: kbd-translator
description: Expert in BIDIRECTIONAL Kabardian↔Russian translation using CORPUS-FIRST approach. Translates both Russian→Kabardian AND Kabardian→Russian. Learns from 292k real translation examples, then falls back to dictionaries. Provides accurate translations by copying patterns from verified corpus. For rus→kbd ensures proper SOV word order and morphology. Activates when user requests translation, mentions "перевод", "translate", "переведи", "Kabardian", "кабардинский", provides sentences in Russian or Kabardian to translate.
allowed-tools: Read, Write, Grep
---

# Kabardian Translation Expert (BIDIRECTIONAL, CORPUS-FIRST)

Эксперт по **двунаправленному** переводу Кабардинский↔Русский (Kabardian↔Russian, kbd↔rus) с приоритетом на обучение из корпуса реальных переводов (292k пар). Словари используются только как запасной вариант.

**Поддерживаемые направления:**
- 🇷🇺 → 🏔️ Русский → Кабардинский (Russian → Kabardian)
- 🏔️ → 🇷🇺 Кабардинский → Русский (Kabardian → Russian)

## 🎯 Когда активироваться

Этот skill активируется когда пользователь:

- Просит перевести **русский текст на кабардинский** язык
- Просит перевести **кабардинский текст на русский** язык
- Упоминает "перевод", "translate", "переведи", "перевести"
- Работает с кабардинским языком или данными
- Упоминает "Kabardian", "kbd", "кабардинский", "адыгэбзэ"
- Предоставляет предложения на русском или кабардинском для перевода
- Спрашивает "что означает" кабардинское предложение
- Просит объяснить перевод кабардинского текста

**Триггеры:** "перевод", "translate", "переведи", "перевести", "Kabardian", "kbd", "кабардинский", "русский↔кабардинский", "что означает", "как переводится"

---

## 📚 Грамматические правила (grammar_discoveries/)

В директории `.claude/skills/kbd-translator/grammar_discoveries/` находятся **подтверждённые грамматические правила**, обнаруженные через практическую работу с переводами и проверенные в академических справочниках.

**Ключевые находки:**
1. **Маркер предикативности -щ:** В именном предложении "X есть Y" маркер -щ ставится ТОЛЬКО ОДИН РАЗ (на подлежащем)
2. **Модальный глагол лъэкI:** Для "мочь/смочь" используется глагол лъэкI(ын), а не другие глаголы
3. **Отрицание -къым:** В финитных формах отрицание выражается суффиксом -къым (после времени), не префиксом мы-
4. **Причастия с -а-р:** В причастиях прошедшего времени используется -а-р (время + определённость), а НЕ -а-щ-ыр
5. **Посессивные конструкции:** "с тобой" = уи гъусэу (посессивный уи, а не базовая форма у)

**Используй эти правила в Шаге 5 (чеклист) для проверки перевода!**

Полный список: `grammar_discoveries/README.md`

---

## 📋 Улучшенный Workflow перевода (BIDIRECTIONAL, CORPUS-FIRST!)

### ⚠️ КРИТИЧЕСКИЕ ПРАВИЛА
**1. ОПРЕДЕЛИ НАПРАВЛЕНИЕ ПЕРЕВОДА:** Русский→Кабардинский или Кабардинский→Русский
**2. ВСЕГДА НАЧИНАЙ С ПОИСКА В КОРПУСЕ ПЕРЕВОДОВ!**
**3. Корпус (292k пар) - твой ОСНОВНОЙ источник знаний!**
**4. Словарь - только ЗАПАСНОЙ вариант, когда корпус не помог!**

---

### Шаг 0: Определение направления перевода

**Определи какой язык источник, какой цель:**

```
Примеры:
- "Переведи на кабардинский: Я вижу дом" → направление: RUS→KBD
- "Переведи на русский: Сэ унэр слъагъу" → направление: KBD→RUS
- "Что означает: Псори ищIэ хуэдэу мэпсалъэ" → направление: KBD→RUS
```

**Индикаторы кабардинского текста:**
- Наличие специальных символов: I, къ, гъ, хъ, хь, жь, щI, кI, пI, тI
- Кириллица + необычные сочетания букв
- Паттерны: -къым (отрицание), -р (определённость), -м (локатив)

**Индикаторы русского текста:**
- Обычная кириллица без специальных символов
- Знакомая грамматика: окончания -ешь, -ет, -ем, -ете, -ут/-ят

---

### Шаг 1: Анализ исходного предложения

Разбери предложение на компоненты и определи ключевые слова:

**Для RUS→KBD:**

```
Пример RUS→KBD: "Я вижу дом"

Компоненты:
- Подлежащее (S): Я
- Сказуемое (V): вижу (наст. вр., 1 л., ед.ч.)
- Дополнение (O): дом (вин. падеж)

Ключевые слова для поиска: вижу, видеть, дом
```

**Для KBD→RUS:**

```
Пример KBD→RUS: "Сэ унэр слъагъу"

Компоненты:
- Сэ: местоимение (я)
- унэр: существительное с маркером -р
- слъагъу: глагол с префиксом с-

Ключевые слова для поиска: слъагъу, унэр, сэ
```

### Шаг 2: 🔍 ГЛАВНОЕ - Поиск в корпусе переводов (ОБЯЗАТЕЛЬНО!)

**Формат корпуса:** CSV с двумя колонками: `"кабардинский","русский"`

**Корпус содержит 292,000 ПРОВЕРЕННЫХ переводов - это твой главный учитель!**

**Стратегия поиска в корпусе (3-уровневый подход, работает для ОБОИХ направлений):**

**Уровень 1: Поиск СОСТАВНЫХ КОНСТРУКЦИЙ (КРИТИЧНО!)**

⚠️ **НЕ ищи отдельные слова! Ищи ЦЕЛЫЕ ФРАЗОВЫЕ КОНСТРУКЦИИ!**

```bash
# ❌ ПЛОХО: Поиск отдельных слов
grep -i "хотел" data/translations/sents_292k.csv    # Слишком много шума
grep -i "забыть" data/translations/sents_292k.csv   # Не найдешь конструкцию

# ✅ ХОРОШО: Поиск составных конструкций
# RUS→KBD: Ищи русские ФРАЗЫ с несколькими ключевыми словами
grep -i "хотел.*забы" data/translations/sents_292k.csv | head -5
grep -i "не смог.*забыть\|не смог.*сделать" data/translations/sents_292k.csv | head -5
grep -i "последн.*ночь" data/translations/sents_292k.csv | head -5
grep -i ", ауэ.*слъэкI\|но.*не смог" data/translations/sents_292k.csv | head -5

# KBD→RUS: Ищи кабардинские ФРАЗЫ с несколькими элементами
grep -i "слъагъу.*унэр\|унэр.*слъагъу" data/translations/sents_292k.csv | head -5
grep -i "уи гъусэу" data/translations/sents_292k.csv | head -5   # "с тобой" целиком
grep -i "ауэ.*слъэкIакъым" data/translations/sents_292k.csv | head -5  # "но не смог"
```

**Примеры успешных составных поисков:**
```
"хотел.*забы" → находит "Я хотел забыть"
"последн.*ночь" → находит "последняя ночь"
"с тобой.*ночь\|ночь.*с тобой" → находит "ночь с тобой"
"ауэ.*слъэкIакъым" → находит "но не смог"
"уи гъусэу" → находит "с тобой" (как составную конструкцию)
```

**Уровень 2: Поиск по отдельным ключевым словам**
```bash
# RUS→KBD: Ищи по русскому глаголу
grep -i -m 10 "вижу\|видеть\|видел" data/translations/sents_292k.csv

# KBD→RUS: Ищи по кабардинскому глаголу
grep -i -m 10 "слъагъу\|лъагъ" data/translations/sents_292k.csv

# Потом по другим ключевым словам в соответствующем языке
grep -i -m 10 "дом" data/translations/sents_292k.csv    # для RUS→KBD
grep -i -m 10 "унэр\|унэм" data/translations/sents_292k.csv  # для KBD→RUS
```

**Уровень 3: Поиск по грамматическим паттернам**
```bash
# Вопросы (работает для обоих направлений)
grep -i -m 10 "\?" data/translations/sents_292k.csv

# Отрицания
# RUS→KBD: русские отрицания "не" → кабардинские "-къым"
grep -i -m 10 "не " data/translations/sents_292k.csv
# KBD→RUS: кабардинские отрицания "-къым"
grep -i -m 10 "къым" data/translations/sents_292k.csv

# Времена
# RUS→KBD: прошедшее "был/была/были"
grep -i -m 10 "был\|была\|были" data/translations/sents_292k.csv
# KBD→RUS: прошедшее "-ащ/-ат"
grep -i -m 10 "ащ\|ат" data/translations/sents_292k.csv
```

**📊 Анализ найденных примеров (для ОБОИХ направлений):**

**Для RUS→KBD перевода, изучи:**
1. **Порядок слов:** Как русский SVO преобразуется в кабардинский SOV?
2. **Глагольные формы:** Какие префиксы (с-, у-, и-) и суффиксы (-къым, -ащ, -нт)?
3. **Падежи:** Какие маркеры у существительных (-р, -м, -кIэ)?
4. **Паттерны:** Как переводятся похожие конструкции?

**Для KBD→RUS перевода, изучи:**
1. **Порядок слов:** Как кабардинский SOV преобразуется в русский SVO?
2. **Глагольные формы:** Как префиксы (с-, у-, и-) переводятся в русские окончания?
3. **Падежи:** Как маркеры (-р, -м, -кIэ) переводятся в русские падежи?
4. **Паттерны:** Как переводятся идиоматические выражения?

**Пример анализа RUS→KBD:**
```
Найдено: "Сэ унэр слъагъу","Я вижу дом"

Анализ:
- Порядок: RUS "Я вижу дом" (SVO) → KBD "Сэ унэр слъагъу" (SOV)
- Глагол: рус. "вижу" → kbd. с-лъагъу (с- = 1л.ед.ч)
- Падеж: рус. "дом" (вин.) → kbd. унэ-р (-р = определённость)
- Паттерн для копирования: [Я] + [объект-р] + [с-глагол]
```

**Пример анализа KBD→RUS:**
```
Найдено: "Сэ унэр слъагъу","Я вижу дом"

Анализ:
- Порядок: KBD "Сэ унэр слъагъу" (SOV) → RUS "Я вижу дом" (SVO)
- Глагол: kbd. с-лъагъу (с- = 1л.ед.ч) → рус. "вижу" (1л.ед.ч)
- Падеж: kbd. унэ-р (-р = определённость) → рус. "дом" (вин.)
- Паттерн для копирования: [Сэ] + [объект-р] + [с-глагол] = "[Я] + [глагол] + [объект]"
```

**⚠️ ВАЖНО:**
- Корпус ~45 МБ, ВСЕГДА используй `-m N` для ограничения!
- Формат CSV: `"кабардинский","русский"` (1-я колонка kbd, 2-я rus)
- Grep ищет по ОБЕИМ колонкам, результаты подходят для любого направления!

### Шаг 3: 📚 ЗАПАСНОЙ - Поиск в словаре (ТОЛЬКО если корпус не помог!)

**Используй словарь ТОЛЬКО когда:**
- Не нашёл ничего похожего в корпусе после 3-уровневого поиска
- Нужно понять базовое значение незнакомого слова
- Слово очень специфичное/редкое

**Для RUS→KBD: Русско-кабардинский словарь**
```bash
# Поиск в Rus-Ady_UASP.csv (ЗАПАСНОЙ вариант!)
grep -i "^\"видеть\"" data/glossary/Rus-Ady_UASP.csv
grep -i "^\"дом\"" data/glossary/Rus-Ady_UASP.csv
```

**Для KBD→RUS: Кабардинский толковый словарь**
```bash
# Поиск в Ady-Ady_AP.csv (толковый словарь на кабардинском)
grep -i "^\"СЛЪАГЪУ\|^\"унэ" data/glossary/Ady-Ady_AP.csv
# ⚠️ Ключи часто в ВЕРХНЕМ РЕГИСТРЕ!
```

**⚠️ ПРОБЛЕМЫ словарей:**
- Rus-Ady: Даёт только словарную форму (например, "лъагъун" - инфинитив), НЕ показывает использование в контексте
- Ady-Ady: Толковый словарь НА кабардинском (не переводит на русский!), полезен для понимания значения
- НЕ показывают правильные префиксы/суффиксы в контексте
- Легко сделать грамматическую ошибку при применении

**Поэтому: ВСЕГДА предпочитай корпус!**

### Шаг 4: Построение перевода по найденным паттернам

**Используй найденные примеры из корпуса как шаблоны!**

**Метод "паттерн-подстановка":**

```
Пример: Переводим "Ты видишь дом"

Нашли в корпусе: "Сэ унэр слъагъу" → "Я вижу дом"

Анализ паттерна:
- [местоимение-1л] + [объект-р] + [префикс-1л]-глагол
- Сэ (я) + унэр (дом) + с-лъагъу (вижу)

Применяем паттерн для "ты":
- [местоимение-2л] + [объект-р] + [префикс-2л]-глагол
- Уэ (ты) + унэр (дом) + у-лъагъу (видишь)

Результат: "Уэ унэр улъагъу"
```

**Ключевые принципы:**
1. **SOV порядок** всегда: Субъект + Объект + Глагол
2. **Копируй структуру** из корпуса, меняй только нужные элементы
3. **Смотри на окончания** в похожих примерах (-р, -м, -кIэ, -къым)
4. **Соблюдай согласование** лица/числа как в примерах

### Шаг 5: Контрольный чеклист

⚠️ **ВАЖНО: Проверь грамматические правила из grammar_discoveries/**

Перед выводом проверь:

**Поиск и паттерны:**
- [ ] Нашёл похожие примеры в корпусе (составные конструкции)?
- [ ] Изучил их структуру и паттерны?
- [ ] Применён SOV порядок как в примерах?

**Морфология (см. grammar_discoveries/):**
- [ ] **⚡ В именном предложении только ОДИН маркер -щ?** (не два!)
- [ ] **⚡ Причастие прошедшего времени: -а-р (НЕ -а-щ-ыр)?**
- [ ] **⚡ Отрицание: -къым в финитных формах (не мы-)?**
- [ ] **⚡ Модальный глагол: лъэкI для "мочь" (не другие глаголы)?**
- [ ] **⚡ Посессивные префиксы: си/уи/и/ди/фи/я (не базовые формы)?**
  - "с тобой" = уи гъусэу (НЕ "у гъусэу")
  - "со мной" = си гъусэу (НЕ "сэ гъусэу")
- [ ] Правильные префиксы/суффиксы (смотри на примеры)?
- [ ] Падежные маркеры соответствуют примерам (-р, -м, -кIэ)?

### Шаг 6: Генерация перевода

**Формат вывода:**

- Предоставляй ТОЛЬКО переводы без объяснений
- Каждый перевод на новой строке
- Используй `""` для непереводимых предложений
- Никогда не объединяй предложения

**Пример:**
```
Входные предложения:
Я вижу дом
Мать готовит еду

Вывод:
Сэ унэр слъагъу.
Анэр шхыныгъуэр щIэщ.
```

### Шаг 4: Пост-обработка

После перевода выполни стандартизацию символов:

1. **Замена символов:**
   - `ӏ` → `I` (латинская I)
   - `1` → `I`
   - `l` → `I`

2. **Проверка пунктуации:**
   - Если исходное предложение заканчивается на `.`, `?`, `!`
   - И перевод не заканчивается таким же символом
   - Добавь соответствующий символ в конец перевода

**Пример пост-обработки:**
```python
# Замена символов
translated = translated.replace('ӏ', 'I')
translated = translated.replace('1', 'I')
translated = translated.replace('l', 'I')

# Добавление пунктуации
if source.endswith('.') and not translated.endswith('.'):
    translated += '.'
```

### Шаг 5: Верификация

Проверь перевод:
- ✅ Порядок слов SOV соблюден?
- ✅ Грамматика правильная?
- ✅ **⚡ В именном предложении только ОДИН маркер -щ?**
- ✅ Символы стандартизированы?
- ✅ Пунктуация соответствует оригиналу?

---

## 🔍 Что делать при неясных/сложных случаях

Если встретил грамматическую конструкцию, в которой не уверен:

### 1. Ищи СОСТАВНЫЕ КОНСТРУКЦИИ в корпусе

**НЕ ищи отдельные слова! Ищи целые фразы!**

```bash
# ✅ ПРАВИЛЬНО: Составные конструкции
grep -i "хотел.*забы" data/translations/sents_292k.csv | head -5
grep -i "провед.*с тобой\|с тобой.*провед" data/translations/sents_292k.csv | head -5
grep -i "последн.*ночь" data/translations/sents_292k.csv | head -5
grep -i "ауэ.*слъэкIакъым\|но.*не смог" data/translations/sents_292k.csv | head -5

# ❌ ПЛОХО: Отдельные слова (слишком много шума)
grep -i "хотел" data/translations/sents_292k.csv    # Найдёт тысячи результатов
grep -i "ночь" data/translations/sents_292k.csv     # Не найдёшь нужную конструкцию
```

### 2. Проверь grammar_discoveries/

Возможно, это правило уже задокументировано:

```bash
# Прочитай список всех находок
Read: grammar_discoveries/README.md

# Если нашёл релевантную находку, прочитай её
Read: grammar_discoveries/2025-11-07_verb_lekI_modal.md
Read: grammar_discoveries/2025-11-07_predicative_marker_shch.md
```

### 3. Если правило НОВОЕ и пользователь указал на ошибку

**Предложи пользователю задокументировать находку:**

"Отличная находка! Это правило не задокументировано. Хотите, чтобы я проверил это в академических справочниках (`references/grammar/`) и создал документацию в `grammar_discoveries/`?"

**Если пользователь согласен, то:**
1. Поиск в академических источниках: `references/grammar/**/*.txt`
2. Поиск паттернов в корпусе для подтверждения
3. Создание документа по шаблону `grammar_discoveries/TEMPLATE.md`
4. Обновление `grammar_discoveries/README.md`

**Пример успешной документации:**
- Пользователь исправил: "либо Уэращ либо иныращ убрать суффикс -щ"
- Проверено в: `references/grammar/syntax/chunk_058_pages_286-290.txt`
- Найдены примеры в корпусе: "уэращ си гъащIэр"
- Создан документ: `2025-11-07_predicative_marker_shch.md`
- Правило добавлено в чеклист

### 4. Ключевые принципы исследования

- **Корпус - первый источник истины** (292k реальных переводов)
- **Академические справочники - подтверждение** (`references/grammar/`)
- **Ищи составные конструкции**, не отдельные слова
- **Документируй находки** для будущих переводов

---

## 📚 Reference Files

Для детальных лингвистических правил см.:

- `reference_improved.md` - **ОСНОВНОЙ** улучшенный reference с пошаговой методологией
- `reference.md` - Дополнительная справка по грамматике кабардинского языка
- `grammar_discoveries/` - **База знаний** документированных грамматических правил

**Когда загружать:**
- `reference_improved.md` - **ВСЕГДА** загружай ПЕРВЫМ перед началом перевода!
- `reference.md` - для дополнительных примеров сложных конструкций
- `grammar_discoveries/README.md` - для быстрого обзора всех задокументированных правил
- `grammar_discoveries/YYYY-MM-DD_*.md` - когда встретил конкретный грамматический вопрос

**Как использовать grammar_discoveries:**

Эта директория содержит **подробно задокументированные** грамматические правила, обнаруженные через практическую работу. Каждая находка включает:
- ✅ Подтверждение из академических справочников (`references/grammar/`)
- ✅ Примеры из корпуса переводов (292k пар)
- ✅ Правильные и неправильные примеры
- ✅ Ссылки на источники

**Когда читать конкретные находки:**

1. **При сомнении в грамматике:** Проверь список в `grammar_discoveries/README.md`
2. **При работе с именными предложениями:** Читай `2025-11-07_predicative_marker_shch.md` (правило об -щ)
3. **Перед финальной проверкой:** Пробеги по списку находок, проверь применимые правила

**Allowed-tools:** `Read` - можешь читать файлы из `grammar_discoveries/` при необходимости!

---

## 🛡️ Безопасность и ограничения

**allowed-tools:** `Read, Write, Grep`

Этот skill может:
- ✅ Переводить русский текст на кабардинский
- ✅ Читать файлы с данными для перевода
- ✅ Искать слова в словарях и корпусе переводов через Grep
- ✅ Сохранять результаты перевода в файлы

Этот skill НЕ может:
- ❌ Переводить с других языков кроме русского
- ❌ Выполнять произвольный код
- ❌ Модифицировать исходные данные

---

## 🎨 Best Practices

1. **Всегда соблюдай порядок слов SOV** - это фундаментальное отличие кабардинского от русского
2. **Используй правильные символы** - кабардинский использует расширенный кириллический алфавит с латинской I для глоттального смычка
3. **Сохраняй пунктуацию** - знаки препинания должны соответствовать исходному тексту
4. **Культурный контекст** - некоторые концепции требуют культурно-адекватных эквивалентов
5. **При сомнении загружай reference.md** - там есть детальные правила и примеры

---

## 🚀 Примеры использования (CORPUS-FIRST подход!)

### Пример 1: Простой перевод с приоритетом на корпус

```
User: "Переведи на кабардинский: Я вижу дом"

Skill (новый подход):
1. Анализирует: Я (S) дом (O) вижу (V) → ключевые слова: вижу, дом

2. 🔍 СНАЧАЛА ищет в КОРПУСЕ:
   grep -i -m 10 "вижу\|видеть" data/translations/sents_292k.csv

   Находит:
   "А зыращ сэ слъагъур.","То, что я вижу."
   "Сэ фIыуэ слъагъухэр.","Я хорошо вижу их."

3. Анализирует найденные паттерны:
   - слъагъур = с-(я) + лъагъ-(видеть) + -ур
   - Паттерн: Сэ + [объект] + с-глагол

4. Ищет "дом" в корпусе для уточнения формы:
   grep -i -m 5 "дом" data/translations/sents_292k.csv
   → находит примеры с "унэр" (дом+определённость)

5. Применяет найденный паттерн: Сэ унэр слъагъу

6. Возвращает: Сэ унэр слъагъу.
```

### Пример 2: Перевод с отрицанием (learning from corpus)

```
User: "Переведи: Я не вижу дом"

Skill (новый подход):
1. Анализирует: НЕ видеть → ключевые слова: не, вижу, отрицание

2. 🔍 Ищет ОТРИЦАНИЯ в корпусе:
   grep -i -m 10 "не вижу\|не видел\|къым" data/translations/sents_292k.csv

   Находит:
   "Ар къэплъыххэркъым","Он не видит"
   "СыщIэгъэнынукъым","Я не могу найти"

3. Изучает паттерн отрицания:
   - Глагол + -къым = отрицание
   - слъагъу + -къым = слъагъукъым (я не вижу)

4. Применяет паттерн: Сэ унэр слъагъукъым

5. Возвращает: Сэ унэр слъагъукъым.
```

### Пример 3: Сложное предложение (паттерн из корпуса)

```
User: "Переведи: Он посоветовал ему делать упражнения"

Skill (новый подход):
1. Анализирует: посоветовал → ключевое слово

2. 🔍 Ищет в корпусе "посоветовал":
   grep -i -m 10 "посоветовал\|посоветовать" data/translations/sents_292k.csv

   Находит примеры конструкции "чэнджэщ етын"

3. Ищет "делать упражнения":
   grep -i -m 10 "делать\|упражнения" data/translations/sents_292k.csv

   Находит паттерн для инфинитива: зэрыщIэну

4. Комбинирует паттерны из корпуса:
   Ар (он) + абы (ему) + и чэнджэщ етащ (посоветовал) +
   зыгъэпсэхупIэхэр зэрыщIэну (делать упражнения)

5. Возвращает: Ар абы и чэнджэщ етащ зыгъэпсэхупIэхэр зэрыщIэну.
```

---

## 🚀 Примеры KBD→RUS (обратное направление!)

### Пример 4: Простой перевод с кабардинского на русский

```
User: "Переведи на русский: Сэ унэр слъагъу"

Skill (bidirectional подход):
0. Определяет направление: KBD→RUS (есть специальные символы I, къ)

1. Анализирует кабардинское предложение:
   - Сэ (местоимение)
   - унэр (существительное с -р)
   - слъагъу (глагол с префиксом с-)
   Ключевые слова: сэ, унэр, слъагъу

2. 🔍 Ищет в КОРПУСЕ:
   grep -i -m 10 "слъагъу" data/translations/sents_292k.csv

   Находит:
   "А зыращ сэ слъагъур.","То, что я вижу."
   "Сэ фIыуэ слъагъухэр.","Я хорошо вижу их."

3. Анализирует паттерн:
   - KBD "Сэ...слъагъ-" → RUS "Я...вижу"
   - с-лъагъу = "я вижу" (1л.ед.ч)
   - унэр = "дом" (с определённостью)

4. Ищет подтверждение для "унэр":
   grep -i -m 5 "унэр" data/translations/sents_292k.csv
   → находит переводы с "дом"

5. Применяет паттерн SOV→SVO:
   KBD: Сэ (S) унэр (O) слъагъу (V)
   RUS: Я (S) вижу (V) дом (O)

6. Возвращает: Я вижу дом.
```

### Пример 5: Перевод отрицания с кабардинского

```
User: "Что означает: Сэ унэр слъагъукъым"

Skill:
0. Определяет: KBD→RUS (суффикс -къым = отрицание)

1. Анализирует: Сэ + унэр + слъагъу-къым
   Ключевые слова: къым (отрицание), слъагъу, унэр

2. 🔍 Ищет отрицания в корпусе:
   grep -i -m 10 "къым" data/translations/sents_292k.csv

   Находит:
   "Ар къэплъыххэркъым","Он не видит"
   "СыщIэгъэнынукъым","Я не могу найти"

3. Изучает паттерн:
   - глагол + -къым → "не" + глагол
   - слъагъу-къым = "не вижу"

4. Применяет паттерн:
   Сэ унэр слъагъу-къым → Я дом не вижу → Я не вижу дом

5. Возвращает: Я не вижу дом.
```

### Пример 6: Сложное предложение KBD→RUS

```
User: "Переведи: Псори ищIэ хуэдэу мэпсалъэ"

Skill:
0. Определяет: KBD→RUS

1. Анализирует: псори + ищIэ + хуэдэу + мэпсалъэ

2. 🔍 Ищет в корпусе:
   grep -i -m 10 "псори ищIэ\|псори.*хуэдэу" data/translations/sents_292k.csv

   Находит ТОЧНОЕ совпадение:
   "Псори ищIэ хуэдэу мэпсалъэ","Он говорит так, будто всё знает"

3. Анализирует паттерн:
   - псори = "всё"
   - ищIэ = "знает"
   - хуэдэу = "как будто/так"
   - мэпсалъэ = "говорит"

4. Найден готовый перевод в корпусе!

5. Возвращает: Он говорит так, будто всё знает.
```

---

### 📌 Ключевое отличие нового подхода:

**СТАРЫЙ подход (словарь-first):**
- Искать в словаре → Применять грамматику вручную → Надеяться на правильность

**НОВЫЙ подход (corpus-first, bidirectional):**
- Определить направление → Искать в корпусе → Находить ГОТОВЫЕ правильные примеры → Копировать паттерн
- Результат: Меньше ошибок, более естественный перевод в ОБОИХ направлениях!

---

## 📝 Примечания

- Кабардинский язык относится к северо-западной кавказской языковой семье
- Использует расширенный кириллический алфавит с специальными символами
- Глоттальный смычка обозначается как **Ӏ** (заглавная I с вертикальной чертой), в нашем формате стандартизируется как латинская **I**
- Правила грамматики значительно отличаются от русского, поэтому дословный перевод часто неприменим
- **Порядок слов:** Русский использует SVO, Кабардинский использует SOV
- **Морфология:** Кабардинский - агглютинативный язык с богатой системой префиксов и суффиксов

---

## ✨ Ключевые возможности

**Поддерживаемые направления:**
- 🇷🇺 → 🏔️ **Русский → Кабардинский:** Применение SOV порядка, правильная морфология
- 🏔️ → 🇷🇺 **Кабардинский → Русский:** Преобразование SOV в SVO, интерпретация морфологии

**Преимущества corpus-first подхода:**
- ✅ Обучение на 292,000 реальных проверенных примеров
- ✅ Естественные переводы, как делают носители языка
- ✅ Меньше грамматических ошибок
- ✅ Понимание идиом и контекстуальных значений
- ✅ Работает в обоих направлениях одинаково эффективно

---

**Готов предоставлять точные ДВУНАПРАВЛЕННЫЕ переводы: Русский ↔ Кабардинский!**
