# Отрицательный суффикс -къым в финитных формах

**Дата:** 2025-11-07
**Автор:** Claude Code + User
**Статус:** ✅ Подтверждено

---

## Контекст

При переводе предложения **"Мне бы хотелось забыть последнюю ночь, проведенную с тобой, но я не смог"** возникла необходимость правильно выразить отрицание.

**Пример предложения:**
```
Русский: "но я не смог"
Правильный перевод: "ауэ слъэкIакъым"
                             ↑
                      суффикс отрицания
```

---

## Проблема

Необходимо использовать правильный аффикс отрицания в финитных (личных) формах глагола.

---

## Исследование

### Источники проверки

**Грамматические справочники:**
- [x] `references/grammar/advanced_verbs/chunk_035_pages_171-175.txt`
- [x] `references/grammar/advanced_verbs/chunk_036_pages_176-180.txt`

**Корпус переводов:**
- [x] `data/translations/sents_292k.csv`

### Что нашли

**1. Из `advanced_verbs/chunk_035_pages_171-175.txt`, строки 189-209:**

> "В кабардино-черкесском языке отрицание выражается:"
> "1) префиксом -мы и суффиксом **-къым**"

> "Суффикс **-къым** исторически составной, т. е. состоит из общеабхазско-адыгского аффикса отрицания м- и суффикса -къы-/-къэ, восходящего к вопросительному аффиксу -къы/-къэ."

> "В финитных формах показатель отрицания – суффикс **-къым** следует после показателей времени и наклонения."

**2. Примеры из академических источников (строки 210-216):**

> "Суффикс -къым способен сочетаться со сказуемым в изъявительном наклонении"

- "Ар тхэркъым" = "Он не пишет"
- "Сщыгъупщэн слъэкIыркъым" = "Не могу забыть"
- "УкъыщIесхьэжьар залымыгъэ уэсхыну аракъым" = "Я похитил тебя не потому, что хочу причинить зло"

**3. Из `advanced_verbs/chunk_035_pages_171-175.txt`, строки 222-225:**

> "Негативный суффикс **-къым** следует за суффиксом -р в презенсе, а в других временах после временного суффикса"

**Примеры:**
- "сы-кIыху-**р-къым**" = "я не знаю" (настоящее)
- "сы-кIыху-а-**къым**" = "я не знал" (прошедшее)

**Примеры из корпуса:**
```bash
grep -F "къым\"" data/translations/sents_292k.csv | head -5
```

Результаты:
```
"слъэкIакъым","не смог"
"слъэгъуакъым","не видел"
"схуэшхыркъым","не могу есть"
"щIэркъым","не знает"
```

---

## Правило

### Формулировка

**Суффикс -къым является основным показателем отрицания в финитных (личных) формах глагола и следует ПОСЛЕ всех временных и модальных показателей.**

### Детали

**Порядок аффиксов:**
```
[PREFIXES]-[STEM]-[TENSE]-[PREDICATE]-[NEGATION]
                    -а/-ыр    -щ/-т      -къым
```

**Позиция -къым:**
- После показателей времени (-а, -ыр, -ну)
- После показателей сказуемости (-щ, -т)
- После определённости (-р) в презенсе
- В абсолютном конце финитной глагольной формы

**Применение:**
- Используется в изъявительном наклонении
- Используется во всех временных формах
- Может комбинироваться с префиксом мы- (двойное отрицание)

**Отличие от префикса мы-:**
- **мы-** используется в инфинитных формах (масдар, деепричастия, повелительное наклонение)
- **-къым** используется в финитных формах (изъявительное наклонение, личные формы)

---

## Примеры

### ✅ Правильно

```
Пример 1: "не смог" (прошедшее время)
Разбор: с-лъэкI-а-къым
        1SG-can-PAST-NEG
Перевод: "слъэкIакъым"
Структура: [субъект]-[корень]-[время]-[отрицание]
```

```
Пример 2: "не могу" (настоящее время)
Разбор: с-лъэкI-ыр-къым
        1SG-can-PRES-NEG
Перевод: "слъэкIыркъым"
Структура: [субъект]-[корень]-[время/опред]-[отрицание]
```

```
Пример 3: "он не пишет" (настоящее время)
Разбор: ар тх-э-р-къым
        он писать-PRES-DEF-NEG
Перевод: "ар тхэркъым"
```

### ❌ Неправильно

```
Пример 1: Неправильная позиция отрицания
❌ слъэкъыма (отрицание перед временем)
✅ слъэкIакъым (отрицание после времени)
```

```
Пример 2: Использование мы- вместо -къым в финитной форме
❌ сымылъэкIа (префикс мы- в изъявительном наклонении)
✅ слъэкIакъым (суффикс -къым в финитной форме)
```

---

## Действия

Что было сделано для интеграции этой находки в skill:

- [x] Создан файл документации в `grammar_discoveries/`
- [ ] Добавить в `reference_improved.md` раздел об отрицании
- [ ] Обновить чеклист в `SKILL.md` - добавить пункт о проверке позиции отрицания

---

## Ссылки

**Грамматические источники:**
- `references/grammar/advanced_verbs/chunk_035_pages_171-175.txt` (строки 189-225) - основное описание
- `references/grammar/advanced_verbs/chunk_036_pages_176-180.txt` - двойное отрицание

**Корпус:**
- Проверено в `data/translations/sents_292k.csv` с паттерном "къым"

**Связанные находки:**
- [2025-11-07: Маркер предикативности -щ](./2025-11-07_predicative_marker_shch.md)
- [2025-11-07: Модальный глагол лъэкI](./2025-11-07_verb_lekI_modal.md)

---

## Примечания

- -къым историчес состоит из отрицательного префикса м- и вопросительного суффикса -къы/-къэ
- В сложных временах следует после ВСЕХ временных показателей
- Префикс мы- используется отдельно в императиве и инфинитных формах
- Двойное отрицание (мы- + -къым) дает утвердительное значение с модальным оттенком необходимости
