# Причастие прошедшего времени с суффиксом -а (без -щ)

**Дата:** 2025-11-07
**Автор:** Claude Code + User
**Статус:** ✅ Подтверждено

---

## Контекст

При переводе предложения **"Мне бы хотелось забыть последнюю ночь, проведенную с тобой"** возник вопрос об использовании причастной формы "проведенную".

**Пример предложения:**
```
Русский: "проведенную с тобой" (причастие прошедшего времени)
Правильный перевод: "уи гъусэу згъэкIуар"
                              згъэкIуа-р (не згъэкIуа-щ-ыр!)
```

---

## Проблема

Причастие прошедшего времени должно использовать суффикс **-а** (маркер времени) + **-р** (определённость), а НЕ **-ащ** (-а + -щ, где -щ - маркер предикативности настоящего времени).

---

## Исследование

### Источники проверки

**Грамматические справочники:**
- [x] `references/grammar/advanced_verbs/chunk_031_pages_151-155.txt` (таблицы спряжения)
- [x] `references/grammar/verbal_derivations/chunk_045_pages_221-225.txt`
- [x] `references/grammar/verbal_derivations/chunk_048_pages_236-240.txt`

**Корпус переводов:**
- [x] `data/translations/sents_292k.csv`

### Что нашли

**1. Из `advanced_verbs/chunk_031_pages_151-155.txt` (Таблица 15, строки 3-63):**

Структура прошедшего времени показывает:
```
Колонка 6: Суф. времени = -а (прошедшее время)
Колонка 7: Суф. утвердительности = -щ (предикативность)
```

Примеры из таблицы:
- "с-т-**а-щ**" = "я ему отдал" (финитная форма: время + предикативность)

**2. Из `verbal_derivations/chunk_048_pages_236-240.txt`, строки 239-250:**

> "Причастия имеют следующие временные формы: настоящее, перфект I, плюсквамперфект I, будущее II."

> "1. Настоящее время: телъыр «тот, который лежит на чем-то»"
> "2. Перфект I: **исар** «тот, который сидел где-то», **зыдэщытар** «где он стоял»"

**Примечание:** В причастиях используется **-а** для прошедшего времени, но БЕЗ дополнительного **-щ**, так как -щ является маркером предикативности для финитных форм!

**Примеры из корпуса:**
```bash
grep -F "згъэкIуар" data/translations/sents_292k.csv | head -3
```

Результаты:
```
"щызгъэкIуари","проведенное им время"
"зэрызгъэкIуар","как провел"
"къызгъэкIуар","проведенное"
```

**Анализ:**
- "згъэкIуа-р" = з-гъэ-кIуэ-**а**-р (REL-CAUS-идти-**PAST**-DEF)
- НЕТ суффикса **-щ** после **-а** в причастиях!

---

## Правило

### Формулировка

**В причастиях прошедшего времени используется суффикс времени -а + суффикс определённости -р, БЕЗ маркера предикативности -щ. Маркер -щ используется только в финитных (личных) формах глагола!**

### Детали

**Различие финитных форм и причастий:**

| Форма | Структура | Пример | Значение |
|-------|-----------|--------|----------|
| **Финитная** (прошедшее) | [PREFIX]-[STEM]-**-а-щ** | с-т-**а-щ** | "я отдал" (личная форма) |
| **Причастие** (прошедшее) | [PREFIX]-[STEM]-**-а-р** | згъэкIу-**а-р** | "проведенное" (атрибутивная форма) |

**Почему НЕТ -щ в причастиях:**
- **-щ** = маркер сказуемости/предикативности НАСТОЯЩЕГО времени
- **-т** = маркер сказуемости ПРОШЕДШЕГО времени (в финитных формах)
- Причастия - это атрибутивные (определяющие) формы, а не предикативные
- В причастиях вместо маркера предикативности используется маркер определённости **-р**

**Структура причастия прошедшего времени:**
```
[PREFIXES]-[STEM]-[TAM: -а]-[DEFINITENESS: -р]
                     ↑              ↑
                 прошедшее    определённость
                   время      (не предикативность!)
```

**Применение:**
- В атрибутивных конструкциях (определения к существительным)
- В относительных придаточных предложениях
- Всегда с маркером -р (определённость), а НЕ -щ (предикативность)

---

## Примеры

### ✅ Правильно

```
Пример 1: "ночь, проведенную с тобой"
Разбор: жэщ уи гъусэу з-гъэ-кIуэ-**а-р**
        ночь ты.GEN с REL-CAUS-идти-**PAST-DEF**
Перевод: "жэщ уи гъусэу згъэкIуар"
Примечание: -а (прошедшее) + -р (определённость), БЕЗ -щ
```

```
Пример 2: "время, которое он провел"
Разбор: щы-з-гъэ-кIуэ-а-р-и
        LOC-REL-CAUS-идти-PAST-DEF-и
Перевод: "щызгъэкIуари"
Примечание: причастие с -а-р, а не -а-щ-ыр
```

```
Пример 3: "тот, который сидел"
Разбор: и-с-**а-р**
        LOC-сидеть-**PAST-DEF**
Перевод: "исар"
Примечание: из академического источника, форма перфекта I
```

### ❌ Неправильно

```
Пример 1: Использование -щ в причастии
❌ згъэкIуащыр (з-гъэ-кIуэ-а-щ-ыр)
✅ згъэкIуар (з-гъэ-кIуэ-а-р)
Причина: -щ используется в финитных формах, не в причастиях
```

```
Пример 2: Смешивание финитной и причастной форм
❌ жэщыр щызгъэкIуащ (использование -щ как в финитной форме)
✅ жэщ згъэкIуар (причастие с -а-р)
Причина: Для определения используется причастие, не финитная форма
```

---

## Действия

Что было сделано для интеграции этой находки в skill:

- [x] Создан файл документации в `grammar_discoveries/`
- [ ] Добавить в `reference_improved.md` раздел о различии финитных форм и причастий
- [ ] Обновить чеклист в `SKILL.md` - добавить пункт "Причастие с -а-р (не -а-щ)?"

---

## Ссылки

**Грамматические источники:**
- `references/grammar/advanced_verbs/chunk_031_pages_151-155.txt` - таблицы спряжения
- `references/grammar/verbal_derivations/chunk_048_pages_236-240.txt` (строки 239-250) - временные формы причастий

**Корпус:**
- Проверено в `data/translations/sents_292k.csv` с паттерном "згъэкIуар"

**Связанные находки:**
- [2025-11-07: Маркер предикативности -щ](./2025-11-07_predicative_marker_shch.md)
- [2025-11-07: Отрицание с -къым](./2025-11-07_negation_kym.md)

---

## Примечания

- **Ключевое различие:** Финитные формы используют -щ/-т для предикативности, причастия используют -р для определённости
- В причастиях настоящего времени также используется -р: "телъыр" = "тот, который лежит"
- Суффикс -а в причастиях обозначает прошедшее время, как и в финитных формах
- Это правило критично для правильного формирования относительных придаточных предложений
