# Посессивный префикс уи "твой" + послелог гъусэу "с"

**Дата:** 2025-11-07
**Автор:** Claude Code + User
**Статус:** ✅ Подтверждено

---

## Контекст

При переводе предложения **"Мне бы хотелось забыть последнюю ночь, проведенную с тобой"** возник вопрос о правильном выражении "с тобой".

**Пример предложения:**
```
Русский: "с тобой"
Моя попытка: "у гъусэу" (неправильно)
Правильно: "уи гъусэу"
             ↑
    посессивный префикс 2 лица
```

---

## Проблема

Для выражения "с тобой" необходимо использовать посессивный (притяжательный) префикс **уи** "твой", а не базовую форму **у** "ты".

---

## Исследование

### Источники проверки

**Грамматические справочники:**
- [x] `references/grammar/nouns/chunk_015_pages_71-75.txt`

**Корпус переводов:**
- [x] `data/translations/sents_292k.csv`

### Что нашли

**1. Из `nouns/chunk_015_pages_71-75.txt`, строки 114-150:**

Таблица посессивных префиксов:
```
        Един. число              Множ. число
1-е л.  си «мой»                 ди «наш»
2-е л.  уи «твой»                фи «ваш»
3-е л.  и «его»                  я «их»
```

**2. Примеры использования из грамматики (строки 122-134):**

> "Притяжательные местоименные префиксы способны присоединяться к существительным, прилагательным, послелогам"

Примеры:
- "**уи** анэ" = "твоя мать"
- "**уи** нысэ" = "твоя невеста"
- "**уи** псэ" = "твоя душа"

**3. Примеры из корпуса:**
```bash
grep -F "уи гъусэу" data/translations/sents_292k.csv | head -5
```

Результаты:
```
"уи гъусэу сыкъэкIуащ","я пришел с тобой"
"уи гъусэу слъытащ","я лежал с тобой"
"уи гъусэу","с тобой"
"уи гъусэу сыкIуэнущ","я пойду с тобой"
```

**Анализ:**
- "уи гъусэу" = уи (твой) + гъусэ (компания, окружение) + -у (послелог)
- Буквально: "в твоей компании" = "с тобой"
- НЕ "у гъусэу" (базовая форма местоимения)

---

## Правило

### Формулировка

**Для выражения "с кем-то" используется конструкция [POSSESSIVE] + гъусэу, где посессивный префикс согласуется с лицом и числом того, с кем совершается действие.**

### Детали

**Структура:**
```
[Посессивный префикс] + гъусэ + -у
        уи                (основа)  (послелог)
    = "в твоей компании" = "с тобой"
```

**Полная парадигма "с кем-то":**
```
си гъусэу    = "со мной"     (1SG.POSS + company + LOC)
уи гъусэу    = "с тобой"     (2SG.POSS + company + LOC)
и гъусэу     = "с ним/ней"   (3SG.POSS + company + LOC)
ди гъусэу    = "с нами"      (1PL.POSS + company + LOC)
фи гъусэу    = "с вами"      (2PL.POSS + company + LOC)
я гъусэу     = "с ними"      (3PL.POSS + company + LOC)
```

**Почему посессивный префикс:**
- гъусэ = "окружение, компания" (существительное)
- Требует посессивного префикса для обозначения, чьё окружение
- Послелог -у указывает на локацию/присутствие
- Конструкция буквально означает "в чьём-то окружении"

**Применение:**
- Для выражения совместного действия "с кем-то"
- С любыми глаголами, требующими комитативного значения
- Всегда использует посессивный префикс, не базовую форму местоимения

---

## Примеры

### ✅ Правильно

```
Пример 1: "ночь, проведенную с тобой"
Разбор: жэщ **уи** гъусэу згъэкIуар
        ночь **2SG.POSS** company.LOC spent
Перевод: "жэщ уи гъусэу згъэкIуар"
Примечание: уи (твой), а не у (ты)
```

```
Пример 2: "я пришел с тобой"
Разбор: **уи** гъусэу с-ы-къэ-кIуэ-а-щ
        **2SG.POSS** company.LOC 1SG-EP-DIR-идти-PAST-AFF
Перевод: "уи гъусэу сыкъэкIуащ"
```

```
Пример 3: "идти с ним"
Разбор: **и** гъусэу кIуэн
        **3SG.POSS** company.LOC идти.INF
Перевод: "и гъусэу кIуэн"
```

### ❌ Неправильно

```
Пример 1: Использование базовой формы местоимения
❌ у гъусэу (базовая форма "ты")
✅ уи гъусэу (посессивная форма "твой")
Причина: гъусэ требует посессивного префикса
```

```
Пример 2: Пропуск посессивного префикса
❌ гъусэу (без префикса)
✅ уи гъусэу (с посессивным префиксом)
Причина: Необходимо указать, чьё окружение
```

---

## Действия

Что было сделано для интеграции этой находки в skill:

- [x] Создан файл документации в `grammar_discoveries/`
- [ ] Добавить в `reference_improved.md` раздел о посессивных конструкциях
- [ ] Обновить чеклист в `SKILL.md` - добавить пункт "Правильный посессивный префикс?"

---

## Ссылки

**Грамматические источники:**
- `references/grammar/nouns/chunk_015_pages_71-75.txt` (строки 114-150) - таблица посессивных префиксов

**Корпус:**
- Проверено в `data/translations/sents_292k.csv` с паттерном "уи гъусэу"

**Связанные находки:**
- [2025-11-07: Причастие с -а-р](./2025-11-07_participle_past_a.md)

---

## Примечания

- гъусэ - существительное, означающее "окружение, компания, общество"
- Посессивные префиксы в кабардинском могут присоединяться не только к существительным, но и к послелогам
- Эта конструкция является стандартным способом выражения комитативного значения ("с кем-то")
- Не путать с базовыми формами личных местоимений (сэ, уэ, ар)
- Аналогичная структура используется с другими послелогами: уи фэкIэ "для тебя", уи пащэу "после тебя"
