# Маркер предикативности -щ в именных предложениях

**Дата:** 2025-11-07
**Автор:** Claude Code + User
**Статус:** ✅ Подтверждено

---

## Контекст

При переводе предложения **"Ты моя самая большая удача в жизни"** возник вопрос об использовании суффикса **-щ**.

**Пример предложения:**
```
Русский: "Ты моя самая большая удача в жизни."
Первая попытка: "Уэращ гъащIэм си насып нэхъ иныращ."
```

---

## Проблема

Первоначальный перевод содержал **два** маркера **-щ** в одном предложении.

**Ошибка:**
```
❌ Уэращ гъащIэм си насып нэхъ иныращ.
   уэр-а-щ ... ины-ра-щ
   (два маркера -щ в одном предложении)
```

Пользователь заметил: "либо Уэращ либо иныращ убрать суффикс -щ"

---

## Исследование

### Источники проверки

**Грамматические справочники:**
- [x] `references/grammar/syntax/chunk_058_pages_286-290.txt`
- [x] `references/grammar/morphology_intro/chunk_011_pages_51-55.txt`
- [x] `references/grammar/nouns/chunk_013_pages_61-65.txt`

**Корпус переводов:**
- [x] `data/translations/sents_292k.csv`

### Что нашли

**1. Из `syntax/chunk_058_pages_286-290.txt`, строки 251-254:**

> "При этом сказуемые придаточных предложений лишаются официальных формантов (показателей) сказуемости **-щ, -т, -къым**"

**2. Из `morphology_intro/chunk_011_pages_51-55.txt`, строки 87-88:**

> "-а – суффикс прошедшего времени, **-щ – утвердительный суффикс (настоящего времени)**"

> "-ну – суффикс будущего времени, **-т – суффикс прошедшего времени**"

**3. Из `nouns/chunk_013_pages_61-65.txt`, строки 216-217:**

> "Морфологическим показателем определенных имен являются форматив **-р и -м**"

**Примеры из корпуса:**
```bash
grep -F "уэращ си" data/translations/sents_292k.csv
```

Результаты:
```
"уэращ си выр зыгъэлIар","это ты убил моего вола"
"уэращ си гъащIэр","ты - моя жизнь"
"уэрщ си плъапIэр","ты моя цель"
"уэрщ си щапхъэр","ты мой пример"
```

**Анализ примеров:**
- Все используют **-щ** на подлежащем ("уэращ" = ты-ЕСТЬ)
- Все используют **-р** на именной части ("гъащIэр", "плъапIэр", "щапхъэр")
- **НИ ОДИН** не использует два **-щ**

---

## Правило

### Формулировка

**В именном предложении типа "X есть Y" маркер предикативности -щ ставится ТОЛЬКО ОДИН РАЗ на подлежащем!**

### Детали

**Маркеры предикативности (показатели сказуемости):**

| Маркер | Функция | Время | Пример |
|--------|---------|-------|--------|
| **-щ** | утвердительность, сказуемость | **настоящее** | уэр**ащ** = "ты есть" |
| **-т** | утвердительность, сказуемость | **прошедшее** | уэр**ат** = "ты был" |
| **-къым** | отрицание | любое | слъагъу**къым** = "не вижу" |

**Маркеры падежа и определённости:**

| Маркер | Функция | Пример |
|--------|---------|--------|
| **-р** | определённость (именительный падеж) | унэ**р** = "дом" (определённый) |
| **-м** | эргативный/локативный падеж | унэ**м** = "в доме" |
| **-кIэ** | послеложный падеж | унэ**кIэ** = "с домом" |

**Структура именного предложения "X есть Y":**

```
[Подлежащее-щ] + [Именная_часть-р]
    ↑                    ↑
    |                    |
предикативность    определённость
(только один -щ!)    (может быть -р)
```

**Применение:**
- Когда использовать: В именных предложениях настоящего времени "X есть Y"
- **-щ** идёт на подлежащее (одно сказуемое = один -щ)
- **-р** идёт на именную часть для определённости
- Исключения: нет

---

## Примеры

### ✅ Правильно

```
Пример 1: "Ты моя жизнь"
Разбор: уэр-а-щ си гъащIэ-р
        ты-ЕСТЬ моя жизнь-ОПРЕД
Перевод: "уэращ си гъащIэр"
```

```
Пример 2: "Ты моя самая большая удача в жизни"
Разбор: уэр-а-щ гъащIэ-м си насып нэхъ ины-р
        ты-ЕСТЬ жизнь-ЛОК моя удача самая большая-ОПРЕД
Перевод: "уэращ гъащIэм си насып нэхъ иныр"
```

```
Пример 3: "Ты моя цель"
Разбор: уэр-щ си плъапIэ-р
        ты-ЕСТЬ моя цель-ОПРЕД
Перевод: "уэрщ си плъапIэр"
```

### ❌ Неправильно

```
Пример 1: "уэращ гъащIэм си насып нэхъ иныращ"
           уэр-а-щ ... ины-ра-щ
Причина: Два маркера предикативности -щ в одном предложении
Исправление: "уэращ гъащIэм си насып нэхъ иныр"
```

---

## Действия

Что было сделано для интеграции этой находки в skill:

- [x] Добавлен раздел "⚡ Маркеры предикативности и определённости" в `reference_improved.md`
- [x] Обновлён чеклист в `SKILL.md` - добавлен пункт "В именном предложении только ОДИН маркер -щ?"
- [x] Создана структура `grammar_discoveries/` для логирования находок

---

## Ссылки

**Обновлённые файлы:**
- `reference_improved.md` - раздел "⚡ Маркеры предикативности и определённости"
- `SKILL.md` - чеклист, пункты в Шагах 5 и 6

**Грамматические источники:**
- `references/grammar/syntax/chunk_058_pages_286-290.txt` - показатели сказуемости
- `references/grammar/morphology_intro/chunk_011_pages_51-55.txt` - суффикс -щ
- `references/grammar/nouns/chunk_013_pages_61-65.txt` - форманты -р и -м

**Корпус:**
- Проверено в `data/translations/sents_292k.csv` с паттерном "уэращ си"

---

## Примечания

- Это правило применимо к **именным предложениям настоящего времени**
- Для прошедшего времени используется **-т** вместо **-щ**
- **-щ** и **-р** выполняют разные функции и не взаимозаменяемы:
  - **-щ** = предикативность (сказуемость)
  - **-р** = определённость (маркер падежа)
