# Модальный глагол лъэкI "мочь, быть способным"

**Дата:** 2025-11-07
**Автор:** Claude Code + User
**Статус:** ✅ Подтверждено

---

## Контекст

При переводе предложения **"Мне бы хотелось забыть последнюю ночь, проведенную с тобой, но я не смог"** возник вопрос об использовании глагола для выражения возможности/способности.

**Пример предложения:**
```
Русский: "но я не смог" (в конце предложения)
Правильный перевод: "ауэ слъэкIакъым"
```

---

## Проблема

Мой перевод не содержал правильного модального глагола для выражения "мочь/смогэ".

---

## Исследование

### Источники проверки

**Грамматические справочники:**
- [x] `references/grammar/advanced_verbs/chunk_040_pages_196-200.txt`
- [x] `references/grammar/advanced_verbs/chunk_036_pages_176-180.txt`

**Корпус переводов:**
- [x] `data/translations/sents_292k.csv`

### Что нашли

**1. Из `advanced_verbs/chunk_040_pages_196-200.txt`, строки 182-194:**

> "При помощи глагола **лъэкIын «мочь»** образуется описательная форма потенциалиса"

> "Глагол лъэкIын – **инверсивный**, на что указывает и отсутствие субъектного аффикса 3-го лица единственного числа"

**Примеры из академических источников:**
- "сэ сыкIуэн **слъэкIыркъым**" = "я не могу идти" (I cannot go)
- "сыкIуэн **схулъэкIакъым**" = "я идти не смог" (I could not go)

**2. Из `advanced_verbs/chunk_036_pages_176-180.txt`, строки 75-79:**

> "При сочетании **лъэкIын** «мочь» в отрицательной форме с отрицательным инфинитивом:"
> - "семыгупсысын **слъэкIыркъым**" = "я не смогу не думать об этом"
> - "къэмыкIуэн **лъэкIыркъым**" = "он не может не идти сюда"
> - "имылъагъун **лъэкIакъым**" = "он не смог не увидеть его"

**3. Из `advanced_verbs/chunk_035_pages_171-175.txt`, строка 212:**

> "Сщыгъэгъупщэн **слъэкIыркъым** а бзылъхугъэр къызэрызэлъэIуар"
> "Не могу забыть, как эта женщина меня просила"

**Примеры из корпуса:**
```bash
grep -F "лъэкIакъым" data/translations/sents_292k.csv | head -5
```

Результаты:
```
"слъэкIакъым сыгу щхьэкIэ игъэцIыху","не мог догадаться"
"слъэкIакъым сыкIуэн","не смог идти"
"слъэкIакъым сыхэт","не смог вынести"
```

---

## Правило

### Формулировка

**Глагол лъэкI(ын) является модальным глаголом, выражающим способность/возможность ("мочь", "смочь", "быть способным"), и является инверсивным (без субъектного аффикса 3-го лица).**

### Детали

**Структура с лъэкI:**
```
[Субъект] + [Инфинитив/Действие] + [с/у/∅]-лъэкI-(а/ыр)-къым
    ↑              ↑                       ↑     ↑      ↑
подлежащее    что делать           субъект время отриц
```

**Формы:**
- **слъэкIыркъым** = "не могу" (настоящее время, отрицание)
- **слъэкIакъым** = "не смог" (прошедшее время, отрицание)
- **схулъэкIакъым** = "не смог" (с префиксом версии ху-)

**Применение:**
- Используется для выражения возможности/способности действия
- Является инверсивным глаголом (без аффикса субъекта 3 лица)
- Часто используется с отрицанием -къым
- Может сочетаться с префиксом версии ху(э)-

**Временные формы:**
- Настоящее: лъэкIыр- ("могу")
- Прошедшее: лъэкIа- ("смог")

---

## Примеры

### ✅ Правильно

```
Пример 1: "я не смог"
Разбор: с-лъэкI-а-къым
        1SG-can-PAST-NEG
Перевод: "слъэкIакъым"
```

```
Пример 2: "я не могу идти"
Разбор: сэ сы-кIуэ-н с-лъэкI-ыр-къым
        я 1SG-идти-INF 1SG-can-PRES-NEG
Перевод: "сэ сыкIуэн слъэкIыркъым"
```

```
Пример 3: "он не смог не увидеть"
Разбор: и-мы-лъагъу-н лъэкI-а-къым
        3SG-NEG-видеть-INF can-PAST-NEG
Перевод: "имылъагъун лъэкIакъым"
```

### ❌ Неправильно

```
Пример 1: Использование другого глагола вместо лъэкI
Моя попытка: схуэщIакъым (неправильный глагол)
Причина: лъэкI является специализированным модальным глаголом
Исправление: слъэкIакъым
```

---

## Действия

Что было сделано для интеграции этой находки в skill:

- [x] Создан файл документации в `grammar_discoveries/`
- [ ] Добавить примеры в `reference_improved.md`
- [ ] Обновить чеклист в `SKILL.md` - добавить пункт о проверке модальных глаголов

---

## Ссылки

**Грамматические источники:**
- `references/grammar/advanced_verbs/chunk_040_pages_196-200.txt` (строки 182-194) - основное описание
- `references/grammar/advanced_verbs/chunk_036_pages_176-180.txt` (строки 75-79) - примеры с двойным отрицанием
- `references/grammar/advanced_verbs/chunk_035_pages_171-175.txt` (строка 212) - пример в контексте

**Корпус:**
- Проверено в `data/translations/sents_292k.csv` с паттерном "лъэкIакъым"

**Связанные находки:**
- [2025-11-07: Маркер предикативности -щ](./2025-11-07_predicative_marker_shch.md)
- [2025-11-07: Отрицание с -къым](./2025-11-07_negation_kym.md) (будет создан)

---

## Примечания

- лъэкI(ын) - инверсивный глагол, поэтому структура предложения отличается от обычных глаголов
- Часто используется в конструкциях с двойным отрицанием (мы- + -къым) для выражения необходимости
- Может сочетаться с префиксом версии хуэ-, но это не обязательно и не меняет основного значения
