# Grammar Discoveries

Эта директория содержит важные грамматические правила и находки, обнаруженные во время работы с переводами.

## Цель

Накапливать знания о кабардинской грамматике, обнаруженные через практическую работу с переводами, и постепенно улучшать качество skill'а kbd-translator.

## Как добавить новую находку

1. **Исследуйте:** Проверьте правило в `references/grammar/` грамматических справочниках
2. **Создайте файл:** Скопируйте `TEMPLATE.md` → `YYYY-MM-DD_короткое_название.md`
3. **Заполните:** Опишите контекст, проблему, исследование, правило, примеры
4. **Обновите skill:** Добавьте правило в `reference_improved.md` и/или `SKILL.md`

## Формат имени файла

```
YYYY-MM-DD_короткое_название_на_английском.md
```

Примеры:
- `2025-11-07_predicative_marker_shch.md`
- `2025-11-08_negative_suffix_kym.md`
- `2025-11-10_sov_word_order_exception.md`

## Список находок

### Морфология и синтаксис

- [2025-11-07: Маркер предикативности -щ](./2025-11-07_predicative_marker_shch.md) - В именном предложении только один -щ
- [2025-11-07: Модальный глагол лъэкI](./2025-11-07_verb_lekI_modal.md) - Глагол "мочь, быть способным"
- [2025-11-07: Отрицание с -къым](./2025-11-07_negation_kym.md) - Суффикс отрицания в финитных формах
- [2025-11-07: Причастие прошедшего времени с -а](./2025-11-07_participle_past_a.md) - Причастие с -а-р (без -щ)
- [2025-11-07: Посессивный префикс уи](./2025-11-07_possessive_ui_guseu.md) - Конструкция "уи гъусэу" = "с тобой"
