# [Название находки]

**Дата:** YYYY-MM-DD
**Автор:** [Имя или "Claude Code + User"]
**Статус:** 🔍 Исследуется | ✅ Подтверждено | ⚠️ Требует проверки

---

## Контекст

[Какая задача/перевод привели к обнаружению этого правила]

**Пример предложения:**
```
Русский: "..."
Попытка перевода: "..."
```

---

## Проблема

[Что было неправильно, непонятно или вызвало вопрос]

**Ошибка:**
```
❌ Неправильно: ...
```

---

## Исследование

### Источники проверки

**Грамматические справочники:**
- [ ] `references/grammar/syntax/...`
- [ ] `references/grammar/morphology_intro/...`
- [ ] `references/grammar/nouns/...`
- [ ] Другие: ...

**Корпус переводов:**
- [ ] `data/translations/sents_292k.csv`
- [ ] `data/00_kbd_sentences.csv`

### Что нашли

[Цитаты из грамматических справочников, примеры из корпуса]

**Пример из справочника:**
> [Цитата], источник: `references/grammar/.../file.txt`, строки X-Y

**Примеры из корпуса:**
```bash
grep -i "..." data/translations/sents_292k.csv | head -5
```

Результаты:
```
"kbd_text","rus_translation"
...
```

---

## Правило

### Формулировка

**[Краткое описание правила в одном-двух предложениях]**

### Детали

[Более подробное объяснение]

**Структура:**
```
[Схема или паттерн]
```

**Применение:**
- Когда использовать: ...
- Когда НЕ использовать: ...
- Исключения: ...

---

## Примеры

### ✅ Правильно

```
Пример 1: "..."
Разбор: ...
Перевод: "..."
```

```
Пример 2: "..."
Разбор: ...
Перевод: "..."
```

### ❌ Неправильно

```
Пример 1: "..." (почему неправильно)
```

```
Пример 2: "..." (почему неправильно)
```

---

## Действия

Что было сделано для интеграции этой находки в skill:

- [ ] Добавлен раздел в `reference_improved.md`
- [ ] Обновлён чеклист в `SKILL.md`
- [ ] Добавлены примеры в `reference.md`
- [ ] Создан тест для проверки правила
- [ ] Другое: ...

---

## Ссылки

**Обновлённые файлы:**
- `reference_improved.md` - раздел "..."
- `SKILL.md` - чеклист, пункт "..."

**Грамматические источники:**
- `references/grammar/.../file.txt`

**Связанные находки:**
- [YYYY-MM-DD: Название другой находки](./YYYY-MM-DD_filename.md)

---

## Примечания

[Дополнительные заметки, вопросы для дальнейшего исследования, неясности]
