# Kabardian Linguistic Reference

> Детальная справка по грамматике, морфологии и синтаксису кабардинского языка для перевода с русского.

---

## О кабардинском языке

**Кабардинский язык (кабардино-черкесский, Kabardian, kbd)** - язык северо-западной кавказской языковой семьи.

**Основные характеристики:**
- Агглютинативная морфология
- Порядок слов: SOV (Subject-Object-Verb)
- Эргативная конструкция предложений
- Богатая система префиксов и суффиксов
- Расширенный кириллический алфавит

---

## 1. Порядок слов (Word Order)

### Правило SOV

**Кабардинский использует строгий порядок слов SOV в отличие от русского SVO.**

| Язык | Порядок | Пример |
|------|---------|---------|
| Русский | SVO | Я (S) вижу (V) дом (O) |
| Кабардинский | SOV | Сэ (S) унэр (O) сыплъ (V) |

### Примеры преобразования

```
Русский: Я не понимаю
Структура: Я (S) не понимаю (V)
Кабардинский: Сэ къызгурыIуэркъым
Структура: Сэ (S) къызгурыIуэркъым (V)

Русский: Он вообще не смотрит телевизор
Структура: Он (S) телевизор (O) не смотрит (V)
Кабардинский: Телевизор еплъыххэркъым
Структура: Телевизор (O) еплъыххэркъым (V)

Русский: Я хотел бы позвонить родителям
Структура: Я (S) родителям (O) позвонить (V) хотел бы
Кабардинский: Си адэ-анэм сепсэлъэну сыхуейт
Структура: Си адэ-анэм (O) сепсэлъэну сыхуейт (V)
```

### Правила для вопросов

Вопросительные предложения также следуют SOV порядку:

```
Русский: Где ты живёшь?
Кабардинский: Уэ тыдэ упсэу?
Структура: Уэ (S) тыдэ (где/O) упсэу (V)?
```

---

## 2. Морфология (Morphology)

### Глагольные префиксы

Кабардинские глаголы используют префиксы для обозначения лица, числа и других грамматических категорий:

| Лицо | Префикс | Пример |
|------|---------|---------|
| 1 л. ед.ч | с(ы)- | с**ы**плъ (я вижу) |
| 2 л. ед.ч | у(э)- | у**э**плъ (ты видишь) |
| 3 л. ед.ч | и-, е- | **и**плъ (он/она видит) |

### Глагольные суффиксы

Суффиксы обозначают время, аспект, наклонение:

| Категория | Суффикс | Пример |
|-----------|---------|---------|
| Отрицание | -къым | сыплъ**къым** (я не вижу) |
| Будущее время | -нщ | сыплъ**ынщ** (я увижу) |
| Желание | -нут, -ныт | сыхуей**т** (я хотел бы) |

### Падежи

```
Именительный: унэ (дом)
Эргативный: унэм (дом + маркер субъекта транзитивного глагола)
Дательный: унэм (к дому)
```

---

## 3. Синтаксис (Syntax)

### Структура простого предложения

**Базовый паттерн:**
```
[Субъект] + [Объект] + [Глагол]
```

**Примеры:**
```
Сэ (S) бэзэрым (O) сокIуэ (V)
Я на рынок хожу
(Русский: Я хожу на рынок)
```

### Структура сложного предложения

Придаточные предложения обычно предшествуют главному:

```
Русский: Я думаю, что он придёт
Кабардинский: Ар къэкIуэну сыгу къэлъыт
Структура: [Он придёт] + [я думаю]
```

### Отрицание

Отрицание в кабардинском выражается суффиксом **-къым**:

```
Положительное: Сэ щIэ (Я знаю)
Отрицательное: Сэ сщIэркъым (Я не знаю)
```

---

## 4. Семантика (Semantics)

### Культурно-специфичные концепты

Некоторые русские выражения требуют культурно-адекватных эквивалентов:

| Русский | Дословный перевод | Правильный перевод |
|---------|-------------------|-------------------|
| Пожалуйста | - | КхъыIэ |
| Спасибо | - | Тхьэ Iущ къытфыщIыщ |
| Здравствуйте | Доброе здоровье | Хъяр кIэщI |

### Идиомы

При переводе идиом сохраняй смысл, а не форму:

```
Русский: Бить баклуши (ничего не делать)
Кабардинский: IуэхуитI къышIэркъым (работу не делает)
```

### Вежливость и обращения

Кабардинский имеет формы вежливости:

```
Ты (неформально): Уэ
Вы (формально/мн.ч): Фэ
```

---

## 5. Алфавит и орфография

### Расширенный кириллический алфавит

Кабардинский использует стандартную кириллицу плюс специальные символы:

**Особые символы:**
- **Ӏ** (I с вертикальной чертой) - глоттальный смычка
- **Ә** - звук между 'а' и 'э'
- **Гъ, Къ, Кӏ, Пӏ, Тӏ, Фӏ, Хь, Хъ, Цӏ, Щӏ, Жь** - специальные диграфы

### Стандартизация символов

**В нашем проекте используем следующую стандартизацию:**

| Исходный символ | Стандартизированный |
|----------------|---------------------|
| ӏ (U+04CF) | I (латинская I) |
| 1 (цифра один) | I (латинская I) |
| l (строчная L) | I (латинская I) |

**Примеры:**
```
Исходный: Iа-зэ ма-зэщ
После стандартизации: Iа-зэ ма-зэщ (без изменений, I уже правильная)

Исходный: сэ къызгурыӏуэркъым
После стандартизации: сэ къызгурыIуэркъым (ӏ → I)
```

---

## 6. Времена и аспекты

### Настоящее время

```
Сэ къэкIуэ - Я прихожу (обычное действие)
Сэ къэкIуэкI - Я пришёл (совершенное)
```

### Прошедшее время

```
Сэ къэкIуащ - Я пришёл (простое прошедшее)
Сэ къэкIуат - Я приходил (несовершенный вид)
```

### Будущее время

```
Сэ къэкIуэнщ - Я приду (будущее)
```

### Условное наклонение

```
Сэ къэкIуэт - Я бы пришёл (условное)
```

---

## 7. Частые конструкции

### Желание (хотеть)

```
Русский: Я хочу
Кабардинский: Сыхуей / Сыхуейт
Структура: сы- (я) + хуей (хотеть)

Русский: Я хотел бы позвонить
Кабардинский: Сепсэлъэну сыхуейт
```

### Возможность (мочь)

```
Русский: Я могу
Кабардинский: СщIэфы / СщIынущ

Русский: Я не могу
Кабардинский: СщIэфынукъым
```

### Необходимость (нужно)

```
Русский: Мне нужно
Кабардинский: Сыфае / Си мурад

Русский: Мне нужно идти
Кабардинский: СыкIуэну сыфае
```

---

## 8. Примеры переводов

### Простые предложения

```
Русский: Это Глэдис
Кабардинский: Мыр Глэдисщ
Анализ: Мыр (это) + Глэдисщ (Глэдис + связка)

Русский: Я люблю тебя
Кабардинский: Сэ уэ улъэгъуащ
Анализ: Сэ (я) + уэ (тебя) + улъэгъуащ (люблю)

Русский: Их отец строг
Кабардинский: Я адэр ткIыщ
Анализ: Я (их) + адэр (отец) + ткIыщ (строг)
```

### Вопросы

```
Русский: Вы их закончили?
Кабардинский: Фэ ахэр вухат?
Анализ: Фэ (вы) + ахэр (их) + вухат (закончили) + ?

Русский: Вы планируете участвовать в собрании?
Кабардинский: Зэхуэсым фыхэтыну фи мурад?
Анализ: Зэхуэсым (в собрании) + фыхэтыну (участвовать) + фи мурад (ваш план)?
```

### Отрицательные предложения

```
Русский: Вы не поняли шутки
Кабардинский: ГушыIэр къывгурыIуакъым
Анализ: ГушыIэр (шутку) + къывгурыIуакъым (не поняли)

Русский: Джон не может сейчас жить в Лондоне
Кабардинский: Джон иджыпсту Лондон щыпсэуфынукъым
Анализ: Джон + иджыпсту (сейчас) + Лондон щыпсэуфынукъым (жить не может)
```

### Сложные предложения

```
Русский: Он говорит так, будто всё знает
Кабардинский: Псори ищIэ хуэдэу мэпсалъэ
Анализ: Псори (всё) + ищIэ (знает) + хуэдэу (как будто) + мэпсалъэ (говорит)

Русский: Я думаю поехать в Лос-Анджелес
Кабардинский: Лос-Анджелес сыкIуэну согупсыс
Анализ: Лос-Анджелес (O) + сыкIуэну (поехать) + согупсыс (думаю)
```

---

## 9. Распространённые ошибки

### ❌ Неправильный порядок слов

```
❌ Сэ сыплъ унэр (Я вижу дом) - неправильно, SVO порядок
✅ Сэ унэр сыплъ (Я дом вижу) - правильно, SOV порядок
```

### ❌ Неправильные префиксы

```
❌ Сэ еплъ (используется префикс 3-го лица вместо 1-го)
✅ Сэ сыплъ (правильный префикс 1-го лица)
```

### ❌ Забытое отрицание

```
❌ Сэ сыплъ (Я вижу) - когда нужно отрицание
✅ Сэ сыплъыркъым (Я не вижу) - правильное отрицание
```

### ❌ Неправильные символы

```
❌ Сэ къызгурыlуэркъым (использована строчная L вместо I)
✅ Сэ къызгурыIуэркъым (правильная латинская I для глоттального смычка)
```

---

## 10. Рекомендации по расширению

Этот reference.md предназначен для постепенного расширения. При обнаружении новых паттернов или правил добавляйте их в соответствующие секции:

**Для добавления новых правил:**
1. Определите категорию (морфология, синтаксис, семантика)
2. Добавьте правило с примерами
3. Укажите распространённые ошибки если применимо

**Для добавления новых примеров:**
1. Добавьте в секцию 8 "Примеры переводов"
2. Обязательно включите анализ структуры
3. Покажите применение конкретных правил

---

## Источники

Лингвистические правила основаны на:
- Практических примерах перевода из notebook `antropic_translate_sents.ipynb`
- Корпусе параллельных текстов Tatoeba
- Грамматических паттернах из реальных переводов

---

**Этот документ является living document и должен обновляться по мере накопления знаний о кабардинском языке.**
