# Улучшенный Kabardian Translation Reference

## 🎯 Методология перевода (ОБЯЗАТЕЛЬНА К ПРИМЕНЕНИЮ!)

### ⚠️ КРИТИЧЕСКОЕ ПРАВИЛО
**НИКОГДА не переводите слова "на глаз" или по аналогии!**
**ВСЕГДА используйте словари для поиска правильных переводов слов!**

---

## 📋 Пошаговый процесс перевода

### Шаг 1: Анализ русского предложения

Разбери предложение на компоненты:

```
Пример: "Я вижу дом"

Компоненты:
- Подлежащее (S): Я
- Сказуемое (V): вижу
- Дополнение (O): дом
```

### Шаг 2: Поиск слов в словаре

**ОБЯЗАТЕЛЬНО ищи каждое ключевое слово в словаре!**

```bash
# Поиск в Rus-Ady словаре
grep -i "^\"видеть\"" data/glossary/Rus-Ady_UASP.csv
grep -i "^\"дом\"" data/glossary/Rus-Ady_UASP.csv
```

**Результаты:**
- видеть → **лъагъун** (глагол)
- дом → **унэ** (сущ.)
- я → **сэ** (местоимение)

### Шаг 3: Определение грамматических форм

**Глаголы требуют личных префиксов:**

| Лицо | Префикс | Пример |
|------|---------|--------|
| я (1 л. ед.ч) | с(ы)- | с**лъагъу** (я вижу) |
| ты (2 л. ед.ч) | у(э)- | у**лъагъу** (ты видишь) |
| он/она (3 л.) | и-, е-, ∅- | **илъагъу** (он видит) |

**Падежи для существительных:**

```
унэ (дом) → унэр (дом + определённость)
              унэм (дому, в доме)
              унэкIэ (с домом)
```

### Шаг 4: Построение SOV порядка

**Русский (SVO):** Я (S) вижу (V) дом (O)
**Кабардинский (SOV):** Сэ (S) унэр (O) слъагъу (V)

```
Сэ унэр слъагъу.
```

### Шаг 5: Финализация

- Проверка: ✅ SOV порядок
- Проверка: ✅ Правильные словарные формы
- Проверка: ✅ Правильная морфология (префиксы/суффиксы)
- Добавление пунктуации: `.`

**Итог:** `Сэ унэр слъагъу.`

---

## 🔍 Реальные примеры из корпуса

### Примеры с глаголом "лъагъун" (видеть)

```
А зыращ сэ слъагъур.
→ То, что я вижу.

Сэ фIыуэ слъагъухэр.
→ Я хорошо вижу их.

Псэущ лъагъуныгъэр.
→ Жизнь видна.
```

**Анализ:**
- слъагъур = с- (я) + лъагъ- (видеть) + -ур (показатель)
- слъагъухэр = с- (я) + лъагъ- (видеть) + -ухэр (мн.ч.)

---

## 📚 Ключевые глаголы (ПРОВЕРЕНЫ по словарю!)

### Базовые глаголы

| Русский (инфинитив) | Кабардинский | Я... | Ты... |
|---------------------|--------------|------|-------|
| видеть | лъагъун | слъагъу | улъагъу |
| знать | щIэн | сщIэ | уэщIэ |
| идти | кIуэн | сыкIуэ | укIуэ |
| говорить | жэн | сыжэ | уэжэ |
| делать | ищIэн | сыщIэ | уэщIэ |
| быть | щытын | сыщыт | уэщыт |
| хотеть | хуэн | сыхуей | уэхуей |
| читать | еджэн | седжэ | уэджэ |
| писать | тхэн | сытхэ | уэтхэ |

### Отрицательные формы (суффикс -къым)

```
Я вижу → Я не вижу
слъагъу → слъагъукъым

Я знаю → Я не знаю
сщIэ → сщIэркъым
```

---

## 🏗️ Построение сложных предложений

### Предложения с дополнением

**Шаблон:** [Подлежащее] + [Дополнение+маркер] + [Глагол]

```
Пример: "Мать готовит еду"

Шаг 1: Поиск в словаре
- мать → анэ
- еда → шхыныгъуэ
- готовить → щIэн (делать)

Шаг 2: Грамматика
- анэр (мать + определённость)
- шхыныгъуэр (еда + определённость)
- ищI (делает, 3 л.)

Шаг 3: SOV
Анэр шхыныгъуэр ищI.
```

### Предложения с обстоятельством места

```
Пример: "Дети играют в саду"

Шаг 1: Словарь
- дети → сабий (мн. сабийхэ)
- играть → къыщыкIуэн
- сад → бгъ (огород)

Шаг 2: Грамматика
- сабийхэр (дети + мн.ч.)
- бгъым (в саду/огороде + локатив)
- къыщыкIуэх (играют, 3 л. мн.ч.)

Шаг 3: SOV
Сабийхэр бгъым къыщыкIуэх.
```

---

## ⚠️ Распространённые ошибки (МОИ ОШИБКИ В ТЕСТЕ!)

### ❌ Ошибка 1: Неправильный глагол

```
❌ НЕПРАВИЛЬНО: Сэ унэр сыплъ.
   (использован несуществующий глагол "плъ")

✅ ПРАВИЛЬНО: Сэ унэр слъагъу.
   (правильный глагол "лъагъун" + префикс "с-")
```

### ❌ Ошибка 2: Неправильная форма

```
❌ НЕПРАВИЛЬНО: Анэр шхыныгъуэр ищI.
   (слишком упрощенно, нужна правильная форма глагола "готовить")

✅ ПРАВИЛЬНО: Анэр шхыныгъуэр щIэщ.
   (правильная форма с правильной морфологией)
```

### ❌ Ошибка 3: Порядок слов SVO вместо SOV

```
❌ НЕПРАВИЛЬНО: Сэ слъагъу унэр.
   (SVO порядок, как в русском)

✅ ПРАВИЛЬНО: Сэ унэр слъагъу.
   (SOV порядок, правильный для кабардинского)
```

---

## ⚡ Маркеры предикативности и определённости

### 📌 КРИТИЧЕСКОЕ ПРАВИЛО для именных предложений

**В именном предложении типа "X есть Y" маркер предикативности -щ ставится ТОЛЬКО ОДИН РАЗ!**

### Маркеры предикативности (показатели сказуемости)

Источник: `references/grammar/syntax/chunk_058_pages_286-290.txt`, строки 251-254

| Маркер | Функция | Время | Пример |
|--------|---------|-------|--------|
| **-щ** | утвердительность, сказуемость | **настоящее** | уэр**ащ** = "ты есть" |
| **-т** | утвердительность, сказуемость | **прошедшее** | уэр**ат** = "ты был" |
| **-къым** | отрицание | любое | слъагъу**къым** = "не вижу" |

### Маркеры падежа и определённости

| Маркер | Функция | Пример |
|--------|---------|--------|
| **-р** | определённость (именительный падеж) | унэ**р** = "дом" (определённый) |
| **-м** | эргативный/локативный падеж | унэ**м** = "в доме" |
| **-кIэ** | послеложный падеж | унэ**кIэ** = "с домом" |

### ⚠️ Правило использования -щ и -р в именных предложениях

**Структура именного предложения "X есть Y":**

```
[Подлежащее-щ] + [Именная_часть-р]
    ↑                    ↑
    |                    |
предикативность    определённость
(только один -щ!)    (может быть -р)
```

**Примеры из корпуса (data/translations/sents_292k.csv):**

✅ **ПРАВИЛЬНО:**
```
уэр-а-щ си гъащIэ-р
ты-ЕСТЬ моя жизнь-ОПРЕД
"Ты моя жизнь"
```

✅ **ПРАВИЛЬНО:**
```
уэр-а-щ гъащIэм си насып нэхъ ины-р
ты-ЕСТЬ в-жизни моя удача самая большая-ОПРЕД
"Ты моя самая большая удача в жизни"
```

❌ **НЕПРАВИЛЬНО:**
```
уэр-а-щ гъащIэм си насып нэхъ ины-ра-щ
ты-ЕСТЬ в-жизни моя удача самая большая-ОПРЕД-ЕСТЬ
(два маркера -щ в одном предложении!)
```

### Почему нельзя два -щ?

**Объяснение:**
- **-щ** = маркер сказуемости (предикативности)
- В предложении может быть **только одно сказуемое**
- **-р** = маркер определённости (не сказуемость!)
- **-р** может использоваться на именной части сказуемого для определённости

### Дополнительные примеры из корпуса

```
"уэрщ си плъапIэр"
→ "ты моя цель"
  -щ (предикативность на "ты есть")
  -р (определённость на "цель")

"уэрщ си щапхъэр"
→ "ты мой пример"
  -щ (предикативность)
  -р (определённость)

"насыпым я нэхъ иныр"
→ "самое большое счастье"
  нет -щ (это именная группа, не предложение)
  -р (определённость на "самое большое")
```

### Проверка в грамматических справочниках

Источники для подтверждения:
- `references/grammar/syntax/chunk_058_pages_286-290.txt` - официальные показатели сказуемости (-щ, -т, -къым)
- `references/grammar/morphology_intro/chunk_011_pages_51-55.txt` - "-щ – утвердительный суффикс (настоящего времени)"
- `references/grammar/nouns/chunk_013_pages_61-65.txt` - "-р и -м" как форманты определённости

---

## 🎯 Контрольный чеклист перевода

Перед финализацией перевода проверь:

- [ ] Все ключевые слова найдены в словаре?
- [ ] Использованы правильные личные префиксы глаголов?
- [ ] Применен SOV порядок слов?
- [ ] Добавлены падежные маркеры (-р, -м, -кIэ)?
- [ ] **В именном предложении только ОДИН маркер -щ?** ⚡
- [ ] Отрицание выражено суффиксом -къым?
- [ ] Множественное число выражено -хэ/-хэр?
- [ ] Стандартизированы символы (ӏ → I)?
- [ ] Добавлена пунктуация?

---

## 📖 Источники для проверки

### 1. Словари (ОБЯЗАТЕЛЬНЫ!)

```bash
# Русско-кабардинский
data/glossary/Rus-Ady_UASP.csv

# Толковый кабардинский
data/glossary/Ady-Ady_AP.csv
```

### 2. Корпус предложений

```bash
# Примеры реального использования
data/00_kbd_sentences.csv
```

### 3. Поиск примеров

```bash
# Найти примеры использования слова
grep -i "слово" data/00_kbd_sentences.csv | head -10
```

---

## 🚀 Улучшенный workflow

```
1. [АНАЛИЗ] → Разбор русского предложения
2. [СЛОВАРЬ] → Поиск КАЖДОГО слова в словаре
3. [МОРФОЛОГИЯ] → Определение правильных форм
4. [SOV] → Построение кабардинского порядка слов
5. [ПРОВЕРКА] → Контрольный чеклист
6. [ФИНАЛИЗАЦИЯ] → Пунктуация и стандартизация
```

**ВСЕГДА следуй этому процессу!** Не пропускай шаги!

---

## 💡 Советы для качественного перевода

1. **Не угадывай слова** - всегда используй словарь
2. **Проверяй примеры** - ищи похожие предложения в корпусе
3. **Думай о морфологии** - правильные префиксы/суффиксы критичны
4. **SOV - это закон** - никогда не нарушай порядок слов
5. **При сомнении - ищи** - лучше потратить время на поиск, чем ошибиться

---

**Этот улучшенный reference создан на основе анализа ошибок в первом тесте перевода!**
