---
name: kindle-sender
description: Send Research Swarm documents to Kindle. Use when "send to Kindle", "send research to Kindle", "send someday-maybe to Kindle", "Kindle my research", "with links expanded".
allowed-tools: Read, Bash, Glob, Write, AskUserQuestion
---

# Kindle Sender

## What This Does

Converts markdown documents from your Zettelkasten to EPUB and emails them to your Kindle for offline reading.

**Three modes:**
1. **Research mode** - Send all Research Swarm docs linked in today's daily note
2. **Review mode** - Send your Someday-Maybe.md backlog for Kindle review
3. **Deep reading mode** - Send with `--expand-links` to include full content of all linked documents as an appendix

## When to Use

- "Send my research to Kindle"
- "Send today's research to Kindle"
- "Send someday-maybe to Kindle"
- "Send someday-maybe to Kindle with links expanded"
- "Kindle my research"

## Prerequisites (One-Time Setup)

Before first use, configure these environment variables in `~/.zshrc`:

```bash
export KINDLE_EMAIL="your-name@kindle.com"
export GMAIL_USER="your-email@gmail.com"
export GMAIL_APP_PASSWORD="your-app-password"
```

**Setup steps:**

1. **Find your Kindle email:**
   - Go to [Amazon → Manage Content & Devices](https://www.amazon.com/hz/mycd/digital-console/contentlist/pdocs)
   - Click "Preferences" tab
   - Look for "Personal Document Settings"
   - Your Kindle email ends in `@kindle.com`

2. **Whitelist your sender email:**
   - Same page, under "Approved Personal Document E-mail List"
   - Add your Gmail address

3. **Create Gmail app password:**
   - Go to [Google Account → Security](https://myaccount.google.com/security)
   - Enable 2-Step Verification if not already
   - Go to "App passwords" (search for it)
   - Create a new app password for "Mail"
   - Use this password, NOT your regular Gmail password

4. **Install Python dependency:**
   ```bash
   pip3 install pypandoc pypandoc_binary
   ```

5. **Reload shell:**
   ```bash
   source ~/.zshrc
   ```

## Instructions

### Standard Flow (All Modes)

**Step 1: Determine what to send**
- Daily notes: Find files in `/Users/eddale/Documents/COPYobsidian/MAGI/Zettelkasten/YYYY-MM-DD.md`
- Research mode: Extract `[[Research Swarm - *]]` links from Captures section
- Someday-maybe: Use the Someday-Maybe.md file
- Specific files: Use paths provided by user

**Step 2: Run dry-run with --expand-links to see linked documents**
```bash
cd /Users/eddale/Documents/GitHub/powerhouse-lab/skills/kindle-sender/tools
python3 send_to_kindle.py --files "file1.md" "file2.md" --expand-links --dry-run
```

**Step 3: Show preview and ask about link expansion**

Display what will be sent, then use AskUserQuestion with TWO questions:

1. **Link expansion** (unless user already said "with links expanded"):
   - Question: "Include linked documents as appendix?"
   - Options:
     - "Yes, expand links" - Include full content of all [[wikilinks]] as tappable appendix sections
     - "No, just the files" - Send documents without expanding links

2. **Confirm send**:
   - Question: "Send X documents to Kindle?"
   - Options: "Yes, send them" / "No, cancel"

**Step 4: Send based on user choices**
```bash
# With link expansion
python3 send_to_kindle.py --files "file1.md" --expand-links

# Without link expansion
python3 send_to_kindle.py --files "file1.md"
```

**Step 5: Report results**
"Sent X documents to your Kindle. They should arrive within a few minutes."

### Mode-Specific Commands

**Daily note research:**
```bash
python3 send_to_kindle.py --daily-note "YYYY-MM-DD" [--expand-links] [--dry-run]
```

**Someday-maybe:**
```bash
python3 send_to_kindle.py --someday-maybe [--expand-links] [--dry-run]
```

**Specific files:**
```bash
python3 send_to_kindle.py --files "Doc1.md" "Doc2.md" [--expand-links] [--dry-run]
```

## Script Options

| Flag | Description |
|------|-------------|
| `--daily-note YYYY-MM-DD` | Send Research Swarm docs from that day's note |
| `--someday-maybe` | Send the Someday-Maybe.md file |
| `--files FILE1 FILE2...` | Send specific markdown files |
| `--expand-links` | Include content of linked docs (wikilinks) as appendix |
| `--dry-run` | Show what would be sent without sending |

## Troubleshooting

| Problem | Solution |
|---------|----------|
| "KINDLE_EMAIL not set" | Add to ~/.zshrc and run `source ~/.zshrc` |
| "Authentication failed" | Use app password, not regular Gmail password |
| "Document not delivered" | Check sender is whitelisted in Amazon settings |
| "pypandoc not found" | Run `pip3 install pypandoc pypandoc_binary` |

## Examples

**Example 1: Research with link expansion choice**
```
User: Send my research to Kindle
Claude: Found 3 Research Swarm documents in today's Captures:
  1. Research Swarm - Markdown to Kindle Workflow - 2026-01-09.md
  2. Research Swarm - API Design Patterns - 2026-01-09.md
  3. Research Swarm - Newsletter Growth - 2026-01-09.md

  These documents contain 27 linked documents total.

  [AskUserQuestion with two questions:]
  1. Include linked documents as appendix? → Yes/No
  2. Send these 3 documents to Kindle? → Yes/No

User: Yes to both
Claude: Sent 3 documents (with 27 linked docs expanded) to your Kindle.
```

**Example 2: Daily notes batch**
```
User: Send my daily notes from Monday through Friday to Kindle
Claude: Found 5 daily notes (Jan 12-16). Dry run shows 100 linked documents.

  [AskUserQuestion:]
  1. Include linked documents as appendix? → User selects "Yes, expand links"
  2. Send 5 documents to Kindle? → User selects "Yes, send them"

Claude: Sent 5 documents with 100 linked docs as appendices. Arriving shortly.
```

**Example 3: User explicitly requests link expansion**
```
User: Send someday-maybe to Kindle with links expanded
Claude: Will send Someday-Maybe.md with 13 linked documents:
  - PROJECT - Email Agent
  - Research - Claude Code Testing Infrastructure - 2026-01-06
  - ...

  [AskUserQuestion - skip link expansion question since user specified it:]
  Send Someday-Maybe.md to Kindle? → Yes/No

User: Yes
Claude: Sent Someday-Maybe.md (with 13 referenced documents) to your Kindle.
```

**Example 4: User declines link expansion**
```
User: Send today's research to Kindle
Claude: Found 2 Research Swarm documents with 15 linked docs.

  [AskUserQuestion:]
  1. Include linked documents as appendix? → User selects "No, just the files"
  2. Send 2 documents to Kindle? → Yes

Claude: Sent 2 documents to your Kindle. They should arrive within a few minutes.
```
