---
schema: "1.0"
name: knowledge-acquisition-4c
version: "1.0.0"
description: 從未知領域到專業的系統化學習方法論
triggers:
  keywords:
    primary: [學習, 研究, 進入新領域, learning, research, new domain, 知識習得]
    secondary: [入門, 專業, 精通, 從零開始, beginner, expert, mastery]
  context_boost: [unfamiliar, unknown, 不熟悉, 不懂, 新手]
  context_penalty: [implement, code, 實作]
  priority: high
keywords: [methodology, learning, knowledge, acquisition, expertise]
dependencies: []
author: claude-domain-skills
---

# 知識習得 4C 方法論

> 從未知領域到專業的系統化流程

## 適用場景

- 進入完全未知的領域
- 需要快速建立專業知識
- 從零開始學習新技能
- 研究不熟悉的主題

## 核心框架

```
┌─────────────────────────────────────────────────────────────────┐
│                                                                 │
│                    4C Knowledge Acquisition                     │
│                                                                 │
│   COLLECT        CURATE         CONNECT        CREATE          │
│   蒐集           篩選            連結           創造            │
│     │              │               │              │             │
│     ▼              ▼               ▼              ▼             │
│  ┌──────┐      ┌──────┐       ┌──────┐      ┌──────┐          │
│  │多元   │      │驗證   │       │建立   │      │產出   │          │
│  │來源   │  →   │測試   │   →   │體系   │  →   │教學   │          │
│  │廣泛   │      │去蕪   │       │連結   │      │迭代   │          │
│  └──────┘      └──────┘       └──────┘      └──────┘          │
│                                                                 │
│  Dreyfus:  Novice → Adv.Beginner → Competent → Expert          │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

## Phase 1: COLLECT（蒐集）

**目標**：廣泛收集，不預設立場

**Dreyfus 階段**：Novice（新手）

### 資訊來源層級

| 層級 | 來源 | 可信度 | 用途 |
|------|------|--------|------|
| L1 | 官方文檔、學術論文、權威書籍 | ⭐⭐⭐⭐⭐ | 核心概念 |
| L2 | 專家文章、技術部落格、教程 | ⭐⭐⭐⭐ | 實務經驗 |
| L3 | 社群討論、Stack Overflow、論壇 | ⭐⭐⭐ | 常見問題 |
| L4 | 社交媒體、新聞報導 | ⭐⭐ | 趨勢觀察 |

### 蒐集清單

```markdown
□ 領域核心術語（建立詞彙表）
□ 主要概念和原理
□ 關鍵人物/權威來源
□ 常見問題和解決方案
□ 工具和資源
□ 成功案例和失敗案例
```

### 產出

- 原始筆記（不整理，只記錄）
- 來源連結清單
- 待驗證的假設清單

---

## Phase 2: CURATE（篩選）

**目標**：驗證資訊，去蕪存菁

**Dreyfus 階段**：Advanced Beginner（進階新手）

### 驗證三步驟

```
1. 交叉驗證：同一資訊是否有多個獨立來源？
2. 實際測試：理論數據是否符合實際結果？
3. 時效檢查：資訊是否過時？
```

### Sharp Edge: 理論 ≠ 實際

```
┌─────────────────────────────────────────────────────────────────┐
│  ⚠️ SE-1: 理論數據 ≠ 實際效果                                   │
│                                                                 │
│  嚴重度: critical                                               │
│                                                                 │
│  實際案例：                                                     │
│  - 圖表模式研究聲稱 80-84% 成功率                               │
│  - 實際回測：讓策略表現更差                                     │
│  - 原因：股市研究數據不適用於加密貨幣                           │
│                                                                 │
│  教訓：永遠用實際測試驗證研究結論                               │
│                                                                 │
│  解決：                                                         │
│  ❌ 看到研究數據就相信                                          │
│  ✅ 用真實數據回測/實驗驗證                                     │
└─────────────────────────────────────────────────────────────────┘
```

### 篩選標準

| 保留 | 標記待驗證 | 丟棄 |
|------|-----------|------|
| 多來源一致 | 單一來源但可測試 | 無法驗證 |
| 實測有效 | 理論合理但未測試 | 已被反駁 |
| 權威來源 | 社群共識但無證據 | 過時資訊 |

### 產出

- 已驗證知識清單
- 待驗證假設清單
- 已排除的錯誤觀念

---

## Phase 3: CONNECT（連結）

**目標**：建立知識體系，形成心智模型

**Dreyfus 階段**：Competent（勝任者）→ Proficient（精通者）

### 連結方法

| 方法 | 說明 | 範例 |
|------|------|------|
| 概念映射 | 畫出概念之間的關係圖 | 心智圖、知識圖譜 |
| 類比遷移 | 連結到已知領域的相似概念 | 「這就像...」 |
| 層級組織 | 從基礎到進階排列 | 金字塔結構 |
| 因果追蹤 | 理解「為什麼」而不只是「是什麼」 | 5 Whys |

### Feynman 驗證法

```
┌─────────────────────────────────────────────────────────────────┐
│  Feynman Technique                                               │
│                                                                 │
│  1. 選擇概念                                                    │
│  2. 用簡單的話解釋給外行人聽                                    │
│  3. 發現解釋不清楚的地方 → 回去學習                             │
│  4. 簡化再簡化                                                  │
│                                                                 │
│  核心：能簡單解釋 = 真正理解                                    │
│        解釋不清楚 = 還沒理解                                    │
└─────────────────────────────────────────────────────────────────┘
```

### 知識結構模板

```markdown
## [領域名稱] 知識體系

### 核心概念
- 概念 A：[定義]
  - 與 B 的關係：[說明]
  - 實際應用：[案例]

### 關鍵原理
1. 原理一：[說明]
   - 為什麼重要：[原因]
   - 常見誤解：[糾正]

### 決策框架
當 [情境] 時 → 選擇 [方案]
因為 [原因]
```

### 產出

- 結構化知識地圖
- 決策框架/心智模型
- 可教學的簡單解釋

---

## Phase 4: CREATE（創造）

**目標**：產出價值，持續迭代

**Dreyfus 階段**：Expert（專家）

### 創造形式

| 形式 | 說明 | 驗證方式 |
|------|------|---------|
| 教學 | 教別人（最強的學習） | 學生能理解嗎？ |
| 實作 | 實際應用知識 | 結果符合預期嗎？ |
| 文檔 | 寫成 Skill/教程 | 別人能用嗎？ |
| 創新 | 提出新方法/改進 | 比現有方法好嗎？ |

### 迭代循環

```
CREATE → 發現不足 → 回到 COLLECT
   ↑                    ↓
   └──── CURATE ← CONNECT ←┘
```

### 專業度自評

```markdown
□ 能用一句話解釋核心概念嗎？
□ 能預測常見問題和解決方案嗎？
□ 能識別錯誤觀念並糾正嗎？
□ 能將知識應用到新情境嗎？
□ 能教會別人嗎？
```

### 產出

- 可重用的 Skill 文檔
- 實際成果/作品
- 教學材料

---

## 最佳實踐

1. **不要跳過 CURATE** - 驗證是最重要的階段
2. **建立詞彙表** - 術語是進入領域的鑰匙
3. **找到權威來源** - 識別領域內的專家和經典
4. **實際動手** - 看十遍不如做一遍
5. **教給別人** - 教學是最好的學習

## 常見錯誤

| 錯誤 | 後果 | 修正 |
|------|------|------|
| ❌ 只收集不驗證 | 錯誤知識 | 強制 CURATE 階段 |
| ❌ 只驗證不連結 | 碎片知識 | 畫概念圖 |
| ❌ 只學不用 | 紙上談兵 | 強制 CREATE |
| ❌ 跳過驗證 | 理論≠實際 | 實測每個假設 |
| ❌ 資訊過載 | 無法消化 | 限制每日輸入量 |

## 時間分配建議

```
COLLECT: 20% （不要過度收集）
CURATE:  30% （驗證最重要）
CONNECT: 30% （建立體系）
CREATE:  20% （產出驗證）
```

## 與 evolve 整合

此 Skill 會被 `/evolve` 自動識別和載入：

```
User: /evolve 學習區塊鏈開發

Agent:
🔍 Auto Domain Detection
→ 關鍵詞: 學習, 區塊鏈
→ 載入: methodology/knowledge-acquisition-4c
→ 使用 4C 方法論執行學習任務
```

## 參考資源

- [Dreyfus Model of Skill Acquisition](https://en.wikipedia.org/wiki/Dreyfus_model_of_skill_acquisition)
- [The Feynman Technique](https://fs.blog/feynman-technique/)
- [Knowledge Management Guide 2025](https://knowmax.ai/knowledge-management/)
