---
name: Knowledge Assets
description: This skill should be used when the user asks about "knowledge assets", "capturing knowledge", "organizational memory", "experiential knowledge", "conceptual knowledge", "systemic knowledge", "routine knowledge", "preserving insights", "knowledge artifacts", or needs guidance on what types of knowledge artifacts to create and maintain in AI-human collaboration.
version: 0.1.0
---

# Knowledge Assets: Types and Cultivation

Knowledge assets are organizational resources that can be used repeatedly to create value. Understanding knowledge asset types helps determine what artifacts to create and how to maintain them.

## Core Concept

Knowledge assets are the inputs, outputs, and moderators of the knowledge creation process. Unlike physical assets, knowledge assets:

- **Grow with use**: Using knowledge often creates more knowledge
- **Require maintenance**: Knowledge can become outdated
- **Are context-dependent**: Value depends on application context
- **Enable creation**: Assets from one cycle enable the next

## Four Types of Knowledge Assets

Knowledge assets map to the SECI phases that create them:

| Asset Type | Created By | Nature | Example |
|------------|------------|--------|---------|
| **Experiential** | Socialization | Tacit, shared | Team intuitions, culture |
| **Conceptual** | Externalization | Explicit, articulated | Designs, specifications |
| **Systemic** | Combination | Explicit, systematized | Databases, documentation |
| **Routine** | Internalization | Tacit, embedded | Skills, operational know-how |

### Experiential Knowledge Assets

**What they are:** Shared tacit knowledge built through common experiences.

**Characteristics:**
- Difficult to capture explicitly
- Built over time through interaction
- Lost when people leave (unless transferred)
- Foundation for other asset types

**Examples:**
- Team culture and norms
- Shared mental models
- Trust and relationships
- Intuitions about the product/domain
- "How we do things here"

**How to cultivate:**
1. Create opportunities for shared experience
2. Maintain team stability when possible
3. Enable storytelling and narrative sharing
4. Build mentorship relationships
5. Document the undocumentable through stories

**AI-Human cultivation:**
- Accumulate context across conversations
- Build shared understanding through iteration
- Reference prior interactions and learnings
- Preserve project context in memory

### Conceptual Knowledge Assets

**What they are:** Explicit knowledge articulated from tacit understanding.

**Characteristics:**
- Captured in language, diagrams, models
- Can be shared and debated
- May need tacit context to fully understand
- Foundation for systematization

**Examples:**
- Product specifications
- Architecture documents
- Design rationale
- Brand guidelines
- Process descriptions

**How to cultivate:**
1. Create structured articulation sessions
2. Use metaphors and analogies
3. Iterate on documentation
4. Include rationale, not just decisions
5. Link to experiential context

**AI-Human cultivation:**
- Use AI to structure informal thoughts
- Generate multiple framings of concepts
- Preserve reasoning behind decisions
- Create visual representations

### Systemic Knowledge Assets

**What they are:** Systematized explicit knowledge combined and organized for reuse.

**Characteristics:**
- Organized in databases, repositories
- Searchable and accessible
- Technology-dependent
- Require maintenance

**Examples:**
- Knowledge bases and wikis
- API documentation
- Code repositories
- Template libraries
- Runbooks and playbooks

**How to cultivate:**
1. Establish clear taxonomies
2. Create consistent templates
3. Enable search and discovery
4. Assign ownership and maintenance
5. Regular review and pruning

**AI-Human cultivation:**
- AI-powered synthesis and summary
- Automated cross-referencing
- Pattern detection across documents
- Gap identification in coverage

### Routine Knowledge Assets

**What they are:** Tacit know-how embedded in individuals and processes.

**Characteristics:**
- Embodied in practice
- Difficult to transfer
- Enables efficient execution
- Built through repetition

**Examples:**
- Operational expertise
- Debugging skills
- Customer interaction abilities
- Pattern recognition capabilities
- "Muscle memory" for tasks

**How to cultivate:**
1. Create practice opportunities
2. Provide graduated challenges
3. Enable learning from mistakes
4. Support reflection on practice
5. Connect learning to real application

**AI-Human cultivation:**
- AI-generated practice exercises
- Feedback on practice attempts
- Progressive difficulty adjustment
- Pattern recognition assistance

## Asset Lifecycle

### Creation

Each asset type is created through its corresponding SECI phase:

```
Experiential ← Socialization (shared experiences)
Conceptual   ← Externalization (articulation)
Systemic     ← Combination (organization)
Routine      ← Internalization (practice)
```

### Maintenance

Assets require different maintenance approaches:

| Asset Type | Maintenance Need | Approach |
|------------|------------------|----------|
| Experiential | Keep team connected | Regular interaction, culture activities |
| Conceptual | Keep current and accurate | Review cycles, update triggers |
| Systemic | Keep organized and accessible | Curation, pruning, search optimization |
| Routine | Keep skills sharp | Practice, refresher training |

### Deprecation

Knowledge assets become less valuable when:

- **Experiential**: Team members leave, culture shifts
- **Conceptual**: Concepts become outdated, better models emerge
- **Systemic**: Documentation becomes stale, tools change
- **Routine**: Skills become irrelevant, better methods emerge

**Deprecation signals:**
- Low usage rates
- Frequent contradictions with reality
- Questions from newcomers that docs should answer
- Workarounds becoming common

## Asset Portfolio Balance

Organizations need all four types in balance:

**Over-indexed on Experiential:**
- Knowledge is in people's heads
- Vulnerable to turnover
- Hard to scale
- "Tribal knowledge" problem

**Over-indexed on Conceptual:**
- Lots of designs, few implementations
- Analysis paralysis
- Documentation without action

**Over-indexed on Systemic:**
- Beautiful documentation nobody reads
- Information overload
- Maintenance burden

**Over-indexed on Routine:**
- Skilled people, no documentation
- Knowledge walks out the door
- Hard to onboard new people

**Healthy balance:**
```
Experiential → Conceptual → Systemic → Routine
     ↑                                    │
     └────────────────────────────────────┘
```

## Creating Assets in AI Collaboration

### Which Asset for Which Task?

| Task | Primary Asset | AI Role |
|------|---------------|---------|
| New feature exploration | Experiential | Build shared context |
| Specification writing | Conceptual | Structure and articulate |
| Documentation building | Systemic | Synthesize and organize |
| Skill development | Routine | Generate practice, give feedback |

### Asset Creation Patterns

**Pattern 1: Experience → Documentation**
```
1. Collaborative exploration (Experiential)
2. Articulate insights (Conceptual)
3. Integrate into knowledge base (Systemic)
```

**Pattern 2: Documentation → Capability**
```
1. Read existing docs (Systemic)
2. Practice with AI support (Routine)
3. Apply in real context
```

**Pattern 3: Capture Before Loss**
```
1. Identify tacit knowledge at risk
2. Conduct articulation sessions (Experiential → Conceptual)
3. Systematize for longevity (Conceptual → Systemic)
```

## Asset Quality Indicators

### Experiential Assets
- Team members share common vocabulary
- Implicit knowledge is consistent across team
- Stories and examples flow easily
- Trust enables knowledge sharing

### Conceptual Assets
- Concepts are clearly defined
- Rationale accompanies decisions
- Multiple framings available
- Links to experiential context

### Systemic Assets
- Easy to find what you need
- Documentation is current
- Templates are used consistently
- Cross-references are valid

### Routine Assets
- Skills are demonstrated consistently
- Application is efficient
- Adaptations are appropriate
- Teaching can occur

## Additional Resources

### Reference Files

For detailed cultivation strategies:

- **`references/asset-cultivation.md`** - Comprehensive strategies for growing each asset type
