# Kubernetes - Api

**Pages:** 474

---

## Command line tool (kubectl)

**URL:** https://kubernetes.io/docs/reference/kubectl/#resource-types

**Contents:**
- Command line tool (kubectl)
- Syntax
    - Caution:
- In-cluster authentication and namespace overrides
- Operations
- Resource types
- Output options
  - Formatting output
    - Syntax
      - Example

Kubernetes provides a command line tool for communicating with a Kubernetes cluster's control plane, using the Kubernetes API.

This tool is named kubectl.

For configuration, kubectl looks for a file named config in the $HOME/.kube directory. You can specify other kubeconfig files by setting the KUBECONFIG environment variable or by setting the --kubeconfig flag.

This overview covers kubectl syntax, describes the command operations, and provides common examples. For details about each command, including all the supported flags and subcommands, see the kubectl reference documentation.

For installation instructions, see Installing kubectl; for a quick guide, see the cheat sheet. If you're used to using the docker command-line tool, kubectl for Docker Users explains some equivalent commands for Kubernetes.

Use the following syntax to run kubectl commands from your terminal window:

where command, TYPE, NAME, and flags are:

command: Specifies the operation that you want to perform on one or more resources, for example create, get, describe, delete.

TYPE: Specifies the resource type. Resource types are case-insensitive and you can specify the singular, plural, or abbreviated forms. For example, the following commands produce the same output:

NAME: Specifies the name of the resource. Names are case-sensitive. If the name is omitted, details for all resources are displayed, for example kubectl get pods.

When performing an operation on multiple resources, you can specify each resource by type and name or specify one or more files:

To specify resources by type and name:

To group resources if they are all the same type: TYPE1 name1 name2 name<#>.Example: kubectl get pod example-pod1 example-pod2

To specify multiple resource types individually: TYPE1/name1 TYPE1/name2 TYPE2/name3 TYPE<#>/name<#>.Example: kubectl get pod/example-pod1 replicationcontroller/example-rc1

To specify resources with one or more files: -f file1 -f file2 -f file<#>

flags: Specifies optional flags. For example, you can use the -s or --server flags to specify the address and port of the Kubernetes API server.

If you need help, run kubectl help from the terminal window.

By default kubectl will first determine if it is running within a pod, and thus in a cluster. It starts by checking for the KUBERNETES_SERVICE_HOST and KUBERNETES_SERVICE_PORT environment variables and the existence of a service account token file at /var/run/secrets/kubernetes.io/serviceaccount/token. If all three 

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kubectl [command] [TYPE] [NAME] [flags]
```

Example 2 (shell):
```shell
kubectl get pod pod1
kubectl get pods pod1
kubectl get po pod1
```

Example 3 (shell):
```shell
kubectl config set-context --current --namespace=<namespace-name>
```

Example 4 (shell):
```shell
kubectl [command] [TYPE] [NAME] -o <output_format>
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-manifest

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-pod-template

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-kube-proxy

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Install Drivers and Allocate Devices with DRA

**URL:** https://kubernetes.io/docs/tutorials/cluster-management/install-use-dra/

**Contents:**
- Install Drivers and Allocate Devices with DRA
  - Objectives
- Before you begin
- Explore the initial cluster state
- Install an example DRA driver
  - Prepare your cluster for driver installation
  - Deploy the DRA driver components
  - Verify the DRA driver installation
- Claim resources and deploy a Pod
  - Create the ResourceClaim

This tutorial shows you how to install Dynamic Resource Allocation (DRA) drivers in your cluster and how to use them in conjunction with the DRA APIs to allocate devices to Pods. This page is intended for cluster administrators.

Dynamic Resource Allocation (DRA) lets a cluster manage availability and allocation of hardware resources to satisfy Pod-based claims for hardware requirements and preferences. To support this, a mixture of Kubernetes built-in components (like the Kubernetes scheduler, kubelet, and kube-controller-manager) and third-party drivers from device owners (called DRA drivers) share the responsibility to advertise, allocate, prepare, mount, healthcheck, unprepare, and cleanup resources throughout the Pod lifecycle. These components share information via a series of DRA specific APIs in the resource.k8s.io API group including DeviceClasses, ResourceSlices, ResourceClaims, as well as new fields in the Pod spec itself.

Your cluster should support RBAC. You can try this tutorial with a cluster using a different authorization mechanism, but in that case you will have to adapt the steps around defining roles and permissions.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

This tutorial has been tested with Linux nodes, though it may also work with other types of nodes.

To check the version, enter kubectl version.

If your cluster is not currently running Kubernetes 1.34 then please check the documentation for the version of Kubernetes that you plan to use.

You can spend some time to observe the initial state of a cluster with DRA enabled, especially if you have not used these APIs extensively before. If you set up a new cluster for this tutorial, with no driver installed and no Pod claims yet to satisfy, the output of these commands won't show any resources.

Get a list of DeviceClasses:

The output is similar to this:

Get a list of ResourceSlices:

The output is similar to this:

Get a list of ResourceClaims and ResourceClaimTemplates

The output is similar to this:

At this point, you have confirmed that DRA is enabled and configured properly in the cluster, and that no DRA drivers have advertised any resources to the

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kubectl get deviceclasses
```

Example 2 (unknown):
```unknown
No resources found
```

Example 3 (shell):
```shell
kubectl get resourceslices
```

Example 4 (unknown):
```unknown
No resources found
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-mvp

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Use an HTTP Proxy to Access the Kubernetes API

**URL:** https://kubernetes.io/docs/tasks/extend-kubernetes/http-proxy-access-api/

**Contents:**
- Use an HTTP Proxy to Access the Kubernetes API
- Before you begin
- Using kubectl to start a proxy server
- Exploring the Kubernetes API
- What's next
- Feedback

This page shows how to use an HTTP proxy to access the Kubernetes API.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:iximiuz LabsKillercodaKodeKloudPlay with KubernetesTo check the version, enter kubectl version.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To check the version, enter kubectl version.

If you do not already have an application running in your cluster, start a Hello world application by entering this command:

This command starts a proxy to the Kubernetes API server:

When the proxy server is running, you can explore the API using curl, wget, or a browser.

Get the API versions:

The output should look similar to this:

The output should look similar to this:

Learn more about kubectl proxy.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

**Examples:**

Example 1 (shell):
```shell
kubectl create deployment hello-app --image=gcr.io/google-samples/hello-app:2.0 --port=8080
```

Example 2 (unknown):
```unknown
kubectl proxy --port=8080
```

Example 3 (unknown):
```unknown
curl http://localhost:8080/api/
```

Example 4 (unknown):
```unknown
{
  "kind": "APIVersions",
  "versions": [
    "v1"
  ],
  "serverAddressByClientCIDRs": [
    {
      "clientCIDR": "0.0.0.0/0",
      "serverAddress": "10.0.2.15:8443"
    }
  ]
}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-device-plugin

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-init-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-upstream

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-scheduler

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/kube-scheduler/

**Contents:**
- kube-scheduler
- Synopsis
- Options
- Feedback

The Kubernetes scheduler is a control plane process which assigns Pods to Nodes. The scheduler determines which Nodes are valid placements for each Pod in the scheduling queue according to constraints and available resources. The scheduler then ranks each valid Node and binds the Pod to a suitable Node. Multiple different schedulers may be used within a cluster; kube-scheduler is the reference implementation. See scheduling for more information about scheduling and the kube-scheduler component.

The map from metric-label to value allow-list of this label. The key's format is <MetricName>,<LabelName>. The value's format is <allowed_value>,<allowed_value>...e.g. metric1,label1='v1,v2,v3', metric1,label2='v1,v2,v3' metric2,label1='v1,v2,v3'.

The path to the manifest file that contains the allow-list mapping. The format of the file is the same as the flag --allow-metric-labels. Note that the flag --allow-metric-labels will override the manifest file.

kubeconfig file pointing at the 'core' kubernetes server with enough rights to create tokenreviews.authentication.k8s.io. This is optional. If empty, all token requests are considered to be anonymous and no client CA is looked up in the cluster.

If false, the authentication-kubeconfig will be used to lookup missing authentication configuration from the cluster.

The duration to cache responses from the webhook token authenticator.

If true, failures to look up missing authentication configuration from the cluster are not considered fatal. Note that this can result in authentication that treats all requests as anonymous.

A list of HTTP paths to skip during authorization, i.e. these are authorized without contacting the 'core' kubernetes server.

kubeconfig file pointing at the 'core' kubernetes server with enough rights to create subjectaccessreviews.authorization.k8s.io. This is optional. If empty, all requests not skipped by authorization are forbidden.

The duration to cache 'authorized' responses from the webhook authorizer.

The duration to cache 'unauthorized' responses from the webhook authorizer.

The IP address on which to listen for the --secure-port port. The associated interface(s) must be reachable by the rest of the cluster, and by CLI/web clients. If blank or an unspecified address (0.0.0.0 or ::), all interfaces and IP address families will be used.

The directory where the TLS certs are located. If --tls-cert-file and --tls-private-key-file are provided, this flag will be ignored.

If set, any 

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
kube-scheduler [flags]
```

---

## kube-controller-manager Configuration (v1alpha1)

**URL:** https://kubernetes.io/docs/reference/config-api/kube-controller-manager-config.v1alpha1/

**Contents:**
- kube-controller-manager Configuration (v1alpha1)
- Resource Types
- ClientConnectionConfiguration
- DebuggingConfiguration
- LeaderElectionConfiguration
- NodeControllerConfiguration
- ServiceControllerConfiguration
- CloudControllerManagerConfiguration
- CloudProviderConfiguration
- KubeCloudSharedConfiguration

KubeSchedulerConfiguration

GenericControllerManagerConfiguration

ClientConnectionConfiguration contains details for constructing a client.

kubeconfig is the path to a KubeConfig file.

acceptContentTypes defines the Accept header sent by clients when connecting to a server, overriding the default value of 'application/json'. This field will control all connections to the server used by a particular client.

contentType is the content type used when sending data to the server from this client.

qps controls the number of queries per second allowed for this connection.

burst allows extra queries to accumulate when a client is exceeding its rate.

KubeSchedulerConfiguration

GenericControllerManagerConfiguration

DebuggingConfiguration holds configuration for Debugging related features.

enableProfiling enables profiling via web interface host:port/debug/pprof/

enableContentionProfiling enables block profiling, if enableProfiling is true.

KubeSchedulerConfiguration

GenericControllerManagerConfiguration

LeaderElectionConfiguration defines the configuration of leader election clients for components that can run with leader election enabled.

leaderElect enables a leader election client to gain leadership before executing the main loop. Enable this when running replicated components for high availability.

leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.

renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.

retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.

resourceLock indicates the resource object type that will be used to lock during leader election cycles.

resourceName indicates the name of resource object that will be used to lock during leader election cycles.

resourceName indicates the namespace of resource object that will be used to lock during leader election cycles.

NodeControllerConfiguration contains elements describing NodeController.

ConcurrentNodeSyncs

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-jwt

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kubelet

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-etcd

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Dynamic Admission Control

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/extensible-admission-controllers/

**Contents:**
- Dynamic Admission Control
- What are admission webhooks?
    - Note:
- Experimenting with admission webhooks
  - Prerequisites
  - Write an admission webhook server
  - Deploy the admission webhook service
  - Configure admission webhooks on the fly
    - Note:
    - Note:

In addition to compiled-in admission plugins, admission plugins can be developed as extensions and run as webhooks configured at runtime. This page describes how to build, configure, use, and monitor admission webhooks.

Admission webhooks are HTTP callbacks that receive admission requests and do something with them. You can define two types of admission webhooks, validating admission webhook and mutating admission webhook. Mutating admission webhooks are invoked first, and can modify objects sent to the API server to enforce custom defaults. After all object modifications are complete, and after the incoming object is validated by the API server, validating admission webhooks are invoked and can reject requests to enforce custom policies.

Admission webhooks are essentially part of the cluster control-plane. You should write and deploy them with great caution. Please read the user guides for instructions if you intend to write/deploy production-grade admission webhooks. In the following, we describe how to quickly experiment with admission webhooks.

Ensure that MutatingAdmissionWebhook and ValidatingAdmissionWebhook admission controllers are enabled. Here is a recommended set of admission controllers to enable in general.

Ensure that the admissionregistration.k8s.io/v1 API is enabled.

Please refer to the implementation of the admission webhook server that is validated in a Kubernetes e2e test. The webhook handles the AdmissionReview request sent by the API servers, and sends back its decision as an AdmissionReview object in the same version it received.

See the webhook request section for details on the data sent to webhooks.

See the webhook response section for the data expected from webhooks.

The example admission webhook server leaves the ClientAuth field empty, which defaults to NoClientCert. This means that the webhook server does not authenticate the identity of the clients, supposedly API servers. If you need mutual TLS or other ways to authenticate the clients, see how to authenticate API servers.

The webhook server in the e2e test is deployed in the Kubernetes cluster, via the deployment API. The test also creates a service as the front-end of the webhook server. See code.

You may also deploy your webhooks outside of the cluster. You will need to update your webhook configurations accordingly.

You can dynamically configure what resources are subject to what admission webhooks via ValidatingWebhookConfiguration or MutatingWebhookConfigura

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: admissionregistration.k8s.io/v1
kind: ValidatingWebhookConfiguration
metadata:
  name: "pod-policy.example.com"
webhooks:
- name: "pod-policy.example.com"
  rules:
  - apiGroups:   [""]
    apiVersions: ["v1"]
    operations:  ["CREATE"]
    resources:   ["pods"]
    scope:       "Namespaced"
  clientConfig:
    service:
      namespace: "example-namespace"
      name: "example-service"
    caBundle: <CA_BUNDLE>
  admissionReviewVersions: ["v1"]
  sideEffects: None
  timeoutSeconds: 5
```

Example 2 (yaml):
```yaml
apiVersion: apiserver.config.k8s.io/v1
kind: AdmissionConfiguration
plugins:
- name: ValidatingAdmissionWebhook
  configuration:
    apiVersion: apiserver.config.k8s.io/v1
    kind: WebhookAdmissionConfiguration
    kubeConfigFile: "<path-to-kubeconfig-file>"
- name: MutatingAdmissionWebhook
  configuration:
    apiVersion: apiserver.config.k8s.io/v1
    kind: WebhookAdmissionConfiguration
    kubeConfigFile: "<path-to-kubeconfig-file>"
```

Example 3 (yaml):
```yaml
# Deprecated in v1.17 in favor of apiserver.config.k8s.io/v1
apiVersion: apiserver.k8s.io/v1alpha1
kind: AdmissionConfiguration
plugins:
- name: ValidatingAdmissionWebhook
  configuration:
    # Deprecated in v1.17 in favor of apiserver.config.k8s.io/v1, kind=WebhookAdmissionConfiguration
    apiVersion: apiserver.config.k8s.io/v1alpha1
    kind: WebhookAdmission
    kubeConfigFile: "<path-to-kubeconfig-file>"
- name: MutatingAdmissionWebhook
  configuration:
    # Deprecated in v1.17 in favor of apiserver.config.k8s.io/v1, kind=WebhookAdmissionConfiguration
    apiVersion: apiserver.config.k8
...
```

Example 4 (yaml):
```yaml
apiVersion: v1
kind: Config
users:
# name should be set to the DNS name of the service or the host (including port) of the URL the webhook is configured to speak to.
# If a non-443 port is used for services, it must be included in the name when configuring 1.16+ API servers.
#
# For a webhook configured to speak to a service on the default port (443), specify the DNS name of the service:
# - name: webhook1.ns1.svc
#   user: ...
#
# For a webhook configured to speak to a service on non-default port (e.g. 8443), specify the DNS name and port of the service in 1.16+:
# - name: webhook1.ns1.svc:84
...
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-taint

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Component tools

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/

**Contents:**
- Component tools
      - Feature Gates
      - Feature Gates (removed)
      - kube-apiserver
      - kube-controller-manager
      - kube-proxy
      - kube-scheduler
      - kubelet
- Feedback

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-managed-service

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-qos-class

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-sidecar-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-approver

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-volumeplugin

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-container-lifecycle-hooks

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-gvr

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-endpoints

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Workload Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/

**Contents:**
- Workload Resources
      - Pod
      - Binding
      - PodTemplate
      - ReplicationController
      - ReplicaSet
      - Deployment
      - StatefulSet
      - ControllerRevision
      - DaemonSet

Pod is a collection of containers that can run on a host.

Binding ties one object to another; for example, a pod is bound to a node by a scheduler.

PodTemplate describes a template for creating copies of a predefined pod.

ReplicationController represents the configuration of a replication controller.

ReplicaSet ensures that a specified number of pod replicas are running at any given time.

Deployment enables declarative updates for Pods and ReplicaSets.

StatefulSet represents a set of pods with consistent identities.

ControllerRevision implements an immutable snapshot of state data.

DaemonSet represents the configuration of a daemon set.

Job represents the configuration of a single job.

CronJob represents the configuration of a single cron job.

configuration of a horizontal pod autoscaler.

HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

PriorityClass defines mapping from a priority class name to the priority integer value.

DeviceTaintRule adds one taint to all devices which match the selector.

ResourceClaim describes a request for access to resources in the cluster, for use by workloads.

ResourceClaimTemplate is used to produce ResourceClaim objects.

ResourceSlice represents one or more resources in a pool of similar resources, managed by a common driver.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-preemption

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-disruption

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-ephemeral-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-helm-chart

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-endpoints

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-statefulset

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-uid

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cluster

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-network-policy

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-toleration

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-finalizer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-admission-controller

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kubernetes-api

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-sig

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Feature Gates

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/

**Contents:**
- Feature Gates
- Overview
    - Note:
  - Feature gates for Alpha or Beta features
  - Feature gates for graduated or deprecated features
- Using a feature
  - Feature stages
    - Note:
- List of feature gates
- What's next

This page contains an overview of the various feature gates an administrator can specify on different Kubernetes components.

See feature stages for an explanation of the stages for a feature.

Feature gates are a set of key=value pairs that describe Kubernetes features. You can turn these features on or off using the --feature-gates command line flag on each Kubernetes component.

Each Kubernetes component lets you enable or disable a set of feature gates that are relevant to that component. Use -h flag to see a full set of feature gates for all components. To set feature gates for a component, such as kubelet, use the --feature-gates flag assigned to a list of feature pairs:

The following tables are a summary of the feature gates that you can set on different Kubernetes components.

A feature can be in Alpha, Beta or GA stage. An Alpha feature means:

A Beta feature means:

A General Availability (GA) feature is also referred to as a stable feature. It means:

Each feature gate is designed for enabling/disabling a specific feature.

Allow kubelet to request a certificate without any Node IP available, only with DNS names.

Disable node admission validation of CertificateSigningRequests for kubelet signers. Unless you disable this feature gate, Kubernetes enforces that new kubelet certificates have a commonName matching system:node:$nodeName.

When this feature is enabled, the subject name attribute 1.3.6.1.4.1.57683.2 in an X.509 certificate will be parsed as the user UID during certificate authentication.

Enables .status.ingress.loadBalancer to be set on Services of types other than LoadBalancer.

Enables the cluster operator to identify corrupt resource(s) using the list operation, and introduces an option ignoreStoreReadErrorWithClusterBreakingPotential that the operator can set to perform unsafe and force delete operation of such corrupt resource(s) using the Kubernetes API.

Enable configurable endpoints for anonymous auth for the API server.

Enable use of any custom resource as the DataSource of a PVC.

Compress the API responses for LIST or GET requests.

Assign each API server an ID in a cluster, using a Lease.

Add support for distributed tracing in the API server. See Traces for Kubernetes System Components for more details.

This feature gate enables an API server performance improvement: the API server can use separate goroutines (lightweight threads managed by the Go runtime) to serve watch requests.

Make the Node authorizer use fine-gra

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
--feature-gates=...,GracefulNodeShutdown=true
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-wg

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-priority-class

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kops

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Kubernetes z-pages

**URL:** https://kubernetes.io/docs/reference/instrumentation/zpages/

**Contents:**
- Kubernetes z-pages
- z-pages
  - statusz
  - flagz
- Feedback

Kubernetes core components can expose a suite of z-endpoints to make it easier for users to debug their cluster and its components. These endpoints are strictly to be used for human inspection to gain real time debugging information of a component binary. Avoid automated scraping of data returned by these endpoints; in Kubernetes 1.34 these are an alpha feature and the response format may change in future releases.

Kubernetes v1.34 allows you to enable z-pages to help you troubleshoot problems with its core control plane components. These special debugging endpoints provide internal information about running components. For Kubernetes 1.34, components serve the following endpoints (when enabled):

Enabled using the ComponentStatusz feature gate, the /statusz endpoint displays high level information about the component such as its Kubernetes version, emulation version, start time and more.

The /statusz response from the API server is similar to:

Enabled using the ComponentFlagz feature gate, the /flagz endpoint shows you the command line arguments that were used to start a component.

The /flagz data for the API server looks something like:

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

**Examples:**

Example 1 (unknown):
```unknown
kube-apiserver statusz
Warning: This endpoint is not meant to be machine parseable, has no formatting compatibility guarantees and is for debugging purposes only.

Started: Wed Oct 16 21:03:43 UTC 2024
Up: 0 hr 00 min 16 sec
Go version: go1.23.2
Binary version: 1.32.0-alpha.0.1484&#43;5eeac4f21a491b-dirty
Emulation version: 1.32.0-alpha.0.1484
```

Example 2 (unknown):
```unknown
kube-apiserver flags
Warning: This endpoint is not meant to be machine parseable, has no formatting compatibility guarantees and is for debugging purposes only.

advertise-address=192.168.8.2
contention-profiling=false
enable-priority-and-fairness=true
profiling=true
authorization-mode=[Node,RBAC]
authorization-webhook-cache-authorized-ttl=5m0s
authorization-webhook-cache-unauthorized-ttl=30s
authorization-webhook-version=v1beta1
default-watch-cache-size=100
```

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetes-io-os

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## TLS bootstrapping

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/kubelet-tls-bootstrapping/

**Contents:**
- TLS bootstrapping
- Initialization process
  - Bootstrap initialization
- Configuration
- Certificate Authority
- kube-apiserver configuration
  - Recognizing client certificates
  - Initial bootstrap authentication
    - Bootstrap tokens
    - Token authentication file

In a Kubernetes cluster, the components on the worker nodes - kubelet and kube-proxy - need to communicate with Kubernetes control plane components, specifically kube-apiserver. In order to ensure that communication is kept private, not interfered with, and ensure that each component of the cluster is talking to another trusted component, we strongly recommend using client TLS certificates on nodes.

The normal process of bootstrapping these components, especially worker nodes that need certificates so they can communicate safely with kube-apiserver, can be a challenging process as it is often outside of the scope of Kubernetes and requires significant additional work. This in turn, can make it challenging to initialize or scale a cluster.

In order to simplify the process, beginning in version 1.4, Kubernetes introduced a certificate request and signing API. The proposal can be found here.

This document describes the process of node initialization, how to set up TLS client certificate bootstrapping for kubelets, and how it works.

When a worker node starts up, the kubelet does the following:

Assuming that the kube-apiserver successfully validates the kubelet's credentials, it will treat the kubelet as a valid node, and begin to assign pods to it.

Note that the above process depends upon:

All of the following are responsibilities of whoever sets up and manages the cluster:

The TLS Bootstrapping described in this document is intended to simplify, and partially or even completely automate, steps 3 onwards, as these are the most common when initializing or scaling a cluster.

In the bootstrap initialization process, the following occurs:

The rest of this document describes the necessary steps to configure TLS Bootstrapping, and its limitations.

To configure for TLS bootstrapping and optional automatic approval, you must configure options on the following components:

In addition, you need your Kubernetes Certificate Authority (CA).

As without bootstrapping, you will need a Certificate Authority (CA) key and certificate. As without bootstrapping, these will be used to sign the kubelet certificate. As before, it is your responsibility to distribute them to control plane nodes.

For the purposes of this document, we will assume these have been distributed to control plane nodes at /var/lib/kubernetes/ca.pem (certificate) and /var/lib/kubernetes/ca-key.pem (key). We will refer to these as "Kubernetes CA certificate and key".

All Kubernetes components tha

*[Content truncated]*

**Examples:**

Example 1 (console):
```console
--enable-bootstrap-token-auth=true
```

Example 2 (shell):
```shell
head -c 16 /dev/urandom | od -An -t x | tr -d ' '
```

Example 3 (console):
```console
02b50b05283e98dd0fd71db496ef01e8,kubelet-bootstrap,10001,"system:bootstrappers"
```

Example 4 (yaml):
```yaml
# enable bootstrapping nodes to create CSR
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: create-csrs-for-bootstrapping
subjects:
- kind: Group
  name: system:bootstrappers
  apiGroup: rbac.authorization.k8s.io
roleRef:
  kind: ClusterRole
  name: system:node-bootstrapper
  apiGroup: rbac.authorization.k8s.io
```

---

## Extend the Kubernetes API with CustomResourceDefinitions

**URL:** https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/

**Contents:**
- Extend the Kubernetes API with CustomResourceDefinitions
- Before you begin
- Create a CustomResourceDefinition
- Create custom objects
- Delete a CustomResourceDefinition
- Specifying a structural schema
  - Field pruning
    - Controlling pruning
  - IntOrString
  - RawExtension

This page shows how to install a custom resource into the Kubernetes API by creating a CustomResourceDefinition.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:iximiuz LabsKillercodaKodeKloudPlay with KubernetesYour Kubernetes server must be at or later than version 1.16.To check the version, enter kubectl version.If you are using an older version of Kubernetes that is still supported, switch to the documentation for that version to see advice that is relevant for your cluster.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To check the version, enter kubectl version.

When you create a new CustomResourceDefinition (CRD), the Kubernetes API Server creates a new RESTful resource path for each version you specify. The custom resource created from a CRD object can be either namespaced or cluster-scoped, as specified in the CRD's spec.scope field. As with existing built-in objects, deleting a namespace deletes all custom objects in that namespace. CustomResourceDefinitions themselves are non-namespaced and are available to all namespaces.

For example, if you save the following CustomResourceDefinition to resourcedefinition.yaml:

Then a new namespaced RESTful API endpoint is created at:

This endpoint URL can then be used to create and manage custom objects. The kind of these objects will be CronTab from the spec of the CustomResourceDefinition object you created above.

It might take a few seconds for the endpoint to be created. You can watch the Established condition of your CustomResourceDefinition to be true or watch the discovery information of the API server for your resource to show up.

After the CustomResourceDefinition object has been created, you can create custom objects. Custom objects can contain custom fields. These fields can contain arbitrary JSON. In the following example, the cronSpec and image cust

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: apiextensions.k8s.io/v1
kind: CustomResourceDefinition
metadata:
  # name must match the spec fields below, and be in the form: <plural>.<group>
  name: crontabs.stable.example.com
spec:
  # group name to use for REST API: /apis/<group>/<version>
  group: stable.example.com
  # list of versions supported by this CustomResourceDefinition
  versions:
    - name: v1
      # Each version can be enabled/disabled by Served flag.
      served: true
      # One and only one version must be marked as the storage version.
      storage: true
      schema:
        openAPIV3Schema:
          t
...
```

Example 2 (shell):
```shell
kubectl apply -f resourcedefinition.yaml
```

Example 3 (unknown):
```unknown
/apis/stable.example.com/v1/namespaces/*/crontabs/...
```

Example 4 (yaml):
```yaml
apiVersion: "stable.example.com/v1"
kind: CronTab
metadata:
  name: my-new-cron-object
spec:
  cronSpec: "* * * * */5"
  image: my-awesome-cron-image
```

---

## Pod

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#PodSpec

**Contents:**
- Pod
- Pod
- PodSpec
  - Containers
  - Volumes
  - Scheduling
  - Lifecycle
  - Hostname and Name resolution
  - Hosts namespaces
  - Service account

import "k8s.io/api/core/v1"

Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.

metadata (ObjectMeta)

Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

PodSpec is a description of a pod.

containers ([]Container), required

Patch strategy: merge on key name

Map: unique values on key name will be kept during a merge

List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.

initContainers ([]Container)

Patch strategy: merge on key name

Map: unique values on key name will be kept during a merge

List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/

ephemeralContainers ([]EphemeralContainer)

Patch strategy: merge on key name

Map: unique values on key name will be kept during a merge

List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresou

*[Content truncated]*

---

## Configure Quotas for API Objects

**URL:** https://kubernetes.io/docs/tasks/administer-cluster/quota-api-object/

**Contents:**
- Configure Quotas for API Objects
- Before you begin
- Create a namespace
- Create a ResourceQuota
- Create a PersistentVolumeClaim
- Attempt to create a second PersistentVolumeClaim
- Notes
- Clean up
- What's next
  - For cluster administrators

This page shows how to configure quotas for API objects, including PersistentVolumeClaims and Services. A quota restricts the number of objects, of a particular type, that can be created in a namespace. You specify quotas in a ResourceQuota object.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:iximiuz LabsKillercodaKodeKloudPlay with KubernetesTo check the version, enter kubectl version.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To check the version, enter kubectl version.

Create a namespace so that the resources you create in this exercise are isolated from the rest of your cluster.

Here is the configuration file for a ResourceQuota object:

Create the ResourceQuota:

View detailed information about the ResourceQuota:

The output shows that in the quota-object-example namespace, there can be at most one PersistentVolumeClaim, at most two Services of type LoadBalancer, and no Services of type NodePort.

Here is the configuration file for a PersistentVolumeClaim object:

Create the PersistentVolumeClaim:

Verify that the PersistentVolumeClaim was created:

The output shows that the PersistentVolumeClaim exists and has status Pending:

Here is the configuration file for a second PersistentVolumeClaim:

Attempt to create the second PersistentVolumeClaim:

The output shows that the second PersistentVolumeClaim was not created, because it would have exceeded the quota for the namespace.

These are the strings used to identify API resources that can be constrained by quotas:

Delete your namespace:

Configure Default Memory Requests and Limits for a Namespace

Configure Default CPU Requests and Limits for a Namespace

Configure Minimum and Maximum Memory Constraints for a Namespace

Configure Minimum and Maximum CPU Constraints for a Namespace

Configure Memory and CPU Quotas for a Namespace

Configure a Pod Quot

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kubectl create namespace quota-object-example
```

Example 2 (yaml):
```yaml
apiVersion: v1
kind: ResourceQuota
metadata:
  name: object-quota-demo
spec:
  hard:
    persistentvolumeclaims: "1"
    services.loadbalancers: "2"
    services.nodeports: "0"
```

Example 3 (shell):
```shell
kubectl apply -f https://k8s.io/examples/admin/resource/quota-objects.yaml --namespace=quota-object-example
```

Example 4 (shell):
```shell
kubectl get resourcequota object-quota-demo --namespace=quota-object-example --output=yaml
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-userns

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetesiohostname

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-immutable-infrastructure

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-configmap

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Virtual IPs and Service Proxies

**URL:** https://kubernetes.io/docs/reference/networking/virtual-ips/#proxy-mode-nftables

**Contents:**
- Virtual IPs and Service Proxies
    - Virtual IP mechanism for Services, using iptables mode
- Proxy modes
  - iptables proxy mode
    - Example
    - Optimizing iptables mode performance
      - minSyncPeriod
      - Updating legacy minSyncPeriod configuration
      - syncPeriod
  - IPVS proxy mode

Every node in a Kubernetes cluster runs a kube-proxy (unless you have deployed your own alternative component in place of kube-proxy).

The kube-proxy component is responsible for implementing a virtual IP mechanism for Services of type other than ExternalName. Each instance of kube-proxy watches the Kubernetes control plane for the addition and removal of Service and EndpointSlice objects. For each Service, kube-proxy calls appropriate APIs (depending on the kube-proxy mode) to configure the node to capture traffic to the Service's clusterIP and port, and redirect that traffic to one of the Service's endpoints (usually a Pod, but possibly an arbitrary user-provided IP address). A control loop ensures that the rules on each node are reliably synchronized with the Service and EndpointSlice state as indicated by the API server.

A question that pops up every now and then is why Kubernetes relies on proxying to forward inbound traffic to backends. What about other approaches? For example, would it be possible to configure DNS records that have multiple A values (or AAAA for IPv6), and rely on round-robin name resolution?

There are a few reasons for using proxying for Services:

Later in this page you can read about how various kube-proxy implementations work. Overall, you should note that, when running kube-proxy, kernel level rules may be modified (for example, iptables rules might get created), which won't get cleaned up, in some cases until you reboot. Thus, running kube-proxy is something that should only be done by an administrator who understands the consequences of having a low level, privileged network proxying service on a computer. Although the kube-proxy executable supports a cleanup function, this function is not an official feature and thus is only available to use as-is.

Some of the details in this reference refer to an example: the backend Pods for a stateless image-processing workloads, running with three replicas. Those replicas are fungible—frontends do not care which backend they use. While the actual Pods that compose the backend set may change, the frontend clients should not need to be aware of that, nor should they need to keep track of the set of backends themselves.

The kube-proxy starts up in different modes, which are determined by its configuration.

On Linux nodes, the available modes for kube-proxy are:

There is only one mode available for kube-proxy on Windows:

This proxy mode is only available on Linux nodes.

In this mode

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
...
iptables:
  minSyncPeriod: 1s
  syncPeriod: 30s
...
```

Example 2 (shell):
```shell
kubectl get services
```

Example 3 (unknown):
```unknown
NAME         TYPE        CLUSTER-IP        EXTERNAL-IP   PORT(S)   AGE
kubernetes   ClusterIP   2001:db8:1:2::1   <none>        443/TCP   3d1h
```

Example 4 (shell):
```shell
kubectl get ipaddresses
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-data-plane

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Server-Side Apply

**URL:** https://kubernetes.io/docs/reference/using-api/server-side-apply/

**Contents:**
- Server-Side Apply
- Field management
  - Example
    - Note:
    - Caution:
  - Conflicts
  - Field managers
- Serialization
    - Note:
- Operations in scope for field management

Kubernetes supports multiple appliers collaborating to manage the fields of a single object.

Server-Side Apply provides an optional mechanism for your cluster's control plane to track changes to an object's fields. At the level of a specific resource, Server-Side Apply records and tracks information about control over the fields of that object.

Server-Side Apply helps users and controllers manage their resources through declarative configuration. Clients can create and modify objects declaratively by submitting their fully specified intent.

A fully specified intent is a partial object that only includes the fields and values for which the user has an opinion. That intent either creates a new object (using default values for unspecified fields), or is combined, by the API server, with the existing object.

Comparison with Client-Side Apply explains how Server-Side Apply differs from the original, client-side kubectl apply implementation.

The Kubernetes API server tracks managed fields for all newly created objects.

When trying to apply an object, fields that have a different value and are owned by another manager will result in a conflict. This is done in order to signal that the operation might undo another collaborator's changes. Writes to objects with managed fields can be forced, in which case the value of any conflicted field will be overridden, and the ownership will be transferred.

Whenever a field's value does change, ownership moves from its current manager to the manager making the change.

Apply checks if there are any other field managers that also own the field. If the field is not owned by any other field managers, that field is set to its default value (if there is one), or otherwise is deleted from the object. The same rule applies to fields that are lists, associative lists, or maps.

For a user to manage a field, in the Server-Side Apply sense, means that the user relies on and expects the value of the field not to change. The user who last made an assertion about the value of a field will be recorded as the current field manager. This can be done by changing the field manager details explicitly using HTTP POST (create), PUT (update), or non-apply PATCH (patch). You can also declare and record a field manager by including a value for that field in a Server-Side Apply operation.

A Server-Side Apply patch request requires the client to provide its identity as a field manager. When using Server-Side Apply, trying to change a field that

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
---
apiVersion: v1
kind: ConfigMap
metadata:
  name: test-cm
  namespace: default
  labels:
    test-label: test
  managedFields:
  - manager: kubectl
    operation: Apply # note capitalization: "Apply" (or "Update")
    apiVersion: v1
    time: "2010-10-10T0:00:00Z"
    fieldsType: FieldsV1
    fieldsV1:
      f:metadata:
        f:labels:
          f:test-label: {}
      f:data:
        f:key: {}
data:
  key: some value
```

Example 2 (yaml):
```yaml
{
  "apiVersion": "v1",
  "kind": "ConfigMap"
}
```

Example 3 (yaml):
```yaml
---
apiVersion: v1
kind: ConfigMap
metadata:
  name: test-cm
  namespace: default
  labels:
    test-label: test
  managedFields:
  - manager: kubectl
    operation: Apply
    time: '2019-03-30T15:00:00.000Z'
    apiVersion: v1
    fieldsType: FieldsV1
    fieldsV1:
      f:metadata:
        f:labels:
          f:test-label: {}
  - manager: kube-controller-manager
    operation: Update
    apiVersion: v1
    time: '2019-03-30T16:00:00.000Z'
    fieldsType: FieldsV1
    fieldsV1:
      f:data:
        f:key: {}
data:
  key: new value
```

Example 4 (yaml):
```yaml
---
apiVersion: example.com/v1
kind: Foo
metadata:
  name: foo-sample
  managedFields:
  - manager: "manager-one"
    operation: Apply
    apiVersion: example.com/v1
    fieldsType: FieldsV1
    fieldsV1:
      f:spec:
        f:data: {}
spec:
  data:
    key1: val1
    key2: val2
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-sysctl

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Declarative API Validation

**URL:** https://kubernetes.io/docs/reference/using-api/declarative-validation/

**Contents:**
- Declarative API Validation
    - Note:
- Disabling declarative validation
- Considerations for downgrade and rollback
- Declarative validation tag reference
  - Tag catalog
- Tag Reference
  - +k8s:eachKey
  - +k8s:eachVal
  - +k8s:enum

Kubernetes 1.34 includes optional declarative validation for APIs. When enabled, the Kubernetes API server can use this mechanism rather than the legacy approach that relies on hand-written Go code (validation.go files) to ensure that requests against the API are valid. Kubernetes developers, and people extending the Kubernetes API, can define validation rules directly alongside the API type definitions (types.go files). Code authors define pecial comment tags (e.g., +k8s:minimum=0). A code generator (validation-gen) then uses these tags to produce optimized Go code for API validation.

While primarily a feature impacting Kubernetes contributors and potentially developers of extension API servers, cluster administrators should understand its behavior, especially during its rollout phases.

Declarative validation is being rolled out gradually. In Kubernetes 1.34, the APIs that use declarative validation include:

Default Behavior (Kubernetes 1.34):

Administrators can choose to explicitly enable DeclarativeValidationTakeover=true to make the declarative validation authoritative for migrated fields, typically after verifying stability in their environment (e.g., by monitoring the mismatch metric).

As a cluster administrator, you might consider disabling declarative validation whilst it is still beta, under specific circumstances:

To revert to only using hand-written validation (as used before Kubernetes v1.33), disable the DeclarativeValidation feature gate, for example via command-line arguments: (--feature-gates=DeclarativeValidation=false). This also implicitly disables the effect of DeclarativeValidationTakeover.

Disabling the feature acts as a safety mechanism. However, be aware of a potential edge case (considered unlikely due to extensive testing): If a bug in declarative validation (when DeclarativeValidationTakeover=true) incorrectly allowed an invalid object to be persisted, disabling the feature gates might then cause subsequent updates to that specific object to be blocked by the now-authoritative (and correct) hand-written validation. Resolving this might require manual correction of the stored object, potentially via direct etcd modification in rare cases.

For details on managing feature gates, see Feature Gates.

This document provides a comprehensive reference for all available declarative validation tags.

Declares a validation for each key in a map.

In this example, eachKey is used to specify that the +k8s:minimum tag should be applied

*[Content truncated]*

**Examples:**

Example 1 (go):
```go
type MyStruct struct {
    // +k8s:eachKey=+k8s:minimum=1
    MyMap map[int]string `json:"myMap"`
}
```

Example 2 (go):
```go
type MyStruct struct {
    // +k8s:eachVal=+k8s:minimum=1
    MyMap map[string]int `json:"myMap"`
}
```

Example 3 (go):
```go
// +k8s:enum
type MyEnum string

const (
    MyEnumA MyEnum = "A"
    MyEnumB MyEnum = "B"
)
```

Example 4 (go):
```go
type MyStruct struct {
    MyField MyEnum `json:"myField"`
}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-daemonset

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cel

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-wg

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kuberc (v1alpha1)

**URL:** https://kubernetes.io/docs/reference/config-api/kuberc.v1alpha1/

**Contents:**
- kuberc (v1alpha1)
- Resource Types
- Preference
- AliasOverride
- CommandDefaults
- CommandOptionDefault
- Feedback

Preference stores elements of KubeRC configuration file

overrides allows changing default flag values of commands. This is especially useful, when user doesn't want to explicitly set flags each time.

aliases allow defining command aliases for existing kubectl commands, with optional default flag values. If the alias name collides with a built-in command, built-in command always takes precedence. Flag overrides defined in the overrides section do NOT apply to aliases for the same command. kubectl [ALIAS NAME] [USER_FLAGS] [USER_EXPLICIT_ARGS] expands to kubectl [COMMAND] # built-in command alias points to [KUBERC_PREPEND_ARGS] [USER_FLAGS] [KUBERC_FLAGS] # rest of the flags that are not passed by user in [USER_FLAGS] [USER_EXPLICIT_ARGS] [KUBERC_APPEND_ARGS] e.g.

AliasOverride stores the alias definitions.

name is the name of alias that can only include alphabetical characters If the alias name conflicts with the built-in command, built-in command will be used.

command is the single or set of commands to execute, such as "set env" or "create"

prependArgs stores the arguments such as resource names, etc. These arguments are inserted after the alias name.

appendArgs stores the arguments such as resource names, etc. These arguments are appended to the USER_ARGS.

flags is allocated to store the flag definitions of alias. flags only modifies the default value of the flag and if user explicitly passes a value, explicit one is used.

CommandDefaults stores the commands and their associated option's default values.

command refers to a command whose flag's default value is changed.

flags is a list of flags storing different default values.

CommandOptionDefault stores the name and the specified default value of an option.

Flag name (long form, without dashes).

In a string format of a default value. It will be parsed by kubectl to the compatible value of the flag.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Cluster Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/cluster-resources/

**Contents:**
- Cluster Resources
      - APIService
      - ComponentStatus
      - Event
      - IPAddress
      - Lease
      - LeaseCandidate v1beta1
      - Namespace
      - Node
      - RuntimeClass

APIService represents a server for a particular GroupVersion.

ComponentStatus (and ComponentStatusList) holds the cluster validation info.

Event is a report of an event somewhere in the cluster.

IPAddress represents a single IP of a single IP Family.

Lease defines a lease concept.

LeaseCandidate defines a candidate for a Lease object.

Namespace provides a scope for Names.

Node is a worker node in Kubernetes.

RuntimeClass defines a class of container runtime supported in the cluster.

ServiceCIDR defines a range of IP addresses using CIDR format (e.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#node-role-kubernetes-io-control-plane-taint

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-statefulset

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-container-env-variables

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-pod

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-persistent-volume-claim

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kubeadm

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kubectl for Docker Users

**URL:** https://kubernetes.io/docs/reference/kubectl/docker-cli-to-kubectl/

**Contents:**
- kubectl for Docker Users
- docker run
    - Note:
- docker ps
- docker attach
- docker exec
- docker logs
- docker stop and docker rm
    - Note:
- docker login

You can use the Kubernetes command line tool kubectl to interact with the API Server. Using kubectl is straightforward if you are familiar with the Docker command line tool. However, there are a few differences between the Docker commands and the kubectl commands. The following sections show a Docker sub-command and describe the equivalent kubectl command.

To run an nginx Deployment and expose the Deployment, see kubectl create deployment.

By using kubectl, you can create a Deployment to ensure that N pods are running nginx, where N is the number of replicas stated in the spec and defaults to 1. You can also create a service with a selector that matches the pod labels. For more information, see Use a Service to Access an Application in a Cluster.

By default images run in the background, similar to docker run -d .... To run things in the foreground, use kubectl run to create pod:

Unlike docker run ..., if you specify --attach, then you attach stdin, stdout and stderr. You cannot control which streams are attached (docker -a ...). To detach from the container, you can type the escape sequence Ctrl+P followed by Ctrl+Q.

To list what is currently running, see kubectl get.

To attach a process that is already running in a container, see kubectl attach.

To detach from the container, you can type the escape sequence Ctrl+P followed by Ctrl+Q.

To execute a command in a container, see kubectl exec.

To use interactive commands.

For more information, see Get a Shell to a Running Container.

To follow stdout/stderr of a process that is running, see kubectl logs.

There is a slight difference between pods and containers; by default pods do not terminate if their processes exit. Instead the pods restart the process. This is similar to the docker run option --restart=always with one major difference. In docker, the output for each invocation of the process is concatenated, but for Kubernetes, each invocation is separate. To see the output from a previous run in Kubernetes, do this:

For more information, see Logging Architecture.

To stop and delete a running process, see kubectl delete.

There is no direct analog of docker login in kubectl. If you are interested in using Kubernetes with a private registry, see Using a Private Registry.

To get the version of client and server, see kubectl version.

To get miscellaneous information about the environment and configuration, see kubectl cluster-info.

Was this page helpful?

Thanks for the feedback. If you have a s

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
docker run -d --restart=always -e DOMAIN=cluster --name nginx-app -p 80:80 nginx
```

Example 2 (unknown):
```unknown
55c103fa129692154a7652490236fee9be47d70a8dd562281ae7d2f9a339a6db
```

Example 3 (unknown):
```unknown
CONTAINER ID        IMAGE               COMMAND                  CREATED             STATUS              PORTS                NAMES
55c103fa1296        nginx               "nginx -g 'daemon of…"   9 seconds ago       Up 9 seconds        0.0.0.0:80->80/tcp   nginx-app
```

Example 4 (shell):
```shell
# start the pod running nginx
kubectl create deployment --image=nginx nginx-app
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cgroup

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-controller

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#app-kubernetes-io-name

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Using Node Authorization

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/node/

**Contents:**
- Using Node Authorization
- Overview
- Migration considerations
  - Kubelets outside the system:nodes group
  - Kubelets with undifferentiated usernames
- Feedback

Node authorization is a special-purpose authorization mode that specifically authorizes API requests made by kubelets.

The Node authorizer allows a kubelet to perform API operations. This includes:

Kubelets are limited to reading their own Node objects, and only reading pods bound to their node.

Auth-related operations:

In future releases, the node authorizer may add or remove permissions to ensure kubelets have the minimal set of permissions required to operate correctly.

In order to be authorized by the Node authorizer, kubelets must use a credential that identifies them as being in the system:nodes group, with a username of system:node:<nodeName>. This group and user name format match the identity created for each kubelet as part of kubelet TLS bootstrapping.

The value of <nodeName> must match precisely the name of the node as registered by the kubelet. By default, this is the host name as provided by hostname, or overridden via the kubelet option --hostname-override. However, when using the --cloud-provider kubelet option, the specific hostname may be determined by the cloud provider, ignoring the local hostname and the --hostname-override option. For specifics about how the kubelet determines the hostname, see the kubelet options reference.

To enable the Node authorizer, start the API server with the --authorization-config flag set to a file that includes the Node authorizer; for example:

Or, start the API server with the --authorization-mode flag set to a comma-separated list that includes Node; for example:

To limit the API objects kubelets are able to write, enable the NodeRestriction admission plugin by starting the apiserver with --enable-admission-plugins=...,NodeRestriction,...

Kubelets outside the system:nodes group would not be authorized by the Node authorization mode, and would need to continue to be authorized via whatever mechanism currently authorizes them. The node admission plugin would not restrict requests from these kubelets.

In some deployments, kubelets have credentials that place them in the system:nodes group, but do not identify the particular node they are associated with, because they do not have a username in the system:node:... format. These kubelets would not be authorized by the Node authorization mode, and would need to continue to be authorized via whatever mechanism currently authorizes them.

The NodeRestriction admission plugin would ignore requests from these kubelets, since the default node identifier im

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: apiserver.config.k8s.io/v1
kind: AuthorizationConfiguration
authorizers:
  ...
  - type: Node
  ...
```

Example 2 (shell):
```shell
kube-apiserver --authorization-mode=...,Node --other-options --more-options
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-replica-set

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-controller

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cloud-provider

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-object

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-ingress

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Common Definitions

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/

**Contents:**
- Common Definitions
      - DeleteOptions
      - LabelSelector
      - ListMeta
      - LocalObjectReference
      - NodeSelectorRequirement
      - ObjectFieldSelector
      - ObjectMeta
      - ObjectReference
      - Patch

DeleteOptions may be provided when deleting an API object.

A label selector is a label query over a set of resources.

ListMeta describes metadata that synthetic resources must have, including lists and various status objects.

LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.

A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.

ObjectFieldSelector selects an APIVersioned field of an object.

ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.

ObjectReference contains enough information to let you inspect or modify the referred object.

Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.

Quantity is a fixed-point representation of a number.

ResourceFieldSelector represents container resources (cpu, memory) and their output format.

Status is a return value for calls that don't return other objects.

TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-kube-apiserver

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Feature Gates

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/#feature-gates-for-alpha-or-beta-features

**Contents:**
- Feature Gates
- Overview
    - Note:
  - Feature gates for Alpha or Beta features
  - Feature gates for graduated or deprecated features
- Using a feature
  - Feature stages
    - Note:
- List of feature gates
- What's next

This page contains an overview of the various feature gates an administrator can specify on different Kubernetes components.

See feature stages for an explanation of the stages for a feature.

Feature gates are a set of key=value pairs that describe Kubernetes features. You can turn these features on or off using the --feature-gates command line flag on each Kubernetes component.

Each Kubernetes component lets you enable or disable a set of feature gates that are relevant to that component. Use -h flag to see a full set of feature gates for all components. To set feature gates for a component, such as kubelet, use the --feature-gates flag assigned to a list of feature pairs:

The following tables are a summary of the feature gates that you can set on different Kubernetes components.

A feature can be in Alpha, Beta or GA stage. An Alpha feature means:

A Beta feature means:

A General Availability (GA) feature is also referred to as a stable feature. It means:

Each feature gate is designed for enabling/disabling a specific feature.

Allow kubelet to request a certificate without any Node IP available, only with DNS names.

Disable node admission validation of CertificateSigningRequests for kubelet signers. Unless you disable this feature gate, Kubernetes enforces that new kubelet certificates have a commonName matching system:node:$nodeName.

When this feature is enabled, the subject name attribute 1.3.6.1.4.1.57683.2 in an X.509 certificate will be parsed as the user UID during certificate authentication.

Enables .status.ingress.loadBalancer to be set on Services of types other than LoadBalancer.

Enables the cluster operator to identify corrupt resource(s) using the list operation, and introduces an option ignoreStoreReadErrorWithClusterBreakingPotential that the operator can set to perform unsafe and force delete operation of such corrupt resource(s) using the Kubernetes API.

Enable configurable endpoints for anonymous auth for the API server.

Enable use of any custom resource as the DataSource of a PVC.

Compress the API responses for LIST or GET requests.

Assign each API server an ID in a cluster, using a Lease.

Add support for distributed tracing in the API server. See Traces for Kubernetes System Components for more details.

This feature gate enables an API server performance improvement: the API server can use separate goroutines (lightweight threads managed by the Go runtime) to serve watch requests.

Make the Node authorizer use fine-gra

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
--feature-gates=...,GracefulNodeShutdown=true
```

---

## kube-apiserver Configuration (v1beta1)

**URL:** https://kubernetes.io/docs/reference/config-api/apiserver-config.v1beta1/

**Contents:**
- kube-apiserver Configuration (v1beta1)
- Resource Types
- TracingConfiguration
- AuthenticationConfiguration
- AuthorizationConfiguration
- EgressSelectorConfiguration
- TracingConfiguration
- AnonymousAuthCondition
- AnonymousAuthConfig
- AudienceMatchPolicyType

Package v1beta1 is the v1beta1 version of the API.

TracingConfiguration provides versioned configuration for OpenTelemetry tracing clients.

Endpoint of the collector this component will report traces to. The connection is insecure, and does not currently support TLS. Recommended is unset, and endpoint is the otlp grpc default, localhost:4317.

SamplingRatePerMillion is the number of samples to collect per million spans. Recommended is unset. If unset, sampler respects its parent span's sampling rate, but otherwise never samples.

AuthenticationConfiguration provides versioned configuration for authentication.

jwt is a list of authenticator to authenticate Kubernetes users using JWT compliant tokens. The authenticator will attempt to parse a raw ID token, verify it's been signed by the configured issuer. The public key to verify the signature is discovered from the issuer's public endpoint using OIDC discovery. For an incoming token, each JWT authenticator will be attempted in the order in which it is specified in this list. Note however that other authenticators may run before or after the JWT authenticators. The specific position of JWT authenticators in relation to other authenticators is neither defined nor stable across releases. Since each JWT authenticator must have a unique issuer URL, at most one JWT authenticator will attempt to cryptographically validate the token.

The minimum valid JWT payload must contain the following claims: { "iss": "https://issuer.example.com", "aud": ["audience"], "exp": 1234567890, "": "username" }

If present --anonymous-auth must not be set

Authorizers is an ordered list of authorizers to authorize requests against. This is similar to the --authorization-modes kube-apiserver flag Must be at least one.

EgressSelectorConfiguration provides versioned configuration for egress selector clients.

connectionServices contains a list of egress selection client configurations

TracingConfiguration provides versioned configuration for tracing clients.

Embed the component config tracing configuration struct

AnonymousAuthCondition describes the condition under which anonymous auth should be enabled.

Path for which anonymous auth is enabled.

AnonymousAuthConfig provides the configuration for the anonymous authenticator.

If set, anonymous auth is only allowed if the request meets one of the conditions.

AudienceMatchPolicyType is a set of valid values for issuer.audienceMatchPolicy

Type refers to the type of the authorizer

*[Content truncated]*

---

## Command line tool (kubectl)

**URL:** https://kubernetes.io/docs/reference/kubectl/

**Contents:**
- Command line tool (kubectl)
- Syntax
    - Caution:
- In-cluster authentication and namespace overrides
- Operations
- Resource types
- Output options
  - Formatting output
    - Syntax
      - Example

Kubernetes provides a command line tool for communicating with a Kubernetes cluster's control plane, using the Kubernetes API.

This tool is named kubectl.

For configuration, kubectl looks for a file named config in the $HOME/.kube directory. You can specify other kubeconfig files by setting the KUBECONFIG environment variable or by setting the --kubeconfig flag.

This overview covers kubectl syntax, describes the command operations, and provides common examples. For details about each command, including all the supported flags and subcommands, see the kubectl reference documentation.

For installation instructions, see Installing kubectl; for a quick guide, see the cheat sheet. If you're used to using the docker command-line tool, kubectl for Docker Users explains some equivalent commands for Kubernetes.

Use the following syntax to run kubectl commands from your terminal window:

where command, TYPE, NAME, and flags are:

command: Specifies the operation that you want to perform on one or more resources, for example create, get, describe, delete.

TYPE: Specifies the resource type. Resource types are case-insensitive and you can specify the singular, plural, or abbreviated forms. For example, the following commands produce the same output:

NAME: Specifies the name of the resource. Names are case-sensitive. If the name is omitted, details for all resources are displayed, for example kubectl get pods.

When performing an operation on multiple resources, you can specify each resource by type and name or specify one or more files:

To specify resources by type and name:

To group resources if they are all the same type: TYPE1 name1 name2 name<#>.Example: kubectl get pod example-pod1 example-pod2

To specify multiple resource types individually: TYPE1/name1 TYPE1/name2 TYPE2/name3 TYPE<#>/name<#>.Example: kubectl get pod/example-pod1 replicationcontroller/example-rc1

To specify resources with one or more files: -f file1 -f file2 -f file<#>

flags: Specifies optional flags. For example, you can use the -s or --server flags to specify the address and port of the Kubernetes API server.

If you need help, run kubectl help from the terminal window.

By default kubectl will first determine if it is running within a pod, and thus in a cluster. It starts by checking for the KUBERNETES_SERVICE_HOST and KUBERNETES_SERVICE_PORT environment variables and the existence of a service account token file at /var/run/secrets/kubernetes.io/serviceaccount/token. If all three 

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kubectl [command] [TYPE] [NAME] [flags]
```

Example 2 (shell):
```shell
kubectl get pod pod1
kubectl get pods pod1
kubectl get po pod1
```

Example 3 (shell):
```shell
kubectl config set-context --current --namespace=<namespace-name>
```

Example 4 (shell):
```shell
kubectl [command] [TYPE] [NAME] -o <output_format>
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-reviewer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cluster-infrastructure

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Audit Annotations

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/audit-annotations/#missing-san-invalid-cert-kubernetes-io-hostname

**Contents:**
- Audit Annotations
    - Note:
- k8s.io/deprecated
- k8s.io/removed-release
- pod-security.kubernetes.io/exempt
- pod-security.kubernetes.io/enforce-policy
- pod-security.kubernetes.io/audit-violations
- apiserver.latency.k8s.io/etcd
- apiserver.latency.k8s.io/decode-response-object
- apiserver.latency.k8s.io/apf-queue-wait

This page serves as a reference for the audit annotations of the kubernetes.io namespace. These annotations apply to Event object from API group audit.k8s.io.

Example: k8s.io/deprecated: "true"

Value must be "true" or "false". The value "true" indicates that the request used a deprecated API version.

Example: k8s.io/removed-release: "1.22"

Value must be in the format "<MAJOR>.<MINOR>". It is set to target the removal release on requests made to deprecated API versions with a target removal release.

Example: pod-security.kubernetes.io/exempt: namespace

Value must be one of user, namespace, or runtimeClass which correspond to Pod Security Exemption dimensions. This annotation indicates on which dimension was based the exemption from the PodSecurity enforcement.

Example: pod-security.kubernetes.io/enforce-policy: restricted:latest

Value must be privileged:<version>, baseline:<version>, restricted:<version> which correspond to Pod Security Standard levels accompanied by a version which must be latest or a valid Kubernetes version in the format v<MAJOR>.<MINOR>. This annotations informs about the enforcement level that allowed or denied the pod during PodSecurity admission.

See Pod Security Standards for more information.

Example: pod-security.kubernetes.io/audit-violations: would violate PodSecurity "restricted:latest": allowPrivilegeEscalation != false (container "example" must set securityContext.allowPrivilegeEscalation=false), ...

Value details an audit policy violation, it contains the Pod Security Standard level that was transgressed as well as the specific policies on the fields that were violated from the PodSecurity enforcement.

See Pod Security Standards for more information.

Example: apiserver.latency.k8s.io/etcd: "4.730661757s"

This annotation indiactes the measure of latency incurred inside the storage layer, it accounts for the time it takes to send data to the etcd and get the complete response back.

The value of this audit annotation does not include the time incurred in admission, or validation.

Example: apiserver.latency.k8s.io/decode-response-object: "450.6649ns"

This annotation records the time taken to decode the response received from the storage layer (etcd)

Example: apiserver.latency.k8s.io/apf-queue-wait: "100ns"

This annotation records the time that a request spent queued due to API server priorities.

See API Priority and Fairness (APF) for more information about this mechanism.

Example: authorization.k8s.io/decis

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-manifest

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-pod-template

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Policy Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/policy-resources/

**Contents:**
- Policy Resources
      - FlowSchema
      - LimitRange
      - ResourceQuota
      - NetworkPolicy
      - PodDisruptionBudget
      - PriorityLevelConfiguration
      - ValidatingAdmissionPolicy
      - ValidatingAdmissionPolicyBinding
      - MutatingAdmissionPolicy v1beta1

FlowSchema defines the schema of a group of flows.

LimitRange sets resource usage limits for each kind of resource in a Namespace.

ResourceQuota sets aggregate quota restrictions enforced per namespace.

NetworkPolicy describes what network traffic is allowed for a set of Pods.

PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.

PriorityLevelConfiguration represents the configuration of a priority level.

ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.

ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources.

MutatingAdmissionPolicy describes the definition of an admission mutation policy that mutates the object coming into admission chain.

MutatingAdmissionPolicyBinding binds the MutatingAdmissionPolicy with parametrized resources.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Common Expression Language in Kubernetes

**URL:** https://kubernetes.io/docs/reference/using-api/cel/

**Contents:**
- Common Expression Language in Kubernetes
- Language overview
- CEL options, language features, and libraries
- Kubernetes CEL libraries
  - Kubernetes list library
  - Kubernetes regex library
  - Kubernetes URL library
  - Kubernetes IP address library
  - Kubernetes CIDR library
    - cidr

The Common Expression Language (CEL) is used in the Kubernetes API to declare validation rules, policy rules, and other constraints or conditions.

CEL expressions are evaluated directly in the API server, making CEL a convenient alternative to out-of-process mechanisms, such as webhooks, for many extensibility use cases. Your CEL expressions continue to execute so long as the control plane's API server component remains available.

The CEL language has a straightforward syntax that is similar to the expressions in C, C++, Java, JavaScript and Go.

CEL was designed to be embedded into applications. Each CEL "program" is a single expression that evaluates to a single value. CEL expressions are typically short "one-liners" that inline well into the string fields of Kubernetes API resources.

Inputs to a CEL program are "variables". Each Kubernetes API field that contains CEL declares in the API documentation which variables are available to use for that field. For example, in the x-kubernetes-validations[i].rules field of CustomResourceDefinitions, the self and oldSelf variables are available and refer to the previous and current state of the custom resource data to be validated by the CEL expression. Other Kubernetes API fields may declare different variables. See the API documentation of the API fields to learn which variables are available for that field.

Example CEL expressions:

CEL is configured with the following options, libraries and language features, introduced at the specified Kubernetes versions:

CEL functions, features and language settings support Kubernetes control plane rollbacks. For example, CEL Optional Values was introduced at Kubernetes 1.29 and so only API servers at that version or newer will accept write requests to CEL expressions that use CEL Optional Values. However, when a cluster is rolled back to Kubernetes 1.28 CEL expressions using "CEL Optional Values" that are already stored in API resources will continue to evaluate correctly.

In additional to the CEL community libraries, Kubernetes includes CEL libraries that are available everywhere CEL is used in Kubernetes.

The list library includes indexOf and lastIndexOf, which work similar to the strings functions of the same names. These functions either the first or last positional index of the provided element in the list.

The list library also includes min, max and sum. Sum is supported on all number types as well as the duration type. Min and max are supported on all compa

*[Content truncated]*

**Examples:**

Example 1 (cel):
```cel
has(object.namex) ? object.namex == 'special' : request.name == 'special'
```

---

## Config and Storage Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/

**Contents:**
- Config and Storage Resources
      - ConfigMap
      - Secret
      - CSIDriver
      - CSINode
      - CSIStorageCapacity
      - PersistentVolumeClaim
      - PersistentVolume
      - StorageClass
      - StorageVersionMigration v1alpha1

ConfigMap holds configuration data for pods to consume.

Secret holds secret data of a certain type.

CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

CSINode holds information about all CSI drivers installed on a node.

CSIStorageCapacity stores the result of one CSI GetCapacity call.

PersistentVolumeClaim is a user's request for and claim to a persistent volume.

PersistentVolume (PV) is a storage resource provisioned by an administrator.

StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

StorageVersionMigration represents a migration of stored data to the latest storage version.

Volume represents a named volume in a pod that may be accessed by any container in the pod.

VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttributesClass represents a specification of mutable volume attributes defined by the CSI driver.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-probe

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-proxy

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-sysctl

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-master

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-replica

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authenticating

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authentication/#anonymous-authenticator-configuration

**Contents:**
- Authenticating
- Users in Kubernetes
- Authentication strategies
    - Note:
- Authentication methods
  - X.509 client certificates
    - Putting a bearer token in a request
  - Bootstrap tokens
  - Service account tokens
    - Note:

This page provides an overview of authentication in Kubernetes, with a focus on authentication to the Kubernetes API.

All Kubernetes clusters have two categories of users: service accounts managed by Kubernetes, and normal users.

It is assumed that a cluster-independent service manages normal users in the following ways:

In this regard, Kubernetes does not have objects which represent normal user accounts. Normal users cannot be added to a cluster through an API call.

Even though a normal user cannot be added via an API call, any user that presents a valid certificate signed by the cluster's certificate authority (CA) is considered authenticated. In this configuration, Kubernetes determines the username from the common name field in the 'subject' of the cert (e.g., "/CN=bob"). From there, the role based access control (RBAC) sub-system would determine whether the user is authorized to perform a specific operation on a resource.

In contrast, service accounts are users managed by the Kubernetes API. They are bound to specific namespaces, and created automatically by the API server or manually through API calls. Service accounts are tied to a set of credentials stored as Secrets, which are mounted into pods allowing in-cluster processes to talk to the Kubernetes API.

API requests are tied to either a normal user or a service account, or are treated as anonymous requests. This means every process inside or outside the cluster, from a human user typing kubectl on a workstation, to kubelets on nodes, to members of the control plane, must authenticate when making requests to the API server, or be treated as an anonymous user.

Kubernetes uses client certificates, bearer tokens, or an authenticating proxy to authenticate API requests through authentication plugins. As HTTP requests are made to the API server, plugins attempt to associate the following attributes with the request:

You can enable multiple authentication methods at once. You should usually use at least two methods:

When multiple authenticator modules are enabled, the first module to successfully authenticate the request short-circuits evaluation. The API server does not guarantee the order authenticators run in.

The system:authenticated group is included in the list of groups for all authenticated users.

Integrations with other authentication protocols (LDAP, SAML, Kerberos, alternate x509 schemes, etc) are available; for example using an authenticating proxy or the authentication webhook.


*[Content truncated]*

**Examples:**

Example 1 (bash):
```bash
openssl req -new -key jbeda.pem -out jbeda-csr.pem -subj "/CN=jbeda/O=app1/O=app2"
```

Example 2 (http):
```http
Authorization: Bearer 31ada4fd-adec-460c-809a-9e56ceb75269
```

Example 3 (http):
```http
Authorization: Bearer 781292.db7bc3a58fc5f07e
```

Example 4 (yaml):
```yaml
apiVersion: apps/v1 # this apiVersion is relevant as of Kubernetes 1.9
kind: Deployment
metadata:
  name: nginx-deployment
  namespace: default
spec:
  replicas: 3
  template:
    metadata:
    # ...
    spec:
      serviceAccountName: bob-the-bot
      containers:
      - name: nginx
        image: nginx:1.14.2
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-operator-pattern

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-label

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-horizontal-pod-autoscaler

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kubectl

**URL:** https://kubernetes.io/docs/reference/kubectl/generated/kubectl/

**Contents:**
- kubectl
- Synopsis
- Options
- See Also
- Feedback

kubectl controls the Kubernetes cluster manager.

Find more information at: https://kubernetes.io/docs/reference/kubectl/

Username to impersonate for the operation. User could be a regular user or a service account in a namespace.

Group to impersonate for the operation, this flag can be repeated to specify multiple groups.

UID to impersonate for the operation.

Default cache directory

Path to a cert file for the certificate authority

Path to a client certificate file for TLS

Path to a client key file for TLS

The name of the kubeconfig cluster to use

The name of the kubeconfig context to use

If true, opt-out of response compression for all requests to the server

If true, the server's certificate will not be checked for validity. This will make your HTTPS connections insecure

Path to the kubeconfig file to use for CLI requests.

Path to the kuberc file to use for preferences. This can be disabled by exporting KUBECTL_KUBERC=false feature gate or turning off the feature KUBERC=off.

Require server version to match client version

If present, the namespace scope for this CLI request

Password for basic authentication to the API server

Name of profile to capture. One of (none|cpu|heap|goroutine|threadcreate|block|mutex)

Name of the file to write the profile to

The length of time to wait before giving up on a single server request. Non-zero values should contain a corresponding time unit (e.g. 1s, 2m, 3h). A value of zero means don't timeout requests.

The address and port of the Kubernetes API server

Writes in the storage driver will be buffered for this duration, and committed to the non memory backends as a single transaction

use secure connection with database

Server name to use for server certificate validation. If it is not provided, the hostname used to contact the server is used

Bearer token for authentication to the API server

The name of the kubeconfig user to use

Username for basic authentication to the API server

--version, --version=raw prints version information and quits; --version=vX.Y.Z... sets the reported version

Treat warnings received from the server as errors and exit with a non-zero exit code

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Ku

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
kubectl [flags]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-admission-controller

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#labels-annotations-and-taints-used-on-api-objects

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-limitrange

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-static-pod

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-gateway-api

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## EndpointSlice

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/service-resources/endpoint-slice-v1/

**Contents:**
- EndpointSlice
- EndpointSlice
- EndpointSliceList
- Operations
  - get read the specified EndpointSlice
    - HTTP Request
    - Parameters
    - Response
  - list list or watch objects of kind EndpointSlice
    - HTTP Request

apiVersion: discovery.k8s.io/v1

import "k8s.io/api/discovery/v1"

EndpointSlice represents a set of service endpoints. Most EndpointSlices are created by the EndpointSlice controller to represent the Pods selected by Service objects. For a given service there may be multiple EndpointSlice objects which must be joined to produce the full set of endpoints; you can find all of the slices for a given service by listing EndpointSlices in the service's namespace whose kubernetes.io/service-name label contains the service's name.

apiVersion: discovery.k8s.io/v1

metadata (ObjectMeta)

Standard object's metadata.

addressType (string), required

addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name. (Deprecated) The EndpointSlice controller only generates, and kube-proxy only processes, slices of addressType "IPv4" and "IPv6". No semantics are defined for the "FQDN" type.

endpoints ([]Endpoint), required

Atomic: will be replaced during a merge

endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.

Endpoint represents a single logical "backend" implementing a service.

endpoints.addresses ([]string), required

Set: unique values will be kept during a merge

addresses of this endpoint. For EndpointSlices of addressType "IPv4" or "IPv6", the values are IP addresses in canonical form. The syntax and semantics of other addressType values are not defined. This must contain at least one address but no more than 100. EndpointSlices generated by the EndpointSlice controller will always have exactly 1 address. No semantics are defined for additional addresses beyond the first, and kube-proxy does not look at them.

endpoints.conditions (EndpointConditions)

conditions contains information about the current status of the endpoint.

EndpointConditions represents the current condition of an endpoint.

endpoints.conditions.ready (boolean)

ready indicates that this endpoint is ready to receive traffic, according to whatever system is managing the endpoint. A nil value should be interpreted as "true". In general, an endpoint should be marked ready if it is serving and not terminating, though this can be overridden in some cases, such as when t

*[Content truncated]*

---

## Audit Annotations

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/audit-annotations/#authorization-k8s-io-reason

**Contents:**
- Audit Annotations
    - Note:
- k8s.io/deprecated
- k8s.io/removed-release
- pod-security.kubernetes.io/exempt
- pod-security.kubernetes.io/enforce-policy
- pod-security.kubernetes.io/audit-violations
- apiserver.latency.k8s.io/etcd
- apiserver.latency.k8s.io/decode-response-object
- apiserver.latency.k8s.io/apf-queue-wait

This page serves as a reference for the audit annotations of the kubernetes.io namespace. These annotations apply to Event object from API group audit.k8s.io.

Example: k8s.io/deprecated: "true"

Value must be "true" or "false". The value "true" indicates that the request used a deprecated API version.

Example: k8s.io/removed-release: "1.22"

Value must be in the format "<MAJOR>.<MINOR>". It is set to target the removal release on requests made to deprecated API versions with a target removal release.

Example: pod-security.kubernetes.io/exempt: namespace

Value must be one of user, namespace, or runtimeClass which correspond to Pod Security Exemption dimensions. This annotation indicates on which dimension was based the exemption from the PodSecurity enforcement.

Example: pod-security.kubernetes.io/enforce-policy: restricted:latest

Value must be privileged:<version>, baseline:<version>, restricted:<version> which correspond to Pod Security Standard levels accompanied by a version which must be latest or a valid Kubernetes version in the format v<MAJOR>.<MINOR>. This annotations informs about the enforcement level that allowed or denied the pod during PodSecurity admission.

See Pod Security Standards for more information.

Example: pod-security.kubernetes.io/audit-violations: would violate PodSecurity "restricted:latest": allowPrivilegeEscalation != false (container "example" must set securityContext.allowPrivilegeEscalation=false), ...

Value details an audit policy violation, it contains the Pod Security Standard level that was transgressed as well as the specific policies on the fields that were violated from the PodSecurity enforcement.

See Pod Security Standards for more information.

Example: apiserver.latency.k8s.io/etcd: "4.730661757s"

This annotation indiactes the measure of latency incurred inside the storage layer, it accounts for the time it takes to send data to the etcd and get the complete response back.

The value of this audit annotation does not include the time incurred in admission, or validation.

Example: apiserver.latency.k8s.io/decode-response-object: "450.6649ns"

This annotation records the time taken to decode the response received from the storage layer (etcd)

Example: apiserver.latency.k8s.io/apf-queue-wait: "100ns"

This annotation records the time that a request spent queued due to API server priorities.

See API Priority and Fairness (APF) for more information about this mechanism.

Example: authorization.k8s.io/decis

*[Content truncated]*

---

## Kubernetes Deprecation Policy

**URL:** https://kubernetes.io/docs/reference/using-api/deprecation-policy/

**Contents:**
- Kubernetes Deprecation Policy
- Deprecating parts of the API
    - Note:
    - Note:
    - Note:
  - REST resources (aka API objects)
  - Fields of REST resources
  - Enumerated or constant values
  - Component config structures
  - Future work

This document details the deprecation policy for various facets of the system.

Kubernetes is a large system with many components and many contributors. As with any such software, the feature set naturally evolves over time, and sometimes a feature may need to be removed. This could include an API, a flag, or even an entire feature. To avoid breaking existing users, Kubernetes follows a deprecation policy for aspects of the system that are slated to be removed.

Since Kubernetes is an API-driven system, the API has evolved over time to reflect the evolving understanding of the problem space. The Kubernetes API is actually a set of APIs, called "API groups", and each API group is independently versioned. API versions fall into 3 main tracks, each of which has different policies for deprecation:

A given release of Kubernetes can support any number of API groups and any number of versions of each.

The following rules govern the deprecation of elements of the API. This includes:

These rules are enforced between official releases, not between arbitrary commits to master or release branches.

Rule #1: API elements may only be removed by incrementing the version of the API group.

Once an API element has been added to an API group at a particular version, it can not be removed from that version or have its behavior significantly changed, regardless of track.

Rule #2: API objects must be able to round-trip between API versions in a given release without information loss, with the exception of whole REST resources that do not exist in some versions.

For example, an object can be written as v1 and then read back as v2 and converted to v1, and the resulting v1 resource will be identical to the original. The representation in v2 might be different from v1, but the system knows how to convert between them in both directions. Additionally, any new field added in v2 must be able to round-trip to v1 and back, which means v1 might have to add an equivalent field or represent it as an annotation.

Rule #3: An API version in a given track may not be deprecated in favor of a less stable API version.

Rule #4a: API lifetime is determined by the API stability level

This ensures beta API support covers the maximum supported version skew of 2 releases, and that APIs don't stagnate on unstable beta versions, accumulating production usage that will be disrupted when support for the beta API ends.

Rule #4b: The "preferred" API version and the "storage version" for a given gro

*[Content truncated]*

**Examples:**

Example 1 (promql):
```promql
apiserver_requested_deprecated_apis{removed_release="1.22"} * on(group,version,resource,subresource) group_right() apiserver_request_total
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-node

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-replica

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authenticating

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authentication/#self-subject-review

**Contents:**
- Authenticating
- Users in Kubernetes
- Authentication strategies
    - Note:
- Authentication methods
  - X.509 client certificates
    - Putting a bearer token in a request
  - Bootstrap tokens
  - Service account tokens
    - Note:

This page provides an overview of authentication in Kubernetes, with a focus on authentication to the Kubernetes API.

All Kubernetes clusters have two categories of users: service accounts managed by Kubernetes, and normal users.

It is assumed that a cluster-independent service manages normal users in the following ways:

In this regard, Kubernetes does not have objects which represent normal user accounts. Normal users cannot be added to a cluster through an API call.

Even though a normal user cannot be added via an API call, any user that presents a valid certificate signed by the cluster's certificate authority (CA) is considered authenticated. In this configuration, Kubernetes determines the username from the common name field in the 'subject' of the cert (e.g., "/CN=bob"). From there, the role based access control (RBAC) sub-system would determine whether the user is authorized to perform a specific operation on a resource.

In contrast, service accounts are users managed by the Kubernetes API. They are bound to specific namespaces, and created automatically by the API server or manually through API calls. Service accounts are tied to a set of credentials stored as Secrets, which are mounted into pods allowing in-cluster processes to talk to the Kubernetes API.

API requests are tied to either a normal user or a service account, or are treated as anonymous requests. This means every process inside or outside the cluster, from a human user typing kubectl on a workstation, to kubelets on nodes, to members of the control plane, must authenticate when making requests to the API server, or be treated as an anonymous user.

Kubernetes uses client certificates, bearer tokens, or an authenticating proxy to authenticate API requests through authentication plugins. As HTTP requests are made to the API server, plugins attempt to associate the following attributes with the request:

You can enable multiple authentication methods at once. You should usually use at least two methods:

When multiple authenticator modules are enabled, the first module to successfully authenticate the request short-circuits evaluation. The API server does not guarantee the order authenticators run in.

The system:authenticated group is included in the list of groups for all authenticated users.

Integrations with other authentication protocols (LDAP, SAML, Kerberos, alternate x509 schemes, etc) are available; for example using an authenticating proxy or the authentication webhook.


*[Content truncated]*

**Examples:**

Example 1 (bash):
```bash
openssl req -new -key jbeda.pem -out jbeda-csr.pem -subj "/CN=jbeda/O=app1/O=app2"
```

Example 2 (http):
```http
Authorization: Bearer 31ada4fd-adec-460c-809a-9e56ceb75269
```

Example 3 (http):
```http
Authorization: Bearer 781292.db7bc3a58fc5f07e
```

Example 4 (yaml):
```yaml
apiVersion: apps/v1 # this apiVersion is relevant as of Kubernetes 1.9
kind: Deployment
metadata:
  name: nginx-deployment
  namespace: default
spec:
  replicas: 3
  template:
    metadata:
    # ...
    spec:
      serviceAccountName: bob-the-bot
      containers:
      - name: nginx
        image: nginx:1.14.2
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-quantity

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## GETTING STARTED

**URL:** https://kubernetes.io/docs/reference/generated/kubectl/kubectl-commands

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-secret

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-application-architect

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-developer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cluster-architect

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-namespace

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-name

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-minikube

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-configmap

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cloud-provider

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## GETTING STARTED

**URL:** https://kubernetes.io/docs/reference/generated/kubectl/kubectl-commands#config

---

## Feature Gates

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/#feature-gates-for-graduated-or-deprecated-features

**Contents:**
- Feature Gates
- Overview
    - Note:
  - Feature gates for Alpha or Beta features
  - Feature gates for graduated or deprecated features
- Using a feature
  - Feature stages
    - Note:
- List of feature gates
- What's next

This page contains an overview of the various feature gates an administrator can specify on different Kubernetes components.

See feature stages for an explanation of the stages for a feature.

Feature gates are a set of key=value pairs that describe Kubernetes features. You can turn these features on or off using the --feature-gates command line flag on each Kubernetes component.

Each Kubernetes component lets you enable or disable a set of feature gates that are relevant to that component. Use -h flag to see a full set of feature gates for all components. To set feature gates for a component, such as kubelet, use the --feature-gates flag assigned to a list of feature pairs:

The following tables are a summary of the feature gates that you can set on different Kubernetes components.

A feature can be in Alpha, Beta or GA stage. An Alpha feature means:

A Beta feature means:

A General Availability (GA) feature is also referred to as a stable feature. It means:

Each feature gate is designed for enabling/disabling a specific feature.

Allow kubelet to request a certificate without any Node IP available, only with DNS names.

Disable node admission validation of CertificateSigningRequests for kubelet signers. Unless you disable this feature gate, Kubernetes enforces that new kubelet certificates have a commonName matching system:node:$nodeName.

When this feature is enabled, the subject name attribute 1.3.6.1.4.1.57683.2 in an X.509 certificate will be parsed as the user UID during certificate authentication.

Enables .status.ingress.loadBalancer to be set on Services of types other than LoadBalancer.

Enables the cluster operator to identify corrupt resource(s) using the list operation, and introduces an option ignoreStoreReadErrorWithClusterBreakingPotential that the operator can set to perform unsafe and force delete operation of such corrupt resource(s) using the Kubernetes API.

Enable configurable endpoints for anonymous auth for the API server.

Enable use of any custom resource as the DataSource of a PVC.

Compress the API responses for LIST or GET requests.

Assign each API server an ID in a cluster, using a Lease.

Add support for distributed tracing in the API server. See Traces for Kubernetes System Components for more details.

This feature gate enables an API server performance improvement: the API server can use separate goroutines (lightweight threads managed by the Go runtime) to serve watch requests.

Make the Node authorizer use fine-gra

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
--feature-gates=...,GracefulNodeShutdown=true
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cla

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-finalizer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Extend Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/extend-resources/

**Contents:**
- Extend Resources
      - CustomResourceDefinition
      - DeviceClass
      - MutatingWebhookConfiguration
      - ValidatingWebhookConfiguration
- Feedback

CustomResourceDefinition represents a resource that should be exposed on the API server.

DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors.

MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.

ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-security-context

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-watch

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-pod-disruption-budget

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Issue a Certificate for a Kubernetes API Client Using A CertificateSigningRequest

**URL:** https://kubernetes.io/docs/tasks/tls/certificate-issue-client-csr/

**Contents:**
- Issue a Certificate for a Kubernetes API Client Using A CertificateSigningRequest
- Before you begin
- Create private key
- Create an X.509 certificate signing request
    - Note:
- Create a Kubernetes CertificateSigningRequest
- Approve the CertificateSigningRequest
- Get the certificate
- Configure the certificate into kubeconfig
- Create Role and RoleBinding

Kubernetes lets you use a public key infrastructure (PKI) to authenticate to your cluster as a client.

A few steps are required in order to get a normal user to be able to authenticate and invoke an API. First, this user must have an X.509 certificate issued by an authority that your Kubernetes cluster trusts. The client must then present that certificate to the Kubernetes API.

You use a CertificateSigningRequest as part of this process, and either you or some other principal must approve the request.

You will create a private key, and then get a certificate issued, and finally configure that private key for a client.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

You need the kubectl, openssl and base64 utilities.

This page assumes you are using Kubernetes role based access control (RBAC). If you have alternative or additional security mechanisms around authorization, you need to account for those as well.

In this step, you create a private key. You need to keep this document secret; anyone who has it can impersonate the user.

It is important to set CN and O attribute of the CSR. CN is the name of the user and O is the group that this user will belong to. You can refer to RBAC for standard groups.

Encode the CSR document using this command:

Create a CertificateSigningRequest and submit it to a Kubernetes Cluster via kubectl. Below is a snippet of shell that you can use to generate the CertificateSigningRequest.

Use kubectl to find the CSR you made, and manually approve it.

Get the list of CSRs:

Retrieve the certificate from the CSR, to check it looks OK.

The certificate value is in Base64-encoded format under .status.certificate.

Export the issued certificate from the CertificateSigningRequest.

The next step is to add this user into the kubeconfig file.

First, you need to add new credentials:

Then, you need to add the context:

You should see output confirming that you are “myuser“.

With the certificate created it is time to define the Role and RoleBinding for this user to access Kubernetes cluster resources.

This is a sample command to create a Role for this new user:

This is a sample command to create a RoleBindi

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
# Create a private key
openssl genrsa -out myuser.key 3072
```

Example 2 (shell):
```shell
# Change the common name "myuser" to the actual username that you want to use
openssl req -new -key myuser.key -out myuser.csr -subj "/CN=myuser"
```

Example 3 (shell):
```shell
cat myuser.csr | base64 | tr -d "\n"
```

Example 4 (shell):
```shell
cat <<EOF | kubectl apply -f -
apiVersion: certificates.k8s.io/v1
kind: CertificateSigningRequest
metadata:
  name: myuser # example
spec:
  # This is an encoded CSR. Change this to the base64-encoded contents of myuser.csr
  request: LS0tLS1CRUdJTiBDRVJUSUZJQ0FURSBSRVFVRVNULS0tLS0KTUlJQ1ZqQ0NBVDRDQVFBd0VURVBNQTBHQTFVRUF3d0dZVzVuWld4aE1JSUJJakFOQmdrcWhraUc5dzBCQVFFRgpBQU9DQVE4QU1JSUJDZ0tDQVFFQTByczhJTHRHdTYxakx2dHhWTTJSVlRWMDNHWlJTWWw0dWluVWo4RElaWjBOCnR2MUZtRVFSd3VoaUZsOFEzcWl0Qm0wMUFSMkNJVXBGd2ZzSjZ4MXF3ckJzVkhZbGlBNVhwRVpZM3ExcGswSDQKM3Z3aGJlK1o2MVNrVHF5SVBYUUwrTWM5T1Nsbm0xb0R2N0NtSkZNMUlMR
...
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-gateway-api

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-dra

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-containerd

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-application-developer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cni

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Use a SOCKS5 Proxy to Access the Kubernetes API

**URL:** https://kubernetes.io/docs/tasks/extend-kubernetes/socks5-proxy-access-api/

**Contents:**
- Use a SOCKS5 Proxy to Access the Kubernetes API
- Before you begin
- Task context
    - Note:
- Using ssh to create a SOCKS5 proxy
- Client configuration
    - Note:
- Clean up
- Further reading
- Feedback

This page shows how to use a SOCKS5 proxy to access the API of a remote Kubernetes cluster. This is useful when the cluster you want to access does not expose its API directly on the public internet.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:iximiuz LabsKillercodaKodeKloudPlay with KubernetesYour Kubernetes server must be at or later than version v1.24.To check the version, enter kubectl version.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To check the version, enter kubectl version.

You need SSH client software (the ssh tool), and an SSH service running on the remote server. You must be able to log in to the SSH service on the remote server.

Figure 1 represents what you're going to achieve in this task.

graph LR; subgraph local[Local client machine] client([client])-. localtraffic .-> local_ssh[Local SSHSOCKS5 proxy]; end local_ssh[SSHSOCKS5proxy]-- SSH Tunnel -->sshd subgraph remote[Remote server] sshd[SSHserver]-- local traffic -->service1; end client([client])-. proxied HTTPs trafficgoing through the proxy .->service1[Kubernetes API]; classDef plain fill:#ddd,stroke:#fff,stroke-width:4px,color:#000; classDef k8s fill:#326ce5,stroke:#fff,stroke-width:4px,color:#fff; classDef cluster fill:#fff,stroke:#bbb,stroke-width:2px,color:#326ce5; class ingress,service1,service2,pod1,pod2,pod3,pod4 k8s; class client plain; class cluster cluster;JavaScript must be enabled to view this contentFigure 1. SOCKS5 tutorial components

The following command starts a SOCKS5 proxy between your client machine and the remote SOCKS server:

The SOCKS5 proxy lets you connect to your cluster's API server based on the following configuration:

To access the Kubernetes API server through the proxy you must instruct kubectl to send queries through the SOCKS proxy we created earlier. Do this by either setting the appropriate enviro

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
# The SSH tunnel continues running in the foreground after you run this
ssh -D 1080 -q -N username@kubernetes-remote-server.example
```

Example 2 (shell):
```shell
export HTTPS_PROXY=socks5://localhost:1080
```

Example 3 (yaml):
```yaml
apiVersion: v1
clusters:
- cluster:
    certificate-authority-data: LRMEMMW2 # shortened for readability 
    server: https://<API_SERVER_IP_ADDRESS>:6443  # the "Kubernetes API" server, in other words the IP address of kubernetes-remote-server.example
    proxy-url: socks5://localhost:1080   # the "SSH SOCKS5 proxy" in the diagram above
  name: default
contexts:
- context:
    cluster: default
    user: default
  name: default
current-context: default
kind: Config
preferences: {}
users:
- name: default
  user:
    client-certificate-data: LS0tLS1CR== # shortened for readability
    client-key
...
```

Example 4 (shell):
```shell
kubectl get pods
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-api-group

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-ephemeral-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kube-scheduler

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## TLS bootstrapping

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/kubelet-tls-bootstrapping/#kubelet-configuration

**Contents:**
- TLS bootstrapping
- Initialization process
  - Bootstrap initialization
- Configuration
- Certificate Authority
- kube-apiserver configuration
  - Recognizing client certificates
  - Initial bootstrap authentication
    - Bootstrap tokens
    - Token authentication file

In a Kubernetes cluster, the components on the worker nodes - kubelet and kube-proxy - need to communicate with Kubernetes control plane components, specifically kube-apiserver. In order to ensure that communication is kept private, not interfered with, and ensure that each component of the cluster is talking to another trusted component, we strongly recommend using client TLS certificates on nodes.

The normal process of bootstrapping these components, especially worker nodes that need certificates so they can communicate safely with kube-apiserver, can be a challenging process as it is often outside of the scope of Kubernetes and requires significant additional work. This in turn, can make it challenging to initialize or scale a cluster.

In order to simplify the process, beginning in version 1.4, Kubernetes introduced a certificate request and signing API. The proposal can be found here.

This document describes the process of node initialization, how to set up TLS client certificate bootstrapping for kubelets, and how it works.

When a worker node starts up, the kubelet does the following:

Assuming that the kube-apiserver successfully validates the kubelet's credentials, it will treat the kubelet as a valid node, and begin to assign pods to it.

Note that the above process depends upon:

All of the following are responsibilities of whoever sets up and manages the cluster:

The TLS Bootstrapping described in this document is intended to simplify, and partially or even completely automate, steps 3 onwards, as these are the most common when initializing or scaling a cluster.

In the bootstrap initialization process, the following occurs:

The rest of this document describes the necessary steps to configure TLS Bootstrapping, and its limitations.

To configure for TLS bootstrapping and optional automatic approval, you must configure options on the following components:

In addition, you need your Kubernetes Certificate Authority (CA).

As without bootstrapping, you will need a Certificate Authority (CA) key and certificate. As without bootstrapping, these will be used to sign the kubelet certificate. As before, it is your responsibility to distribute them to control plane nodes.

For the purposes of this document, we will assume these have been distributed to control plane nodes at /var/lib/kubernetes/ca.pem (certificate) and /var/lib/kubernetes/ca-key.pem (key). We will refer to these as "Kubernetes CA certificate and key".

All Kubernetes components tha

*[Content truncated]*

**Examples:**

Example 1 (console):
```console
--enable-bootstrap-token-auth=true
```

Example 2 (shell):
```shell
head -c 16 /dev/urandom | od -An -t x | tr -d ' '
```

Example 3 (console):
```console
02b50b05283e98dd0fd71db496ef01e8,kubelet-bootstrap,10001,"system:bootstrappers"
```

Example 4 (yaml):
```yaml
# enable bootstrapping nodes to create CSR
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: create-csrs-for-bootstrapping
subjects:
- kind: Group
  name: system:bootstrappers
  apiGroup: rbac.authorization.k8s.io
roleRef:
  kind: ClusterRole
  name: system:node-bootstrapper
  apiGroup: rbac.authorization.k8s.io
```

---

## kubectl Usage Conventions

**URL:** https://kubernetes.io/docs/reference/kubectl/conventions/

**Contents:**
- kubectl Usage Conventions
- Using kubectl in Reusable Scripts
- Subresources
- Best Practices
  - kubectl run
  - kubectl apply
- Feedback

Recommended usage conventions for kubectl.

For a stable output in a script:

For kubectl run to satisfy infrastructure as code:

You can use the --dry-run=client flag to preview the object that would be sent to your cluster, without really submitting it.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-developer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-control-plane

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kubeadm Configuration (v1beta4)

**URL:** https://kubernetes.io/docs/reference/config-api/kubeadm-config.v1beta4/

**Contents:**
- kubeadm Configuration (v1beta4)
- Overview
- Migration from old kubeadm config versions
- Basics
- Kubeadm init configuration types
- Kubeadm join configuration types
- Kubeadm reset configuration types
- Kubeadm upgrade configuration types
- Resource Types
- BootstrapToken

Package v1beta4 defines the v1beta4 version of the kubeadm configuration file format. This version improves on the v1beta3 format by fixing some minor issues and adding a few new fields.

A list of changes since v1beta3:

The preferred way to configure kubeadm is to pass a YAML configuration file with the --config option. Some of the configuration options defined in the kubeadm config file are also available as command line flags, but only the most common/simple use case are supported with this approach.

A kubeadm config file could contain multiple configuration types separated using three dashes (---).

kubeadm supports the following configuration types:

To print the defaults for init and join actions use the following commands:

The list of configuration types that must be included in a configuration file depends by the action you are performing (init or join) and by the configuration options you are going to use (defaults or advanced customization).

If some configuration types are not provided, or provided only partially, kubeadm will use default values; defaults provided by kubeadm includes also enforcing consistency of values across components when required (e.g. --cluster-cidr flag on controller manager and clusterCIDR on kube-proxy).

Users are always allowed to override default values, with the only exception of a small subset of setting with relevance for security (e.g. enforce authorization-mode Node and RBAC on api server).

If the user provides a configuration types that is not expected for the action you are performing, kubeadm will ignore those types and print a warning.

When executing kubeadm init with the --config option, the following configuration types could be used: InitConfiguration, ClusterConfiguration, KubeProxyConfiguration, KubeletConfiguration, but only one between InitConfiguration and ClusterConfiguration is mandatory.

The InitConfiguration type should be used to configure runtime settings, that in case of kubeadm init are the configuration of the bootstrap token and all the setting which are specific to the node where kubeadm is executed, including:

NodeRegistration, that holds fields that relate to registering the new node to the cluster; use it to customize the node name, the CRI socket to use or any other settings that should apply to this node only (e.g. the node ip).

LocalAPIEndpoint, that represents the endpoint of the instance of the API server to be deployed on this node; use it e.g. to customize the API server 

*[Content truncated]*

---

## Kubelet authentication/authorization

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/kubelet-authn-authz/#fine-grained-authorization

**Contents:**
- Kubelet authentication/authorization
- Overview
- Kubelet authentication
- Kubelet authorization
  - Fine-grained authorization
- Feedback

A kubelet's HTTPS endpoint exposes APIs which give access to data of varying sensitivity, and allow you to perform operations with varying levels of power on the node and within containers.

This document describes how to authenticate and authorize access to the kubelet's HTTPS endpoint.

By default, requests to the kubelet's HTTPS endpoint that are not rejected by other configured authentication methods are treated as anonymous requests, and given a username of system:anonymous and a group of system:unauthenticated.

To disable anonymous access and send 401 Unauthorized responses to unauthenticated requests:

To enable X509 client certificate authentication to the kubelet's HTTPS endpoint:

To enable API bearer tokens (including service account tokens) to be used to authenticate to the kubelet's HTTPS endpoint:

Any request that is successfully authenticated (including an anonymous request) is then authorized. The default authorization mode is AlwaysAllow, which allows all requests.

There are many possible reasons to subdivide access to the kubelet API:

To subdivide access to the kubelet API, delegate authorization to the API server:

The kubelet authorizes API requests using the same request attributes approach as the apiserver.

The verb is determined from the incoming request's HTTP verb:

The resource and subresource is determined from the incoming request's path:

The namespace and API group attributes are always an empty string, and the resource name is always the name of the kubelet's Node API object.

When running in this mode, ensure the user identified by the --kubelet-client-certificate and --kubelet-client-key flags passed to the apiserver is authorized for the following attributes:

When the feature gate KubeletFineGrainedAuthz is enabled kubelet performs a fine-grained check before falling back to the proxy subresource for the /pods, /runningPods, /configz and /healthz endpoints. The resource and subresource are determined from the incoming request's path:

When the feature-gate KubeletFineGrainedAuthz is enabled, ensure the user identified by the --kubelet-client-certificate and --kubelet-client-key flags passed to the API server is authorized for the following attributes:

If RBAC authorization is used, enabling this gate also ensure that the builtin system:kubelet-api-admin ClusterRole is updated with permissions to access all the above mentioned subresources.

Was this page helpful?

Thanks for the feedback. If you have a specific, ans

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-mirror-pod

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-replica-set

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-daemonset

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-deployment

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-kube-scheduler

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-member

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-drain

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-service

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Reference

**URL:** https://kubernetes.io/docs/reference/

**Contents:**
- API Reference
- Officially supported client libraries
- CLI
- Components
- Config APIs
- Config API for kubeadm
- External APIs
- Design Docs
- Feedback

This section of the Kubernetes documentation contains references.

Glossary - a comprehensive, standardized list of Kubernetes terminology

Kubernetes API Reference

One-page API Reference for Kubernetes v1.34

Using The Kubernetes API - overview of the API for Kubernetes.

API access control - details on how Kubernetes controls API access

Well-Known Labels, Annotations and Taints

To call the Kubernetes API from a programming language, you can use client libraries. Officially supported client libraries:

kubelet - The primary agent that runs on each node. The kubelet takes a set of PodSpecs and ensures that the described containers are running and healthy.

kube-apiserver - REST API that validates and configures data for API objects such as pods, services, replication controllers.

kube-controller-manager - Daemon that embeds the core control loops shipped with Kubernetes.

kube-proxy - Can do simple TCP/UDP stream forwarding or round-robin TCP/UDP forwarding across a set of back-ends.

kube-scheduler - Scheduler that manages availability, performance, and capacity.

List of ports and protocols that should be open on control plane and worker nodes

This section hosts the documentation for "unpublished" APIs which are used to configure kubernetes components or tools. Most of these APIs are not exposed by the API server in a RESTful way though they are essential for a user or an operator to use or manage a cluster.

These are the APIs defined by the Kubernetes project, but are not implemented by the core project:

An archive of the design docs for Kubernetes functionality. Good starting points are Kubernetes Architecture and Kubernetes Design Overview.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Kubelet Configuration (v1beta1)

**URL:** https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/

**Contents:**
- Kubelet Configuration (v1beta1)
- Resource Types
- FormatOptions
- JSONOptions
- LogFormatFactory
- LoggingConfiguration
- LoggingOptions
- OutputRoutingOptions
- TextOptions
- TimeOrMetaDuration

FormatOptions contains options for the different logging formats.

[Alpha] Text contains options for logging format "text". Only available when the LoggingAlphaOptions feature gate is enabled.

[Alpha] JSON contains options for logging format "json". Only available when the LoggingAlphaOptions feature gate is enabled.

JSONOptions contains options for logging format "json".

LogFormatFactory provides support for a certain additional, non-default log format.

LoggingConfiguration contains logging options.

Format Flag specifies the structure of log messages. default value of format is text

Maximum time between log flushes. If a string, parsed as a duration (i.e. "1s") If an int, the maximum number of nanoseconds (i.e. 1s = 1000000000). Ignored if the selected logging backend writes log messages without buffering.

Verbosity is the threshold that determines which log messages are logged. Default is zero which logs only the most important messages. Higher values enable additional messages. Error messages are always logged.

VModule overrides the verbosity threshold for individual files. Only supported for "text" log format.

[Alpha] Options holds additional parameters that are specific to the different logging formats. Only the options for the selected format get used, but all of them get validated. Only available when the LoggingAlphaOptions feature gate is enabled.

LoggingOptions can be used with ValidateAndApplyWithOptions to override certain global defaults.

ErrorStream can be used to override the os.Stderr default.

InfoStream can be used to override the os.Stdout default.

OutputRoutingOptions contains options that are supported by both "text" and "json".

[Alpha] SplitStream redirects error messages to stderr while info messages go to stdout, with buffering. The default is to write both to stdout, without buffering. Only available when the LoggingAlphaOptions feature gate is enabled.

[Alpha] InfoBufferSize sets the size of the info stream when using split streams. The default is zero, which disables buffering. Only available when the LoggingAlphaOptions feature gate is enabled.

TextOptions contains options for logging format "text".

TimeOrMetaDuration is present only for backwards compatibility for the flushFrequency field, and new fields should use metav1.Duration.

Duration holds the duration

SerializeAsString controls whether the value is serialized as a string or an integer

TracingConfiguration provides versioned configuration for OpenTelem

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cluster-operator

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-pod-priority

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Feature Gates (removed)

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates-removed/

**Contents:**
- Feature Gates (removed)
  - Feature gates that are removed
- Descriptions for removed feature gates
- Feedback

This page contains list of feature gates that have been removed. The information on this page is for reference. A removed feature gate is different from a GA'ed or deprecated one in that a removed one is no longer recognized as a valid feature gate. However, a GA'ed or a deprecated feature gate is still recognized by the corresponding Kubernetes components although they are unable to cause any behavior differences in a cluster.

For feature gates that are still recognized by the Kubernetes components, please refer to the Alpha/Beta feature gate table or the Graduated/Deprecated feature gate table

In the following table:

Provided an early form of plugin to enable Nvidia GPU support when using Docker Engine; no longer available. See Device Plugins for an alternative.

Enable match conditions on mutating & validating admission webhooks.

Enable advanced auditing

Enable setting Pod affinity or anti-affinity.

Enable a single HTTP endpoint /discovery/<version> which supports native HTTP caching with ETags containing all APIResources known to the API server.

Enable a service to route external requests to node local endpoints.

Enable the users to skip TLS verification of kubelets on Pod log requests.

Enable the API clients to retrieve (LIST or GET) resources from API server in chunks.

Enable managing request concurrency with prioritization and fairness at each server. (Renamed from RequestManagement)

Activate the SelfSubjectReview API which allows users to see the requesting subject's authentication information. See API access to authentication information for a client for more details.

Enable use of AppArmor mandatory access control for Pods running on Linux nodes. See AppArmor Tutorial for more details.

Enable AppArmor related security context settings.

For more information about AppArmor and Kubernetes, read the AppArmor section within security features in the Linux kernel.

Enable volume plugins to report limits on number of volumes that can be attached to a node. See dynamic volume limits for more details.

Include volume count on node to be considered for balanced resource allocation while scheduling. A node which has closer CPU, memory utilization, and volume count is favored by the scheduler while making decisions.

Enable the definition and consumption of raw block devices in Pods. See Raw Block Volume Support for more details.

Migrate ServiceAccount volumes to use a projected volume consisting of a ServiceAccountTokenVolumeProjection. Cluste

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-dynamicvolumeprovisioning

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-eviction

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-dockershim

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Audit Annotations

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/audit-annotations/#validation-policy-admission-k8s-io-validation-failure

**Contents:**
- Audit Annotations
    - Note:
- k8s.io/deprecated
- k8s.io/removed-release
- pod-security.kubernetes.io/exempt
- pod-security.kubernetes.io/enforce-policy
- pod-security.kubernetes.io/audit-violations
- apiserver.latency.k8s.io/etcd
- apiserver.latency.k8s.io/decode-response-object
- apiserver.latency.k8s.io/apf-queue-wait

This page serves as a reference for the audit annotations of the kubernetes.io namespace. These annotations apply to Event object from API group audit.k8s.io.

Example: k8s.io/deprecated: "true"

Value must be "true" or "false". The value "true" indicates that the request used a deprecated API version.

Example: k8s.io/removed-release: "1.22"

Value must be in the format "<MAJOR>.<MINOR>". It is set to target the removal release on requests made to deprecated API versions with a target removal release.

Example: pod-security.kubernetes.io/exempt: namespace

Value must be one of user, namespace, or runtimeClass which correspond to Pod Security Exemption dimensions. This annotation indicates on which dimension was based the exemption from the PodSecurity enforcement.

Example: pod-security.kubernetes.io/enforce-policy: restricted:latest

Value must be privileged:<version>, baseline:<version>, restricted:<version> which correspond to Pod Security Standard levels accompanied by a version which must be latest or a valid Kubernetes version in the format v<MAJOR>.<MINOR>. This annotations informs about the enforcement level that allowed or denied the pod during PodSecurity admission.

See Pod Security Standards for more information.

Example: pod-security.kubernetes.io/audit-violations: would violate PodSecurity "restricted:latest": allowPrivilegeEscalation != false (container "example" must set securityContext.allowPrivilegeEscalation=false), ...

Value details an audit policy violation, it contains the Pod Security Standard level that was transgressed as well as the specific policies on the fields that were violated from the PodSecurity enforcement.

See Pod Security Standards for more information.

Example: apiserver.latency.k8s.io/etcd: "4.730661757s"

This annotation indiactes the measure of latency incurred inside the storage layer, it accounts for the time it takes to send data to the etcd and get the complete response back.

The value of this audit annotation does not include the time incurred in admission, or validation.

Example: apiserver.latency.k8s.io/decode-response-object: "450.6649ns"

This annotation records the time taken to decode the response received from the storage layer (etcd)

Example: apiserver.latency.k8s.io/apf-queue-wait: "100ns"

This annotation records the time that a request spent queued due to API server priorities.

See API Priority and Fairness (APF) for more information about this mechanism.

Example: authorization.k8s.io/decis

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-csi

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Update API Objects in Place Using kubectl patch

**URL:** https://kubernetes.io/docs/tasks/manage-kubernetes-objects/update-api-object-kubectl-patch/

**Contents:**
- Update API Objects in Place Using kubectl patch
- Before you begin
- Use a strategic merge patch to update a Deployment
  - Notes on the strategic merge patch
- Use a JSON merge patch to update a Deployment
- Use strategic merge patch to update a Deployment using the retainKeys strategy
  - Notes on the strategic merge patch using the retainKeys strategy
  - Alternate forms of the kubectl patch command
  - Update an object's replica count using kubectl patch with --subresource
    - Note:

This task shows how to use kubectl patch to update an API object in place. The exercises in this task demonstrate a strategic merge patch and a JSON merge patch.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:iximiuz LabsKillercodaKodeKloudPlay with KubernetesTo check the version, enter kubectl version.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To check the version, enter kubectl version.

Here's the configuration file for a Deployment that has two replicas. Each replica is a Pod that has one container:

Create the Deployment:

View the Pods associated with your Deployment:

The output shows that the Deployment has two Pods. The 1/1 indicates that each Pod has one container:

Make a note of the names of the running Pods. Later, you will see that these Pods get terminated and replaced by new ones.

At this point, each Pod has one Container that runs the nginx image. Now suppose you want each Pod to have two containers: one that runs nginx and one that runs redis.

Create a file named patch-file.yaml that has this content:

Patch your Deployment:

View the patched Deployment:

The output shows that the PodSpec in the Deployment has two Containers:

View the Pods associated with your patched Deployment:

The output shows that the running Pods have different names from the Pods that were running previously. The Deployment terminated the old Pods and created two new Pods that comply with the updated Deployment spec. The 2/2 indicates that each Pod has two Containers:

Take a closer look at one of the patch-demo Pods:

The output shows that the Pod has two Containers: one running nginx and one running redis:

The patch you did in the preceding exercise is called a strategic merge patch. Notice that the patch did not replace the containers list. Instead it added a new Container to the list. In other words, the list i

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  name: patch-demo
spec:
  replicas: 2
  selector:
    matchLabels:
      app: nginx
  template:
    metadata:
      labels:
        app: nginx
    spec:
      containers:
      - name: patch-demo-ctr
        image: nginx
      tolerations:
      - effect: NoSchedule
        key: dedicated
        value: test-team
```

Example 2 (shell):
```shell
kubectl apply -f https://k8s.io/examples/application/deployment-patch.yaml
```

Example 3 (shell):
```shell
kubectl get pods
```

Example 4 (unknown):
```unknown
NAME                        READY     STATUS    RESTARTS   AGE
patch-demo-28633765-670qr   1/1       Running   0          23s
patch-demo-28633765-j5qs3   1/1       Running   0          23s
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-member

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-namespace

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-node-pressure-eviction

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kubectl Quick Reference

**URL:** https://kubernetes.io/docs/reference/kubectl/quick-reference/

**Contents:**
- kubectl Quick Reference
    - Note:
- Kubectl autocomplete
  - BASH
  - ZSH
  - FISH
    - Note:
  - A note on --all-namespaces
- Kubectl context and configuration
- Kubectl apply

This page contains a list of commonly used kubectl commands and flags.

You can also use a shorthand alias for kubectl that also works with completion:

Appending --all-namespaces happens frequently enough that you should be aware of the shorthand for --all-namespaces:

Set which Kubernetes cluster kubectl communicates with and modifies configuration information. See Authenticating Across Clusters with kubeconfig documentation for detailed config file information.

apply manages applications through files defining Kubernetes resources. It creates and updates resources in a cluster through running kubectl apply. This is the recommended way of managing Kubernetes applications on production. See Kubectl Book.

Kubernetes manifests can be defined in YAML or JSON. The file extension .yaml, .yml, and .json can be used.

Edit any API resource in your preferred editor.

List all supported resource types along with their shortnames, API group, whether they are namespaced, and kind:

Other operations for exploring API resources:

To output details to your terminal window in a specific format, add the -o (or --output) flag to a supported kubectl command.

Examples using -o=custom-columns:

More examples in the kubectl reference documentation.

Kubectl verbosity is controlled with the -v or --v flags followed by an integer representing the log level. General Kubernetes logging conventions and the associated log levels are described here.

Read the kubectl overview and learn about JsonPath.

Also read kubectl Usage Conventions to understand how to use kubectl in reusable scripts.

See more community kubectl cheatsheets.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

**Examples:**

Example 1 (bash):
```bash
source <(kubectl completion bash) # set up autocomplete in bash into the current shell, bash-completion package should be installed first.
echo "source <(kubectl completion bash)" >> ~/.bashrc # add autocomplete permanently to your bash shell.
```

Example 2 (bash):
```bash
alias k=kubectl
complete -o default -F __start_kubectl k
```

Example 3 (bash):
```bash
source <(kubectl completion zsh)  # set up autocomplete in zsh into the current shell
echo '[[ $commands[kubectl] ]] && source <(kubectl completion zsh)' >> ~/.zshrc # add autocomplete permanently to your zsh shell
```

Example 4 (bash):
```bash
echo 'kubectl completion fish | source' > ~/.config/fish/completions/kubectl.fish && source ~/.config/fish/completions/kubectl.fish
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-image

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-volumeplugin

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-kubernetes-api

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-infrastructure-resource

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authorization

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authorization/#using-configuration-file-for-authorization

**Contents:**
- Authorization
- Authorization verdicts
    - Note:
- Request attributes used in authorization
  - Request verbs and authorization
    - Non-resource requests
    - Resource requests
    - Caution:
- Authorization context
- Authorization modes

Kubernetes authorization takes place following authentication. Usually, a client making a request must be authenticated (logged in) before its request can be allowed; however, Kubernetes also allows anonymous requests in some circumstances.

For an overview of how authorization fits into the wider context of API access control, read Controlling Access to the Kubernetes API.

Kubernetes authorization of API requests takes place within the API server. The API server evaluates all of the request attributes against all policies, potentially also consulting external services, and then allows or denies the request.

All parts of an API request must be allowed by some authorization mechanism in order to proceed. In other words: access is denied by default.

Access controls and policies that depend on specific fields of specific kinds of objects are handled by admission controllers.

Kubernetes admission control happens after authorization has completed (and, therefore, only when the authorization decision was to allow the request).

When multiple authorization modules are configured, each is checked in sequence. If any authorizer approves or denies a request, that decision is immediately returned and no other authorizer is consulted. If all modules have no opinion on the request, then the request is denied. An overall deny verdict means that the API server rejects the request and responds with an HTTP 403 (Forbidden) status.

Kubernetes reviews only the following API request attributes:

Requests to endpoints other than /api/v1/... or /apis/<group>/<version>/... are considered non-resource requests, and use the lower-cased HTTP method of the request as the verb. For example, making a GET request using HTTP to endpoints such as /api or /healthz would use get as the verb.

To determine the request verb for a resource API endpoint, Kubernetes maps the HTTP verb used and considers whether or not the request acts on an individual resource or on a collection of resources:

Kubernetes sometimes checks authorization for additional permissions using specialized verbs. For example:

Kubernetes expects attributes that are common to REST API requests. This means that Kubernetes authorization works with existing organization-wide or cloud-provider-wide access control systems which may handle other APIs besides the Kubernetes API.

The Kubernetes API server may authorize a request using one of several authorization modes:

Enabling the AlwaysAllow mode bypasses authorization; 

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
---
#
# DO NOT USE THE CONFIG AS IS. THIS IS AN EXAMPLE.
#
apiVersion: apiserver.config.k8s.io/v1
kind: AuthorizationConfiguration
authorizers:
  - type: Webhook
    # Name used to describe the authorizer
    # This is explicitly used in monitoring machinery for metrics
    # Note:
    #   - Validation for this field is similar to how K8s labels are validated today.
    # Required, with no default
    name: webhook
    webhook:
      # The duration to cache 'authorized' responses from the webhook
      # authorizer.
      # Same as setting `--authorization-webhook-cache-authorized-ttl` flag
  
...
```

Example 2 (bash):
```bash
kubectl auth can-i create deployments --namespace dev
```

Example 3 (shell):
```shell
kubectl auth can-i create deployments --namespace prod
```

Example 4 (bash):
```bash
kubectl auth can-i list secrets --namespace dev --as dave
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-upstream

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authentication Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/authentication-resources/

**Contents:**
- Authentication Resources
      - ServiceAccount
      - TokenRequest
      - TokenReview
      - CertificateSigningRequest
      - ClusterTrustBundle v1beta1
      - SelfSubjectReview
      - PodCertificateRequest v1alpha1
- Feedback

ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets.

TokenRequest requests a token for a given service account.

TokenReview attempts to authenticate a token to a known user.

CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

ClusterTrustBundle is a cluster-scoped container for X.

SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request.

PodCertificateRequest encodes a pod requesting a certificate from a given signer.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Authorization

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authorization/

**Contents:**
- Authorization
- Authorization verdicts
    - Note:
- Request attributes used in authorization
  - Request verbs and authorization
    - Non-resource requests
    - Resource requests
    - Caution:
- Authorization context
- Authorization modes

Kubernetes authorization takes place following authentication. Usually, a client making a request must be authenticated (logged in) before its request can be allowed; however, Kubernetes also allows anonymous requests in some circumstances.

For an overview of how authorization fits into the wider context of API access control, read Controlling Access to the Kubernetes API.

Kubernetes authorization of API requests takes place within the API server. The API server evaluates all of the request attributes against all policies, potentially also consulting external services, and then allows or denies the request.

All parts of an API request must be allowed by some authorization mechanism in order to proceed. In other words: access is denied by default.

Access controls and policies that depend on specific fields of specific kinds of objects are handled by admission controllers.

Kubernetes admission control happens after authorization has completed (and, therefore, only when the authorization decision was to allow the request).

When multiple authorization modules are configured, each is checked in sequence. If any authorizer approves or denies a request, that decision is immediately returned and no other authorizer is consulted. If all modules have no opinion on the request, then the request is denied. An overall deny verdict means that the API server rejects the request and responds with an HTTP 403 (Forbidden) status.

Kubernetes reviews only the following API request attributes:

Requests to endpoints other than /api/v1/... or /apis/<group>/<version>/... are considered non-resource requests, and use the lower-cased HTTP method of the request as the verb. For example, making a GET request using HTTP to endpoints such as /api or /healthz would use get as the verb.

To determine the request verb for a resource API endpoint, Kubernetes maps the HTTP verb used and considers whether or not the request acts on an individual resource or on a collection of resources:

Kubernetes sometimes checks authorization for additional permissions using specialized verbs. For example:

Kubernetes expects attributes that are common to REST API requests. This means that Kubernetes authorization works with existing organization-wide or cloud-provider-wide access control systems which may handle other APIs besides the Kubernetes API.

The Kubernetes API server may authorize a request using one of several authorization modes:

Enabling the AlwaysAllow mode bypasses authorization; 

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
---
#
# DO NOT USE THE CONFIG AS IS. THIS IS AN EXAMPLE.
#
apiVersion: apiserver.config.k8s.io/v1
kind: AuthorizationConfiguration
authorizers:
  - type: Webhook
    # Name used to describe the authorizer
    # This is explicitly used in monitoring machinery for metrics
    # Note:
    #   - Validation for this field is similar to how K8s labels are validated today.
    # Required, with no default
    name: webhook
    webhook:
      # The duration to cache 'authorized' responses from the webhook
      # authorizer.
      # Same as setting `--authorization-webhook-cache-authorized-ttl` flag
  
...
```

Example 2 (bash):
```bash
kubectl auth can-i create deployments --namespace dev
```

Example 3 (shell):
```shell
kubectl auth can-i create deployments --namespace prod
```

Example 4 (bash):
```bash
kubectl auth can-i list secrets --namespace dev --as dave
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-CustomResourceDefinition

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-control-plane

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-certificate

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-qos-class

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-application-developer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-addons

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-docker

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Dynamic Admission Control

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/extensible-admission-controllers/#admission-webhooks

**Contents:**
- Dynamic Admission Control
- What are admission webhooks?
    - Note:
- Experimenting with admission webhooks
  - Prerequisites
  - Write an admission webhook server
  - Deploy the admission webhook service
  - Configure admission webhooks on the fly
    - Note:
    - Note:

In addition to compiled-in admission plugins, admission plugins can be developed as extensions and run as webhooks configured at runtime. This page describes how to build, configure, use, and monitor admission webhooks.

Admission webhooks are HTTP callbacks that receive admission requests and do something with them. You can define two types of admission webhooks, validating admission webhook and mutating admission webhook. Mutating admission webhooks are invoked first, and can modify objects sent to the API server to enforce custom defaults. After all object modifications are complete, and after the incoming object is validated by the API server, validating admission webhooks are invoked and can reject requests to enforce custom policies.

Admission webhooks are essentially part of the cluster control-plane. You should write and deploy them with great caution. Please read the user guides for instructions if you intend to write/deploy production-grade admission webhooks. In the following, we describe how to quickly experiment with admission webhooks.

Ensure that MutatingAdmissionWebhook and ValidatingAdmissionWebhook admission controllers are enabled. Here is a recommended set of admission controllers to enable in general.

Ensure that the admissionregistration.k8s.io/v1 API is enabled.

Please refer to the implementation of the admission webhook server that is validated in a Kubernetes e2e test. The webhook handles the AdmissionReview request sent by the API servers, and sends back its decision as an AdmissionReview object in the same version it received.

See the webhook request section for details on the data sent to webhooks.

See the webhook response section for the data expected from webhooks.

The example admission webhook server leaves the ClientAuth field empty, which defaults to NoClientCert. This means that the webhook server does not authenticate the identity of the clients, supposedly API servers. If you need mutual TLS or other ways to authenticate the clients, see how to authenticate API servers.

The webhook server in the e2e test is deployed in the Kubernetes cluster, via the deployment API. The test also creates a service as the front-end of the webhook server. See code.

You may also deploy your webhooks outside of the cluster. You will need to update your webhook configurations accordingly.

You can dynamically configure what resources are subject to what admission webhooks via ValidatingWebhookConfiguration or MutatingWebhookConfigura

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: admissionregistration.k8s.io/v1
kind: ValidatingWebhookConfiguration
metadata:
  name: "pod-policy.example.com"
webhooks:
- name: "pod-policy.example.com"
  rules:
  - apiGroups:   [""]
    apiVersions: ["v1"]
    operations:  ["CREATE"]
    resources:   ["pods"]
    scope:       "Namespaced"
  clientConfig:
    service:
      namespace: "example-namespace"
      name: "example-service"
    caBundle: <CA_BUNDLE>
  admissionReviewVersions: ["v1"]
  sideEffects: None
  timeoutSeconds: 5
```

Example 2 (yaml):
```yaml
apiVersion: apiserver.config.k8s.io/v1
kind: AdmissionConfiguration
plugins:
- name: ValidatingAdmissionWebhook
  configuration:
    apiVersion: apiserver.config.k8s.io/v1
    kind: WebhookAdmissionConfiguration
    kubeConfigFile: "<path-to-kubeconfig-file>"
- name: MutatingAdmissionWebhook
  configuration:
    apiVersion: apiserver.config.k8s.io/v1
    kind: WebhookAdmissionConfiguration
    kubeConfigFile: "<path-to-kubeconfig-file>"
```

Example 3 (yaml):
```yaml
# Deprecated in v1.17 in favor of apiserver.config.k8s.io/v1
apiVersion: apiserver.k8s.io/v1alpha1
kind: AdmissionConfiguration
plugins:
- name: ValidatingAdmissionWebhook
  configuration:
    # Deprecated in v1.17 in favor of apiserver.config.k8s.io/v1, kind=WebhookAdmissionConfiguration
    apiVersion: apiserver.config.k8s.io/v1alpha1
    kind: WebhookAdmission
    kubeConfigFile: "<path-to-kubeconfig-file>"
- name: MutatingAdmissionWebhook
  configuration:
    # Deprecated in v1.17 in favor of apiserver.config.k8s.io/v1, kind=WebhookAdmissionConfiguration
    apiVersion: apiserver.config.k8
...
```

Example 4 (yaml):
```yaml
apiVersion: v1
kind: Config
users:
# name should be set to the DNS name of the service or the host (including port) of the URL the webhook is configured to speak to.
# If a non-443 port is used for services, it must be included in the name when configuring 1.16+ API servers.
#
# For a webhook configured to speak to a service on the default port (443), specify the DNS name of the service:
# - name: webhook1.ns1.svc
#   user: ...
#
# For a webhook configured to speak to a service on non-default port (e.g. 8443), specify the DNS name and port of the service in 1.16+:
# - name: webhook1.ns1.svc:84
...
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-logging

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-downward-api

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Extend the Kubernetes API with CustomResourceDefinitions

**URL:** https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#validation-ratcheting

**Contents:**
- Extend the Kubernetes API with CustomResourceDefinitions
- Before you begin
- Create a CustomResourceDefinition
- Create custom objects
- Delete a CustomResourceDefinition
- Specifying a structural schema
  - Field pruning
    - Controlling pruning
  - IntOrString
  - RawExtension

This page shows how to install a custom resource into the Kubernetes API by creating a CustomResourceDefinition.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:iximiuz LabsKillercodaKodeKloudPlay with KubernetesYour Kubernetes server must be at or later than version 1.16.To check the version, enter kubectl version.If you are using an older version of Kubernetes that is still supported, switch to the documentation for that version to see advice that is relevant for your cluster.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To check the version, enter kubectl version.

When you create a new CustomResourceDefinition (CRD), the Kubernetes API Server creates a new RESTful resource path for each version you specify. The custom resource created from a CRD object can be either namespaced or cluster-scoped, as specified in the CRD's spec.scope field. As with existing built-in objects, deleting a namespace deletes all custom objects in that namespace. CustomResourceDefinitions themselves are non-namespaced and are available to all namespaces.

For example, if you save the following CustomResourceDefinition to resourcedefinition.yaml:

Then a new namespaced RESTful API endpoint is created at:

This endpoint URL can then be used to create and manage custom objects. The kind of these objects will be CronTab from the spec of the CustomResourceDefinition object you created above.

It might take a few seconds for the endpoint to be created. You can watch the Established condition of your CustomResourceDefinition to be true or watch the discovery information of the API server for your resource to show up.

After the CustomResourceDefinition object has been created, you can create custom objects. Custom objects can contain custom fields. These fields can contain arbitrary JSON. In the following example, the cronSpec and image cust

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: apiextensions.k8s.io/v1
kind: CustomResourceDefinition
metadata:
  # name must match the spec fields below, and be in the form: <plural>.<group>
  name: crontabs.stable.example.com
spec:
  # group name to use for REST API: /apis/<group>/<version>
  group: stable.example.com
  # list of versions supported by this CustomResourceDefinition
  versions:
    - name: v1
      # Each version can be enabled/disabled by Served flag.
      served: true
      # One and only one version must be marked as the storage version.
      storage: true
      schema:
        openAPIV3Schema:
          t
...
```

Example 2 (shell):
```shell
kubectl apply -f resourcedefinition.yaml
```

Example 3 (unknown):
```unknown
/apis/stable.example.com/v1/namespaces/*/crontabs/...
```

Example 4 (yaml):
```yaml
apiVersion: "stable.example.com/v1"
kind: CronTab
metadata:
  name: my-new-cron-object
spec:
  cronSpec: "* * * * */5"
  image: my-awesome-cron-image
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cluster-operations

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Kubectl user preferences (kuberc)

**URL:** https://kubernetes.io/docs/reference/kubectl/kuberc/

**Contents:**
- Kubectl user preferences (kuberc)
- aliases
  - prependArgs
  - appendArgs
- defaults
- Suggested defaults
- Disable kuberc
- Feedback

A Kubernetes kuberc configuration file allows you to define preferences for kubectl, such as default options and command aliases. Unlike the kubeconfig file, a kuberc configuration file does not contain cluster details, usernames or passwords.

The default location of this configuration file is $HOME/.kube/kuberc. To provide kubectl with a path to a custom kuberc file, use the --kuberc command line option, or set the KUBERC environment variable.

A kuberc using the kubectl.config.k8s.io/v1beta1 format allows you to define two types of user preferences:

Within a kuberc configuration, the aliases section allows you to define custom shortcuts for kubectl commands, optionally with preset command line arguments and flags.

This next example defines a kubectl getn alias for the kubectl get subcommand, additionally specifying JSON output format: --output=json.

In this example, the following settings were used:

With this alias, running kubectl getn pods will default JSON output. However, if you execute kubectl getn pods -oyaml, the output will be in YAML format.

Full kuberc schema is available here.

This next example, will expand the previous one, introducing prependArgs section, which allows inserting arbitrary arguments immediately after the kubectl command and its subcommand (if any).

In this example, the following settings were used:

This next example, will introduce a mechanism similar to prepending arguments, this time, though, we will append arguments to the end of the kubectl command.

In this example, the following settings were used:

Within a kuberc configuration, defaults section lets you specify default values for command line arguments.

This next example makes the interactive removal the default mode for invoking kubectl delete:

In this example, the following settings were used:

With this setting, running kubectl delete pod/test-pod will default to prompting for confirmation. However, kubectl delete pod/test-pod --interactive=false will bypass the confirmation.

The kubectl maintainers encourage you to adopt kuberc with the following defaults:

In this example, the following settings are enforced:

To temporarily disable the kuberc functionality, set (and export) the environment variable KUBERC with the value off:

or disable the feature gate:

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want 

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: kubectl.config.k8s.io/v1beta1
kind: Preference
aliases:
- name: getn
  command: get
  options:
   - name: output
     default: json
```

Example 2 (yaml):
```yaml
apiVersion: kubectl.config.k8s.io/v1beta1
kind: Preference
aliases:
  - name: getn
    command: get
    options:
      - name: output
        default: json
    prependArgs:
      - namespace
```

Example 3 (yaml):
```yaml
apiVersion: kubectl.config.k8s.io/v1beta1
kind: Preference
aliases:
- name: runx
  command: run
  options:
    - name: image
      default: busybox
    - name: namespace
      default: test-ns
  appendArgs:
    - --
    - custom-arg
```

Example 4 (yaml):
```yaml
apiVersion: kubectl.config.k8s.io/v1beta1
kind: Preference
defaults:
- command: delete
  options:
    - name: interactive
      default: "true"
```

---

## Kubelet Checkpoint API

**URL:** https://kubernetes.io/docs/reference/node/kubelet-checkpoint-api/

**Contents:**
- Kubelet Checkpoint API
- Operations
  - post checkpoint the specified container
    - HTTP Request
    - Parameters
    - Response
- Feedback

Checkpointing a container is the functionality to create a stateful copy of a running container. Once you have a stateful copy of a container, you could move it to a different computer for debugging or similar purposes.

If you move the checkpointed container data to a computer that's able to restore it, that restored container continues to run at exactly the same point it was checkpointed. You can also inspect the saved data, provided that you have suitable tools for doing so.

Creating a checkpoint of a container might have security implications. Typically a checkpoint contains all memory pages of all processes in the checkpointed container. This means that everything that used to be in memory is now available on the local disk. This includes all private data and possibly keys used for encryption. The underlying CRI implementations (the container runtime on that node) should create the checkpoint archive to be only accessible by the root user. It is still important to remember if the checkpoint archive is transferred to another system all memory pages will be readable by the owner of the checkpoint archive.

Tell the kubelet to checkpoint a specific container from the specified Pod.

Consult the Kubelet authentication/authorization reference for more information about how access to the kubelet checkpoint interface is controlled.

The kubelet will request a checkpoint from the underlying CRI implementation. In the checkpoint request the kubelet will specify the name of the checkpoint archive as checkpoint-<podFullName>-<containerName>-<timestamp>.tar and also request to store the checkpoint archive in the checkpoints directory below its root directory (as defined by --root-dir). This defaults to /var/lib/kubelet/checkpoints.

The checkpoint archive is in tar format, and could be listed using an implementation of tar. The contents of the archive depend on the underlying CRI implementation (the container runtime on that node).

POST /checkpoint/{namespace}/{pod}/{container}

namespace (in path): string, required

pod (in path): string, required

container (in path): string, required

timeout (in query): integer

Timeout in seconds to wait until the checkpoint creation is finished. If zero or no timeout is specified the default CRI timeout value will be used. Checkpoint creation time depends directly on the used memory of the container. The more memory a container uses the more time is required to create the corresponding checkpoint.

404: Not Found (if the 

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-deployment

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-disruption

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-drain

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-master

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-resourceclaim

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cluster

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-scheduler Configuration (v1)

**URL:** https://kubernetes.io/docs/reference/config-api/kube-scheduler-config.v1/

**Contents:**
- kube-scheduler Configuration (v1)
- Resource Types
- ClientConnectionConfiguration
- DebuggingConfiguration
- LeaderElectionConfiguration
- DefaultPreemptionArgs
- DynamicResourcesArgs
- InterPodAffinityArgs
- KubeSchedulerConfiguration
- NodeAffinityArgs

ClientConnectionConfiguration contains details for constructing a client.

kubeconfig is the path to a KubeConfig file.

acceptContentTypes defines the Accept header sent by clients when connecting to a server, overriding the default value of 'application/json'. This field will control all connections to the server used by a particular client.

contentType is the content type used when sending data to the server from this client.

qps controls the number of queries per second allowed for this connection.

burst allows extra queries to accumulate when a client is exceeding its rate.

DebuggingConfiguration holds configuration for Debugging related features.

enableProfiling enables profiling via web interface host:port/debug/pprof/

enableContentionProfiling enables block profiling, if enableProfiling is true.

LeaderElectionConfiguration defines the configuration of leader election clients for components that can run with leader election enabled.

leaderElect enables a leader election client to gain leadership before executing the main loop. Enable this when running replicated components for high availability.

leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.

renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.

retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.

resourceLock indicates the resource object type that will be used to lock during leader election cycles.

resourceName indicates the name of resource object that will be used to lock during leader election cycles.

resourceName indicates the namespace of resource object that will be used to lock during leader election cycles.

DefaultPreemptionArgs holds arguments used to configure the DefaultPreemption plugin.

MinCandidateNodesPercentage is the minimum number of candidates to shortlist when dry running preemption as a percentage of number of nodes. Must be in the range [0, 100]. Defaults to 10% of the cluster size

*[Content truncated]*

---

## Authenticating

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authentication/#client-go-credential-plugins

**Contents:**
- Authenticating
- Users in Kubernetes
- Authentication strategies
    - Note:
- Authentication methods
  - X.509 client certificates
    - Putting a bearer token in a request
  - Bootstrap tokens
  - Service account tokens
    - Note:

This page provides an overview of authentication in Kubernetes, with a focus on authentication to the Kubernetes API.

All Kubernetes clusters have two categories of users: service accounts managed by Kubernetes, and normal users.

It is assumed that a cluster-independent service manages normal users in the following ways:

In this regard, Kubernetes does not have objects which represent normal user accounts. Normal users cannot be added to a cluster through an API call.

Even though a normal user cannot be added via an API call, any user that presents a valid certificate signed by the cluster's certificate authority (CA) is considered authenticated. In this configuration, Kubernetes determines the username from the common name field in the 'subject' of the cert (e.g., "/CN=bob"). From there, the role based access control (RBAC) sub-system would determine whether the user is authorized to perform a specific operation on a resource.

In contrast, service accounts are users managed by the Kubernetes API. They are bound to specific namespaces, and created automatically by the API server or manually through API calls. Service accounts are tied to a set of credentials stored as Secrets, which are mounted into pods allowing in-cluster processes to talk to the Kubernetes API.

API requests are tied to either a normal user or a service account, or are treated as anonymous requests. This means every process inside or outside the cluster, from a human user typing kubectl on a workstation, to kubelets on nodes, to members of the control plane, must authenticate when making requests to the API server, or be treated as an anonymous user.

Kubernetes uses client certificates, bearer tokens, or an authenticating proxy to authenticate API requests through authentication plugins. As HTTP requests are made to the API server, plugins attempt to associate the following attributes with the request:

You can enable multiple authentication methods at once. You should usually use at least two methods:

When multiple authenticator modules are enabled, the first module to successfully authenticate the request short-circuits evaluation. The API server does not guarantee the order authenticators run in.

The system:authenticated group is included in the list of groups for all authenticated users.

Integrations with other authentication protocols (LDAP, SAML, Kerberos, alternate x509 schemes, etc) are available; for example using an authenticating proxy or the authentication webhook.


*[Content truncated]*

**Examples:**

Example 1 (bash):
```bash
openssl req -new -key jbeda.pem -out jbeda-csr.pem -subj "/CN=jbeda/O=app1/O=app2"
```

Example 2 (http):
```http
Authorization: Bearer 31ada4fd-adec-460c-809a-9e56ceb75269
```

Example 3 (http):
```http
Authorization: Bearer 781292.db7bc3a58fc5f07e
```

Example 4 (yaml):
```yaml
apiVersion: apps/v1 # this apiVersion is relevant as of Kubernetes 1.9
kind: Deployment
metadata:
  name: nginx-deployment
  namespace: default
spec:
  replicas: 3
  template:
    metadata:
    # ...
    spec:
      serviceAccountName: bob-the-bot
      containers:
      - name: nginx
        image: nginx:1.14.2
```

---

## Admission Control in Kubernetes

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#podtolerationrestriction

**Contents:**
- Admission Control in Kubernetes
- What are they?
  - Admission control extension points
  - Admission control phases
- Why do I need them?
- How do I turn on an admission controller?
    - Note:
- How do I turn off an admission controller?
- Which plugins are enabled by default?
- What does each admission controller do?

This page provides an overview of admission controllers.

An admission controller is a piece of code that intercepts requests to the Kubernetes API server prior to persistence of the resource, but after the request is authenticated and authorized.

Several important features of Kubernetes require an admission controller to be enabled in order to properly support the feature. As a result, a Kubernetes API server that is not properly configured with the right set of admission controllers is an incomplete server that will not support all the features you expect.

Admission controllers are code within the Kubernetes API server that check the data arriving in a request to modify a resource.

Admission controllers apply to requests that create, delete, or modify objects. Admission controllers can also block custom verbs, such as a request to connect to a pod via an API server proxy. Admission controllers do not (and cannot) block requests to read (get, watch or list) objects, because reads bypass the admission control layer.

Admission control mechanisms may be validating, mutating, or both. Mutating controllers may modify the data for the resource being modified; validating controllers may not.

The admission controllers in Kubernetes 1.34 consist of the list below, are compiled into the kube-apiserver binary, and may only be configured by the cluster administrator.

Within the full list, there are three special controllers: MutatingAdmissionWebhook, ValidatingAdmissionWebhook, and ValidatingAdmissionPolicy. The two webhook controllers execute the mutating and validating (respectively) admission control webhooks which are configured in the API. ValidatingAdmissionPolicy provides a way to embed declarative validation code within the API, without relying on any external HTTP callouts.

You can use these three admission controllers to customize cluster behavior at admission time.

The admission control process proceeds in two phases. In the first phase, mutating admission controllers are run. In the second phase, validating admission controllers are run. Note again that some of the controllers are both.

If any of the controllers in either phase reject the request, the entire request is rejected immediately and an error is returned to the end-user.

Finally, in addition to sometimes mutating the object in question, admission controllers may sometimes have side effects, that is, mutate related resources as part of request processing. Incrementing quota usage is the

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kube-apiserver --enable-admission-plugins=NamespaceLifecycle,LimitRanger ...
```

Example 2 (shell):
```shell
kube-apiserver --disable-admission-plugins=PodNodeSelector,AlwaysDeny ...
```

Example 3 (shell):
```shell
kube-apiserver -h | grep enable-admission-plugins
```

Example 4 (shell):
```shell
CertificateApproval, CertificateSigning, CertificateSubjectRestriction, DefaultIngressClass, DefaultStorageClass, DefaultTolerationSeconds, LimitRanger, MutatingAdmissionWebhook, NamespaceLifecycle, PersistentVolumeClaimResize, PodSecurity, Priority, ResourceQuota, RuntimeClass, ServiceAccount, StorageObjectInUseProtection, TaintNodesByCondition, ValidatingAdmissionPolicy, ValidatingAdmissionWebhook
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-image

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-resourceclaimtemplate

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-reviewer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-rbac

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-spec

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Using RBAC Authorization

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/rbac/

**Contents:**
- Using RBAC Authorization
- API objects
    - Caution:
  - Role and ClusterRole
    - Role example
    - ClusterRole example
  - RoleBinding and ClusterRoleBinding
    - RoleBinding examples
    - ClusterRoleBinding example
  - Referring to resources

Role-based access control (RBAC) is a method of regulating access to computer or network resources based on the roles of individual users within your organization.

RBAC authorization uses the rbac.authorization.k8s.io API group to drive authorization decisions, allowing you to dynamically configure policies through the Kubernetes API.

To enable RBAC, start the API server with the --authorization-config flag set to a file that includes the RBAC authorizer; for example:

Or, start the API server with the --authorization-mode flag set to a comma-separated list that includes RBAC; for example:

The RBAC API declares four kinds of Kubernetes object: Role, ClusterRole, RoleBinding and ClusterRoleBinding. You can describe or amend the RBAC objects using tools such as kubectl, just like any other Kubernetes object.

An RBAC Role or ClusterRole contains rules that represent a set of permissions. Permissions are purely additive (there are no "deny" rules).

A Role always sets permissions within a particular namespace; when you create a Role, you have to specify the namespace it belongs in.

ClusterRole, by contrast, is a non-namespaced resource. The resources have different names (Role and ClusterRole) because a Kubernetes object always has to be either namespaced or not namespaced; it can't be both.

ClusterRoles have several uses. You can use a ClusterRole to:

If you want to define a role within a namespace, use a Role; if you want to define a role cluster-wide, use a ClusterRole.

Here's an example Role in the "default" namespace that can be used to grant read access to pods:

A ClusterRole can be used to grant the same permissions as a Role. Because ClusterRoles are cluster-scoped, you can also use them to grant access to:

cluster-scoped resources (like nodes)

non-resource endpoints (like /healthz)

namespaced resources (like Pods), across all namespaces

For example: you can use a ClusterRole to allow a particular user to run kubectl get pods --all-namespaces

Here is an example of a ClusterRole that can be used to grant read access to secrets in any particular namespace, or across all namespaces (depending on how it is bound):

The name of a Role or a ClusterRole object must be a valid path segment name.

A role binding grants the permissions defined in a role to a user or set of users. It holds a list of subjects (users, groups, or service accounts), and a reference to the role being granted. A RoleBinding grants permissions within a specific namespace w

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: apiserver.config.k8s.io/v1
kind: AuthorizationConfiguration
authorizers:
  ...
  - type: RBAC
  ...
```

Example 2 (shell):
```shell
kube-apiserver --authorization-mode=...,RBAC --other-options --more-options
```

Example 3 (yaml):
```yaml
apiVersion: rbac.authorization.k8s.io/v1
kind: Role
metadata:
  namespace: default
  name: pod-reader
rules:
- apiGroups: [""] # "" indicates the core API group
  resources: ["pods"]
  verbs: ["get", "watch", "list"]
```

Example 4 (yaml):
```yaml
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  # "namespace" omitted since ClusterRoles are not namespaced
  name: secret-reader
rules:
- apiGroups: [""]
  #
  # at the HTTP level, the name of the resource for accessing Secret
  # objects is "secrets"
  resources: ["secrets"]
  verbs: ["get", "watch", "list"]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cluster-architect

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-persistent-volume-claim

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-apiserver

**URL:** https://kubernetes.io/docs/reference/generated/kube-apiserver/

**Contents:**
- kube-apiserver
- Synopsis
- Options
- Feedback

The Kubernetes API server validates and configures data for the api objects which include pods, services, replicationcontrollers, and others. The API Server services REST operations and provides the frontend to the cluster's shared state through which all other components interact.

File with admission control configuration.

The IP address on which to advertise the apiserver to members of the cluster. This address must be reachable by the rest of the cluster. If blank, the --bind-address will be used. If --bind-address is unspecified, the host's default interface will be used.

Aggregator reject forwarding redirect response back to client.

The map from metric-label to value allow-list of this label. The key's format is <MetricName>,<LabelName>. The value's format is <allowed_value>,<allowed_value>...e.g. metric1,label1='v1,v2,v3', metric1,label2='v1,v2,v3' metric2,label1='v1,v2,v3'.

The path to the manifest file that contains the allow-list mapping. The format of the file is the same as the flag --allow-metric-labels. Note that the flag --allow-metric-labels will override the manifest file.

If true, allow privileged containers. [default=false]

Enables anonymous requests to the secure port of the API server. Requests that are not rejected by another authentication method are treated as anonymous requests. Anonymous requests have a username of system:anonymous, and a group name of system:unauthenticated.

Identifiers of the API. The service account token authenticator will validate that tokens used against the API are bound to at least one of these audiences. If the --service-account-issuer flag is configured and this flag is not, this field defaults to a single element list containing the issuer URL.

The size of the buffer to store events before batching and writing. Only used in batch mode.

The maximum size of a batch. Only used in batch mode.

The amount of time to wait before force writing the batch that hadn't reached the max size. Only used in batch mode.

Maximum number of requests sent at the same moment if ThrottleQPS was not utilized before. Only used in batch mode.

Whether batching throttling is enabled. Only used in batch mode.

Maximum average number of batches per second. Only used in batch mode.

If set, the rotated log files will be compressed using gzip.

Format of saved audits. "legacy" indicates 1-line text format for each event. "json" indicates structured json format. Known formats are legacy,json.

The maximum number of days to 

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
kube-apiserver [flags]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-service-account

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Auditing

**URL:** https://kubernetes.io/docs/tasks/debug/debug-cluster/audit/

**Contents:**
- Auditing
    - Note:
- Audit policy
- Audit backends
    - Note:
  - Log backend
  - Webhook backend
- Event batching
- Parameter tuning
  - Log entry truncation

Kubernetes auditing provides a security-relevant, chronological set of records documenting the sequence of actions in a cluster. The cluster audits the activities generated by users, by applications that use the Kubernetes API, and by the control plane itself.

Auditing allows cluster administrators to answer the following questions:

Audit records begin their lifecycle inside the kube-apiserver component. Each request on each stage of its execution generates an audit event, which is then pre-processed according to a certain policy and written to a backend. The policy determines what's recorded and the backends persist the records. The current backend implementations include logs files and webhooks.

Each request can be recorded with an associated stage. The defined stages are:

The audit logging feature increases the memory consumption of the API server because some context required for auditing is stored for each request. Memory consumption depends on the audit logging configuration.

Audit policy defines rules about what events should be recorded and what data they should include. The audit policy object structure is defined in the audit.k8s.io API group. When an event is processed, it's compared against the list of rules in order. The first matching rule sets the audit level of the event. The defined audit levels are:

You can pass a file with the policy to kube-apiserver using the --audit-policy-file flag. If the flag is omitted, no events are logged. Note that the rules field must be provided in the audit policy file. A policy with no (0) rules is treated as illegal.

Below is an example audit policy file:

You can use a minimal audit policy file to log all requests at the Metadata level:

If you're crafting your own audit profile, you can use the audit profile for Google Container-Optimized OS as a starting point. You can check the configure-helper.sh script, which generates an audit policy file. You can see most of the audit policy file by looking directly at the script.

You can also refer to the Policy configuration reference for details about the fields defined.

Audit backends persist audit events to an external storage. Out of the box, the kube-apiserver provides two backends:

In all cases, audit events follow a structure defined by the Kubernetes API in the audit.k8s.io API group.

In case of patches, request body is a JSON array with patch operations, not a JSON object with an appropriate Kubernetes API object. For example, the following re

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: audit.k8s.io/v1 # This is required.
kind: Policy
# Don't generate audit events for all requests in RequestReceived stage.
omitStages:
  - "RequestReceived"
rules:
  # Log pod changes at RequestResponse level
  - level: RequestResponse
    resources:
    - group: ""
      # Resource "pods" doesn't match requests to any subresource of pods,
      # which is consistent with the RBAC policy.
      resources: ["pods"]
  # Log "pods/log", "pods/status" at Metadata level
  - level: Metadata
    resources:
    - group: ""
      resources: ["pods/log", "pods/status"]

  # Don't log requests
...
```

Example 2 (yaml):
```yaml
# Log all requests at the Metadata level.
apiVersion: audit.k8s.io/v1
kind: Policy
rules:
- level: Metadata
```

Example 3 (json):
```json
[
  {
    "op": "replace",
    "path": "/spec/parallelism",
    "value": 0
  },
  {
    "op": "remove",
    "path": "/spec/template/spec/containers/0/terminationMessagePolicy"
  }
]
```

Example 4 (yaml):
```yaml
- --audit-policy-file=/etc/kubernetes/audit-policy.yaml
  - --audit-log-path=/var/log/kubernetes/audit/audit.log
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-certificate

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-volume-plugin

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kubelet

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/kubelet

**Contents:**
- kubelet
- Synopsis
- Options
- Feedback

The kubelet is the primary "node agent" that runs on each node. It can register the node with the apiserver using one of: the hostname; a flag to override the hostname; or specific logic for a cloud provider.

The kubelet works in terms of a PodSpec. A PodSpec is a YAML or JSON object that describes a pod. The kubelet takes a set of PodSpecs that are provided through various mechanisms (primarily through the apiserver) and ensures that the containers described in those PodSpecs are running and healthy. The kubelet doesn't manage containers which were not created by Kubernetes.

Other than from an PodSpec from the apiserver, there are two ways that a container manifest can be provided to the Kubelet.

File: Path passed as a flag on the command line. Files under this path will be monitored periodically for updates. The monitoring period is 20s by default and is configurable via a flag.

HTTP endpoint: HTTP endpoint passed as a parameter on the command line. This endpoint is checked every 20 seconds (also configurable with a flag).

The IP address for the Kubelet to serve on (set to '0.0.0.0' or '::' for listening on all interfaces and IP address families) (DEPRECATED: This parameter should be set via the config file specified by the Kubelet's --config flag. See https://kubernetes.io/docs/tasks/administer-cluster/kubelet-config-file/ for more information.)

Comma-separated whitelist of unsafe sysctls or unsafe sysctl patterns (ending in *). Use these at your own risk. (DEPRECATED: This parameter should be set via the config file specified by the Kubelet's --config flag. See https://kubernetes.io/docs/tasks/administer-cluster/kubelet-config-file/ for more information.)

Enables anonymous requests to the Kubelet server. Requests that are not rejected by another authentication method are treated as anonymous requests. Anonymous requests have a username of system:anonymous, and a group name of system:unauthenticated. (DEPRECATED: This parameter should be set via the config file specified by the Kubelet's --config flag. See https://kubernetes.io/docs/tasks/administer-cluster/kubelet-config-file/ for more information.)

Use the TokenReview API to determine authentication for bearer tokens. (DEPRECATED: This parameter should be set via the config file specified by the Kubelet's --config flag. See https://kubernetes.io/docs/tasks/administer-cluster/kubelet-config-file/ for more information.)

The duration to cache responses from the webhook token authenticator. (DEPR

*[Content truncated]*

**Examples:**

Example 1 (javascript):
```javascript
kubelet [flags]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-dynamicvolumeprovisioning

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-userns

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-apiserver Admission (v1)

**URL:** https://kubernetes.io/docs/reference/config-api/apiserver-admission.v1/

**Contents:**
- kube-apiserver Admission (v1)
- Resource Types
- AdmissionReview
- AdmissionRequest
- AdmissionResponse
- Operation
- PatchType
- Feedback

AdmissionReview describes an admission review request/response.

Request describes the attributes for the admission request.

Response describes the attributes for the admission response.

AdmissionRequest describes the admission.Attributes for the admission request.

UID is an identifier for the individual request/response. It allows us to distinguish instances of requests which are otherwise identical (parallel requests, requests when earlier requests did not modify etc) The UID is meant to track the round trip (request/response) between the KAS and the WebHook, not the user request. It is suitable for correlating log entries between the webhook and apiserver, for either auditing or debugging.

Kind is the fully-qualified type of object being submitted (for example, v1.Pod or autoscaling.v1.Scale)

Resource is the fully-qualified resource being requested (for example, v1.pods)

SubResource is the subresource being requested, if any (for example, "status" or "scale")

RequestKind is the fully-qualified type of the original API request (for example, v1.Pod or autoscaling.v1.Scale). If this is specified and differs from the value in "kind", an equivalent match and conversion was performed.

For example, if deployments can be modified via apps/v1 and apps/v1beta1, and a webhook registered a rule of apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"] and matchPolicy: Equivalent, an API request to apps/v1beta1 deployments would be converted and sent to the webhook with kind: {group:"apps", version:"v1", kind:"Deployment"} (matching the rule the webhook registered for), and requestKind: {group:"apps", version:"v1beta1", kind:"Deployment"} (indicating the kind of the original API request).

See documentation for the "matchPolicy" field in the webhook configuration type for more details.

RequestResource is the fully-qualified resource of the original API request (for example, v1.pods). If this is specified and differs from the value in "resource", an equivalent match and conversion was performed.

For example, if deployments can be modified via apps/v1 and apps/v1beta1, and a webhook registered a rule of apiGroups:["apps"], apiVersions:["v1"], resources: ["deployments"] and matchPolicy: Equivalent, an API request to apps/v1beta1 deployments would be converted and sent to the webhook with resource: {group:"apps", version:"v1", resource:"deployments"} (matching the resource the webhook registered for), and requestResource: {group:"apps", version:"v1

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-flexvolume

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-contributor

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## GETTING STARTED

**URL:** https://kubernetes.io/docs/reference/generated/kubectl/kubectl-commands/#describe

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cla

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-CustomResourceDefinition

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-container-env-variables

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-selector

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-apiserver Audit Configuration (v1)

**URL:** https://kubernetes.io/docs/reference/config-api/apiserver-audit.v1/

**Contents:**
- kube-apiserver Audit Configuration (v1)
- Resource Types
- Event
- EventList
- Policy
- PolicyList
- GroupResources
- Level
- ObjectReference
- PolicyRule

Event captures all the information that can be included in an API audit log.

AuditLevel at which event was generated

Unique audit ID, generated for each request.

Stage of the request handling when this event instance was generated.

RequestURI is the request URI as sent by the client to a server.

Verb is the kubernetes verb associated with the request. For non-resource requests, this is the lower-cased HTTP method.

Authenticated user information.

Impersonated user information.

Source IPs, from where the request originated and intermediate proxies. The source IPs are listed from (in order):

UserAgent records the user agent string reported by the client. Note that the UserAgent is provided by the client, and must not be trusted.

Object reference this request is targeted at. Does not apply for List-type requests, or non-resource requests.

The response status, populated even when the ResponseObject is not a Status type. For successful responses, this will only include the Code and StatusSuccess. For non-status type error responses, this will be auto-populated with the error Message.

API object from the request, in JSON format. The RequestObject is recorded as-is in the request (possibly re-encoded as JSON), prior to version conversion, defaulting, admission or merging. It is an external versioned object type, and may not be a valid object on its own. Omitted for non-resource requests. Only logged at Request Level and higher.

API object returned in the response, in JSON. The ResponseObject is recorded after conversion to the external type, and serialized as JSON. Omitted for non-resource requests. Only logged at Response Level.

Time the request reached the apiserver.

Time the request reached current audit stage.

Annotations is an unstructured key value map stored with an audit event that may be set by plugins invoked in the request serving chain, including authentication, authorization and admission plugins. Note that these annotations are for the audit event, and do not correspond to the metadata.annotations of the submitted object. Keys should uniquely identify the informing component to avoid name collisions (e.g. podsecuritypolicy.admission.k8s.io/policy). Values should be short. Annotations are included in the Metadata level.

EventList is a list of audit Events.

Policy defines the configuration of audit logging, and the rules for how different request categories are logged.

ObjectMeta is included for interoperability with API infrastructu

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-kube-controller-manager

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-aggregation-layer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-proxy Configuration (v1alpha1)

**URL:** https://kubernetes.io/docs/reference/config-api/kube-proxy-config.v1alpha1/

**Contents:**
- kube-proxy Configuration (v1alpha1)
- Resource Types
- FormatOptions
- JSONOptions
- LogFormatFactory
- LoggingConfiguration
- LoggingOptions
- OutputRoutingOptions
- TextOptions
- TimeOrMetaDuration

FormatOptions contains options for the different logging formats.

[Alpha] Text contains options for logging format "text". Only available when the LoggingAlphaOptions feature gate is enabled.

[Alpha] JSON contains options for logging format "json". Only available when the LoggingAlphaOptions feature gate is enabled.

JSONOptions contains options for logging format "json".

LogFormatFactory provides support for a certain additional, non-default log format.

KubeProxyConfiguration

LoggingConfiguration contains logging options.

Format Flag specifies the structure of log messages. default value of format is text

Maximum time between log flushes. If a string, parsed as a duration (i.e. "1s") If an int, the maximum number of nanoseconds (i.e. 1s = 1000000000). Ignored if the selected logging backend writes log messages without buffering.

Verbosity is the threshold that determines which log messages are logged. Default is zero which logs only the most important messages. Higher values enable additional messages. Error messages are always logged.

VModule overrides the verbosity threshold for individual files. Only supported for "text" log format.

[Alpha] Options holds additional parameters that are specific to the different logging formats. Only the options for the selected format get used, but all of them get validated. Only available when the LoggingAlphaOptions feature gate is enabled.

LoggingOptions can be used with ValidateAndApplyWithOptions to override certain global defaults.

ErrorStream can be used to override the os.Stderr default.

InfoStream can be used to override the os.Stdout default.

OutputRoutingOptions contains options that are supported by both "text" and "json".

[Alpha] SplitStream redirects error messages to stderr while info messages go to stdout, with buffering. The default is to write both to stdout, without buffering. Only available when the LoggingAlphaOptions feature gate is enabled.

[Alpha] InfoBufferSize sets the size of the info stream when using split streams. The default is zero, which disables buffering. Only available when the LoggingAlphaOptions feature gate is enabled.

TextOptions contains options for logging format "text".

TimeOrMetaDuration is present only for backwards compatibility for the flushFrequency field, and new fields should use metav1.Duration.

Duration holds the duration

SerializeAsString controls whether the value is serialized as a string or an integer

(Alias of []k8s.io/component-base/logs/api/

*[Content truncated]*

---

## JSONPath Support

**URL:** https://kubernetes.io/docs/reference/kubectl/jsonpath/

**Contents:**
- JSONPath Support
    - Note:
- Functions in Kubernetes JSONPath
- Using JSONPath expressions with kubectl
    - Note:
- Regular expressions in JSONPath
- Feedback

The kubectl tool supports JSONPath templates as an output format.

A JSONPath template is composed of JSONPath expressions enclosed by curly braces: { and }. Kubectl uses JSONPath expressions to filter on specific fields in the JSON object and format the output. In addition to the original JSONPath template syntax, the following functions and syntax are valid:

The $ operator is optional since the expression always starts from the root object by default.

The result object is printed as its String() function.

Given the JSON input:

Examples using kubectl and JSONPath expressions:

Or, with a "my_pod" and "my_namespace" (adjust these names to your environment):

On Windows, you must double quote any JSONPath template that contains spaces (not single quote as shown above for bash). This in turn means that you must use a single quote or escaped double quote around any literals in the template. For example:

JSONPath regular expressions are not supported. If you want to match using regular expressions, you can use a tool such as jq.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

**Examples:**

Example 1 (json):
```json
{
  "kind": "List",
  "items":[
    {
      "kind":"None",
      "metadata":{
        "name":"127.0.0.1",
        "labels":{
          "kubernetes.io/hostname":"127.0.0.1"
        }
      },
      "status":{
        "capacity":{"cpu":"4"},
        "addresses":[{"type": "LegacyHostIP", "address":"127.0.0.1"}]
      }
    },
    {
      "kind":"None",
      "metadata":{"name":"127.0.0.2"},
      "status":{
        "capacity":{"cpu":"8"},
        "addresses":[
          {"type": "LegacyHostIP", "address":"127.0.0.2"},
          {"type": "another", "address":"127.0.0.3"}
        ]
      }
    }
  
...
```

Example 2 (shell):
```shell
kubectl get pods -o json
kubectl get pods -o=jsonpath='{@}'
kubectl get pods -o=jsonpath='{.items[0]}'
kubectl get pods -o=jsonpath='{.items[0].metadata.name}'
kubectl get pods -o=jsonpath="{.items[*]['metadata.name', 'status.capacity']}"
kubectl get pods -o=jsonpath='{range .items[*]}{.metadata.name}{"\t"}{.status.startTime}{"\n"}{end}'
kubectl get pods -o=jsonpath='{.items[0].metadata.labels.kubernetes\.io/hostname}'
```

Example 3 (shell):
```shell
kubectl get pod/my_pod -n my_namespace -o=jsonpath='{@}'
kubectl get pod/my_pod -n my_namespace -o=jsonpath='{.metadata.name}'
kubectl get pod/my_pod -n my_namespace -o=jsonpath='{.status}'
```

Example 4 (cmd):
```cmd
kubectl get pods -o=jsonpath="{range .items[*]}{.metadata.name}{'\t'}{.status.startTime}{'\n'}{end}"
kubectl get pods -o=jsonpath="{range .items[*]}{.metadata.name}{\"\t\"}{.status.startTime}{\"\n\"}{end}"
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cluster-infrastructure

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#applyset-kubernetes-io-contains-group-kinds

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-endpoint-slice

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-feature-gate

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Client Libraries

**URL:** https://kubernetes.io/docs/reference/using-api/client-libraries/

**Contents:**
- Client Libraries
- Officially-supported Kubernetes client libraries
- Community-maintained client libraries
- Feedback

This page contains an overview of the client libraries for using the Kubernetes API from various programming languages.

To write applications using the Kubernetes REST API, you do not need to implement the API calls and request/response types yourself. You can use a client library for the programming language you are using.

Client libraries often handle common tasks such as authentication for you. Most client libraries can discover and use the Kubernetes Service Account to authenticate if the API client is running inside the Kubernetes cluster, or can understand the kubeconfig file format to read the credentials and the API Server address.

The following client libraries are officially maintained by Kubernetes SIG API Machinery.

The following Kubernetes API client libraries are provided and maintained by their authors, not the Kubernetes team.

Items on this page refer to third party products or projects that provide functionality required by Kubernetes. The Kubernetes project authors aren't responsible for those third-party products or projects. See the CNCF website guidelines for more details.

You should read the content guide before proposing a change that adds an extra third-party link.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-applications

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cadvisor

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-minikube

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-csi

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-selector

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-api-eviction

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-event

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## GETTING STARTED

**URL:** https://kubernetes.io/docs/reference/generated/kubectl/kubectl-commands#apply

---

## Audit Annotations

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/audit-annotations/#pod-security-kubernetes-io-audit-violations

**Contents:**
- Audit Annotations
    - Note:
- k8s.io/deprecated
- k8s.io/removed-release
- pod-security.kubernetes.io/exempt
- pod-security.kubernetes.io/enforce-policy
- pod-security.kubernetes.io/audit-violations
- apiserver.latency.k8s.io/etcd
- apiserver.latency.k8s.io/decode-response-object
- apiserver.latency.k8s.io/apf-queue-wait

This page serves as a reference for the audit annotations of the kubernetes.io namespace. These annotations apply to Event object from API group audit.k8s.io.

Example: k8s.io/deprecated: "true"

Value must be "true" or "false". The value "true" indicates that the request used a deprecated API version.

Example: k8s.io/removed-release: "1.22"

Value must be in the format "<MAJOR>.<MINOR>". It is set to target the removal release on requests made to deprecated API versions with a target removal release.

Example: pod-security.kubernetes.io/exempt: namespace

Value must be one of user, namespace, or runtimeClass which correspond to Pod Security Exemption dimensions. This annotation indicates on which dimension was based the exemption from the PodSecurity enforcement.

Example: pod-security.kubernetes.io/enforce-policy: restricted:latest

Value must be privileged:<version>, baseline:<version>, restricted:<version> which correspond to Pod Security Standard levels accompanied by a version which must be latest or a valid Kubernetes version in the format v<MAJOR>.<MINOR>. This annotations informs about the enforcement level that allowed or denied the pod during PodSecurity admission.

See Pod Security Standards for more information.

Example: pod-security.kubernetes.io/audit-violations: would violate PodSecurity "restricted:latest": allowPrivilegeEscalation != false (container "example" must set securityContext.allowPrivilegeEscalation=false), ...

Value details an audit policy violation, it contains the Pod Security Standard level that was transgressed as well as the specific policies on the fields that were violated from the PodSecurity enforcement.

See Pod Security Standards for more information.

Example: apiserver.latency.k8s.io/etcd: "4.730661757s"

This annotation indiactes the measure of latency incurred inside the storage layer, it accounts for the time it takes to send data to the etcd and get the complete response back.

The value of this audit annotation does not include the time incurred in admission, or validation.

Example: apiserver.latency.k8s.io/decode-response-object: "450.6649ns"

This annotation records the time taken to decode the response received from the storage layer (etcd)

Example: apiserver.latency.k8s.io/apf-queue-wait: "100ns"

This annotation records the time that a request spent queued due to API server priorities.

See API Priority and Fairness (APF) for more information about this mechanism.

Example: authorization.k8s.io/decis

*[Content truncated]*

---

## Scheduling Policies

**URL:** https://kubernetes.io/docs/reference/scheduling/policies/

**Contents:**
- Scheduling Policies
- What's next
- Feedback

In Kubernetes versions before v1.23, a scheduling policy can be used to specify the predicates and priorities process. For example, you can set a scheduling policy by running kube-scheduler --policy-config-file <filename> or kube-scheduler --policy-configmap <ConfigMap>.

This scheduling policy is not supported since Kubernetes v1.23. Associated flags policy-config-file, policy-configmap, policy-configmap-namespace and use-legacy-policy-config are also not supported. Instead, use the Scheduler Configuration to achieve similar behavior.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Quantity

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

**Contents:**
- Quantity
- Feedback

import "k8s.io/apimachinery/pkg/api/resource"

Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.

The serialization format is:

No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.

When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.

Before serializing, Quantity will be put in "canonical form". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:

The sign will be omitted unless the number is negative.

Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.

Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)

This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

**Examples:**

Example 1 (unknown):
```unknown
\<quantity>        ::= \<signedNumber>\<suffix>

  (Note that \<suffix> may be empty, from the "" case in \<decimalSI>.)

\<digit>           ::= 0 | 1 | ... | 9 \<digits>          ::= \<digit> | \<digit>\<digits> \<number>          ::= \<digits> | \<digits>.\<digits> | \<digits>. | .\<digits> \<sign>            ::= "+" | "-" \<signedNumber>    ::= \<number> | \<sign>\<number> \<suffix>          ::= \<binarySI> | \<decimalExponent> | \<decimalSI> \<binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei

  (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html)

\<decimalSI
...
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-container-runtime

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-app-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-affinity

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kubeconfig (v1)

**URL:** https://kubernetes.io/docs/reference/config-api/kubeconfig.v1/

**Contents:**
- kubeconfig (v1)
- Resource Types
- Config
- AuthInfo
- AuthProviderConfig
- Cluster
- Context
- ExecConfig
- ExecEnvVar
- ExecInteractiveMode

Config holds the information needed to build connect to remote kubernetes clusters as a given user

Legacy field from pkg/api/types.go TypeMeta. TODO(jlowdermilk): remove this after eliminating downstream dependencies.

Legacy field from pkg/api/types.go TypeMeta. TODO(jlowdermilk): remove this after eliminating downstream dependencies.

Preferences holds general information to be use for cli interactions Deprecated: this field is deprecated in v1.34. It is not used by any of the Kubernetes components.

Clusters is a map of referenceable names to cluster configs

AuthInfos is a map of referenceable names to user configs

Contexts is a map of referenceable names to context configs

CurrentContext is the name of the context that you would like to use by default

Extensions holds additional information. This is useful for extenders so that reads and writes don't clobber unknown fields

AuthInfo contains information that describes identity information. This is use to tell the kubernetes cluster who you are.

ClientCertificate is the path to a client cert file for TLS.

ClientCertificateData contains PEM-encoded data from a client cert file for TLS. Overrides ClientCertificate

ClientKey is the path to a client key file for TLS.

ClientKeyData contains PEM-encoded data from a client key file for TLS. Overrides ClientKey

Token is the bearer token for authentication to the kubernetes cluster.

TokenFile is a pointer to a file that contains a bearer token (as described above). If both Token and TokenFile are present, the TokenFile will be periodically read and the last successfully read value takes precedence over Token.

Impersonate is the username to impersonate. The name matches the flag.

ImpersonateUID is the uid to impersonate.

ImpersonateGroups is the groups to impersonate.

ImpersonateUserExtra contains additional information for impersonated user.

Username is the username for basic authentication to the kubernetes cluster.

Password is the password for basic authentication to the kubernetes cluster.

AuthProvider specifies a custom authentication plugin for the kubernetes cluster.

Exec specifies a custom exec-based authentication plugin for the kubernetes cluster.

Extensions holds additional information. This is useful for extenders so that reads and writes don't clobber unknown fields

AuthProviderConfig holds the configuration for a specified auth provider.

Cluster contains information about how to communicate with a kubernetes cluster

Server is 

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-downstream

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Kubernetes Metrics (v1beta1)

**URL:** https://kubernetes.io/docs/reference/external-api/metrics.v1beta1/

**Contents:**
- Kubernetes Metrics (v1beta1)
- Resource Types
- NodeMetrics
- NodeMetricsList
- PodMetrics
- PodMetricsList
- ContainerMetrics
- Feedback

Package v1beta1 is the v1beta1 version of the metrics API.

NodeMetrics sets resource usage metrics of a node.

Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

The following fields define time interval from which metrics were collected from the interval [Timestamp-Window, Timestamp].

The memory usage is the memory working set.

NodeMetricsList is a list of NodeMetrics.

Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

List of node metrics.

PodMetrics sets resource usage metrics of a pod.

Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

The following fields define time interval from which metrics were collected from the interval [Timestamp-Window, Timestamp].

Metrics for all containers are collected within the same time window.

PodMetricsList is a list of PodMetrics.

Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds

ContainerMetrics sets resource usage metrics of a container.

Container name corresponding to the one from pod.spec.containers.

The memory usage is the memory working set.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-init-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-container-lifecycle-hooks

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-aggregation-layer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Managing Service Accounts

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/service-accounts-admin/#external-serviceaccount-token-signing-and-key-management

**Contents:**
- Managing Service Accounts
- Before you begin
- User accounts versus service accounts
- Bound service account tokens
  - Additional metadata in Pod bound tokens
  - Verifying and inspecting private claims
    - Note:
    - Schema for service account private claims
    - Note:
- Bound service account token volume mechanism

A ServiceAccount provides an identity for processes that run in a Pod.

A process inside a Pod can use the identity of its associated service account to authenticate to the cluster's API server.

For an introduction to service accounts, read configure service accounts.

This task guide explains some of the concepts behind ServiceAccounts. The guide also explains how to obtain or revoke tokens that represent ServiceAccounts, and how to (optionally) bind a ServiceAccount's validity to the lifetime of an API object.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

To be able to follow these steps exactly, ensure you have a namespace named examplens. If you don't, create one by running:

Kubernetes distinguishes between the concept of a user account and a service account for a number of reasons:

ServiceAccount tokens can be bound to API objects that exist in the kube-apiserver. This can be used to tie the validity of a token to the existence of another API object. Supported object types are as follows:

When a token is bound to an object, the object's metadata.name and metadata.uid are stored as extra 'private claims' in the issued JWT.

When a bound token is presented to the kube-apiserver, the service account authenticator will extract and verify these claims. If the referenced object or the ServiceAccount is pending deletion (for example, due to finalizers), then for any instant that is 60 seconds (or more) after the .metadata.deletionTimestamp date, authentication with that token would fail. If the referenced object no longer exists (or its metadata.uid does not match), the request will not be authenticated.

When a service account token is bound to a Pod object, additional metadata is also embedded into the token that indicates the value of the bound pod's spec.nodeName field, and the uid of that Node, if available.

This node information is not verified by the kube-apiserver when the token is used for authentication. It is included so integrators do not have to fetch Pod or Node API objects to check the associated Node name and uid when inspecting a JWT.

The TokenReview API can be used to verify and extract private claims from a tok

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kubectl create namespace examplens
```

Example 2 (shell):
```shell
kubectl create token my-sa --bound-object-kind="Pod" --bound-object-name="test-pod"
```

Example 3 (yaml):
```yaml
apiVersion: authentication.k8s.io/v1
kind: TokenReview
spec:
  token: <token from step 2>
```

Example 4 (shell):
```shell
# use '-o yaml' to inspect the output
kubectl create -o yaml -f tokenreview.yaml
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-sig

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-duration

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## WebhookAdmission Configuration (v1)

**URL:** https://kubernetes.io/docs/reference/config-api/apiserver-webhookadmission.v1/

**Contents:**
- WebhookAdmission Configuration (v1)
- Resource Types
- WebhookAdmission
- Feedback

Package v1 is the v1 version of the API.

WebhookAdmission provides configuration for the webhook admission controller.

KubeConfigFile is the path to the kubeconfig file.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetes-io-config-hash

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Common Parameters

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/common-parameters/common-parameters/

**Contents:**
- Common Parameters
- allowWatchBookmarks
- continue
- dryRun
- fieldManager
- fieldSelector
- fieldValidation
- force
- gracePeriodSeconds
- ignoreStoreReadErrorWithClusterBreakingPotential

allowWatchBookmarks requests watch events with type "BOOKMARK". Servers that do not implement bookmarks may ignore this flag and bookmarks are sent at the server's discretion. Clients should not assume bookmarks are returned at any specific interval, nor may they assume the server will send any BOOKMARK event during a session. If this is not a watch, this field is ignored.

The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the "next key".

This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.

When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed

fieldManager is a name associated with the actor or entity that is making these changes. The value must be less than or 128 characters long, and only contain printable characters, as defined by https://golang.org/pkg/unicode/#IsPrint.

A selector to restrict the list of returned objects by their fields. Defaults to everything.

fieldValidation instructs the server on how to handle objects in the request (POST/PUT/PATCH) containing unknown or duplicate fields. Valid values are: - Ignore: This will ignore any unknown fields that are silently dropped from the object, and will ignore all but the last duplicate field that the decoder encounters.

*[Content truncated]*

---

## Kubelet CredentialProvider (v1)

**URL:** https://kubernetes.io/docs/reference/config-api/kubelet-credentialprovider.v1/

**Contents:**
- Kubelet CredentialProvider (v1)
- Resource Types
- CredentialProviderRequest
- CredentialProviderResponse
- AuthConfig
- PluginCacheKeyType
- Feedback

CredentialProviderRequest includes the image that the kubelet requires authentication for. Kubelet will pass this request object to the plugin via stdin. In general, plugins should prefer responding with the same apiVersion they were sent.

image is the container image that is being pulled as part of the credential provider plugin request. Plugins may optionally parse the image to extract any information required to fetch credentials.

serviceAccountToken is the service account token bound to the pod for which the image is being pulled. This token is only sent to the plugin if the tokenAttributes.serviceAccountTokenAudience field is configured in the kubelet's credential provider configuration.

serviceAccountAnnotations is a map of annotations on the service account bound to the pod for which the image is being pulled. The list of annotations in the service account that need to be passed to the plugin is configured in the kubelet's credential provider configuration.

CredentialProviderResponse holds credentials that the kubelet should use for the specified image provided in the original request. Kubelet will read the response from the plugin via stdout. This response should be set to the same apiVersion as CredentialProviderRequest.

cacheKeyType indicates the type of caching key to use based on the image provided in the request. There are three valid values for the cache key type: Image, Registry, and Global. If an invalid value is specified, the response will NOT be used by the kubelet.

cacheDuration indicates the duration the provided credentials should be cached for. The kubelet will use this field to set the in-memory cache duration for credentials in the AuthConfig. If null, the kubelet will use defaultCacheDuration provided in CredentialProviderConfig. If set to 0, the kubelet will not cache the provided AuthConfig.

auth is a map containing authentication information passed into the kubelet. Each key is a match image string (more on this below). The corresponding authConfig value should be valid for all images that match against this key. A plugin should set this field to null if no valid credentials can be returned for the requested image.

Each key in the map is a pattern which can optionally contain a port and a path. Globs can be used in the domain, but not in the port or the path. Globs are supported as subdomains like '.k8s.io' or 'k8s..io', and top-level-domains such as 'k8s.'. Matching partial subdomains like 'app.k8s.io' is also supporte

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-static-pod

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authenticating

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authentication/

**Contents:**
- Authenticating
- Users in Kubernetes
- Authentication strategies
    - Note:
- Authentication methods
  - X.509 client certificates
    - Putting a bearer token in a request
  - Bootstrap tokens
  - Service account tokens
    - Note:

This page provides an overview of authentication in Kubernetes, with a focus on authentication to the Kubernetes API.

All Kubernetes clusters have two categories of users: service accounts managed by Kubernetes, and normal users.

It is assumed that a cluster-independent service manages normal users in the following ways:

In this regard, Kubernetes does not have objects which represent normal user accounts. Normal users cannot be added to a cluster through an API call.

Even though a normal user cannot be added via an API call, any user that presents a valid certificate signed by the cluster's certificate authority (CA) is considered authenticated. In this configuration, Kubernetes determines the username from the common name field in the 'subject' of the cert (e.g., "/CN=bob"). From there, the role based access control (RBAC) sub-system would determine whether the user is authorized to perform a specific operation on a resource.

In contrast, service accounts are users managed by the Kubernetes API. They are bound to specific namespaces, and created automatically by the API server or manually through API calls. Service accounts are tied to a set of credentials stored as Secrets, which are mounted into pods allowing in-cluster processes to talk to the Kubernetes API.

API requests are tied to either a normal user or a service account, or are treated as anonymous requests. This means every process inside or outside the cluster, from a human user typing kubectl on a workstation, to kubelets on nodes, to members of the control plane, must authenticate when making requests to the API server, or be treated as an anonymous user.

Kubernetes uses client certificates, bearer tokens, or an authenticating proxy to authenticate API requests through authentication plugins. As HTTP requests are made to the API server, plugins attempt to associate the following attributes with the request:

You can enable multiple authentication methods at once. You should usually use at least two methods:

When multiple authenticator modules are enabled, the first module to successfully authenticate the request short-circuits evaluation. The API server does not guarantee the order authenticators run in.

The system:authenticated group is included in the list of groups for all authenticated users.

Integrations with other authentication protocols (LDAP, SAML, Kerberos, alternate x509 schemes, etc) are available; for example using an authenticating proxy or the authentication webhook.


*[Content truncated]*

**Examples:**

Example 1 (bash):
```bash
openssl req -new -key jbeda.pem -out jbeda-csr.pem -subj "/CN=jbeda/O=app1/O=app2"
```

Example 2 (http):
```http
Authorization: Bearer 31ada4fd-adec-460c-809a-9e56ceb75269
```

Example 3 (http):
```http
Authorization: Bearer 781292.db7bc3a58fc5f07e
```

Example 4 (yaml):
```yaml
apiVersion: apps/v1 # this apiVersion is relevant as of Kubernetes 1.9
kind: Deployment
metadata:
  name: nginx-deployment
  namespace: default
spec:
  replicas: 3
  template:
    metadata:
    # ...
    spec:
      serviceAccountName: bob-the-bot
      containers:
      - name: nginx
        image: nginx:1.14.2
```

---

## Admission Control in Kubernetes

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#alwayspullimages

**Contents:**
- Admission Control in Kubernetes
- What are they?
  - Admission control extension points
  - Admission control phases
- Why do I need them?
- How do I turn on an admission controller?
    - Note:
- How do I turn off an admission controller?
- Which plugins are enabled by default?
- What does each admission controller do?

This page provides an overview of admission controllers.

An admission controller is a piece of code that intercepts requests to the Kubernetes API server prior to persistence of the resource, but after the request is authenticated and authorized.

Several important features of Kubernetes require an admission controller to be enabled in order to properly support the feature. As a result, a Kubernetes API server that is not properly configured with the right set of admission controllers is an incomplete server that will not support all the features you expect.

Admission controllers are code within the Kubernetes API server that check the data arriving in a request to modify a resource.

Admission controllers apply to requests that create, delete, or modify objects. Admission controllers can also block custom verbs, such as a request to connect to a pod via an API server proxy. Admission controllers do not (and cannot) block requests to read (get, watch or list) objects, because reads bypass the admission control layer.

Admission control mechanisms may be validating, mutating, or both. Mutating controllers may modify the data for the resource being modified; validating controllers may not.

The admission controllers in Kubernetes 1.34 consist of the list below, are compiled into the kube-apiserver binary, and may only be configured by the cluster administrator.

Within the full list, there are three special controllers: MutatingAdmissionWebhook, ValidatingAdmissionWebhook, and ValidatingAdmissionPolicy. The two webhook controllers execute the mutating and validating (respectively) admission control webhooks which are configured in the API. ValidatingAdmissionPolicy provides a way to embed declarative validation code within the API, without relying on any external HTTP callouts.

You can use these three admission controllers to customize cluster behavior at admission time.

The admission control process proceeds in two phases. In the first phase, mutating admission controllers are run. In the second phase, validating admission controllers are run. Note again that some of the controllers are both.

If any of the controllers in either phase reject the request, the entire request is rejected immediately and an error is returned to the end-user.

Finally, in addition to sometimes mutating the object in question, admission controllers may sometimes have side effects, that is, mutate related resources as part of request processing. Incrementing quota usage is the

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kube-apiserver --enable-admission-plugins=NamespaceLifecycle,LimitRanger ...
```

Example 2 (shell):
```shell
kube-apiserver --disable-admission-plugins=PodNodeSelector,AlwaysDeny ...
```

Example 3 (shell):
```shell
kube-apiserver -h | grep enable-admission-plugins
```

Example 4 (shell):
```shell
CertificateApproval, CertificateSigning, CertificateSubjectRestriction, DefaultIngressClass, DefaultStorageClass, DefaultTolerationSeconds, LimitRanger, MutatingAdmissionWebhook, NamespaceLifecycle, PersistentVolumeClaimResize, PodSecurity, Priority, ResourceQuota, RuntimeClass, ServiceAccount, StorageObjectInUseProtection, TaintNodesByCondition, ValidatingAdmissionPolicy, ValidatingAdmissionWebhook
```

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#volume-kubernetes-io-storage-provisioner

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-node

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cloud-controller-manager

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Kubernetes Custom Metrics (v1beta2)

**URL:** https://kubernetes.io/docs/reference/external-api/custom-metrics.v1beta2/

**Contents:**
- Kubernetes Custom Metrics (v1beta2)
- Resource Types
- MetricListOptions
- MetricValue
- MetricValueList
- MetricIdentifier
- Feedback

Package v1beta2 is the v1beta2 version of the custom_metrics API.

MetricListOptions is used to select metrics by their label selectors

A selector to restrict the list of returned objects by their labels. Defaults to everything.

A selector to restrict the list of returned metrics by their labels

MetricValue is the metric value for some object

a reference to the described object

indicates the time at which the metrics were produced

indicates the window ([Timestamp-Window, Timestamp]) from which these metrics were calculated, when returning rate metrics calculated from cumulative metrics (or zero for non-calculated instantaneous metrics).

the value of the metric for this

MetricValueList is a list of values for a given metric for some set of objects

the value of the metric across the described objects

MetricIdentifier identifies a metric by name and, optionally, selector

name is the name of the given metric

selector represents the label selector that could be used to select this metric, and will generally just be the selector passed in to the query used to fetch this metric. When left blank, only the metric's Name will be used to gather metrics.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-resourceclaimtemplate

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-dra

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-Extensions

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-logging

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-horizontal-pod-autoscaler

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Accessing the Kubernetes API from a Pod

**URL:** https://kubernetes.io/docs/tasks/run-application/access-api-from-pod/

**Contents:**
- Accessing the Kubernetes API from a Pod
- Before you begin
- Accessing the API from within a Pod
  - Using Official Client Libraries
  - Directly accessing the REST API
    - Note:
  - Using kubectl proxy
  - Without using a proxy
- Feedback

This guide demonstrates how to access the Kubernetes API from within a pod.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

When accessing the API from within a Pod, locating and authenticating to the API server are slightly different to the external client case.

The easiest way to use the Kubernetes API from a Pod is to use one of the official client libraries. These libraries can automatically discover the API server and authenticate.

From within a Pod, the recommended ways to connect to the Kubernetes API are:

For a Go client, use the official Go client library. The rest.InClusterConfig() function handles API host discovery and authentication automatically. See an example here.

For a Python client, use the official Python client library. The config.load_incluster_config() function handles API host discovery and authentication automatically. See an example here.

There are a number of other libraries available, please refer to the Client Libraries page.

In each case, the service account credentials of the Pod are used to communicate securely with the API server.

While running in a Pod, your container can create an HTTPS URL for the Kubernetes API server by fetching the KUBERNETES_SERVICE_HOST and KUBERNETES_SERVICE_PORT_HTTPS environment variables. The API server's in-cluster address is also published to a Service named kubernetes in the default namespace so that pods may reference kubernetes.default.svc as a DNS name for the local API server.

The recommended way to authenticate to the API server is with a service account credential. By default, a Pod is associated with a service account, and a credential (token) for that service account is placed into the filesystem tree of each container in that Pod, at /var/run/secrets/kubernetes.io/serviceaccount/token.

If available, a certificate bundle is placed into the filesystem tree of each container at /var/run/secrets/kubernetes.io/serviceaccount/ca.crt, and should be used to verify the serving certificate of the API server.

Finally, the default namespace to be used for namespaced API operations is placed in a file at /var/run/secrets/kubernetes.io/serviceaccount/namespace in eac

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
# Point to the internal API server hostname
APISERVER=https://kubernetes.default.svc

# Path to ServiceAccount token
SERVICEACCOUNT=/var/run/secrets/kubernetes.io/serviceaccount

# Read this Pod's namespace
NAMESPACE=$(cat ${SERVICEACCOUNT}/namespace)

# Read the ServiceAccount bearer token
TOKEN=$(cat ${SERVICEACCOUNT}/token)

# Reference the internal certificate authority (CA)
CACERT=${SERVICEACCOUNT}/ca.crt

# Explore the API with TOKEN
curl --cacert ${CACERT} --header "Authorization: Bearer ${TOKEN}" -X GET ${APISERVER}/api
```

Example 2 (json):
```json
{
  "kind": "APIVersions",
  "versions": ["v1"],
  "serverAddressByClientCIDRs": [
    {
      "clientCIDR": "0.0.0.0/0",
      "serverAddress": "10.0.1.149:443"
    }
  ]
}
```

---

## SubjectAccessReview

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/subject-access-review-v1/

**Contents:**
- SubjectAccessReview
- SubjectAccessReview
- SubjectAccessReviewSpec
- SubjectAccessReviewStatus
- Operations
  - create create a SubjectAccessReview
    - HTTP Request
    - Parameters
    - Response
- Feedback

apiVersion: authorization.k8s.io/v1

import "k8s.io/api/authorization/v1"

SubjectAccessReview checks whether or not a user or group can perform an action.

apiVersion: authorization.k8s.io/v1

kind: SubjectAccessReview

metadata (ObjectMeta)

Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

spec (SubjectAccessReviewSpec), required

Spec holds information about the request being evaluated

status (SubjectAccessReviewStatus)

Status is filled in by the server and indicates whether the request is allowed or not

SubjectAccessReviewSpec is a description of the access request. Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set

extra (map[string][]string)

Extra corresponds to the user.Info.GetExtra() method from the authenticator. Since that is input to the authorizer it needs a reflection here.

Atomic: will be replaced during a merge

Groups is the groups you're testing for.

nonResourceAttributes (NonResourceAttributes)

NonResourceAttributes describes information for a non-resource access request

NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface

nonResourceAttributes.path (string)

Path is the URL path of the request

nonResourceAttributes.verb (string)

Verb is the standard HTTP verb

resourceAttributes (ResourceAttributes)

ResourceAuthorizationAttributes describes information for a resource access request

ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface

resourceAttributes.fieldSelector (FieldSelectorAttributes)

fieldSelector describes the limitation on access based on field. It can only limit access, not broaden it.

*FieldSelectorAttributes indicates a field limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the 

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-app-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-Extensions

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Audit Annotations

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/audit-annotations/#authorization-k8s-io-decision

**Contents:**
- Audit Annotations
    - Note:
- k8s.io/deprecated
- k8s.io/removed-release
- pod-security.kubernetes.io/exempt
- pod-security.kubernetes.io/enforce-policy
- pod-security.kubernetes.io/audit-violations
- apiserver.latency.k8s.io/etcd
- apiserver.latency.k8s.io/decode-response-object
- apiserver.latency.k8s.io/apf-queue-wait

This page serves as a reference for the audit annotations of the kubernetes.io namespace. These annotations apply to Event object from API group audit.k8s.io.

Example: k8s.io/deprecated: "true"

Value must be "true" or "false". The value "true" indicates that the request used a deprecated API version.

Example: k8s.io/removed-release: "1.22"

Value must be in the format "<MAJOR>.<MINOR>". It is set to target the removal release on requests made to deprecated API versions with a target removal release.

Example: pod-security.kubernetes.io/exempt: namespace

Value must be one of user, namespace, or runtimeClass which correspond to Pod Security Exemption dimensions. This annotation indicates on which dimension was based the exemption from the PodSecurity enforcement.

Example: pod-security.kubernetes.io/enforce-policy: restricted:latest

Value must be privileged:<version>, baseline:<version>, restricted:<version> which correspond to Pod Security Standard levels accompanied by a version which must be latest or a valid Kubernetes version in the format v<MAJOR>.<MINOR>. This annotations informs about the enforcement level that allowed or denied the pod during PodSecurity admission.

See Pod Security Standards for more information.

Example: pod-security.kubernetes.io/audit-violations: would violate PodSecurity "restricted:latest": allowPrivilegeEscalation != false (container "example" must set securityContext.allowPrivilegeEscalation=false), ...

Value details an audit policy violation, it contains the Pod Security Standard level that was transgressed as well as the specific policies on the fields that were violated from the PodSecurity enforcement.

See Pod Security Standards for more information.

Example: apiserver.latency.k8s.io/etcd: "4.730661757s"

This annotation indiactes the measure of latency incurred inside the storage layer, it accounts for the time it takes to send data to the etcd and get the complete response back.

The value of this audit annotation does not include the time incurred in admission, or validation.

Example: apiserver.latency.k8s.io/decode-response-object: "450.6649ns"

This annotation records the time taken to decode the response received from the storage layer (etcd)

Example: apiserver.latency.k8s.io/apf-queue-wait: "100ns"

This annotation records the time that a request spent queued due to API server priorities.

See API Priority and Fairness (APF) for more information about this mechanism.

Example: authorization.k8s.io/decis

*[Content truncated]*

---

## kube-controller-manager

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/kube-controller-manager/

**Contents:**
- kube-controller-manager
- Synopsis
- Options
- Feedback

The Kubernetes controller manager is a daemon that embeds the core control loops shipped with Kubernetes. In applications of robotics and automation, a control loop is a non-terminating loop that regulates the state of the system. In Kubernetes, a controller is a control loop that watches the shared state of the cluster through the apiserver and makes changes attempting to move the current state towards the desired state. Examples of controllers that ship with Kubernetes today are the replication controller, endpoints controller, namespace controller, and serviceaccounts controller.

Should CIDRs for Pods be allocated and set on the cloud provider. Requires --cluster-cidr.

The map from metric-label to value allow-list of this label. The key's format is <MetricName>,<LabelName>. The value's format is <allowed_value>,<allowed_value>...e.g. metric1,label1='v1,v2,v3', metric1,label2='v1,v2,v3' metric2,label1='v1,v2,v3'.

The path to the manifest file that contains the allow-list mapping. The format of the file is the same as the flag --allow-metric-labels. Note that the flag --allow-metric-labels will override the manifest file.

The reconciler sync wait time between volume attach detach. This duration must be larger than one second, and increasing this value from the default may allow for volumes to be mismatched with pods.

kubeconfig file pointing at the 'core' kubernetes server with enough rights to create tokenreviews.authentication.k8s.io. This is optional. If empty, all token requests are considered to be anonymous and no client CA is looked up in the cluster.

If false, the authentication-kubeconfig will be used to lookup missing authentication configuration from the cluster.

The duration to cache responses from the webhook token authenticator.

If true, failures to look up missing authentication configuration from the cluster are not considered fatal. Note that this can result in authentication that treats all requests as anonymous.

A list of HTTP paths to skip during authorization, i.e. these are authorized without contacting the 'core' kubernetes server.

kubeconfig file pointing at the 'core' kubernetes server with enough rights to create subjectaccessreviews.authorization.k8s.io. This is optional. If empty, all requests not skipped by authorization are forbidden.

The duration to cache 'authorized' responses from the webhook authorizer.

The duration to cache 'unauthorized' responses from the webhook authorizer.

The IP address on which to list

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
kube-controller-manager [flags]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-etcd

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-pod-security-policy

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-node-pressure-eviction

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-device

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-watch

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Audit Annotations

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/audit-annotations/#insecure-sha1-invalid-cert-kubernetes-io-hostname

**Contents:**
- Audit Annotations
    - Note:
- k8s.io/deprecated
- k8s.io/removed-release
- pod-security.kubernetes.io/exempt
- pod-security.kubernetes.io/enforce-policy
- pod-security.kubernetes.io/audit-violations
- apiserver.latency.k8s.io/etcd
- apiserver.latency.k8s.io/decode-response-object
- apiserver.latency.k8s.io/apf-queue-wait

This page serves as a reference for the audit annotations of the kubernetes.io namespace. These annotations apply to Event object from API group audit.k8s.io.

Example: k8s.io/deprecated: "true"

Value must be "true" or "false". The value "true" indicates that the request used a deprecated API version.

Example: k8s.io/removed-release: "1.22"

Value must be in the format "<MAJOR>.<MINOR>". It is set to target the removal release on requests made to deprecated API versions with a target removal release.

Example: pod-security.kubernetes.io/exempt: namespace

Value must be one of user, namespace, or runtimeClass which correspond to Pod Security Exemption dimensions. This annotation indicates on which dimension was based the exemption from the PodSecurity enforcement.

Example: pod-security.kubernetes.io/enforce-policy: restricted:latest

Value must be privileged:<version>, baseline:<version>, restricted:<version> which correspond to Pod Security Standard levels accompanied by a version which must be latest or a valid Kubernetes version in the format v<MAJOR>.<MINOR>. This annotations informs about the enforcement level that allowed or denied the pod during PodSecurity admission.

See Pod Security Standards for more information.

Example: pod-security.kubernetes.io/audit-violations: would violate PodSecurity "restricted:latest": allowPrivilegeEscalation != false (container "example" must set securityContext.allowPrivilegeEscalation=false), ...

Value details an audit policy violation, it contains the Pod Security Standard level that was transgressed as well as the specific policies on the fields that were violated from the PodSecurity enforcement.

See Pod Security Standards for more information.

Example: apiserver.latency.k8s.io/etcd: "4.730661757s"

This annotation indiactes the measure of latency incurred inside the storage layer, it accounts for the time it takes to send data to the etcd and get the complete response back.

The value of this audit annotation does not include the time incurred in admission, or validation.

Example: apiserver.latency.k8s.io/decode-response-object: "450.6649ns"

This annotation records the time taken to decode the response received from the storage layer (etcd)

Example: apiserver.latency.k8s.io/apf-queue-wait: "100ns"

This annotation records the time that a request spent queued due to API server priorities.

See API Priority and Fairness (APF) for more information about this mechanism.

Example: authorization.k8s.io/decis

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kube-proxy

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-proxy

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/

**Contents:**
- kube-proxy
- Synopsis
- Options
- Feedback

The Kubernetes network proxy runs on each node. This reflects services as defined in the Kubernetes API on each node and can do simple TCP, UDP, and SCTP stream forwarding or round robin TCP, UDP, and SCTP forwarding across a set of backends. Service cluster IPs and ports are currently found through Docker-links-compatible environment variables specifying ports opened by the service proxy. There is an optional addon that provides cluster DNS for these cluster IPs. The user must create a service with the apiserver API to configure the proxy.

If true, adds the file directory to the header of the log messages

log to standard error as well as files (no effect when -logtostderr=true)

Overrides kube-proxy's idea of what its node's primary IP is. Note that the name is a historical artifact, and kube-proxy does not actually bind any sockets to this IP. This parameter is ignored if a config file is specified by --config.

If true kube-proxy will treat failure to bind to a port as fatal and exit

If true cleanup iptables and ipvs rules and exit.

The CIDR range of the pods in the cluster. (For dual-stack clusters, this can be a comma-separated dual-stack pair of CIDR ranges.). When --detect-local-mode is set to ClusterCIDR, kube-proxy will consider traffic to be local if its source IP is in this range. (Otherwise it is not used.) This parameter is ignored if a config file is specified by --config.

The path to the configuration file.

How often configuration from the apiserver is refreshed. Must be greater than 0.

Maximum number of NAT connections to track per CPU core (0 to leave the limit as-is and ignore conntrack-min).

Minimum number of conntrack entries to allocate, regardless of conntrack-max-per-core (set conntrack-max-per-core=0 to leave the limit as-is).

Enable liberal mode for tracking TCP packets by setting nf_conntrack_tcp_be_liberal to 1

NAT timeout for TCP connections in the CLOSE_WAIT state

Idle timeout for established TCP connections (0 to leave as-is)

Idle timeout for UNREPLIED UDP connections (0 to leave as-is)

Idle timeout for ASSURED UDP connections (0 to leave as-is)

Mode to use to detect local traffic. This parameter is ignored if a config file is specified by --config.

A set of key=value pairs that describe feature gates for alpha/experimental features. Options are:APIResponseCompression=true|false (BETA - default=true)APIServerIdentity=true|false (BETA - default=true)APIServerTracing=true|false (BETA - default=true)APIServingWithR

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
kube-proxy [flags]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-applications

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cluster-operations

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-service-catalog

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-replication-controller

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Mutating Admission Policy

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/mutating-admission-policy/

**Contents:**
- Mutating Admission Policy
- What are MutatingAdmissionPolicies?
- What resources make a policy
- Getting Started with MutatingAdmissionPolicies
  - Create a MutatingAdmissionPolicy
    - Parameter resources
    - ApplyConfiguration
    - JSONPatch
- API kinds exempt from mutating admission
- Feedback

This page provides an overview of MutatingAdmissionPolicies. MutatingAdmissionPolicies allow you change what happens when someone writes a change to the Kubernetes API. If you want to use declarative policies just to prevent a particular kind of change to resources (for example: protecting platform namespaces from deletion), ValidatingAdmissionPolicy is a simpler and more effective alternative.

To use the feature, enable the MutatingAdmissionPolicy feature gate (which is off by default) and set --runtime-config=admissionregistration.k8s.io/v1beta1=true on the kube-apiserver.

Mutating admission policies offer a declarative, in-process alternative to mutating admission webhooks.

Mutating admission policies use the Common Expression Language (CEL) to declare mutations to resources. Mutations can be defined either with an apply configuration that is merged using the server side apply merge strategy, or a JSON patch.

Mutating admission policies are highly configurable, enabling policy authors to define policies that can be parameterized and scoped to resources as needed by cluster administrators.

A policy is generally made up of three resources:

The MutatingAdmissionPolicy describes the abstract logic of a policy (think: "this policy sets a particular label to a particular value").

A parameter resource provides information to a MutatingAdmissionPolicy to make it a concrete statement (think "set the owner label to something like company.example.com"). Parameter resources refer to Kubernetes resources, available in the Kubernetes API. They can be built-in types or extensions, such as a CustomResourceDefinition (CRD). For example, you can use a ConfigMap as a parameter.

A MutatingAdmissionPolicyBinding links the above (MutatingAdmissionPolicy and parameter) resources together and provides scoping. If you only want to set an owner label for Pods, and not other API kinds, the binding is where you specify this mutation.

At least a MutatingAdmissionPolicy and a corresponding MutatingAdmissionPolicyBinding must be defined for a policy to have an effect.

If a MutatingAdmissionPolicy does not need to be configured via parameters, simply leave spec.paramKind in MutatingAdmissionPolicy not specified.

Mutating admission policy is part of the cluster control-plane. You should write and deploy them with great caution. The following describes how to quickly experiment with Mutating admission policy.

The following is an example of a MutatingAdmissionPolicy. This pol

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: admissionregistration.k8s.io/v1beta1
kind: MutatingAdmissionPolicy
metadata:
  name: "sidecar-policy.example.com"
spec:
  paramKind:
    kind: Sidecar
    apiVersion: mutations.example.com/v1
  matchConstraints:
    resourceRules:
    - apiGroups:   [""]
      apiVersions: ["v1"]
      operations:  ["CREATE"]
      resources:   ["pods"]
  matchConditions:
    - name: does-not-already-have-sidecar
      expression: "!object.spec.initContainers.exists(ic, ic.name == \"mesh-proxy\")"
  failurePolicy: Fail
  reinvocationPolicy: IfNeeded
  mutations:
    - patchType: "ApplyConfiguration
...
```

Example 2 (yaml):
```yaml
apiVersion: v1
kind: Pod
metadata:
  name: myapp
  namespace: default
spec:
  ...
  initContainers:
  - name: mesh-proxy
    image: mesh/proxy:v1.0.0
    args: ["proxy", "sidecar"]
    restartPolicy: Always
  - name: myapp-initializer
    image: example/initializer:v1.0.0
  ...
```

Example 3 (yaml):
```yaml
apiVersion: admissionregistration.k8s.io/v1beta1
kind: MutatingAdmissionPolicy
metadata:
  name: "sidecar-policy.example.com"
spec:
  paramKind:
    kind: Sidecar
    apiVersion: mutations.example.com/v1
  matchConstraints:
    resourceRules:
    - apiGroups:   [""]
      apiVersions: ["v1"]
      operations:  ["CREATE"]
      resources:   ["pods"]
  matchConditions:
    - name: does-not-already-have-sidecar
      expression: "!object.spec.initContainers.exists(ic, ic.name == \"mesh-proxy\")"
  failurePolicy: Fail
  reinvocationPolicy: IfNeeded
  mutations:
    - patchType: "JSONPatch"
      j
...
```

Example 4 (unknown):
```unknown
[
    JSONPatch{op: "test", path: "/spec/example", value: "Red"},
    JSONPatch{op: "replace", path: "/spec/example", value: "Green"}
  ]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-platform-developer

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-pod-lifecycle

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-device

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#service-beta-kubernetes-io-aws-load-balancer-connection-draining-enabled

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-shuffle-sharding

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-pod-disruption

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-event

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesiozone

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-resource-quota

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Webhook Mode

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/webhook/

**Contents:**
- Webhook Mode
- Configuration File Format
- Request Payloads
- Feedback

A WebHook is an HTTP callback: an HTTP POST that occurs when something happens; a simple event-notification via HTTP POST. A web application implementing WebHooks will POST a message to a URL when certain things happen.

When specified, mode Webhook causes Kubernetes to query an outside REST service when determining user privileges.

Mode Webhook requires a file for HTTP configuration, specify by the --authorization-webhook-config-file=SOME_FILENAME flag.

The configuration file uses the kubeconfig file format. Within the file "users" refers to the API Server webhook and "clusters" refers to the remote service.

A configuration example which uses HTTPS client auth:

When faced with an authorization decision, the API Server POSTs a JSON- serialized authorization.k8s.io/v1beta1 SubjectAccessReview object describing the action. This object contains fields describing the user attempting to make the request, and either details about the resource being accessed or requests attributes.

Note that webhook API objects are subject to the same versioning compatibility rules as other Kubernetes API objects. Implementers should be aware of looser compatibility promises for beta objects and check the "apiVersion" field of the request to ensure correct deserialization. Additionally, the API Server must enable the authorization.k8s.io/v1beta1 API extensions group (--runtime-config=authorization.k8s.io/v1beta1=true).

An example request body:

The remote service is expected to fill the status field of the request and respond to either allow or disallow access. The response body's spec field is ignored and may be omitted. A permissive response would return:

For disallowing access there are two methods.

The first method is preferred in most cases, and indicates the authorization webhook does not allow, or has "no opinion" about the request, but if other authorizers are configured, they are given a chance to allow the request. If there are no other authorizers, or none of them allow the request, the request is forbidden. The webhook would return:

The second method denies immediately, short-circuiting evaluation by other configured authorizers. This should only be used by webhooks that have detailed knowledge of the full authorizer configuration of the cluster. The webhook would return:

Access to non-resource paths are sent as:

When calling out to an authorization webhook, Kubernetes passes label and field selectors in the request to the authorization webhook. The authori

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
# Kubernetes API version
apiVersion: v1
# kind of the API object
kind: Config
# clusters refers to the remote service.
clusters:
  - name: name-of-remote-authz-service
    cluster:
      # CA for verifying the remote service.
      certificate-authority: /path/to/ca.pem
      # URL of remote service to query. Must use 'https'. May not include parameters.
      server: https://authz.example.com/authorize

# users refers to the API Server's webhook configuration.
users:
  - name: name-of-api-server
    user:
      client-certificate: /path/to/cert.pem # cert for the webhook plugin to use
      c
...
```

Example 2 (json):
```json
{
  "apiVersion": "authorization.k8s.io/v1beta1",
  "kind": "SubjectAccessReview",
  "spec": {
    "resourceAttributes": {
      "namespace": "kittensandponies",
      "verb": "get",
      "group": "unicorn.example.org",
      "resource": "pods"
    },
    "user": "jane",
    "group": [
      "group1",
      "group2"
    ]
  }
}
```

Example 3 (json):
```json
{
  "apiVersion": "authorization.k8s.io/v1beta1",
  "kind": "SubjectAccessReview",
  "status": {
    "allowed": true
  }
}
```

Example 4 (json):
```json
{
  "apiVersion": "authorization.k8s.io/v1beta1",
  "kind": "SubjectAccessReview",
  "status": {
    "allowed": false,
    "reason": "user does not have read access to the namespace"
  }
}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cadvisor

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-cronjob

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Expose Pod Information to Containers Through Files

**URL:** https://kubernetes.io/docs/tasks/inject-data-application/downward-api-volume-expose-pod-information/

**Contents:**
- Expose Pod Information to Containers Through Files
- Before you begin
- Store Pod fields
    - Note:
    - Note:
- Store container fields
- Project keys to specific paths and file permissions
- What's next
- Feedback

This page shows how a Pod can use a downwardAPI volume, to expose information about itself to containers running in the Pod. A downwardAPI volume can expose Pod fields and container fields.

In Kubernetes, there are two ways to expose Pod and container fields to a running container:

Together, these two ways of exposing Pod and container fields are called the downward API.

You need to have a Kubernetes cluster, and the kubectl command-line tool must be configured to communicate with your cluster. It is recommended to run this tutorial on a cluster with at least two nodes that are not acting as control plane hosts. If you do not already have a cluster, you can create one by using minikube or you can use one of these Kubernetes playgrounds:

In this part of exercise, you create a Pod that has one container, and you project Pod-level fields into the running container as files. Here is the manifest for the Pod:

In the manifest, you can see that the Pod has a downwardAPI Volume, and the container mounts the volume at /etc/podinfo.

Look at the items array under downwardAPI. Each element of the array defines a downwardAPI volume. The first element specifies that the value of the Pod's metadata.labels field should be stored in a file named labels. The second element specifies that the value of the Pod's annotations field should be stored in a file named annotations.

Verify that the container in the Pod is running:

View the container's logs:

The output shows the contents of the labels file and the annotations file:

Get a shell into the container that is running in your Pod:

In your shell, view the labels file:

The output shows that all of the Pod's labels have been written to the labels file:

Similarly, view the annotations file:

View the files in the /etc/podinfo directory:

In the output, you can see that the labels and annotations files are in a temporary subdirectory: in this example, ..2982_06_02_21_47_53.299460680. In the /etc/podinfo directory, ..data is a symbolic link to the temporary subdirectory. Also in the /etc/podinfo directory, labels and annotations are symbolic links.

Using symbolic links enables dynamic atomic refresh of the metadata; updates are written to a new temporary directory, and the ..data symlink is updated atomically using rename(2).

The preceding exercise, you made Pod-level fields accessible using the downward API. In this next exercise, you are going to pass fields that are part of the Pod definition, but taken from the 

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
apiVersion: v1
kind: Pod
metadata:
  name: kubernetes-downwardapi-volume-example
  labels:
    zone: us-est-coast
    cluster: test-cluster1
    rack: rack-22
  annotations:
    build: two
    builder: john-doe
spec:
  containers:
    - name: client-container
      image: registry.k8s.io/busybox:1.27.2
      command: ["sh", "-c"]
      args:
      - while true; do
          if [[ -e /etc/podinfo/labels ]]; then
            echo -en '\n\n'; cat /etc/podinfo/labels; fi;
          if [[ -e /etc/podinfo/annotations ]]; then
            echo -en '\n\n'; cat /etc/podinfo/annotations; fi;
          s
...
```

Example 2 (shell):
```shell
kubectl apply -f https://k8s.io/examples/pods/inject/dapi-volume.yaml
```

Example 3 (shell):
```shell
kubectl get pods
```

Example 4 (shell):
```shell
kubectl logs kubernetes-downwardapi-volume-example
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-spec

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-istio

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-sidecar-container

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-service

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-annotation

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#service-beta-kubernetes-io-aws-load-balancer-scheme

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-rbac

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-api-eviction

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-resourceslice

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-ingress

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-kubectl

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cri

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-resource-quota

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-limitrange

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-downward-api

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesioregion

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Admission Control in Kubernetes

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#imagepolicywebhook

**Contents:**
- Admission Control in Kubernetes
- What are they?
  - Admission control extension points
  - Admission control phases
- Why do I need them?
- How do I turn on an admission controller?
    - Note:
- How do I turn off an admission controller?
- Which plugins are enabled by default?
- What does each admission controller do?

This page provides an overview of admission controllers.

An admission controller is a piece of code that intercepts requests to the Kubernetes API server prior to persistence of the resource, but after the request is authenticated and authorized.

Several important features of Kubernetes require an admission controller to be enabled in order to properly support the feature. As a result, a Kubernetes API server that is not properly configured with the right set of admission controllers is an incomplete server that will not support all the features you expect.

Admission controllers are code within the Kubernetes API server that check the data arriving in a request to modify a resource.

Admission controllers apply to requests that create, delete, or modify objects. Admission controllers can also block custom verbs, such as a request to connect to a pod via an API server proxy. Admission controllers do not (and cannot) block requests to read (get, watch or list) objects, because reads bypass the admission control layer.

Admission control mechanisms may be validating, mutating, or both. Mutating controllers may modify the data for the resource being modified; validating controllers may not.

The admission controllers in Kubernetes 1.34 consist of the list below, are compiled into the kube-apiserver binary, and may only be configured by the cluster administrator.

Within the full list, there are three special controllers: MutatingAdmissionWebhook, ValidatingAdmissionWebhook, and ValidatingAdmissionPolicy. The two webhook controllers execute the mutating and validating (respectively) admission control webhooks which are configured in the API. ValidatingAdmissionPolicy provides a way to embed declarative validation code within the API, without relying on any external HTTP callouts.

You can use these three admission controllers to customize cluster behavior at admission time.

The admission control process proceeds in two phases. In the first phase, mutating admission controllers are run. In the second phase, validating admission controllers are run. Note again that some of the controllers are both.

If any of the controllers in either phase reject the request, the entire request is rejected immediately and an error is returned to the end-user.

Finally, in addition to sometimes mutating the object in question, admission controllers may sometimes have side effects, that is, mutate related resources as part of request processing. Incrementing quota usage is the

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kube-apiserver --enable-admission-plugins=NamespaceLifecycle,LimitRanger ...
```

Example 2 (shell):
```shell
kube-apiserver --disable-admission-plugins=PodNodeSelector,AlwaysDeny ...
```

Example 3 (shell):
```shell
kube-apiserver -h | grep enable-admission-plugins
```

Example 4 (shell):
```shell
CertificateApproval, CertificateSigning, CertificateSubjectRestriction, DefaultIngressClass, DefaultStorageClass, DefaultTolerationSeconds, LimitRanger, MutatingAdmissionWebhook, NamespaceLifecycle, PersistentVolumeClaimResize, PodSecurity, Priority, ResourceQuota, RuntimeClass, ServiceAccount, StorageObjectInUseProtection, TaintNodesByCondition, ValidatingAdmissionPolicy, ValidatingAdmissionWebhook
```

---

## Kubelet Systemd Watchdog

**URL:** https://kubernetes.io/docs/reference/node/systemd-watchdog/

**Contents:**
- Kubelet Systemd Watchdog
- Configuration
  - Example Configuration
- What's next
- Feedback

On Linux nodes, Kubernetes 1.34 supports integrating with systemd to allow the operating system supervisor to recover a failed kubelet. This integration is not enabled by default. It can be used as an alternative to periodically requesting the kubelet's /healthz endpoint for health checks. If the kubelet does not respond to the watchdog within the timeout period, the watchdog will kill the kubelet.

The systemd watchdog works by requiring the service to periodically send a keep-alive signal to the systemd process. If the signal is not received within a specified timeout period, the service is considered unresponsive and is terminated. The service can then be restarted according to the configuration.

Using the systemd watchdog requires configuring the WatchdogSec parameter in the [Service] section of the kubelet service unit file:

Setting WatchdogSec=30s indicates a service watchdog timeout of 30 seconds. Within the kubelet, the sd_notify() function is invoked, at intervals of \( WatchdogSec \div 2\). to send WATCHDOG=1 (a keep-alive message). If the watchdog is not fed within the timeout period, the kubelet will be killed. Setting Restart to "always", "on-failure", "on-watchdog", or "on-abnormal" will ensure that the service is automatically restarted.

Some details about the systemd configuration:

For more details about systemd configuration, refer to the systemd documentation

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

**Examples:**

Example 1 (unknown):
```unknown
[Service]
WatchdogSec=30s
```

Example 2 (systemd):
```systemd
[Unit]
Description=kubelet: The Kubernetes Node Agent
Documentation=https://kubernetes.io/docs/home/
Wants=network-online.target
After=network-online.target

[Service]
ExecStart=/usr/bin/kubelet
# Configures the watchdog timeout
WatchdogSec=30s
Restart=on-failure
StartLimitInterval=0
RestartSec=10

[Install]
WantedBy=multi-user.target
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cncf

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-pod

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-dockershim

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-affinity

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-mvp

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-istio

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## kube-apiserver

**URL:** https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/

**Contents:**
- kube-apiserver
- Synopsis
- Options
- Feedback

The Kubernetes API server validates and configures data for the api objects which include pods, services, replicationcontrollers, and others. The API Server services REST operations and provides the frontend to the cluster's shared state through which all other components interact.

File with admission control configuration.

The IP address on which to advertise the apiserver to members of the cluster. This address must be reachable by the rest of the cluster. If blank, the --bind-address will be used. If --bind-address is unspecified, the host's default interface will be used.

Aggregator reject forwarding redirect response back to client.

The map from metric-label to value allow-list of this label. The key's format is <MetricName>,<LabelName>. The value's format is <allowed_value>,<allowed_value>...e.g. metric1,label1='v1,v2,v3', metric1,label2='v1,v2,v3' metric2,label1='v1,v2,v3'.

The path to the manifest file that contains the allow-list mapping. The format of the file is the same as the flag --allow-metric-labels. Note that the flag --allow-metric-labels will override the manifest file.

If true, allow privileged containers. [default=false]

Enables anonymous requests to the secure port of the API server. Requests that are not rejected by another authentication method are treated as anonymous requests. Anonymous requests have a username of system:anonymous, and a group name of system:unauthenticated.

Identifiers of the API. The service account token authenticator will validate that tokens used against the API are bound to at least one of these audiences. If the --service-account-issuer flag is configured and this flag is not, this field defaults to a single element list containing the issuer URL.

The size of the buffer to store events before batching and writing. Only used in batch mode.

The maximum size of a batch. Only used in batch mode.

The amount of time to wait before force writing the batch that hadn't reached the max size. Only used in batch mode.

Maximum number of requests sent at the same moment if ThrottleQPS was not utilized before. Only used in batch mode.

Whether batching throttling is enabled. Only used in batch mode.

Maximum average number of batches per second. Only used in batch mode.

If set, the rotated log files will be compressed using gzip.

Format of saved audits. "legacy" indicates 1-line text format for each event. "json" indicates structured json format. Known formats are legacy,json.

The maximum number of days to 

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
kube-apiserver [flags]
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-label

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-helm-chart

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Other Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/other-resources/

**Contents:**
- Other Resources
      - MutatingAdmissionPolicyBindingList v1beta1
- Feedback

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-security-context

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authorization Resources

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/

**Contents:**
- Authorization Resources
      - LocalSubjectAccessReview
      - SelfSubjectAccessReview
      - SelfSubjectRulesReview
      - SubjectAccessReview
      - ClusterRole
      - ClusterRoleBinding
      - Role
      - RoleBinding
- Feedback

LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

SelfSubjectAccessReview checks whether or the current user can perform an action.

SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace.

SubjectAccessReview checks whether or not a user or group can perform an action.

ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

ClusterRoleBinding references a ClusterRole, but not contain it.

Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.

RoleBinding references a role, but does not contain it.

This page is automatically generated.

If you plan to report an issue with this page, mention that the page is auto-generated in your issue description. The fix may need to happen elsewhere in the Kubernetes project.

Was this page helpful?

Thanks for the feedback. If you have a specific, answerable question about how to use Kubernetes, ask it on Stack Overflow. Open an issue in the GitHub Repository if you want to report a problem or suggest an improvement.

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-cni

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-secret

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Command line tool (kubectl)

**URL:** https://kubernetes.io/docs/reference/kubectl/#custom-columns

**Contents:**
- Command line tool (kubectl)
- Syntax
    - Caution:
- In-cluster authentication and namespace overrides
- Operations
- Resource types
- Output options
  - Formatting output
    - Syntax
      - Example

Kubernetes provides a command line tool for communicating with a Kubernetes cluster's control plane, using the Kubernetes API.

This tool is named kubectl.

For configuration, kubectl looks for a file named config in the $HOME/.kube directory. You can specify other kubeconfig files by setting the KUBECONFIG environment variable or by setting the --kubeconfig flag.

This overview covers kubectl syntax, describes the command operations, and provides common examples. For details about each command, including all the supported flags and subcommands, see the kubectl reference documentation.

For installation instructions, see Installing kubectl; for a quick guide, see the cheat sheet. If you're used to using the docker command-line tool, kubectl for Docker Users explains some equivalent commands for Kubernetes.

Use the following syntax to run kubectl commands from your terminal window:

where command, TYPE, NAME, and flags are:

command: Specifies the operation that you want to perform on one or more resources, for example create, get, describe, delete.

TYPE: Specifies the resource type. Resource types are case-insensitive and you can specify the singular, plural, or abbreviated forms. For example, the following commands produce the same output:

NAME: Specifies the name of the resource. Names are case-sensitive. If the name is omitted, details for all resources are displayed, for example kubectl get pods.

When performing an operation on multiple resources, you can specify each resource by type and name or specify one or more files:

To specify resources by type and name:

To group resources if they are all the same type: TYPE1 name1 name2 name<#>.Example: kubectl get pod example-pod1 example-pod2

To specify multiple resource types individually: TYPE1/name1 TYPE1/name2 TYPE2/name3 TYPE<#>/name<#>.Example: kubectl get pod/example-pod1 replicationcontroller/example-rc1

To specify resources with one or more files: -f file1 -f file2 -f file<#>

flags: Specifies optional flags. For example, you can use the -s or --server flags to specify the address and port of the Kubernetes API server.

If you need help, run kubectl help from the terminal window.

By default kubectl will first determine if it is running within a pod, and thus in a cluster. It starts by checking for the KUBERNETES_SERVICE_HOST and KUBERNETES_SERVICE_PORT environment variables and the existence of a service account token file at /var/run/secrets/kubernetes.io/serviceaccount/token. If all three 

*[Content truncated]*

**Examples:**

Example 1 (shell):
```shell
kubectl [command] [TYPE] [NAME] [flags]
```

Example 2 (shell):
```shell
kubectl get pod pod1
kubectl get pods pod1
kubectl get po pod1
```

Example 3 (shell):
```shell
kubectl config set-context --current --namespace=<namespace-name>
```

Example 4 (shell):
```shell
kubectl [command] [TYPE] [NAME] -o <output_format>
```

---

## Well-Known Labels, Annotations and Taints

**URL:** https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetes-io-arch

**Contents:**
- Well-Known Labels, Annotations and Taints
- Labels, annotations and taints used on API objects
  - apf.kubernetes.io/autoupdate-spec
  - app.kubernetes.io/component
  - app.kubernetes.io/created-by (deprecated)
    - Note:
  - app.kubernetes.io/instance
  - app.kubernetes.io/managed-by
  - app.kubernetes.io/name
  - app.kubernetes.io/part-of

Kubernetes reserves all labels, annotations and taints in the kubernetes.io and k8s.io namespaces.

This document serves both as a reference to the values and as a coordination point for assigning values.

Example: apf.kubernetes.io/autoupdate-spec: "true"

Used on: FlowSchema and PriorityLevelConfiguration Objects

If this annotation is set to true on a FlowSchema or PriorityLevelConfiguration, the spec for that object is managed by the kube-apiserver. If the API server does not recognize an APF object, and you annotate it for automatic update, the API server deletes the entire object. Otherwise, the API server does not manage the object spec. For more details, read Maintenance of the Mandatory and Suggested Configuration Objects.

Example: app.kubernetes.io/component: "database"

Used on: All Objects (typically used on workload resources).

The component within the application architecture.

One of the recommended labels.

Example: app.kubernetes.io/created-by: "controller-manager"

Used on: All Objects (typically used on workload resources).

The controller/user who created this resource.

Example: app.kubernetes.io/instance: "mysql-abcxyz"

Used on: All Objects (typically used on workload resources).

A unique name identifying the instance of an application. To assign a non-unique name, use app.kubernetes.io/name.

One of the recommended labels.

Example: app.kubernetes.io/managed-by: "helm"

Used on: All Objects (typically used on workload resources).

The tool being used to manage the operation of an application.

One of the recommended labels.

Example: app.kubernetes.io/name: "mysql"

Used on: All Objects (typically used on workload resources).

The name of the application.

One of the recommended labels.

Example: app.kubernetes.io/part-of: "wordpress"

Used on: All Objects (typically used on workload resources).

The name of a higher-level application this object is part of.

One of the recommended labels.

Example: app.kubernetes.io/version: "5.7.21"

Used on: All Objects (typically used on workload resources).

The current version of the application.

Common forms of values include:

One of the recommended labels.

Example: applyset.kubernetes.io/additional-namespaces: "namespace1,namespace2"

Used on: Objects being used as ApplySet parents.

Use of this annotation is Alpha. For Kubernetes version 1.34, you can use this annotation on Secrets, ConfigMaps, or custom resources if the CustomResourceDefinition defining them has the applyset.kubernet

*[Content truncated]*

**Examples:**

Example 1 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/filter-result: >-
      {"node-282x7":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","NodeName":"passed","NodePorts":"passed","NodeResourcesFit":"passed","NodeUnschedulable":"passed","NodeVolumeLimits":"passed","PodTopologySpread":"passed","TaintToleration":"passed","VolumeBinding":"passed","VolumeRestrictions":"passed","VolumeZone":"passed"},"node-gp9t4":{"AzureDiskLimits":"passed","EBSLimits":"passed","GCEPDLimits":"passed","InterPodAffinity":"passed","NodeAffinity":"passed","Nod
...
```

Example 2 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/finalscore-result: >-
      {"node-282x7":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"},"node-gp9t4":{"ImageLocality":"0","InterPodAffinity":"0","NodeAffinity":"0","NodeNumber":"0","NodeResourcesBalancedAllocation":"76","NodeResourcesFit":"73","PodTopologySpread":"200","TaintToleration":"300","VolumeBinding":"0"}}
```

Example 3 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prefilter-result-status: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodePorts":"success","NodeResourcesFit":"success","PodTopologySpread":"success","VolumeBinding":"success","VolumeRestrictions":"success"}
```

Example 4 (yaml):
```yaml
kube-scheduler-simulator.sigs.k8s.io/prescore-result: >-
      {"InterPodAffinity":"success","NodeAffinity":"success","NodeNumber":"success","PodTopologySpread":"success","TaintToleration":"success"}
```

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-object

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Kubelet authentication/authorization

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/kubelet-authn-authz/

**Contents:**
- Kubelet authentication/authorization
- Overview
- Kubelet authentication
- Kubelet authorization
  - Fine-grained authorization
- Feedback

A kubelet's HTTPS endpoint exposes APIs which give access to data of varying sensitivity, and allow you to perform operations with varying levels of power on the node and within containers.

This document describes how to authenticate and authorize access to the kubelet's HTTPS endpoint.

By default, requests to the kubelet's HTTPS endpoint that are not rejected by other configured authentication methods are treated as anonymous requests, and given a username of system:anonymous and a group of system:unauthenticated.

To disable anonymous access and send 401 Unauthorized responses to unauthenticated requests:

To enable X509 client certificate authentication to the kubelet's HTTPS endpoint:

To enable API bearer tokens (including service account tokens) to be used to authenticate to the kubelet's HTTPS endpoint:

Any request that is successfully authenticated (including an anonymous request) is then authorized. The default authorization mode is AlwaysAllow, which allows all requests.

There are many possible reasons to subdivide access to the kubelet API:

To subdivide access to the kubelet API, delegate authorization to the API server:

The kubelet authorizes API requests using the same request attributes approach as the apiserver.

The verb is determined from the incoming request's HTTP verb:

The resource and subresource is determined from the incoming request's path:

The namespace and API group attributes are always an empty string, and the resource name is always the name of the kubelet's Node API object.

When running in this mode, ensure the user identified by the --kubelet-client-certificate and --kubelet-client-key flags passed to the apiserver is authorized for the following attributes:

When the feature gate KubeletFineGrainedAuthz is enabled kubelet performs a fine-grained check before falling back to the proxy subresource for the /pods, /runningPods, /configz and /healthz endpoints. The resource and subresource are determined from the incoming request's path:

When the feature-gate KubeletFineGrainedAuthz is enabled, ensure the user identified by the --kubelet-client-certificate and --kubelet-client-key flags passed to the API server is authorized for the following attributes:

If RBAC authorization is used, enabling this gate also ensure that the builtin system:kubelet-api-admin ClusterRole is updated with permissions to access all the above mentioned subresources.

Was this page helpful?

Thanks for the feedback. If you have a specific, ans

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/?all=true#term-code-contributor

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-uid

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-kube-apiserver

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Glossary

**URL:** https://kubernetes.io/docs/reference/glossary/#term-priority-class

**Contents:**
- Glossary
    - Note:
    - Note:
    - Note:
- Feedback

This glossary is intended to be a comprehensive, standardized list of Kubernetes terminology. It includes technical terms that are specific to Kubernetes, as well as more general terms that provide useful context.

Filter terms according to their tags

Click on the [+] indicators below to get a longer explanation for any particular term.

Resources that extend the functionality of Kubernetes.

Installing addons explains more about using add-ons with your cluster, and lists some popular add-ons.

A piece of code that intercepts requests to the Kubernetes API server prior to persistence of the object.

Admission controllers are configurable for the Kubernetes API server and may be "validating", "mutating", or both. Any admission controller may reject the request. Mutating controllers may modify the objects they admit; validating controllers may not.

In Kubernetes, affinity is a set of rules that give hints to the scheduler about where to place pods.

There are two kinds of affinity:

The rules are defined using the Kubernetes labels, and selectors specified in pods, and they can be either required or preferred, depending on how strictly you want the scheduler to enforce them.

The aggregation layer lets you install additional Kubernetes-style APIs in your cluster.

When you've configured the Kubernetes API Server to support additional APIs, you can add APIService objects to "claim" a URL path in the Kubernetes API.

A key-value pair that is used to attach arbitrary non-identifying metadata to objects.

The metadata in an annotation can be small or large, structured or unstructured, and can include characters not permitted by labels. Clients such as tools and libraries can retrieve this metadata.

A set of related paths in Kubernetes API.

You can enable or disable each API group by changing the configuration of your API server. You can also disable or enable paths to specific resources. An API group makes it easier to extend the Kubernetes API. The API group is specified in a REST path and in the apiVersion field of a serialized object.

An entity in the Kubernetes type system, corresponding to an endpoint on the Kubernetes API. A resource typically represents an object. Some resources represent an operation on other objects, such as a permission check.

Each resource represents an HTTP endpoint (URI) on the Kubernetes API server, defining the schema for the objects or operations on that resource.

The API server is a component of the Kubernetes control pla

*[Content truncated]*

---

## Authenticating

**URL:** https://kubernetes.io/docs/reference/access-authn-authz/authentication/#configuring-the-api-server

**Contents:**
- Authenticating
- Users in Kubernetes
- Authentication strategies
    - Note:
- Authentication methods
  - X.509 client certificates
    - Putting a bearer token in a request
  - Bootstrap tokens
  - Service account tokens
    - Note:

This page provides an overview of authentication in Kubernetes, with a focus on authentication to the Kubernetes API.

All Kubernetes clusters have two categories of users: service accounts managed by Kubernetes, and normal users.

It is assumed that a cluster-independent service manages normal users in the following ways:

In this regard, Kubernetes does not have objects which represent normal user accounts. Normal users cannot be added to a cluster through an API call.

Even though a normal user cannot be added via an API call, any user that presents a valid certificate signed by the cluster's certificate authority (CA) is considered authenticated. In this configuration, Kubernetes determines the username from the common name field in the 'subject' of the cert (e.g., "/CN=bob"). From there, the role based access control (RBAC) sub-system would determine whether the user is authorized to perform a specific operation on a resource.

In contrast, service accounts are users managed by the Kubernetes API. They are bound to specific namespaces, and created automatically by the API server or manually through API calls. Service accounts are tied to a set of credentials stored as Secrets, which are mounted into pods allowing in-cluster processes to talk to the Kubernetes API.

API requests are tied to either a normal user or a service account, or are treated as anonymous requests. This means every process inside or outside the cluster, from a human user typing kubectl on a workstation, to kubelets on nodes, to members of the control plane, must authenticate when making requests to the API server, or be treated as an anonymous user.

Kubernetes uses client certificates, bearer tokens, or an authenticating proxy to authenticate API requests through authentication plugins. As HTTP requests are made to the API server, plugins attempt to associate the following attributes with the request:

You can enable multiple authentication methods at once. You should usually use at least two methods:

When multiple authenticator modules are enabled, the first module to successfully authenticate the request short-circuits evaluation. The API server does not guarantee the order authenticators run in.

The system:authenticated group is included in the list of groups for all authenticated users.

Integrations with other authentication protocols (LDAP, SAML, Kerberos, alternate x509 schemes, etc) are available; for example using an authenticating proxy or the authentication webhook.


*[Content truncated]*

**Examples:**

Example 1 (bash):
```bash
openssl req -new -key jbeda.pem -out jbeda-csr.pem -subj "/CN=jbeda/O=app1/O=app2"
```

Example 2 (http):
```http
Authorization: Bearer 31ada4fd-adec-460c-809a-9e56ceb75269
```

Example 3 (http):
```http
Authorization: Bearer 781292.db7bc3a58fc5f07e
```

Example 4 (yaml):
```yaml
apiVersion: apps/v1 # this apiVersion is relevant as of Kubernetes 1.9
kind: Deployment
metadata:
  name: nginx-deployment
  namespace: default
spec:
  replicas: 3
  template:
    metadata:
    # ...
    spec:
      serviceAccountName: bob-the-bot
      containers:
      - name: nginx
        image: nginx:1.14.2
```

---

## Endpoints

**URL:** https://kubernetes.io/docs/reference/kubernetes-api/service-resources/endpoints-v1/

**Contents:**
- Endpoints
- Endpoints
- EndpointsList
- Operations
  - get read the specified Endpoints
    - HTTP Request
    - Parameters
    - Response
  - list list or watch objects of kind Endpoints
    - HTTP Request

import "k8s.io/api/core/v1"

Endpoints is a collection of endpoints that implement the actual service. Example:

Name: "mysvc", Subsets: [ { Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}], Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}] }, { Addresses: [{"ip": "10.10.3.3"}], Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}] }, ]

Endpoints is a legacy API and does not contain information about all Service features. Use discoveryv1.EndpointSlice for complete information about Service endpoints.

Deprecated: This API is deprecated in v1.33+. Use discoveryv1.EndpointSlice.

metadata (ObjectMeta)

Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

subsets ([]EndpointSubset)

Atom