---
name: kuznetsov
description: Создание стратегических аналитических документов в стиле Кузнецова — профессиональное оформление для корпоративных стратегий, правовых меморандумов, финансовых планов и аналитических записок. Документы отличаются строгой структурой, точными формулировками и элегантным минималистичным дизайном. Использовать для создания документов высшего уровня качества для руководства компании, советов директоров, арбитражных трибуналов.
---

# Навык: Стиль Кузнецова

## Философия стиля

Стиль Кузнецова — это профессиональный подход к созданию корпоративных документов, основанный на принципах:

- **Ясность** — каждое предложение несёт смысловую нагрузку
- **Структура** — логическая иерархия от общего к частному
- **Точность** — конкретные даты, суммы, ссылки на нормативные акты
- **Элегантность** — минималистичный дизайн без визуального шума

## Структура документа

### Обязательные элементы

1. **Заголовок документа** — краткое название, отражающее суть
2. **Нумерованные разделы** — иерархическая нумерация (1., 2., 2.1., 2.2.)
3. **Таблицы с данными** — структурированная подача цифр и фактов
4. **Таймлайн** (при необходимости) — хронология действий
5. **Заключение** — краткие выводы и рекомендации
6. **Колонтитулы** — название документа в хедере, номер страницы в футере

### Рекомендуемый порядок разделов

```
1. [Контекст/Механизм] — правовые или экономические основания
2. [Инструменты/Методы] — способы достижения цели
3. [Требования/Условия] — необходимые предпосылки
4. [Синхронизация/Координация] — взаимосвязь элементов
5. [Расчёты/Прогнозы] — количественные оценки
6. [Таймлайн] — календарный план
7. [Ограничения/Риски] — критические условия
Заключение
```

## Форматирование

### Цветовая схема

| Элемент | Цвет | HEX |
|---------|------|-----|
| Заголовки всех уровней | Тёмно-синий | `#1a3a6e` |
| Основной текст | Чёрный | `#000000` |
| Хедер документа | Серый | `#666666` |
| Границы таблиц | Голубой | `#8eaadb` |
| Заголовок таблицы (фон) | Светло-голубой | `#c5d9f1` |
| Чередующиеся строки | Бледно-голубой | `#e9f0f9` |

### Шрифты и размеры

| Элемент | Шрифт | Размер | Начертание |
|---------|-------|--------|------------|
| Заголовок документа | Times New Roman | 16pt (32) | Bold, по центру, UPPERCASE |
| Heading 1 | Times New Roman | 13pt (26) | Bold |
| Heading 2 | Times New Roman | 12pt (24) | Bold |
| Основной текст | Times New Roman | 12pt (24) | Regular |
| Хедер | Times New Roman | 10pt (20) | Italic |
| Футер (номер стр.) | Times New Roman | 10pt (20) | Regular |

### Параметры страницы

- **Формат**: A4 (21.0 × 29.7 см)
- **Поля**: 2.54 см (1440 DXA) со всех сторон
- **Межстрочный интервал**: 1.15 (276 twips)
- **Отступ после абзаца**: 6pt (120 twips)
- **Выравнивание текста**: по ширине (justify)

### Таблицы

**Структура:**
- Ширина колонок задаётся явно
- Первая колонка: описание (60-65%)
- Вторая колонка: значения (35-40%)

**Оформление:**
- Границы: 1pt, цвет `#8eaadb`
- Заголовок: фон `#c5d9f1`, текст по центру, полужирный
- Данные: чередование белый / `#e9f0f9`
- Числа: выравнивание вправо
- Итоговые строки: полужирный текст, без заливки

**Специальные строки:**
- Вложенные элементы: отступ 3 пробела в начале текста
- Отрицательные числа: в скобках, например (100)

## Стиль написания

### Принципы

1. **Формальный деловой язык** — без разговорных оборотов
2. **Безличные конструкции** — «предлагается», «необходимо», «целесообразно»
3. **Точные формулировки** — избегать двусмысленности
4. **Ссылки на источники** — законы, стандарты, отчётность

### Форматирование терминов

- Сокращения расшифровываются при первом упоминании: `EuroChem Group AG (далее — ЕАГ)`
- Нормативные акты: `ПБУ 8/2010`, `МСФО (IAS) 37`, `ст. 67 ГК РФ`
- Даты: `30.11.2025`, `до 31.03.2027`
- Суммы: `405,1 млрд рублей`, `около 2,5 млрд евро`

### Акценты в тексте

- **Полужирный** — ключевые цифры и важные термины в тексте
- Курсив — не используется в основном тексте
- UPPERCASE — только для заголовка документа

## Создание документа

Используйте шаблон `template.js` из этого skill как основу:

```bash
# Установка зависимостей
npm install docx

# Копирование и адаптация шаблона
cp template.js my-document.js
# Редактирование содержимого
node my-document.js
```

### Технические параметры для docx

```javascript
const COLORS = {
  heading: "1a3a6e",
  text: "000000",
  headerText: "666666",
  tableBorder: "8eaadb",
  tableHeader: "c5d9f1",
  tableAlt: "e9f0f9"
};

const SIZES = {
  title: 32,      // 16pt
  heading1: 26,   // 13pt
  heading2: 24,   // 12pt
  body: 24,       // 12pt
  header: 20,     // 10pt
  footer: 20      // 10pt
};

const SPACING = {
  titleAfter: 240,      // 12pt после заголовка документа
  h1Before: 360,        // 18pt до H1
  h1After: 180,         // 9pt после H1
  h2Before: 240,        // 12pt до H2
  h2After: 120,         // 6pt после H2
  paragraphAfter: 120,  // 6pt после абзаца
  lineSpacing: 276      // 1.15 межстрочный
};
```

## Примеры применения

### Типы документов

- Корпоративные стратегии
- Правовые меморандумы
- Инвестиционные предложения
- Аналитические справки для руководства
- Заключения для арбитражных трибуналов
- Отчёты о рисках

### Когда использовать

- Документ предназначен для высшего руководства
- Требуется профессиональное оформление
- Содержит финансовые данные и расчёты
- Имеет юридическое или стратегическое значение

## Файлы skill

- `SKILL.md` — данный файл с описанием стиля
- `template.js` — базовый шаблон для создания документов
