# Support Response Templates

## Quick Responses

### Deposit Received
```
Hi [Name],

Great news! Your deposit of [amount] has been successfully processed and is now earning yield in [vault name].

Current position: [X] shares
Current value: $[X]

You can view your position at any time in your dashboard.

Best regards,
[Support Agent]
```

### Redemption Processed
```
Hi [Name],

Your redemption has been processed successfully!

Amount redeemed: [X] [asset]
Transaction: [hash link]

The funds should appear in your wallet shortly (usually within a few minutes depending on network conditions).

Best regards,
[Support Agent]
```

### Request More Information
```
Hi [Name],

Thank you for contacting Lagoon support. I'd like to help resolve this for you.

To assist you better, could you please provide:
- [Specific information needed]
- [Additional context]

Once I have this information, I'll be able to investigate further.

Best regards,
[Support Agent]
```

### Issue Resolved
```
Hi [Name],

I'm pleased to confirm that your issue has been resolved.

Summary:
- Issue: [Brief description]
- Resolution: [What was done]
- Current Status: [Resolved/Monitoring]

Is there anything else I can help you with?

Best regards,
[Support Agent]
```

### Scheduled Maintenance
```
Hi [Name],

Thank you for your patience. The [feature/service] is currently undergoing scheduled maintenance.

Expected duration: [timeframe]
Impact: [What is affected]
Workaround: [If any]

We'll notify you when service is restored. Your funds remain safe during this maintenance period.

Best regards,
[Support Agent]
```

## FAQ Responses

### What are vault fees?
```
Lagoon vaults have transparent fee structures:

- Management Fee: [X]% annually (accrued daily)
- Performance Fee: [X]% of profits (only charged on gains)
- Entry/Exit Fees: [Details if applicable]

These fees are automatically deducted and reflected in your share value. The displayed APR is already net of fees.

For specific vault fees, you can find them on the vault details page or I can look them up for you.
```

### How is APR calculated?
```
APR (Annual Percentage Rate) represents the annualized return based on recent vault performance.

Calculation method:
- Based on [30-day/7-day] historical performance
- Annualized for comparison purposes
- Net of all fees
- Does not include compounding effects

Important: APR is variable and based on historical data. It does not guarantee future returns.
```

### What happens if a vault strategy fails?
```
While rare, strategy issues are possible in DeFi. Here's what you should know:

Protections in place:
- Professional curator oversight
- Diversified underlying strategies
- Regular monitoring and rebalancing

If issues occur:
- Curator may pause deposits/redemptions temporarily
- Strategy adjustments made as needed
- Communication sent to all depositors

Risk reminder: All DeFi investments carry risk, including potential total loss.
```

### How do I contact support?
```
You can reach Lagoon support through:

- This support chat (fastest response)
- Email: support@lagoon.protocol
- Discord: [link to support channel]

Support hours: [Hours]
Average response time: [Timeframe]

For urgent security concerns, please use [emergency contact method].
```

## Closing Messages

### Positive Resolution
```
I'm glad I could help resolve this for you! If you have any other questions in the future, don't hesitate to reach out.

Thank you for using Lagoon!
```

### Awaiting Customer Response
```
I'll keep this ticket open while awaiting your response. Feel free to reply whenever convenient.

This ticket will auto-close after [X] days of inactivity, but you can always open a new one if needed.
```

### After Escalation
```
I've escalated this to our specialized team who will follow up with you directly.

Ticket reference: [number]
Expected follow-up: [timeframe]

Thank you for your patience.
```

## Escalation Template

```
ESCALATION REQUEST
==================

Priority: [Critical/High/Medium/Low]
Category: [Technical/Financial/Security/Other]

Customer: [Name/ID]
Contact: [Email]
Original Ticket: [Number]

Issue Summary:
[Brief description]

Attempted Resolution:
[What has been tried]

Escalation Reason:
[Why this needs escalation]

Requested Action:
[What is needed from escalation team]

Supporting Information:
[Transaction hashes, screenshots, etc.]
```
