---
name: landing-page-creator
description: Create high-converting landing pages with optimized copy, structure, and design elements. Generates complete pages for lead generation, product launches, event registration, and sales campaigns with conversion-focused layouts.
---

# Landing Page Creator

Build high-converting landing pages with persuasive copy, optimized structure, and conversion-focused design elements tailored to specific campaign goals.

## When to Use This Skill

Use this skill for:
- Lead generation campaigns
- Product launch pages
- Event registration and webinars
- Free trial sign-ups
- Newsletter subscriptions
- Course or service sales
- App download campaigns
- Contest and giveaway pages

## Landing Page Framework

### Essential Elements
Every high-converting landing page includes:
- **Compelling Headline**: Clear value proposition in 6-10 words
- **Supporting Subheadline**: Elaborates on main benefit
- **Hero Image/Video**: Visually supports the main message
- **Benefits Section**: Focus on user outcomes, not features
- **Social Proof**: Testimonials, reviews, trust badges
- **Call-to-Action**: Clear, prominent, action-oriented
- **Form Optimization**: Minimal fields, logical flow
- **Mobile Responsive**: Optimized for all devices

### Conversion Optimization
Maximize page performance through:
- **Single Focus**: One primary goal per page
- **Above-Fold CTA**: Primary action visible without scrolling
- **Urgency Elements**: Limited time offers, scarcity indicators
- **Trust Signals**: Security badges, guarantees, certifications
- **Progressive Disclosure**: Complex information revealed gradually
- **A/B Testing**: Multiple variations for optimization

## Page Structure Templates

### Lead Generation Template
```
1. Headline + Value Proposition
2. Subheadline with Benefits
3. Hero Image/Video
4. Lead Magnet Description
5. Form (Name, Email)
6. Social Proof
7. Additional Benefits
8. FAQ Section
9. Footer with Trust Elements
```

### Product Sales Template
```
1. Problem Statement
2. Solution Introduction
3. Product Demo/Screenshots
4. Features and Benefits
5. Pricing Options
6. Customer Testimonials
7. Guarantee/Risk Reversal
8. Urgency/Scarcity
9. Final CTA
```

## Content Guidelines

### Headline Formula
- Lead with primary benefit
- Include specific outcome or number
- Address target audience directly
- Create curiosity or urgency
- Keep under 10 words when possible

### Copy Structure
- **Problem-Agitation-Solution**: Identify pain, amplify urgency, present solution
- **Before-After-Bridge**: Current state, desired future, path to get there
- **Features-Advantages-Benefits**: What it is, what it does, what it means

## Technical Implementation

Generate clean, conversion-optimized HTML/CSS code with:
- **Semantic HTML**: Proper structure for accessibility and SEO
- **Mobile-First Design**: Responsive layouts that work on all devices
- **Fast Loading**: Optimized images and minimal code
- **Form Validation**: Client-side validation for better UX
- **Analytics Ready**: Event tracking for conversion measurement

Create complete, ready-to-deploy landing pages that drive results.