---
name: latex-format-adapter
description: LaTeX 模板格式适配助手，根据外部规范文档（PDF/图片/Word）解析格式要求并调整页面布局、字体、标题样式等配置文件。不涉及正文内容写作。
---

# latex-format-adapter

## 1. 核心职责
解析格式规范 → 生成/修改 LaTeX 配置

## 2. 输入来源

### 📄 外部规范文档
- **PDF 格式规范**：学校/期刊/出版社的模板要求文档
- **Word 参考模板** (.docx)：需要转换为 LaTeX 格式的 Word 模板
- **图片/截图**：格式样例、标注说明、扫描的纸质规范

### 📝 文字描述
- **用户直接描述**：如 "页边距改成上下2.5cm，左右3cm，标题用黑体小三"
- **格式说明文档**：LaTeX 模板附带的格式规范 (README/说明文档)
- **规范条文**：逐条列出的格式要求清单

### 🔍 逆向分析
- **从 PDF 反推**：分析已有 PDF 输出，提取页面布局、字体、间距等参数
- **学习现有模板**：从其他 LaTeX 项目的配置文件中学习格式定义
- **对比修改**：用户提供编译后的 PDF，指出与规范不符之处

### 🤝 交互式调整
- **迭代优化**：根据用户反馈逐步调整格式
- **局部修正**：针对具体问题（如"目录页码对齐不正确"）精确修改

## 3. 输出目标
根据项目结构**自动识别**并调整相应的格式控制文件：

### ① 导言区配置（最常见，优先使用）
适用于大多数项目，直接在主文档或配置文件中调整宏包参数：

| 配置位置 | 典型文件 | 调整内容 |
|---------|---------|---------|
| 主文档导言区 | `main.tex`、`thesis.tex` | 直接在 `\documentclass` 和 `\begin{document}` 之间配置 |
| 独立配置文件 | `config.tex`、`setup.tex`、`preamble.tex` | 通过 `\input{config}` 导入的格式设置 |

**常见调整内容**：
- **页面布局**：geometry 宏包（页边距、页眉页脚间距）
- **字体设置**：fontspec/ctex（中英文字体、字号、字重）
- **标题样式**：ctex/titlesec（章节格式、编号样式、间距）
- **行距段距**：setspace/parskip（行距、段前段后间距）
- **页眉页脚**：fancyhdr（页眉页脚内容、样式、分隔线）
- **目录样式**：tocloft/titletoc（目录格式、缩进、页码）
- **列表样式**：enumitem（编号格式、缩进、间距）
- **参考文献**：biblatex/natbib（引用格式、排序方式）

### ② 独立样式文件（中大型项目）
适用于需要模块化管理或复用格式定义的项目：

| 文件类型 | 典型用途 | 示例 |
|---------|---------|------|
| `.sty` 文件 | 封装可复用的格式定义和宏命令 | `mythesis.sty`、`heading-style.sty` |
| 分模块配置 | 按功能拆分配置（便于维护） | `config/fonts.tex`、`config/layout.tex` |

**操作方式**：
- 创建新的 `.sty` 文件或修改现有样式包
- 拆分大型 `config.tex` 为多个模块化文件
- 通过 `\usepackage{mystyle}` 或 `\input{config/module}` 引入

### ③ 文档类定制（高级需求）
适用于需要深度定制文档行为的场景（如学校官方模板）：

| 文件类型 | 典型用途 | 注意事项 |
|---------|---------|---------|
| `.cls` 文件 | 定义文档类（如 `\documentclass{mythesis}`） | 需要深入理解 LaTeX 内部机制 |

**操作方式**：
- 修改现有 `.cls` 文件（如 `thesis.cls`、`ctexart.cls` 的定制版）
- 从零创建新的文档类（复杂，通常基于现有类扩展）
- 调整底层命令定义（字体族、计数器、浮动体行为等）

**选择原则**：
- ✅ **优先使用 ①**：简单直接，适合 90% 的格式调整需求
- ⚠️ **必要时用 ②**：项目复杂度高、需要模块化管理、多人协作时
- ⛔ **谨慎使用 ③**：仅在导言区配置无法实现时才考虑（如需修改文档类底层行为）

## 4. 工作流程

### 第一步：理解需求
1. **接收输入**：获取用户提供的格式规范（PDF/图片/文字描述等）
2. **提取参数**：识别关键格式要求
   - 页面布局：纸张大小、页边距、装订线
   - 字体字号：正文/标题/图表的字体、字号、字重
   - 间距设置：行距、段间距、标题间距
   - 编号格式：章节编号、图表编号、公式编号
   - 页眉页脚：内容、位置、样式
   - 特殊要求：封面、摘要、目录、参考文献等格式

### 第二步：分析项目结构
1. **检查现有文件**：
   - 主文档是什么？（`main.tex`、`thesis.tex` 等）
   - 是否有配置文件？（`config.tex`、`setup.tex` 等）
   - 是否使用自定义类/样式？（`.cls`、`.sty` 文件）
2. **确定调整策略**：
   - 简单项目 → 直接修改导言区配置
   - 复杂项目 → 考虑模块化拆分
   - 官方模板 → 可能需要修改 `.cls` 文件

### 第三步：映射 LaTeX 命令
将格式要求转换为 LaTeX 代码：
- **页边距 2.5cm** → `\usepackage[top=2.5cm, bottom=2.5cm, ...]{geometry}`
- **标题黑体小三加粗** → `\ctexset{section={format={\heiti\zihao{-3}\bfseries}}}`
- **行距 1.5 倍** → `\setstretch{1.5}` 或 `\linespread{1.5}`

### 第四步：实施修改
1. **备份原文件**（如有必要）
2. **编辑配置文件**：
   - 修改现有配置
   - 或创建新的 `.sty` / `.tex` 文件
3. **验证语法**：确保 LaTeX 命令正确

### 第五步：测试验证
1. **提醒用户编译**：`xelatex main.tex` 或项目特定的编译命令
2. **对比输出**：将生成的 PDF 与格式要求对比
3. **迭代调整**：根据差异继续优化

## 5. 与 latex-document-writer 的协作
- **格式与内容分离**：
  - 本 skill（latex-format-adapter）：只负责格式配置文件（`config.tex`、`.sty`、`.cls` 等）
  - latex-document-writer：只负责正文内容（章节 `.tex` 文件、图表、公式等）
- **协作边界**：
  - ✅ 本 skill 可以修改：宏包引入、格式参数、样式定义
  - ❌ 本 skill 不应修改：章节内容、图表数据、参考文献条目
- **典型工作流**：
  1. 用户先用 latex-format-adapter 配置好格式
  2. 再用 latex-document-writer 填充内容
  3. 格式微调时切回 latex-format-adapter